/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.util.List;
import org.apache.juneau.annotation.Marshalled;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.internal.ClassUtils;

public final class MarshalledFilter {
    private final Class<?> marshalledClass;
    private final Class<?> implClass;
    private final String example;

    public static <T> Builder create(Class<T> marshalledClass) {
        return new Builder(marshalledClass);
    }

    protected MarshalledFilter(Builder builder) {
        this.marshalledClass = builder.marshalledClass;
        this.implClass = builder.implClass;
        this.example = builder.example;
    }

    public Class<?> getMarshalledClass() {
        return this.marshalledClass;
    }

    public Class<?> getImplClass() {
        return this.implClass;
    }

    public String getExample() {
        return this.example;
    }

    public static class Builder {
        Class<?> marshalledClass;
        Class<?> implClass;
        String example;

        protected Builder(Class<?> marshalledClass) {
            this.marshalledClass = marshalledClass;
        }

        public Builder applyAnnotations(List<Marshalled> annotations) {
            annotations.forEach(x -> {
                if (ClassUtils.isNotVoid(x.implClass())) {
                    this.implClass(x.implClass());
                }
                if (StringUtils.isNotEmpty(x.example())) {
                    this.example(x.example());
                }
            });
            return this;
        }

        public Builder implClass(Class<?> value) {
            this.implClass = value;
            return this;
        }

        public Builder example(String value) {
            this.example = value;
            return this;
        }

        public MarshalledFilter build() {
            return new MarshalledFilter(this);
        }
    }
}

