/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.common.internal.ThrowableUtils;
import org.apache.juneau.internal.FluentSetter;
import org.apache.juneau.internal.FluentSetters;

@FluentSetters
public class BasicRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    boolean unmodifiable;
    String message;

    public BasicRuntimeException(Throwable cause, String message, Object ... args) {
        super(StringUtils.format(message, args), cause);
    }

    public BasicRuntimeException(String message, Object ... args) {
        super(StringUtils.format(message, args));
    }

    public BasicRuntimeException(Throwable cause) {
        super(cause);
    }

    @FluentSetter
    protected BasicRuntimeException setUnmodifiable() {
        this.unmodifiable = true;
        return this;
    }

    public boolean isUnmodifiable() {
        return this.unmodifiable;
    }

    protected final void assertModifiable() {
        if (this.unmodifiable) {
            throw new UnsupportedOperationException("Bean is read-only");
        }
    }

    public <T extends Throwable> T getCause(Class<T> c) {
        return ThrowableUtils.getCause(c, this);
    }

    @FluentSetter
    public BasicRuntimeException setMessage(String message, Object ... args) {
        this.assertModifiable();
        this.message = StringUtils.format(message, args);
        return this;
    }

    @Override
    public String getMessage() {
        if (this.message != null) {
            return this.message;
        }
        String m = super.getMessage();
        if (m == null && this.getCause() != null) {
            m = this.getCause().getMessage();
        }
        return m;
    }

    @Override
    public synchronized Throwable fillInStackTrace() {
        this.assertModifiable();
        return super.fillInStackTrace();
    }

    @Override
    public synchronized Throwable initCause(Throwable cause) {
        this.assertModifiable();
        return super.initCause(cause);
    }

    @Override
    public void setStackTrace(StackTraceElement[] stackTrace) {
        this.assertModifiable();
        super.setStackTrace(stackTrace);
    }

    public Throwable unwrap() {
        Throwable t = this.getCause();
        return t == null ? this : t;
    }
}

