/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.juneau.AnnotationProvider;
import org.apache.juneau.BasicRuntimeException;
import org.apache.juneau.BeanRuntimeException;
import org.apache.juneau.Value;
import org.apache.juneau.Visibility;
import org.apache.juneau.internal.ConsumerUtils;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.ReflectFlags;

public final class FieldInfo
implements Comparable<FieldInfo> {
    private final Field f;
    private final ClassInfo declaringClass;
    private volatile ClassInfo type;

    public static FieldInfo of(ClassInfo declaringClass, Field f) {
        if (f == null) {
            return null;
        }
        return ClassInfo.of(declaringClass).getFieldInfo(f);
    }

    public static FieldInfo of(Field f) {
        if (f == null) {
            return null;
        }
        return ClassInfo.of(f.getDeclaringClass()).getFieldInfo(f);
    }

    protected FieldInfo(ClassInfo declaringClass, Field f) {
        this.declaringClass = declaringClass;
        this.f = f;
    }

    public Field inner() {
        return this.f;
    }

    public ClassInfo getDeclaringClass() {
        return this.declaringClass;
    }

    public <A extends Annotation> A getAnnotation(Class<A> type) {
        return this.getAnnotation(AnnotationProvider.DEFAULT, type);
    }

    public <A extends Annotation> A getAnnotation(AnnotationProvider annotationProvider, Class<A> type) {
        Value<Object> t = Value.empty();
        annotationProvider.forEachAnnotation(type, this.f, x -> true, x -> t.set(x));
        return (A)((Annotation)t.orElse(null));
    }

    public <A extends Annotation> boolean hasAnnotation(Class<A> type) {
        return this.f.isAnnotationPresent(type);
    }

    public final <A extends Annotation> boolean hasNoAnnotation(Class<A> type) {
        return !this.hasAnnotation(type);
    }

    public <A extends Annotation> boolean hasAnnotation(AnnotationProvider annotationProvider, Class<A> type) {
        return annotationProvider.firstAnnotation(type, this.f, x -> true) != null;
    }

    public <A extends Annotation> boolean hasNoAnnotation(AnnotationProvider annotationProvider, Class<A> type) {
        return !this.hasAnnotation(annotationProvider, type);
    }

    public boolean isAll(ReflectFlags ... flags) {
        block10: for (ReflectFlags f : flags) {
            switch (f) {
                case DEPRECATED: {
                    if (!this.isNotDeprecated()) continue block10;
                    return false;
                }
                case NOT_DEPRECATED: {
                    if (!this.isDeprecated()) continue block10;
                    return false;
                }
                case PUBLIC: {
                    if (!this.isNotPublic()) continue block10;
                    return false;
                }
                case NOT_PUBLIC: {
                    if (!this.isPublic()) continue block10;
                    return false;
                }
                case STATIC: {
                    if (!this.isNotStatic()) continue block10;
                    return false;
                }
                case NOT_STATIC: {
                    if (!this.isStatic()) continue block10;
                    return false;
                }
                case TRANSIENT: {
                    if (!this.isNotTransient()) continue block10;
                    return false;
                }
                case NOT_TRANSIENT: {
                    if (!this.isTransient()) continue block10;
                    return false;
                }
                default: {
                    throw new BasicRuntimeException("Invalid flag for field: {0}", new Object[]{f});
                }
            }
        }
        return true;
    }

    public boolean isAny(ReflectFlags ... flags) {
        block10: for (ReflectFlags f : flags) {
            switch (f) {
                case DEPRECATED: {
                    if (!this.isDeprecated()) continue block10;
                    return true;
                }
                case NOT_DEPRECATED: {
                    if (!this.isNotDeprecated()) continue block10;
                    return true;
                }
                case PUBLIC: {
                    if (!this.isPublic()) continue block10;
                    return true;
                }
                case NOT_PUBLIC: {
                    if (!this.isNotPublic()) continue block10;
                    return true;
                }
                case STATIC: {
                    if (!this.isStatic()) continue block10;
                    return true;
                }
                case NOT_STATIC: {
                    if (!this.isNotStatic()) continue block10;
                    return true;
                }
                case TRANSIENT: {
                    if (!this.isTransient()) continue block10;
                    return true;
                }
                case NOT_TRANSIENT: {
                    if (!this.isNotTransient()) continue block10;
                    return true;
                }
                default: {
                    throw new BasicRuntimeException("Invalid flag for field: {0}", new Object[]{f});
                }
            }
        }
        return false;
    }

    public boolean is(ReflectFlags ... flags) {
        return this.isAll(flags);
    }

    public boolean isDeprecated() {
        return this.f.isAnnotationPresent(Deprecated.class);
    }

    public boolean isNotDeprecated() {
        return !this.f.isAnnotationPresent(Deprecated.class);
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.f.getModifiers());
    }

    public boolean isNotPublic() {
        return !Modifier.isPublic(this.f.getModifiers());
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.f.getModifiers());
    }

    public boolean isNotStatic() {
        return !Modifier.isStatic(this.f.getModifiers());
    }

    public boolean isTransient() {
        return Modifier.isTransient(this.f.getModifiers());
    }

    public boolean isNotTransient() {
        return !Modifier.isTransient(this.f.getModifiers());
    }

    public boolean hasName(String name) {
        return this.f.getName().equals(name);
    }

    public FieldInfo accessible() {
        this.setAccessible();
        return this;
    }

    public boolean setAccessible() {
        try {
            if (this.f != null) {
                this.f.setAccessible(true);
            }
            return true;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public boolean isVisible(Visibility v) {
        return v.isVisible(this.f);
    }

    public boolean matches(Predicate<FieldInfo> test) {
        return ConsumerUtils.test(test, this);
    }

    public FieldInfo accept(Predicate<FieldInfo> test, Consumer<FieldInfo> action) {
        if (this.matches(test)) {
            action.accept(this);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassInfo getType() {
        if (this.type == null) {
            FieldInfo fieldInfo = this;
            synchronized (fieldInfo) {
                this.type = ClassInfo.of(this.f.getType());
            }
        }
        return this.type;
    }

    public String toString() {
        return this.f.getDeclaringClass().getName() + "." + this.f.getName();
    }

    @Override
    public int compareTo(FieldInfo o) {
        return this.getName().compareTo(o.getName());
    }

    public String getName() {
        return this.f.getName();
    }

    public String getFullName() {
        StringBuilder sb = new StringBuilder(128);
        ClassInfo dc = this.declaringClass;
        Package p = dc.getPackage();
        if (p != null) {
            sb.append(p.getName()).append('.');
        }
        dc.appendShortName(sb);
        sb.append(".").append(this.getName());
        return sb.toString();
    }

    public <T> T get(Object o) throws BeanRuntimeException {
        try {
            this.f.setAccessible(true);
            return (T)this.f.get(o);
        }
        catch (Exception e) {
            throw new BeanRuntimeException(e);
        }
    }

    public <T> Optional<T> getOptional(Object o) throws BeanRuntimeException {
        return Optional.ofNullable(this.get(o));
    }

    public void set(Object o, Object value) throws BeanRuntimeException {
        try {
            this.f.setAccessible(true);
            this.f.set(o, value);
        }
        catch (Exception e) {
            throw new BeanRuntimeException(e);
        }
    }

    public void setIfNull(Object o, Object value) {
        Object v = this.get(o);
        if (v == null) {
            this.set(o, value);
        }
    }
}

