/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.reflect;

import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.juneau.AnnotationProvider;
import org.apache.juneau.BasicRuntimeException;
import org.apache.juneau.ExecutableException;
import org.apache.juneau.Value;
import org.apache.juneau.Visibility;
import org.apache.juneau.common.internal.ArgUtils;
import org.apache.juneau.common.internal.ThrowableUtils;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.ConsumerUtils;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.reflect.AnnotationInfo;
import org.apache.juneau.reflect.AnnotationList;
import org.apache.juneau.reflect.ConstructorInfo;
import org.apache.juneau.reflect.FieldInfo;
import org.apache.juneau.reflect.MethodInfo;
import org.apache.juneau.reflect.ReflectFlags;

public final class ClassInfo {
    private static final Map<Class<?>, ClassInfo> CACHE = new ConcurrentHashMap();
    public static final ClassInfo OBJECT = ClassInfo.of(Object.class);
    private final Type t;
    final Class<?> c;
    private final boolean isParameterizedType;
    private volatile Boolean isRepeatedAnnotation;
    private volatile ClassInfo[] interfaces;
    private volatile ClassInfo[] declaredInterfaces;
    private volatile ClassInfo[] parents;
    private volatile ClassInfo[] allParents;
    private volatile MethodInfo[] publicMethods;
    private volatile MethodInfo[] declaredMethods;
    private volatile MethodInfo[] allMethods;
    private volatile MethodInfo[] allMethodsParentFirst;
    private volatile MethodInfo repeatedAnnotationMethod;
    private volatile ConstructorInfo[] publicConstructors;
    private volatile ConstructorInfo[] declaredConstructors;
    private volatile FieldInfo[] publicFields;
    private volatile FieldInfo[] declaredFields;
    private volatile FieldInfo[] allFields;
    private volatile Annotation[] declaredAnnotations;
    private int dim = -1;
    private ClassInfo componentType;
    private final ConcurrentHashMap<Method, MethodInfo> methods = new ConcurrentHashMap();
    private final ConcurrentHashMap<Field, FieldInfo> fields = new ConcurrentHashMap();
    private final ConcurrentHashMap<Constructor<?>, ConstructorInfo> constructors = new ConcurrentHashMap();
    private static final Map<Class<?>, Class<?>> pmap1 = new HashMap();
    private static final Map<Class<?>, Class<?>> pmap2 = new HashMap();
    private static final Map<Class, Object> primitiveDefaultMap;

    public static ClassInfo of(Type t) {
        if (t == null) {
            return null;
        }
        if (t instanceof Class) {
            return ClassInfo.of((Class)t);
        }
        return new ClassInfo(ClassUtils.toClass(t), t);
    }

    public static ClassInfo of(Class<?> c) {
        if (c == null) {
            return null;
        }
        ClassInfo ci = CACHE.get(c);
        if (ci == null) {
            ci = new ClassInfo(c, c);
            CACHE.put(c, ci);
        }
        return ci;
    }

    public static ClassInfo of(Class<?> c, Type t) {
        if (c == t) {
            return ClassInfo.of(c);
        }
        return new ClassInfo(c, t);
    }

    public static ClassInfo of(Object o) {
        return ClassInfo.of(o == null ? null : (o instanceof Class ? (Class<?>)o : o.getClass()));
    }

    public static ClassInfo ofProxy(Object o) {
        if (o == null) {
            return null;
        }
        Class<?> c = ClassInfo.getProxyFor(o);
        return c == null ? ClassInfo.of(o) : ClassInfo.of(c);
    }

    private static Class<?> getProxyFor(Object o) {
        Class<?> c = o.getClass();
        String s = c.getName();
        if (s.indexOf(36) == -1 || !s.contains("$$EnhancerBySpringCGLIB$$")) {
            return null;
        }
        Value<Object> v = Value.empty();
        ClassInfo.of(c).forEachPublicMethod(m -> m.hasName("getTargetClass") && m.hasNoParams() && m.hasReturnType(Class.class), m -> ThrowableUtils.safeRun(() -> v.set((Class)m.invoke(o, new Object[0]))));
        return v.orElse(null);
    }

    protected ClassInfo(Class<?> c, Type t) {
        this.t = t;
        this.c = c;
        this.isParameterizedType = t == null ? false : t instanceof ParameterizedType;
    }

    public Type innerType() {
        return this.t;
    }

    public <T> Class<T> inner() {
        return this.c;
    }

    public ClassInfo unwrap(Class<?> ... wrapperTypes) {
        for (Class<?> wt : wrapperTypes) {
            Type t;
            if (!this.isParameterizedTypeOf(wt) || (t = this.getFirstParameterType(wt)) == null) continue;
            return ClassInfo.of(t).unwrap(wrapperTypes);
        }
        return this;
    }

    private boolean isParameterizedTypeOf(Class<?> c) {
        return this.t instanceof ParameterizedType && ((ParameterizedType)this.t).getRawType() == c || this.t instanceof Class && c.isAssignableFrom((Class)this.t);
    }

    private Type getFirstParameterType(Class<?> parameterizedType) {
        Class c;
        if (this.t instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)this.t;
            Type[] ta = pt.getActualTypeArguments();
            if (ta.length > 0) {
                return ta[0];
            }
        } else if (this.t instanceof Class && (c = (Class)this.t) != parameterizedType && parameterizedType.isAssignableFrom(c)) {
            return ClassInfo.of(c).getParameterType(0, parameterizedType);
        }
        return null;
    }

    MethodInfo getMethodInfo(Method x) {
        MethodInfo i = this.methods.get(x);
        if (i == null) {
            i = new MethodInfo(this, x);
            this.methods.put(x, i);
        }
        return i;
    }

    FieldInfo getFieldInfo(Field x) {
        FieldInfo i = this.fields.get(x);
        if (i == null) {
            i = new FieldInfo(this, x);
            this.fields.put(x, i);
        }
        return i;
    }

    ConstructorInfo getConstructorInfo(Constructor<?> x) {
        ConstructorInfo i = this.constructors.get(x);
        if (i == null) {
            i = new ConstructorInfo(this, x);
            this.constructors.put(x, i);
        }
        return i;
    }

    public ClassInfo getSuperclass() {
        return this.c == null ? null : ClassInfo.of(this.c.getSuperclass());
    }

    public List<ClassInfo> getDeclaredInterfaces() {
        return CollectionUtils.ulist(this._getDeclaredInterfaces());
    }

    public List<ClassInfo> getInterfaces() {
        return CollectionUtils.ulist(this._getInterfaces());
    }

    public List<ClassInfo> getParents() {
        return CollectionUtils.ulist(this._getParents());
    }

    public List<ClassInfo> getAllParents() {
        return CollectionUtils.ulist(this._getAllParents());
    }

    public ClassInfo getAnyParent(Predicate<ClassInfo> filter) {
        for (ClassInfo ci : this._getAllParents()) {
            if (!ConsumerUtils.test(filter, ci)) continue;
            return ci;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClassInfo[] _getInterfaces() {
        if (this.interfaces == null) {
            ClassInfo classInfo = this;
            synchronized (classInfo) {
                LinkedHashSet<ClassInfo> s = CollectionUtils.set(new ClassInfo[0]);
                for (ClassInfo ci : this._getParents()) {
                    for (ClassInfo ci2 : ci._getDeclaredInterfaces()) {
                        s.add(ci2);
                        for (ClassInfo ci3 : ci2._getInterfaces()) {
                            s.add(ci3);
                        }
                    }
                }
                this.interfaces = s.toArray(new ClassInfo[s.size()]);
            }
        }
        return this.interfaces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClassInfo[] _getDeclaredInterfaces() {
        if (this.declaredInterfaces == null) {
            ClassInfo classInfo = this;
            synchronized (classInfo) {
                Class[] ii = this.c == null ? new Class[]{} : this.c.getInterfaces();
                ClassInfo[] l = new ClassInfo[ii.length];
                for (int i = 0; i < ii.length; ++i) {
                    l[i] = ClassInfo.of(ii[i]);
                }
                this.declaredInterfaces = l;
            }
        }
        return this.declaredInterfaces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClassInfo[] _getParents() {
        if (this.parents == null) {
            ClassInfo classInfo = this;
            synchronized (classInfo) {
                ArrayList<ClassInfo> l = CollectionUtils.list(new ClassInfo[0]);
                for (Class<?> pc = this.c; pc != null && pc != Object.class; pc = pc.getSuperclass()) {
                    l.add(ClassInfo.of(pc));
                }
                this.parents = l.toArray(new ClassInfo[l.size()]);
            }
        }
        return this.parents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClassInfo[] _getAllParents() {
        if (this.allParents == null) {
            ClassInfo classInfo = this;
            synchronized (classInfo) {
                int i;
                ClassInfo[] a1 = this._getParents();
                ClassInfo[] a2 = this._getInterfaces();
                ClassInfo[] l = new ClassInfo[a1.length + a2.length];
                for (i = 0; i < a1.length; ++i) {
                    l[i] = a1[i];
                }
                for (i = 0; i < a2.length; ++i) {
                    l[i + a1.length] = a2[i];
                }
                this.allParents = l;
            }
        }
        return this.allParents;
    }

    public List<MethodInfo> getPublicMethods() {
        return CollectionUtils.ulist(this._getPublicMethods());
    }

    public final ClassInfo forEachPublicMethod(Predicate<MethodInfo> filter, Consumer<MethodInfo> action) {
        for (MethodInfo mi : this._getPublicMethods()) {
            ConsumerUtils.consume(filter, action, mi);
        }
        return this;
    }

    public final MethodInfo getPublicMethod(Predicate<MethodInfo> filter) {
        for (MethodInfo mi : this._getPublicMethods()) {
            if (!ConsumerUtils.test(filter, mi)) continue;
            return mi;
        }
        return null;
    }

    public List<MethodInfo> getDeclaredMethods() {
        return CollectionUtils.ulist(this._getDeclaredMethods());
    }

    public final ClassInfo forEachDeclaredMethod(Predicate<MethodInfo> filter, Consumer<MethodInfo> action) {
        for (MethodInfo mi : this._getDeclaredMethods()) {
            ConsumerUtils.consume(filter, action, mi);
        }
        return this;
    }

    public MethodInfo getDeclaredMethod(Predicate<MethodInfo> filter) {
        for (MethodInfo mi : this._getDeclaredMethods()) {
            if (!ConsumerUtils.test(filter, mi)) continue;
            return mi;
        }
        return null;
    }

    public List<MethodInfo> getMethods() {
        return CollectionUtils.ulist(this._getAllMethods());
    }

    public final ClassInfo forEachMethod(Predicate<MethodInfo> filter, Consumer<MethodInfo> action) {
        for (MethodInfo mi : this._getAllMethods()) {
            ConsumerUtils.consume(filter, action, mi);
        }
        return this;
    }

    public MethodInfo getMethod(Predicate<MethodInfo> filter) {
        for (MethodInfo mi : this._getAllMethods()) {
            if (!ConsumerUtils.test(filter, mi)) continue;
            return mi;
        }
        return null;
    }

    public List<MethodInfo> getAllMethodsParentFirst() {
        return CollectionUtils.ulist(this._getAllMethodsParentFirst());
    }

    public final ClassInfo forEachAllMethodParentFirst(Predicate<MethodInfo> filter, Consumer<MethodInfo> action) {
        for (MethodInfo mi : this._getAllMethodsParentFirst()) {
            ConsumerUtils.consume(filter, action, mi);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MethodInfo[] _getPublicMethods() {
        if (this.publicMethods == null) {
            ClassInfo classInfo = this;
            synchronized (classInfo) {
                Method[] mm = this.c == null ? new Method[]{} : this.c.getMethods();
                ArrayList<MethodInfo> l = CollectionUtils.list(mm.length);
                for (Method m : mm) {
                    if (m.getDeclaringClass() == Object.class) continue;
                    l.add(this.getMethodInfo(m));
                }
                l.sort(null);
                this.publicMethods = l.toArray(new MethodInfo[l.size()]);
            }
        }
        return this.publicMethods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MethodInfo[] _getDeclaredMethods() {
        if (this.declaredMethods == null) {
            ClassInfo classInfo = this;
            synchronized (classInfo) {
                Method[] mm = this.c == null ? new Method[]{} : this.c.getDeclaredMethods();
                ArrayList<MethodInfo> l = CollectionUtils.list(mm.length);
                for (Method m : mm) {
                    if ("$jacocoInit".equals(m.getName())) continue;
                    l.add(this.getMethodInfo(m));
                }
                l.sort(null);
                this.declaredMethods = l.toArray(new MethodInfo[l.size()]);
            }
        }
        return this.declaredMethods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MethodInfo[] _getAllMethods() {
        if (this.allMethods == null) {
            ClassInfo classInfo = this;
            synchronized (classInfo) {
                ArrayList<MethodInfo> l = CollectionUtils.list(new MethodInfo[0]);
                for (ClassInfo c : this._getAllParents()) {
                    c._appendDeclaredMethods(l);
                }
                this.allMethods = l.toArray(new MethodInfo[l.size()]);
            }
        }
        return this.allMethods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MethodInfo[] _getAllMethodsParentFirst() {
        if (this.allMethodsParentFirst == null) {
            ClassInfo classInfo = this;
            synchronized (classInfo) {
                ArrayList<MethodInfo> l = CollectionUtils.list(new MethodInfo[0]);
                ClassInfo[] parents = this._getAllParents();
                for (int i = parents.length - 1; i >= 0; --i) {
                    parents[i]._appendDeclaredMethods(l);
                }
                this.allMethodsParentFirst = l.toArray(new MethodInfo[l.size()]);
            }
        }
        return this.allMethodsParentFirst;
    }

    private synchronized List<MethodInfo> _appendDeclaredMethods(List<MethodInfo> l) {
        for (MethodInfo mi : this._getDeclaredMethods()) {
            l.add(mi);
        }
        return l;
    }

    public List<ConstructorInfo> getPublicConstructors() {
        return CollectionUtils.ulist(this._getPublicConstructors());
    }

    public final ClassInfo forEachPublicConstructor(Predicate<ConstructorInfo> filter, Consumer<ConstructorInfo> action) {
        for (ConstructorInfo mi : this._getPublicConstructors()) {
            ConsumerUtils.consume(filter, action, mi);
        }
        return this;
    }

    public ConstructorInfo getPublicConstructor(Predicate<ConstructorInfo> filter) {
        for (ConstructorInfo ci : this._getPublicConstructors()) {
            if (!ConsumerUtils.test(filter, ci)) continue;
            return ci;
        }
        return null;
    }

    public List<ConstructorInfo> getDeclaredConstructors() {
        return CollectionUtils.ulist(this._getDeclaredConstructors());
    }

    public final ClassInfo forEachDeclaredConstructor(Predicate<ConstructorInfo> filter, Consumer<ConstructorInfo> action) {
        for (ConstructorInfo mi : this._getDeclaredConstructors()) {
            ConsumerUtils.consume(filter, action, mi);
        }
        return this;
    }

    public ConstructorInfo getDeclaredConstructor(Predicate<ConstructorInfo> filter) {
        for (ConstructorInfo ci : this._getDeclaredConstructors()) {
            if (!ConsumerUtils.test(filter, ci)) continue;
            return ci;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConstructorInfo[] _getPublicConstructors() {
        if (this.publicConstructors == null) {
            ClassInfo classInfo = this;
            synchronized (classInfo) {
                Constructor[] cc = this.c == null ? new Constructor[]{} : this.c.getConstructors();
                ArrayList<ConstructorInfo> l = CollectionUtils.list(cc.length);
                for (Constructor ccc : cc) {
                    l.add(this.getConstructorInfo(ccc));
                }
                l.sort(null);
                this.publicConstructors = l.toArray(new ConstructorInfo[l.size()]);
            }
        }
        return this.publicConstructors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConstructorInfo[] _getDeclaredConstructors() {
        if (this.declaredConstructors == null) {
            ClassInfo classInfo = this;
            synchronized (classInfo) {
                Constructor[] cc = this.c == null ? new Constructor[]{} : this.c.getDeclaredConstructors();
                ArrayList<ConstructorInfo> l = CollectionUtils.list(cc.length);
                for (Constructor ccc : cc) {
                    l.add(this.getConstructorInfo(ccc));
                }
                l.sort(null);
                this.declaredConstructors = l.toArray(new ConstructorInfo[l.size()]);
            }
        }
        return this.declaredConstructors;
    }

    public ConstructorInfo getNoArgConstructor(Visibility v) {
        if (this.isAbstract()) {
            return null;
        }
        boolean isMemberClass = this.isNonStaticMemberClass();
        for (ConstructorInfo cc : this._getDeclaredConstructors()) {
            if (!cc.hasNumParams(isMemberClass ? 1 : 0) || !cc.isVisible(v)) continue;
            return cc.accessible(v);
        }
        return null;
    }

    public List<FieldInfo> getPublicFields() {
        return CollectionUtils.ulist(this._getPublicFields());
    }

    public final ClassInfo forEachPublicField(Predicate<FieldInfo> filter, Consumer<FieldInfo> action) {
        for (FieldInfo mi : this._getPublicFields()) {
            ConsumerUtils.consume(filter, action, mi);
        }
        return this;
    }

    public FieldInfo getPublicField(Predicate<FieldInfo> filter) {
        for (FieldInfo f : this._getPublicFields()) {
            if (!ConsumerUtils.test(filter, f)) continue;
            return f;
        }
        return null;
    }

    public List<FieldInfo> getDeclaredFields() {
        return CollectionUtils.ulist(this._getDeclaredFields());
    }

    public ClassInfo forEachDeclaredField(Predicate<FieldInfo> filter, Consumer<FieldInfo> action) {
        for (FieldInfo fi : this._getDeclaredFields()) {
            ConsumerUtils.consume(filter, action, fi);
        }
        return this;
    }

    public FieldInfo getDeclaredField(Predicate<FieldInfo> filter) {
        for (FieldInfo f : this._getDeclaredFields()) {
            if (!ConsumerUtils.test(filter, f)) continue;
            return f;
        }
        return null;
    }

    public List<FieldInfo> getAllFields() {
        return CollectionUtils.ulist(this._getAllFields());
    }

    public ClassInfo forEachAllField(Predicate<FieldInfo> filter, Consumer<FieldInfo> action) {
        for (FieldInfo fi : this._getAllFields()) {
            ConsumerUtils.consume(filter, action, fi);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FieldInfo[] _getPublicFields() {
        if (this.publicFields == null) {
            ClassInfo classInfo = this;
            synchronized (classInfo) {
                LinkedHashMap<String, FieldInfo> m = CollectionUtils.map();
                for (ClassInfo c : this._getParents()) {
                    for (FieldInfo f : c._getDeclaredFields()) {
                        String fn = f.getName();
                        if (!f.isPublic() || m.containsKey(fn) || "$jacocoData".equals(fn)) continue;
                        m.put(f.getName(), f);
                    }
                }
                ArrayList l = CollectionUtils.listFrom(m.values());
                l.sort(null);
                this.publicFields = l.toArray(new FieldInfo[l.size()]);
            }
        }
        return this.publicFields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FieldInfo[] _getDeclaredFields() {
        if (this.declaredFields == null) {
            ClassInfo classInfo = this;
            synchronized (classInfo) {
                Field[] ff = this.c == null ? new Field[]{} : this.c.getDeclaredFields();
                ArrayList<FieldInfo> l = CollectionUtils.list(ff.length);
                for (Field f : ff) {
                    if ("$jacocoData".equals(f.getName())) continue;
                    l.add(this.getFieldInfo(f));
                }
                l.sort(null);
                this.declaredFields = l.toArray(new FieldInfo[l.size()]);
            }
        }
        return this.declaredFields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FieldInfo[] _getAllFields() {
        if (this.allFields == null) {
            ClassInfo classInfo = this;
            synchronized (classInfo) {
                ArrayList<FieldInfo> l = CollectionUtils.list(new FieldInfo[0]);
                ClassInfo[] parents = this._getAllParents();
                for (int i = parents.length - 1; i >= 0; --i) {
                    for (FieldInfo f : parents[i]._getDeclaredFields()) {
                        l.add(f);
                    }
                }
                this.allFields = l.toArray(new FieldInfo[l.size()]);
            }
        }
        return this.allFields;
    }

    public <A extends Annotation> List<A> getAnnotations(Class<A> type) {
        return this.getAnnotations(null, type);
    }

    public <A extends Annotation> List<A> getAnnotations(AnnotationProvider annotationProvider, Class<A> type) {
        ArrayList<Annotation> l = CollectionUtils.list(new Annotation[0]);
        this.forEachAnnotation(annotationProvider, type, x -> true, x -> l.add((Annotation)x));
        return l;
    }

    public <A extends Annotation> ClassInfo forEachAnnotation(Class<A> type, Predicate<A> filter, Consumer<A> action) {
        return this.forEachAnnotation(null, type, filter, action);
    }

    public <A extends Annotation> ClassInfo forEachAnnotation(AnnotationProvider annotationProvider, Class<A> type, Predicate<A> filter, Consumer<A> action) {
        A t2;
        if (annotationProvider == null) {
            annotationProvider = AnnotationProvider.DEFAULT;
        }
        if ((t2 = this.getPackageAnnotation(type)) != null) {
            ConsumerUtils.consume(filter, action, t2);
        }
        ClassInfo[] interfaces = this._getInterfaces();
        for (int i = interfaces.length - 1; i >= 0; --i) {
            annotationProvider.forEachDeclaredAnnotation(type, interfaces[i].inner(), filter, action);
        }
        ClassInfo[] parents = this._getParents();
        for (int i = parents.length - 1; i >= 0; --i) {
            annotationProvider.forEachDeclaredAnnotation(type, parents[i].inner(), filter, action);
        }
        return this;
    }

    public <A extends Annotation> A firstAnnotation(Class<A> type, Predicate<A> filter) {
        return this.firstAnnotation(null, type, filter);
    }

    public <A extends Annotation> A firstAnnotation(AnnotationProvider annotationProvider, Class<A> type, Predicate<A> filter) {
        if (annotationProvider == null) {
            annotationProvider = AnnotationProvider.DEFAULT;
        }
        A x = null;
        x = this.getPackageAnnotation(type);
        if (x != null && ConsumerUtils.test(filter, x)) {
            return x;
        }
        ClassInfo[] interfaces = this._getInterfaces();
        for (int i = interfaces.length - 1; i >= 0; --i) {
            x = annotationProvider.firstAnnotation(type, interfaces[i].inner(), filter);
            if (x == null) continue;
            return x;
        }
        ClassInfo[] parents = this._getParents();
        for (int i = parents.length - 1; i >= 0; --i) {
            x = annotationProvider.firstAnnotation(type, parents[i].inner(), filter);
            if (x == null) continue;
            return x;
        }
        return null;
    }

    public <A extends Annotation> A lastAnnotation(Class<A> type, Predicate<A> filter) {
        return this.lastAnnotation(null, type, filter);
    }

    public <A extends Annotation> A lastAnnotation(AnnotationProvider annotationProvider, Class<A> type, Predicate<A> filter) {
        if (annotationProvider == null) {
            annotationProvider = AnnotationProvider.DEFAULT;
        }
        A x = null;
        ClassInfo[] parents = this._getParents();
        for (int i = 0; i < parents.length; ++i) {
            x = annotationProvider.lastAnnotation(type, parents[i].inner(), filter);
            if (x == null) continue;
            return x;
        }
        ClassInfo[] interfaces = this._getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            x = annotationProvider.lastAnnotation(type, interfaces[i].inner(), filter);
            if (x == null) continue;
            return x;
        }
        x = this.getPackageAnnotation(type);
        if (x != null && ConsumerUtils.test(filter, x)) {
            return x;
        }
        return null;
    }

    public <A extends Annotation> A getAnnotation(Class<A> type) {
        return this.getAnnotation(null, type);
    }

    public <A extends Annotation> A getAnnotation(AnnotationProvider annotationProvider, Class<A> type) {
        return this.findAnnotation(annotationProvider, type);
    }

    public <A extends Annotation> boolean hasAnnotation(Class<A> type) {
        return this.hasAnnotation(null, type);
    }

    public <A extends Annotation> boolean hasNoAnnotation(Class<A> type) {
        return !this.hasAnnotation(type);
    }

    public <A extends Annotation> boolean hasAnnotation(AnnotationProvider annotationProvider, Class<A> type) {
        if (annotationProvider == null) {
            annotationProvider = AnnotationProvider.DEFAULT;
        }
        return annotationProvider.firstAnnotation(type, this.c, (A x) -> true) != null;
    }

    public <A extends Annotation> A getPackageAnnotation(Class<A> type) {
        Package p = this.c == null ? null : this.c.getPackage();
        return p == null ? null : (A)p.getAnnotation(type);
    }

    public <A extends Annotation> A getAnnotation(Class<A> type, Predicate<A> filter) {
        return this.getAnnotation(null, type, filter);
    }

    public AnnotationList getAnnotationList() {
        return this.getAnnotationList(x -> true);
    }

    public AnnotationList getAnnotationList(Predicate<AnnotationInfo<?>> filter) {
        AnnotationList l = new AnnotationList();
        this.forEachAnnotationInfo(filter, x -> l.add(x));
        return l;
    }

    private static Annotation[] splitRepeated(Annotation a) {
        try {
            ClassInfo ci = ClassInfo.of(a.annotationType());
            MethodInfo mi = ci.getRepeatedAnnotationMethod();
            if (mi != null) {
                return (Annotation[])mi.invoke(a, new Object[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new Annotation[]{a};
    }

    private <A extends Annotation> A findAnnotation(AnnotationProvider ap, Class<A> a) {
        Annotation t;
        if (a == null) {
            return null;
        }
        if (ap == null) {
            ap = AnnotationProvider.DEFAULT;
        }
        if ((t = ap.firstDeclaredAnnotation(a, this.c, x -> true)) != null) {
            return (A)t;
        }
        ClassInfo sci = this.getSuperclass();
        if (sci != null && (t = sci.getAnnotation(ap, a)) != null) {
            return (A)t;
        }
        for (ClassInfo c2 : this._getInterfaces()) {
            t = c2.getAnnotation(ap, a);
            if (t == null) continue;
            return (A)t;
        }
        return null;
    }

    private <A extends Annotation> A getAnnotation(AnnotationProvider ap, Class<A> a, Predicate<A> filter) {
        A t2;
        if (ap == null) {
            ap = AnnotationProvider.DEFAULT;
        }
        if ((t2 = this.getPackageAnnotation(a)) != null && filter.test(t2)) {
            return t2;
        }
        ClassInfo[] interfaces = this._getInterfaces();
        for (int i = interfaces.length - 1; i >= 0; --i) {
            A o = ap.firstDeclaredAnnotation(a, interfaces[i].inner(), filter);
            if (o == null) continue;
            return o;
        }
        ClassInfo[] parents = this._getParents();
        for (int i = parents.length - 1; i >= 0; --i) {
            A o = ap.firstDeclaredAnnotation(a, parents[i].inner(), filter);
            if (o == null) continue;
            return o;
        }
        return null;
    }

    public ClassInfo forEachAnnotationInfo(Predicate<AnnotationInfo<?>> filter, Consumer<AnnotationInfo<?>> action) {
        Package p = this.c.getPackage();
        if (p != null) {
            for (Annotation a : p.getDeclaredAnnotations()) {
                for (Annotation a2 : ClassInfo.splitRepeated(a)) {
                    AnnotationInfo.of(p, a2).accept(filter, action);
                }
            }
        }
        ClassInfo[] interfaces = this._getInterfaces();
        for (int i = interfaces.length - 1; i >= 0; --i) {
            for (Annotation a : interfaces[i].c.getDeclaredAnnotations()) {
                for (Annotation a2 : ClassInfo.splitRepeated(a)) {
                    AnnotationInfo.of(interfaces[i], a2).accept(filter, action);
                }
            }
        }
        ClassInfo[] parents = this._getParents();
        for (int i = parents.length - 1; i >= 0; --i) {
            for (Annotation a : parents[i].c.getDeclaredAnnotations()) {
                for (Annotation a2 : ClassInfo.splitRepeated(a)) {
                    AnnotationInfo.of(parents[i], a2).accept(filter, action);
                }
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Annotation[] _getDeclaredAnnotations() {
        if (this.declaredAnnotations == null) {
            ClassInfo classInfo = this;
            synchronized (classInfo) {
                this.declaredAnnotations = this.c.getDeclaredAnnotations();
            }
        }
        return this.declaredAnnotations;
    }

    public boolean isAll(ReflectFlags ... flags) {
        block14: for (ReflectFlags f : flags) {
            switch (f) {
                case DEPRECATED: {
                    if (!this.isNotDeprecated()) continue block14;
                    return false;
                }
                case NOT_DEPRECATED: {
                    if (!this.isDeprecated()) continue block14;
                    return false;
                }
                case PUBLIC: {
                    if (!this.isNotPublic()) continue block14;
                    return false;
                }
                case NOT_PUBLIC: {
                    if (!this.isPublic()) continue block14;
                    return false;
                }
                case STATIC: {
                    if (!this.isNotStatic()) continue block14;
                    return false;
                }
                case NOT_STATIC: {
                    if (!this.isStatic()) continue block14;
                    return false;
                }
                case MEMBER: {
                    if (!this.isNotMemberClass()) continue block14;
                    return false;
                }
                case NOT_MEMBER: {
                    if (!this.isMemberClass()) continue block14;
                    return false;
                }
                case ABSTRACT: {
                    if (!this.isNotAbstract()) continue block14;
                    return false;
                }
                case NOT_ABSTRACT: {
                    if (!this.isAbstract()) continue block14;
                    return false;
                }
                case INTERFACE: {
                    if (!this.isClass()) continue block14;
                    return false;
                }
                case CLASS: {
                    if (!this.isInterface()) continue block14;
                    return false;
                }
                default: {
                    throw new BasicRuntimeException("Invalid flag for class: {0}", new Object[]{f});
                }
            }
        }
        return true;
    }

    public boolean isAny(ReflectFlags ... flags) {
        block14: for (ReflectFlags f : flags) {
            switch (f) {
                case DEPRECATED: {
                    if (!this.isDeprecated()) continue block14;
                    return true;
                }
                case NOT_DEPRECATED: {
                    if (!this.isNotDeprecated()) continue block14;
                    return true;
                }
                case PUBLIC: {
                    if (!this.isPublic()) continue block14;
                    return true;
                }
                case NOT_PUBLIC: {
                    if (!this.isNotPublic()) continue block14;
                    return true;
                }
                case STATIC: {
                    if (!this.isStatic()) continue block14;
                    return true;
                }
                case NOT_STATIC: {
                    if (!this.isNotStatic()) continue block14;
                    return true;
                }
                case MEMBER: {
                    if (!this.isMemberClass()) continue block14;
                    return true;
                }
                case NOT_MEMBER: {
                    if (!this.isNotMemberClass()) continue block14;
                    return true;
                }
                case ABSTRACT: {
                    if (!this.isAbstract()) continue block14;
                    return true;
                }
                case NOT_ABSTRACT: {
                    if (!this.isNotAbstract()) continue block14;
                    return true;
                }
                case INTERFACE: {
                    if (!this.isInterface()) continue block14;
                    return true;
                }
                case CLASS: {
                    if (!this.isClass()) continue block14;
                    return true;
                }
                default: {
                    throw new BasicRuntimeException("Invalid flag for class: {0}", new Object[]{f});
                }
            }
        }
        return false;
    }

    public boolean isDeprecated() {
        return this.c != null && this.c.isAnnotationPresent(Deprecated.class);
    }

    public boolean isNotDeprecated() {
        return this.c == null || !this.c.isAnnotationPresent(Deprecated.class);
    }

    public boolean isPublic() {
        return this.c != null && Modifier.isPublic(this.c.getModifiers());
    }

    public boolean isNotPublic() {
        return this.c == null || !Modifier.isPublic(this.c.getModifiers());
    }

    public boolean isStatic() {
        return this.c != null && Modifier.isStatic(this.c.getModifiers());
    }

    public boolean isNotStatic() {
        return this.c == null || !Modifier.isStatic(this.c.getModifiers());
    }

    public boolean isAbstract() {
        return this.c != null && Modifier.isAbstract(this.c.getModifiers());
    }

    public boolean isNotAbstract() {
        return this.c == null || !Modifier.isAbstract(this.c.getModifiers());
    }

    public boolean isMemberClass() {
        return this.c != null && this.c.isMemberClass();
    }

    public boolean isNotMemberClass() {
        return this.c == null || !this.c.isMemberClass();
    }

    public boolean isNonStaticMemberClass() {
        return this.c != null && this.c.isMemberClass() && !this.isStatic();
    }

    public boolean isNotNonStaticMemberClass() {
        return !this.isNonStaticMemberClass();
    }

    public boolean isLocalClass() {
        return this.c != null && this.c.isLocalClass();
    }

    public boolean isNotLocalClass() {
        return this.c == null || !this.c.isLocalClass();
    }

    public boolean isVisible(Visibility v) {
        return this.c != null && v.isVisible(this.c);
    }

    public boolean isPrimitive() {
        return this.c != null && this.c.isPrimitive();
    }

    public boolean isNotPrimitive() {
        return this.c == null || !this.c.isPrimitive();
    }

    public boolean isInterface() {
        return this.c != null && this.c.isInterface();
    }

    public boolean isClass() {
        return this.c != null && !this.c.isInterface();
    }

    public boolean isRuntimeException() {
        return this.isChildOf(RuntimeException.class);
    }

    public boolean hasPrimitiveWrapper() {
        return pmap1.containsKey(this.c);
    }

    public Class<?> getPrimitiveWrapper() {
        return pmap1.get(this.c);
    }

    public Class<?> getPrimitiveForWrapper() {
        return pmap2.get(this.c);
    }

    public Class<?> getWrapperIfPrimitive() {
        if (this.c != null && !this.c.isPrimitive()) {
            return this.c;
        }
        return pmap1.get(this.c);
    }

    public ClassInfo getWrapperInfoIfPrimitive() {
        if (this.c == null || !this.c.isPrimitive()) {
            return this;
        }
        return ClassInfo.of(pmap1.get(this.c));
    }

    public Object getPrimitiveDefault() {
        return primitiveDefaultMap.get(this.c);
    }

    public String getFullName() {
        Class ct = this.getComponentType().inner();
        int dim = this.getDimensions();
        if (ct != null && dim == 0 && !this.isParameterizedType) {
            return ct.getName();
        }
        StringBuilder sb = new StringBuilder(128);
        this.appendFullName(sb);
        return sb.toString();
    }

    public String[] getNames() {
        return new String[]{this.getFullName(), this.c.getName(), this.getShortName(), this.getSimpleName()};
    }

    public StringBuilder appendFullName(StringBuilder sb) {
        Class ct = this.getComponentType().inner();
        int dim = this.getDimensions();
        if (ct != null && dim == 0 && !this.isParameterizedType) {
            return sb.append(ct.getName());
        }
        sb.append(ct != null ? ct.getName() : this.t.getTypeName());
        if (this.isParameterizedType) {
            ParameterizedType pt = (ParameterizedType)this.t;
            sb.append('<');
            boolean first = true;
            for (Type t2 : pt.getActualTypeArguments()) {
                if (!first) {
                    sb.append(',');
                }
                first = false;
                ClassInfo.of(t2).appendFullName(sb);
            }
            sb.append('>');
        }
        for (int i = 0; i < dim; ++i) {
            sb.append('[').append(']');
        }
        return sb;
    }

    public String getShortName() {
        Class ct = this.getComponentType().inner();
        int dim = this.getDimensions();
        if (!(ct == null || dim != 0 || this.isParameterizedType || this.isMemberClass() || this.c.isLocalClass())) {
            return ct.getSimpleName();
        }
        StringBuilder sb = new StringBuilder(32);
        this.appendShortName(sb);
        return sb.toString();
    }

    public StringBuilder appendShortName(StringBuilder sb) {
        Class ct = this.getComponentType().inner();
        int dim = this.getDimensions();
        if (ct != null) {
            if (ct.isLocalClass()) {
                sb.append(ClassInfo.of(ct.getEnclosingClass()).getSimpleName()).append('$').append(ct.getSimpleName());
            } else if (ct.isMemberClass()) {
                sb.append(ClassInfo.of(ct.getDeclaringClass()).getSimpleName()).append('$').append(ct.getSimpleName());
            } else {
                sb.append(ct.getSimpleName());
            }
        } else {
            sb.append(this.t.getTypeName());
        }
        if (this.isParameterizedType) {
            ParameterizedType pt = (ParameterizedType)this.t;
            sb.append('<');
            boolean first = true;
            for (Type t2 : pt.getActualTypeArguments()) {
                if (!first) {
                    sb.append(',');
                }
                first = false;
                ClassInfo.of(t2).appendShortName(sb);
            }
            sb.append('>');
        }
        for (int i = 0; i < dim; ++i) {
            sb.append('[').append(']');
        }
        return sb;
    }

    public String getSimpleName() {
        return this.c != null ? this.c.getSimpleName() : this.t.getTypeName();
    }

    public String getName() {
        return this.c != null ? this.c.getName() : this.t.getTypeName();
    }

    public String getReadableName() {
        if (this.c == null) {
            return this.t.getTypeName();
        }
        if (!this.c.isArray()) {
            return this.c.getSimpleName();
        }
        Class<?> c = this.c;
        StringBuilder sb = new StringBuilder();
        while (c.isArray()) {
            sb.append("Array");
            c = c.getComponentType();
        }
        return c.getSimpleName() + sb;
    }

    public boolean isParentOf(Class<?> child) {
        return this.c != null && child != null && this.c.isAssignableFrom(child);
    }

    public boolean isParentOfFuzzyPrimitives(Class<?> child) {
        if (this.c == null || child == null) {
            return false;
        }
        if (this.c.isAssignableFrom(child)) {
            return true;
        }
        if (this.isPrimitive() || child.isPrimitive()) {
            return this.getWrapperIfPrimitive().isAssignableFrom(ClassInfo.of(child).getWrapperIfPrimitive());
        }
        return false;
    }

    public boolean canAcceptArg(Object child) {
        if (this.c == null || child == null) {
            return false;
        }
        if (this.c.isInstance(child)) {
            return true;
        }
        if (this.isPrimitive() || child.getClass().isPrimitive()) {
            return this.getWrapperIfPrimitive().isAssignableFrom(ClassInfo.of(child).getWrapperIfPrimitive());
        }
        return false;
    }

    public boolean isParentOfFuzzyPrimitives(ClassInfo child) {
        if (this.c == null || child == null) {
            return false;
        }
        if (this.c.isAssignableFrom(child.inner())) {
            return true;
        }
        if (this.isPrimitive() || child.isPrimitive()) {
            return this.getWrapperIfPrimitive().isAssignableFrom(child.getWrapperIfPrimitive());
        }
        return false;
    }

    public boolean isParentOf(Type child) {
        if (child instanceof Class) {
            return this.isParentOf((Class)child);
        }
        return false;
    }

    public boolean isParentOfFuzzyPrimitives(Type child) {
        if (child instanceof Class) {
            return this.isParentOfFuzzyPrimitives((Class)child);
        }
        return false;
    }

    public boolean isStrictChildOf(Class<?> parent) {
        return this.c != null && parent != null && parent.isAssignableFrom(this.c) && !this.c.equals(parent);
    }

    public boolean isChildOf(Class<?> parent) {
        return this.c != null && parent != null && parent.isAssignableFrom(this.c);
    }

    public boolean isChildOfAny(Class<?> ... parents) {
        for (Class<?> p : parents) {
            if (!this.isChildOf(p)) continue;
            return true;
        }
        return false;
    }

    public boolean isChildOf(Type parent) {
        if (parent instanceof Class) {
            return this.isChildOf((Class)parent);
        }
        return false;
    }

    public boolean isChildOf(ClassInfo parent) {
        return this.isChildOf(parent.inner());
    }

    public boolean is(Class<?> c) {
        return this.c != null && this.c.equals(c);
    }

    public boolean is(ClassInfo c) {
        if (this.c != null) {
            return this.c.equals(c.inner());
        }
        return this.t.equals(c.t);
    }

    public boolean isInstance(Object value) {
        if (this.c != null) {
            return this.c.isInstance(value);
        }
        return false;
    }

    public boolean isAny(Class<?> ... types) {
        for (Class<?> cc : types) {
            if (!this.is(cc)) continue;
            return true;
        }
        return false;
    }

    public boolean is(ReflectFlags ... flags) {
        return this.isAll(flags);
    }

    public Package getPackage() {
        return this.c == null ? null : this.c.getPackage();
    }

    public boolean hasPackage() {
        return this.getPackage() != null;
    }

    public int getDimensions() {
        if (this.dim == -1) {
            Class<?> ct;
            int d = 0;
            for (ct = this.c; ct != null && ct.isArray(); ct = ct.getComponentType()) {
                ++d;
            }
            this.dim = d;
            this.componentType = ct == this.c ? this : ClassInfo.of(ct);
        }
        return this.dim;
    }

    public ClassInfo getComponentType() {
        if (this.componentType == null) {
            if (this.c == null) {
                this.componentType = this;
            } else {
                this.getDimensions();
            }
        }
        return this.componentType;
    }

    public boolean isEnum() {
        return this.c != null && this.c.isEnum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRepeatedAnnotation() {
        if (this.isRepeatedAnnotation == null) {
            ClassInfo classInfo = this;
            synchronized (classInfo) {
                ClassInfo rct;
                ClassInfo rt;
                boolean b = false;
                this.repeatedAnnotationMethod = this.getPublicMethod(x -> x.hasName("value"));
                if (this.repeatedAnnotationMethod != null && (rt = this.repeatedAnnotationMethod.getReturnType()).isArray() && (rct = rt.getComponentType()).hasAnnotation(Repeatable.class)) {
                    Repeatable r = rct.getAnnotation(Repeatable.class);
                    b = r.value().equals(this.c);
                }
                this.isRepeatedAnnotation = b;
            }
        }
        return this.isRepeatedAnnotation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MethodInfo getRepeatedAnnotationMethod() {
        if (this.isRepeatedAnnotation()) {
            if (this.repeatedAnnotationMethod == null) {
                ClassInfo classInfo = this;
                synchronized (classInfo) {
                    this.repeatedAnnotationMethod = this.getPublicMethod(x -> x.hasName("value"));
                }
            }
            return this.repeatedAnnotationMethod;
        }
        return null;
    }

    public boolean isArray() {
        return this.c != null && this.c.isArray();
    }

    public boolean isAnnotation() {
        return this.c != null && this.c.isAnnotation();
    }

    public boolean isCollectionOrArray() {
        return this.c != null && (Collection.class.isAssignableFrom(this.c) || this.c.isArray());
    }

    public Object newInstance() throws ExecutableException {
        if (this.c == null) {
            throw new ExecutableException("Type ''{0}'' cannot be instantiated", this.getFullName());
        }
        try {
            return this.c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new ExecutableException(e);
        }
    }

    public Class<?> getParameterType(int index, Class<?> pt) {
        ArgUtils.assertArgNotNull((String)"pt", pt);
        HashMap<Type, Type> typeMap = new HashMap<Type, Type>();
        Class<?> cc = this.c;
        while (pt != cc.getSuperclass()) {
            ClassInfo.extractTypes(typeMap, cc);
            cc = cc.getSuperclass();
            ArgUtils.assertArg((cc != null ? 1 : 0) != 0, (String)"Class ''{0}'' is not a subclass of parameterized type ''{1}''", (Object[])new Object[]{this.c.getSimpleName(), pt.getSimpleName()});
        }
        Type gsc = cc.getGenericSuperclass();
        ArgUtils.assertArg((boolean)(gsc instanceof ParameterizedType), (String)"Class ''{0}'' is not a parameterized type", (Object[])new Object[]{pt.getSimpleName()});
        ParameterizedType cpt = (ParameterizedType)gsc;
        Type[] atArgs = cpt.getActualTypeArguments();
        ArgUtils.assertArg((index < atArgs.length ? 1 : 0) != 0, (String)"Invalid type index. index={0}, argsLength={1}", (Object[])new Object[]{index, atArgs.length});
        Type actualType = cpt.getActualTypeArguments()[index];
        if (typeMap.containsKey(actualType)) {
            actualType = (Type)typeMap.get(actualType);
        }
        if (actualType instanceof Class) {
            return (Class)actualType;
        }
        if (actualType instanceof GenericArrayType) {
            Type gct = ((GenericArrayType)actualType).getGenericComponentType();
            if (gct instanceof ParameterizedType) {
                return Array.newInstance((Class)((ParameterizedType)gct).getRawType(), 0).getClass();
            }
        } else if (actualType instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)actualType;
            LinkedList nestedOuterTypes = new LinkedList();
            for (Class<?> ec = cc.getEnclosingClass(); ec != null; ec = ec.getEnclosingClass()) {
                Class<?> outerClass = cc.getClass();
                nestedOuterTypes.add(outerClass);
                HashMap<Type, Type> outerTypeMap = new HashMap<Type, Type>();
                ClassInfo.extractTypes(outerTypeMap, outerClass);
                for (Map.Entry entry : outerTypeMap.entrySet()) {
                    TypeVariable keyType;
                    Type key = (Type)entry.getKey();
                    Type value = (Type)entry.getValue();
                    if (!(key instanceof TypeVariable) || !(keyType = (TypeVariable)key).getName().equals(typeVariable.getName()) || !ClassInfo.isInnerClass(keyType.getGenericDeclaration(), typeVariable.getGenericDeclaration())) continue;
                    if (value instanceof Class) {
                        return (Class)value;
                    }
                    typeVariable = (TypeVariable)entry.getValue();
                }
            }
        } else if (actualType instanceof ParameterizedType) {
            return (Class)((ParameterizedType)actualType).getRawType();
        }
        throw new IllegalArgumentException("Could not resolve variable '" + actualType.getTypeName() + "' to a type.");
    }

    private static boolean isInnerClass(GenericDeclaration od, GenericDeclaration id) {
        if (od instanceof Class && id instanceof Class) {
            Class oc = (Class)od;
            Class<?> ic = (Class<?>)id;
            while ((ic = ic.getEnclosingClass()) != null) {
                if (ic != oc) continue;
                return true;
            }
        }
        return false;
    }

    private static void extractTypes(Map<Type, Type> typeMap, Class<?> c) {
        Type gs = c.getGenericSuperclass();
        if (gs instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)gs;
            TypeVariable<Class<T>>[] typeParameters = ((Class)pt.getRawType()).getTypeParameters();
            Type[] actualTypeArguments = pt.getActualTypeArguments();
            for (int i = 0; i < typeParameters.length; ++i) {
                if (typeMap.containsKey(actualTypeArguments[i])) {
                    actualTypeArguments[i] = typeMap.get(actualTypeArguments[i]);
                }
                typeMap.put(typeParameters[i], actualTypeArguments[i]);
            }
        }
    }

    public boolean matches(Predicate<ClassInfo> test) {
        return ConsumerUtils.test(test, this);
    }

    public ClassInfo accept(Predicate<ClassInfo> test, Consumer<ClassInfo> action) {
        if (this.matches(test)) {
            action.accept(this);
        }
        return this;
    }

    public String toString() {
        return this.t.toString();
    }

    public int hashCode() {
        return this.t.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof ClassInfo && ObjectUtils.eq(this, (ClassInfo)o, (x, y) -> ObjectUtils.eq(x.t, y.t));
    }

    static {
        pmap1.put(Boolean.TYPE, Boolean.class);
        pmap1.put(Byte.TYPE, Byte.class);
        pmap1.put(Short.TYPE, Short.class);
        pmap1.put(Character.TYPE, Character.class);
        pmap1.put(Integer.TYPE, Integer.class);
        pmap1.put(Long.TYPE, Long.class);
        pmap1.put(Float.TYPE, Float.class);
        pmap1.put(Double.TYPE, Double.class);
        pmap2.put(Boolean.class, Boolean.TYPE);
        pmap2.put(Byte.class, Byte.TYPE);
        pmap2.put(Short.class, Short.TYPE);
        pmap2.put(Character.class, Character.TYPE);
        pmap2.put(Integer.class, Integer.TYPE);
        pmap2.put(Long.class, Long.TYPE);
        pmap2.put(Float.class, Float.TYPE);
        pmap2.put(Double.class, Double.TYPE);
        primitiveDefaultMap = CollectionUtils.mapBuilder(Class.class, Object.class, new Type[0]).unmodifiable().add(Boolean.TYPE, false).add(Character.TYPE, Character.valueOf('\u0000')).add(Short.TYPE, (short)0).add(Integer.TYPE, 0).add(Long.TYPE, 0L).add(Float.TYPE, Float.valueOf(0.0f)).add(Double.TYPE, 0.0).add(Byte.TYPE, (byte)0).add(Boolean.class, false).add(Character.class, Character.valueOf('\u0000')).add(Short.class, (short)0).add(Integer.class, 0).add(Long.class, 0L).add(Float.class, Float.valueOf(0.0f)).add(Double.class, 0.0).add(Byte.class, (byte)0).build();
    }
}

