/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.html;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanMapEntry;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.Delegate;
import org.apache.juneau.MediaType;
import org.apache.juneau.UriContext;
import org.apache.juneau.Value;
import org.apache.juneau.common.internal.IOUtils;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.html.AnchorText;
import org.apache.juneau.html.HtmlBeanPropertyMeta;
import org.apache.juneau.html.HtmlClassMeta;
import org.apache.juneau.html.HtmlRender;
import org.apache.juneau.html.HtmlSerializer;
import org.apache.juneau.html.HtmlWriter;
import org.apache.juneau.html.annotation.HtmlLink;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.SerializerPipe;
import org.apache.juneau.serializer.SerializerSession;
import org.apache.juneau.svl.VarResolverSession;
import org.apache.juneau.swap.ObjectSwap;
import org.apache.juneau.xml.Namespace;
import org.apache.juneau.xml.XmlSerializerSession;
import org.apache.juneau.xml.XmlWriter;
import org.apache.juneau.xml.annotation.XmlFormat;

public class HtmlSerializerSession
extends XmlSerializerSession {
    private final HtmlSerializer ctx;
    private final Pattern urlPattern = Pattern.compile("http[s]?\\:\\/\\/.*");
    private final Pattern labelPattern;

    public static Builder create(HtmlSerializer ctx) {
        return new Builder(ctx);
    }

    protected HtmlSerializerSession(Builder builder) {
        super(builder);
        this.ctx = builder.ctx;
        this.labelPattern = Pattern.compile("[\\?\\&]" + Pattern.quote(this.ctx.getLabelParameter()) + "=([^\\&]*)");
    }

    protected final HtmlWriter getHtmlWriter(SerializerPipe out) throws IOException {
        Object output = out.getRawOutput();
        if (output instanceof HtmlWriter) {
            return (HtmlWriter)output;
        }
        HtmlWriter w = new HtmlWriter(out.getWriter(), this.isUseWhitespace(), this.getMaxIndent(), this.isTrimStrings(), this.getQuoteChar(), this.getUriResolver());
        out.setWriter(w);
        return w;
    }

    public boolean isUri(ClassMeta<?> cm, BeanPropertyMeta pMeta, Object o) {
        if (cm.isUri() || pMeta != null && pMeta.isUri()) {
            return true;
        }
        return this.isDetectLinksInStrings() && o instanceof CharSequence && this.urlPattern.matcher(o.toString()).matches();
    }

    public String getAnchorText(BeanPropertyMeta pMeta, Object o) {
        Matcher m;
        String s = o.toString();
        if (this.isDetectLabelParameters() && (m = this.labelPattern.matcher(s)).find()) {
            return StringUtils.urlDecode((String)m.group(1));
        }
        switch (this.getUriAnchorText()) {
            case LAST_TOKEN: {
                s = this.resolveUri(s);
                if (s.indexOf(47) != -1) {
                    s = s.substring(s.lastIndexOf(47) + 1);
                }
                if (s.indexOf(63) != -1) {
                    s = s.substring(0, s.indexOf(63));
                }
                if (s.indexOf(35) != -1) {
                    s = s.substring(0, s.indexOf(35));
                }
                if (s.isEmpty()) {
                    s = "/";
                }
                return StringUtils.urlDecode((String)s);
            }
            case URI_ANCHOR: {
                if (s.indexOf(35) != -1) {
                    s = s.substring(s.lastIndexOf(35) + 1);
                }
                return StringUtils.urlDecode((String)s);
            }
            case PROPERTY_NAME: {
                return pMeta == null ? s : pMeta.getName();
            }
            case URI: {
                return this.resolveUri(s);
            }
            case CONTEXT_RELATIVE: {
                return this.relativizeUri("context:/", s);
            }
            case SERVLET_RELATIVE: {
                return this.relativizeUri("servlet:/", s);
            }
            case PATH_RELATIVE: {
                return this.relativizeUri("request:/", s);
            }
        }
        return s;
    }

    @Override
    public boolean isHtmlMode() {
        return true;
    }

    @Override
    protected void doSerialize(SerializerPipe out, Object o) throws IOException, SerializeException {
        this.doSerialize(o, this.getHtmlWriter(out));
    }

    private XmlWriter doSerialize(Object o, XmlWriter w) throws IOException, SerializeException {
        this.serializeAnything(w, o, this.getExpectedRootType(o), null, null, this.getInitialDepth() - 1, true, false);
        return w;
    }

    @Override
    protected XmlSerializerSession.ContentResult serializeAnything(XmlWriter out, Object o, ClassMeta<?> eType, String keyName, String elementName, Namespace elementNamespace, boolean addNamespaceUris, XmlFormat format, boolean isMixed, boolean preserveWhitespace, BeanPropertyMeta pMeta) throws SerializeException {
        ClassMeta<Object> type = this.push2(elementName, o, eType);
        this.pop();
        if (type == null) {
            type = this.object();
        } else if (type.isDelegate()) {
            type = ((Delegate)o).getClassMeta();
        }
        ObjectSwap<Object, ?> swap = type.getSwap(this);
        if (swap != null) {
            o = this.swap(swap, o);
            type = swap.getSwapClassMeta(this);
            if (type.isObject()) {
                type = this.getClassMetaForObject(o);
            }
        }
        HtmlClassMeta cHtml = this.getHtmlClassMeta(type);
        if (type.isMapOrBean() && !cHtml.isXml()) {
            return this.serializeAnything(out, o, eType, elementName, pMeta, 0, false, false);
        }
        return super.serializeAnything(out, o, eType, keyName, elementName, elementNamespace, addNamespaceUris, format, isMixed, preserveWhitespace, pMeta);
    }

    protected XmlSerializerSession.ContentResult serializeAnything(XmlWriter out, Object o, ClassMeta<?> eType, String name, BeanPropertyMeta pMeta, int xIndent, boolean isRoot, boolean nlIfElement) throws SerializeException {
        ClassMeta<Object> aType = null;
        ClassMeta<Object> wType = null;
        ClassMeta<Object> sType = this.object();
        if (eType == null) {
            eType = this.object();
        }
        if ((aType = this.push2(name, o, eType)) == null) {
            o = null;
            aType = this.object();
        }
        if (this.isOptional(aType)) {
            o = this.getOptionalValue(o);
            eType = this.getOptionalType(eType);
            aType = this.getClassMetaForObject(o, this.object());
        }
        this.indent += xIndent;
        XmlSerializerSession.ContentResult cr = XmlSerializerSession.ContentResult.CR_ELEMENTS;
        if (o == null || aType.isChar() && ((Character)o).charValue() == '\u0000') {
            out.tag("null");
            cr = XmlSerializerSession.ContentResult.CR_MIXED;
        } else {
            Object o2;
            ObjectSwap<Object, ?> swap;
            if (aType.isDelegate()) {
                wType = aType;
                aType = ((Delegate)o).getClassMeta();
            }
            sType = aType;
            String typeName = null;
            if (this.isAddBeanTypes() && !eType.equals(aType)) {
                typeName = aType.getDictionaryName();
            }
            if ((swap = aType.getSwap(this)) != null) {
                o = this.swap(swap, o);
                sType = swap.getSwapClassMeta(this);
                if (sType.isObject()) {
                    sType = this.getClassMetaForObject(o);
                }
            }
            if (sType.isReader() || sType.isInputStream()) {
                this.pop();
                this.indent -= xIndent;
                if (sType.isReader()) {
                    IOUtils.pipe((Reader)((Reader)o), (Writer)out, x$0 -> SerializerSession.handleThrown(x$0));
                } else {
                    IOUtils.pipe((InputStream)((InputStream)o), (Writer)out, x$0 -> SerializerSession.handleThrown(x$0));
                }
                return XmlSerializerSession.ContentResult.CR_MIXED;
            }
            HtmlClassMeta cHtml = this.getHtmlClassMeta(sType);
            HtmlBeanPropertyMeta bpHtml = this.getHtmlBeanPropertyMeta(pMeta);
            HtmlRender render = ObjectUtils.firstNonNull(bpHtml.getRender(), cHtml.getRender());
            if (render != null && (o2 = render.getContent(this, o)) != o) {
                this.indent -= xIndent;
                this.pop();
                out.nl(this.indent);
                return this.serializeAnything(out, o2, null, typeName, null, xIndent, false, false);
            }
            if (cHtml.isXml() || bpHtml.isXml()) {
                this.pop();
                ++this.indent;
                if (nlIfElement) {
                    out.nl(0);
                }
                super.serializeAnything(out, o, null, null, null, null, false, XmlFormat.MIXED, false, false, null);
                this.indent -= xIndent + 1;
                return cr;
            }
            if (cHtml.isPlainText() || bpHtml.isPlainText()) {
                out.w(o == null ? "null" : o.toString());
                cr = XmlSerializerSession.ContentResult.CR_MIXED;
            } else if (o == null || sType.isChar() && ((Character)o).charValue() == '\u0000') {
                out.tag("null");
                cr = XmlSerializerSession.ContentResult.CR_MIXED;
            } else if (sType.isNumber()) {
                if (eType.isNumber() && !isRoot) {
                    out.append(o);
                } else {
                    out.sTag("number").append(o).eTag("number");
                }
                cr = XmlSerializerSession.ContentResult.CR_MIXED;
            } else if (sType.isBoolean()) {
                if (eType.isBoolean() && !isRoot) {
                    out.append(o);
                } else {
                    out.sTag("boolean").append(o).eTag("boolean");
                }
                cr = XmlSerializerSession.ContentResult.CR_MIXED;
            } else if (sType.isMap() || wType != null && wType.isMap()) {
                out.nlIf(!isRoot, xIndent + 1);
                if (o instanceof BeanMap) {
                    this.serializeBeanMap(out, (BeanMap)o, eType, pMeta);
                } else {
                    this.serializeMap(out, (Map)o, sType, eType.getKeyType(), eType.getValueType(), typeName, pMeta);
                }
            } else if (sType.isBean()) {
                BeanMap<Object> m = this.toBeanMap(o);
                if (aType.hasAnnotation(HtmlLink.class)) {
                    Value<String> uriProperty = Value.empty();
                    Value<String> nameProperty = Value.empty();
                    aType.forEachAnnotation(HtmlLink.class, x -> StringUtils.isNotEmpty((String)x.uriProperty()), x -> uriProperty.set(x.uriProperty()));
                    aType.forEachAnnotation(HtmlLink.class, x -> StringUtils.isNotEmpty((String)x.nameProperty()), x -> nameProperty.set(x.nameProperty()));
                    Object urlProp = m.get(uriProperty.orElse(""));
                    Object nameProp = m.get(nameProperty.orElse(""));
                    out.oTag("a").attrUri("href", urlProp).w('>').text(nameProp).eTag("a");
                    cr = XmlSerializerSession.ContentResult.CR_MIXED;
                } else {
                    out.nlIf(!isRoot, xIndent + 2);
                    this.serializeBeanMap(out, m, eType, pMeta);
                }
            } else if (sType.isCollection() || sType.isArray() || wType != null && wType.isCollection()) {
                out.nlIf(!isRoot, xIndent + 1);
                this.serializeCollection(out, o, sType, eType, name, pMeta);
            } else if (this.isUri(sType, pMeta, o)) {
                String label = this.getAnchorText(pMeta, o);
                out.oTag("a").attrUri("href", o).w('>');
                out.text(label);
                out.eTag("a");
                cr = XmlSerializerSession.ContentResult.CR_MIXED;
            } else {
                if (isRoot) {
                    out.sTag("string").text(this.toString(o)).eTag("string");
                } else {
                    out.text(this.toString(o));
                }
                cr = XmlSerializerSession.ContentResult.CR_MIXED;
            }
        }
        this.pop();
        this.indent -= xIndent;
        return cr;
    }

    private void serializeMap(XmlWriter out, Map m, ClassMeta<?> sType, ClassMeta<?> eKeyType, ClassMeta<?> eValueType, String typeName, BeanPropertyMeta ppMeta) throws SerializeException {
        ClassMeta<Object> keyType = eKeyType == null ? this.string() : eKeyType;
        ClassMeta<Object> valueType = eValueType == null ? this.object() : eValueType;
        ClassMeta<Map> aType = this.getClassMetaForObject(m);
        HtmlClassMeta cHtml = this.getHtmlClassMeta(aType);
        HtmlBeanPropertyMeta bpHtml = this.getHtmlBeanPropertyMeta(ppMeta);
        int i = this.indent;
        out.oTag(i, "table");
        if (typeName != null && ppMeta != null && ppMeta.getClassMeta() != aType) {
            out.attr(this.getBeanTypePropertyName(sType), typeName);
        }
        out.append(">").nl(i + 1);
        if (this.isAddKeyValueTableHeaders() && !cHtml.isNoTableHeaders() && !bpHtml.isNoTableHeaders()) {
            out.sTag(i + 1, "tr").nl(i + 2);
            out.sTag(i + 2, "th").append("key").eTag("th").nl(i + 3);
            out.sTag(i + 2, "th").append("value").eTag("th").nl(i + 3);
            out.ie(i + 1).eTag("tr").nl(i + 2);
        }
        this.forEachEntry(m, (Map.Entry<K, V> x) -> this.serializeMapEntry(out, (Map.Entry)x, keyType, valueType, i, ppMeta));
        out.ie(i).eTag("table").nl(i);
    }

    private void serializeMapEntry(XmlWriter out, Map.Entry e, ClassMeta<?> keyType, ClassMeta<?> valueType, int i, BeanPropertyMeta ppMeta) throws SerializeException {
        Object key = this.generalize(e.getKey(), keyType);
        Object value = null;
        try {
            value = e.getValue();
        }
        catch (StackOverflowError t) {
            throw t;
        }
        catch (Throwable t) {
            this.onError(t, "Could not call getValue() on property ''{0}'', {1}", e.getKey(), t.getLocalizedMessage());
        }
        String link = this.getLink(ppMeta);
        String style = this.getStyle(this, ppMeta, value);
        out.sTag(i + 1, "tr").nl(i + 2);
        out.oTag(i + 2, "td");
        if (style != null) {
            out.attr("style", style);
        }
        out.cTag();
        if (link != null) {
            out.oTag(i + 3, "a").attrUri("href", link.replace("{#}", StringUtils.stringify(value))).cTag();
        }
        XmlSerializerSession.ContentResult cr = this.serializeAnything(out, key, keyType, null, null, 2, false, false);
        if (link != null) {
            out.eTag("a");
        }
        if (cr == XmlSerializerSession.ContentResult.CR_ELEMENTS) {
            out.i(i + 2);
        }
        out.eTag("td").nl(i + 2);
        out.sTag(i + 2, "td");
        cr = this.serializeAnything(out, value, valueType, key == null ? "_x0000_" : this.toString(key), null, 2, false, true);
        if (cr == XmlSerializerSession.ContentResult.CR_ELEMENTS) {
            out.ie(i + 2);
        }
        out.eTag("td").nl(i + 2);
        out.ie(i + 1).eTag("tr").nl(i + 1);
    }

    private void serializeBeanMap(XmlWriter out, BeanMap<?> m, ClassMeta<?> eType, BeanPropertyMeta ppMeta) throws SerializeException {
        HtmlClassMeta cHtml = this.getHtmlClassMeta(m.getClassMeta());
        HtmlBeanPropertyMeta bpHtml = this.getHtmlBeanPropertyMeta(ppMeta);
        int i = this.indent;
        out.oTag(i, "table");
        String typeName = m.getMeta().getDictionaryName();
        if (typeName != null && eType != m.getClassMeta()) {
            out.attr(this.getBeanTypePropertyName(m.getClassMeta()), typeName);
        }
        out.w('>').nl(i);
        if (this.isAddKeyValueTableHeaders() && !cHtml.isNoTableHeaders() && !bpHtml.isNoTableHeaders()) {
            out.sTag(i + 1, "tr").nl(i + 1);
            out.sTag(i + 2, "th").append("key").eTag("th").nl(i + 2);
            out.sTag(i + 2, "th").append("value").eTag("th").nl(i + 2);
            out.ie(i + 1).eTag("tr").nl(i + 1);
        }
        Predicate<Object> checkNull = x -> this.isKeepNullProperties() || x != null;
        m.forEachValue(checkNull, (pMeta, key, value, thrown) -> {
            ClassMeta<?> cMeta = pMeta.getClassMeta();
            if (thrown != null) {
                this.onBeanGetterException((BeanPropertyMeta)pMeta, (Throwable)thrown);
            }
            if (this.canIgnoreValue(cMeta, (String)key, value)) {
                return;
            }
            String link = null;
            String anchorText = null;
            if (!cMeta.isCollectionOrArray()) {
                link = m.resolveVars(this.getLink((BeanPropertyMeta)pMeta));
                anchorText = m.resolveVars(this.getAnchorText((BeanPropertyMeta)pMeta));
            }
            if (anchorText != null) {
                value = anchorText;
            }
            out.sTag(i + 1, "tr").nl(i + 1);
            out.sTag(i + 2, "td").text(key).eTag("td").nl(i + 2);
            out.oTag(i + 2, "td");
            String style = this.getStyle(this, (BeanPropertyMeta)pMeta, value);
            if (style != null) {
                out.attr("style", style);
            }
            out.cTag();
            try {
                XmlSerializerSession.ContentResult cr;
                if (link != null) {
                    out.oTag(i + 3, "a").attrUri("href", link).cTag();
                }
                if ((cr = this.serializeAnything(out, value, cMeta, (String)key, (BeanPropertyMeta)pMeta, 2, false, true)) == XmlSerializerSession.ContentResult.CR_ELEMENTS) {
                    out.i(i + 2);
                }
                if (link != null) {
                    out.eTag("a");
                }
            }
            catch (SerializeException e) {
                throw e;
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable e) {
                this.onBeanGetterException((BeanPropertyMeta)pMeta, e);
            }
            out.eTag("td").nl(i + 2);
            out.ie(i + 1).eTag("tr").nl(i + 1);
        });
        out.ie(i).eTag("table").nl(i);
    }

    private void serializeCollection(XmlWriter out, Object in, ClassMeta<?> sType, ClassMeta<?> eType, String name, BeanPropertyMeta ppMeta) throws SerializeException {
        HtmlClassMeta cHtml = this.getHtmlClassMeta(sType);
        HtmlBeanPropertyMeta bpHtml = this.getHtmlBeanPropertyMeta(ppMeta);
        Collection<Object> c = sType.isCollection() ? (List<Object>)in : HtmlSerializerSession.toList(sType.getInnerClass(), in);
        boolean isCdc = cHtml.isHtmlCdc() || bpHtml.isHtmlCdc();
        boolean isSdc = cHtml.isHtmlSdc() || bpHtml.isHtmlSdc();
        boolean isDc = isCdc || isSdc;
        int i = this.indent;
        if (c.isEmpty()) {
            out.appendln(i, "<ul></ul>");
            return;
        }
        String type2 = null;
        if (sType != eType) {
            type2 = sType.getDictionaryName();
        }
        if (type2 == null) {
            type2 = "array";
        }
        c = this.sort(c);
        String btpn = this.getBeanTypePropertyName(eType);
        Object[] th = this.getTableHeaders(c, bpHtml);
        if (th != null) {
            out.oTag(i, "table").attr(btpn, type2).w('>').nl(i + 1);
            if (th.length > 0) {
                out.sTag(i + 1, "tr").nl(i + 2);
                for (Object key : th) {
                    out.sTag(i + 2, "th");
                    out.text(this.convertToType(key, String.class));
                    out.eTag("th").nl(i + 2);
                }
                out.ie(i + 1).eTag("tr").nl(i + 1);
            } else {
                th = null;
            }
            for (Object o : c) {
                Map<String, Object> m2;
                ClassMeta<Object> cm = this.getClassMetaForObject(o);
                if (cm != null && cm.getSwap(this) != null) {
                    ObjectSwap<Object, ?> swap = cm.getSwap(this);
                    o = this.swap(swap, o);
                    cm = swap.getSwapClassMeta(this);
                }
                out.oTag(i + 1, "tr");
                String typeName = cm == null ? null : cm.getDictionaryName();
                String typeProperty = this.getBeanTypePropertyName(cm);
                if (typeName != null && eType.getElementType() != cm) {
                    out.attr(typeProperty, typeName);
                }
                out.cTag().nl(i + 2);
                if (cm == null) {
                    out.i(i + 2);
                    this.serializeAnything(out, o, null, null, null, 1, false, false);
                    out.nl(0);
                } else if (cm.isMap() && !cm.isBeanMap()) {
                    m2 = this.sort((Map)o);
                    if (th == null) {
                        th = m2.keySet().toArray(new Object[m2.size()]);
                    }
                    for (Object k : th) {
                        out.sTag(i + 2, "td");
                        XmlSerializerSession.ContentResult cr = this.serializeAnything(out, m2.get(k), eType.getElementType(), this.toString(k), null, 2, false, true);
                        if (cr == XmlSerializerSession.ContentResult.CR_ELEMENTS) {
                            out.i(i + 2);
                        }
                        out.eTag("td").nl(i + 2);
                    }
                } else {
                    m2 = this.toBeanMap(o);
                    if (th == null) {
                        th = ((BeanMap)m2).keySet().toArray(new Object[((AbstractMap)m2).size()]);
                    }
                    for (Object k : th) {
                        XmlSerializerSession.ContentResult cr;
                        BeanMapEntry p = ((BeanMap)m2).getProperty(this.toString(k));
                        BeanPropertyMeta pMeta = p.getMeta();
                        if (!pMeta.canRead()) continue;
                        Object value = p.getValue();
                        String link = null;
                        String anchorText = null;
                        if (!pMeta.getClassMeta().isCollectionOrArray()) {
                            link = ((BeanMap)m2).resolveVars(this.getLink(pMeta));
                            anchorText = ((BeanMap)m2).resolveVars(this.getAnchorText(pMeta));
                        }
                        if (anchorText != null) {
                            value = anchorText;
                        }
                        String style = this.getStyle(this, pMeta, value);
                        out.oTag(i + 2, "td");
                        if (style != null) {
                            out.attr("style", style);
                        }
                        out.cTag();
                        if (link != null) {
                            out.oTag("a").attrUri("href", link).cTag();
                        }
                        if ((cr = this.serializeAnything(out, value, pMeta.getClassMeta(), p.getKey().toString(), pMeta, 2, false, true)) == XmlSerializerSession.ContentResult.CR_ELEMENTS) {
                            out.i(i + 2);
                        }
                        if (link != null) {
                            out.eTag("a");
                        }
                        out.eTag("td").nl(i + 2);
                    }
                }
                out.ie(i + 1).eTag("tr").nl(i + 1);
            }
            out.ie(i).eTag("table").nl(i);
        } else {
            out.oTag(i, isDc ? "p" : "ul");
            if (!type2.equals("array")) {
                out.attr(btpn, type2);
            }
            out.w('>').nl(i + 1);
            boolean isFirst = true;
            for (Object o : c) {
                if (isDc && !isFirst) {
                    out.append(isCdc ? ", " : " ");
                }
                if (!isDc) {
                    out.oTag(i + 1, "li");
                }
                String style = this.getStyle(this, ppMeta, o);
                String link = this.getLink(ppMeta);
                if (style != null && !isDc) {
                    out.attr("style", style);
                }
                if (!isDc) {
                    out.cTag();
                }
                if (link != null) {
                    out.oTag(i + 2, "a").attrUri("href", link.replace("{#}", StringUtils.stringify((Object)o))).cTag();
                }
                XmlSerializerSession.ContentResult cr = this.serializeAnything(out, o, eType.getElementType(), name, null, 1, false, true);
                if (link != null) {
                    out.eTag("a");
                }
                if (cr == XmlSerializerSession.ContentResult.CR_ELEMENTS) {
                    out.ie(i + 1);
                }
                if (!isDc) {
                    out.eTag("li").nl(i + 1);
                }
                isFirst = false;
            }
            out.ie(i).eTag(isDc ? "p" : "ul").nl(i);
        }
    }

    private HtmlRender<?> getRender(HtmlSerializerSession session, BeanPropertyMeta pMeta, Object value) {
        if (pMeta == null) {
            return null;
        }
        HtmlRender render = this.getHtmlBeanPropertyMeta(pMeta).getRender();
        if (render != null) {
            return render;
        }
        ClassMeta<Object> cMeta = session.getClassMetaForObject(value);
        render = cMeta == null ? null : this.getHtmlClassMeta(cMeta).getRender();
        return render;
    }

    private String getStyle(HtmlSerializerSession session, BeanPropertyMeta pMeta, Object value) {
        HtmlRender<?> render = this.getRender(session, pMeta, value);
        return render == null ? null : render.getStyle(session, value);
    }

    private String getLink(BeanPropertyMeta pMeta) {
        return pMeta == null ? null : this.getHtmlBeanPropertyMeta(pMeta).getLink();
    }

    private String getAnchorText(BeanPropertyMeta pMeta) {
        return pMeta == null ? null : this.getHtmlBeanPropertyMeta(pMeta).getAnchorText();
    }

    private Object[] getTableHeaders(Collection c, HtmlBeanPropertyMeta bpHtml) throws SerializeException {
        if (c.size() == 0) {
            return null;
        }
        c = this.sort(c);
        Object o1 = null;
        for (Object o : c) {
            if (o == null) continue;
            o1 = o;
            break;
        }
        if (o1 == null) {
            return null;
        }
        ClassMeta<Object> cm1 = this.getClassMetaForObject(o1);
        ObjectSwap<Object, ?> swap = cm1.getSwap(this);
        o1 = this.swap(swap, o1);
        if (swap != null) {
            cm1 = swap.getSwapClassMeta(this);
        }
        if (cm1 == null || !cm1.isMapOrBean() || cm1.hasAnnotation(HtmlLink.class)) {
            return null;
        }
        HtmlClassMeta cHtml = this.getHtmlClassMeta(cm1);
        if (cHtml.isNoTables() || bpHtml.isNoTables() || cHtml.isXml() || bpHtml.isXml() || this.canIgnoreValue(cm1, null, o1)) {
            return null;
        }
        if (cHtml.isNoTableHeaders() || bpHtml.isNoTableHeaders()) {
            return new Object[0];
        }
        if (cm1.isMap() && !cm1.isBeanMap()) {
            LinkedHashSet<Object> set = CollectionUtils.set(new Object[0]);
            for (Object o : c) {
                if (this.canIgnoreValue(cm1, null, o = this.swap(swap, o))) continue;
                if (!cm1.isInstance(o)) {
                    return null;
                }
                this.forEachEntry((Map)o, (Map.Entry<K, V> x) -> set.add(x.getKey()));
            }
            return set.toArray(new Object[set.size()]);
        }
        for (Object o : c) {
            if (this.canIgnoreValue(cm1, null, o = this.swap(swap, o)) || cm1.isInstance(o)) continue;
            return null;
        }
        BeanMap<Object> bm = this.toBeanMap(o1);
        return bm.keySet().toArray(new String[bm.size()]);
    }

    @Override
    protected final boolean isAddBeanTypes() {
        return this.ctx.isAddBeanTypes();
    }

    protected final boolean isAddKeyValueTableHeaders() {
        return this.ctx.isAddKeyValueTableHeaders();
    }

    protected final boolean isDetectLabelParameters() {
        return this.ctx.isDetectLabelParameters();
    }

    protected final boolean isDetectLinksInStrings() {
        return this.ctx.isDetectLinksInStrings();
    }

    protected final String getLabelParameter() {
        return this.ctx.getLabelParameter();
    }

    protected final AnchorText getUriAnchorText() {
        return this.ctx.getUriAnchorText();
    }

    protected HtmlClassMeta getHtmlClassMeta(ClassMeta<?> cm) {
        return this.ctx.getHtmlClassMeta(cm);
    }

    protected HtmlBeanPropertyMeta getHtmlBeanPropertyMeta(BeanPropertyMeta bpm) {
        return this.ctx.getHtmlBeanPropertyMeta(bpm);
    }

    @FluentSetters
    public static class Builder
    extends XmlSerializerSession.Builder {
        HtmlSerializer ctx;

        protected Builder(HtmlSerializer ctx) {
            super(ctx);
            this.ctx = ctx;
        }

        @Override
        public HtmlSerializerSession build() {
            return new HtmlSerializerSession(this);
        }

        @Override
        public <T> Builder apply(Class<T> type, Consumer<T> apply) {
            super.apply((Class)type, (Consumer)apply);
            return this;
        }

        @Override
        public Builder debug(Boolean value) {
            super.debug(value);
            return this;
        }

        @Override
        public Builder properties(Map<String, Object> value) {
            super.properties((Map)value);
            return this;
        }

        @Override
        public Builder property(String key, Object value) {
            super.property(key, value);
            return this;
        }

        @Override
        public Builder unmodifiable() {
            super.unmodifiable();
            return this;
        }

        @Override
        public Builder locale(Locale value) {
            super.locale(value);
            return this;
        }

        @Override
        public Builder localeDefault(Locale value) {
            super.localeDefault(value);
            return this;
        }

        @Override
        public Builder mediaType(MediaType value) {
            super.mediaType(value);
            return this;
        }

        @Override
        public Builder mediaTypeDefault(MediaType value) {
            super.mediaTypeDefault(value);
            return this;
        }

        @Override
        public Builder timeZone(TimeZone value) {
            super.timeZone(value);
            return this;
        }

        @Override
        public Builder timeZoneDefault(TimeZone value) {
            super.timeZoneDefault(value);
            return this;
        }

        @Override
        public Builder javaMethod(Method value) {
            super.javaMethod(value);
            return this;
        }

        @Override
        public Builder resolver(VarResolverSession value) {
            super.resolver(value);
            return this;
        }

        @Override
        public Builder schema(HttpPartSchema value) {
            super.schema(value);
            return this;
        }

        @Override
        public Builder schemaDefault(HttpPartSchema value) {
            super.schemaDefault(value);
            return this;
        }

        @Override
        public Builder uriContext(UriContext value) {
            super.uriContext(value);
            return this;
        }

        @Override
        public Builder fileCharset(Charset value) {
            super.fileCharset(value);
            return this;
        }

        @Override
        public Builder streamCharset(Charset value) {
            super.streamCharset(value);
            return this;
        }

        @Override
        public Builder useWhitespace(Boolean value) {
            super.useWhitespace(value);
            return this;
        }
    }
}

