/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.html;

import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Consumer;
import org.apache.juneau.MediaType;
import org.apache.juneau.UriContext;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.html.AsideFloat;
import org.apache.juneau.html.HtmlDocSerializer;
import org.apache.juneau.html.HtmlDocTemplate;
import org.apache.juneau.html.HtmlStrippedDocSerializerSession;
import org.apache.juneau.html.HtmlWidget;
import org.apache.juneau.html.HtmlWidgetMap;
import org.apache.juneau.html.HtmlWidgetVar;
import org.apache.juneau.html.HtmlWriter;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.SerializerPipe;
import org.apache.juneau.svl.VarResolver;
import org.apache.juneau.svl.VarResolverSession;

public class HtmlDocSerializerSession
extends HtmlStrippedDocSerializerSession {
    private static final VarResolver DEFAULT_VR = (VarResolver)VarResolver.create().defaultVars().vars(HtmlWidgetVar.class).build();
    private final HtmlDocSerializer ctx;

    public static Builder create(HtmlDocSerializer ctx) {
        return new Builder(ctx);
    }

    protected HtmlDocSerializerSession(Builder builder) {
        super(builder);
        this.ctx = builder.ctx;
        this.addVarBean(HtmlWidgetMap.class, this.ctx.getWidgets());
    }

    @Override
    protected VarResolverSession createDefaultVarResolverSession() {
        return DEFAULT_VR.createSession();
    }

    public final String[] getNavLinks() {
        return this.ctx.navlinks;
    }

    @Override
    protected void doSerialize(SerializerPipe out, Object o) throws IOException, SerializeException {
        try (HtmlWriter w = this.getHtmlWriter(out);){
            try {
                this.getTemplate().writeTo(this, w, o);
            }
            catch (Exception e) {
                throw new SerializeException(e);
            }
        }
    }

    public void parentSerialize(Object out, Object o) throws Exception {
        try (SerializerPipe pipe = this.createPipe(out);){
            super.doSerialize(pipe, o);
        }
    }

    protected final String[] getAside() {
        return this.ctx.aside;
    }

    protected final AsideFloat getAsideFloat() {
        return this.ctx.asideFloat;
    }

    protected final String[] getFooter() {
        return this.ctx.footer;
    }

    protected final String[] getHead() {
        return this.ctx.head;
    }

    protected final String[] getHeader() {
        return this.ctx.header;
    }

    protected final String[] getNav() {
        return this.ctx.nav;
    }

    protected final String[] getNavlinks() {
        return this.ctx.navlinks;
    }

    protected final String getNoResultsMessage() {
        return this.ctx.getNoResultsMessage();
    }

    protected final boolean isNowrap() {
        return this.ctx.nowrap;
    }

    protected final String[] getScript() {
        return this.ctx.script;
    }

    protected final String[] getStyle() {
        return this.ctx.style;
    }

    protected final String[] getStylesheet() {
        return this.ctx.stylesheet;
    }

    protected final HtmlDocTemplate getTemplate() {
        return this.ctx.getTemplate();
    }

    protected final HtmlDocSerializerSession forEachWidget(Consumer<HtmlWidget> action) {
        this.ctx.forEachWidget(action);
        return this;
    }

    @Override
    protected JsonMap properties() {
        return JsonMap.filteredMap("ctx", this.ctx, "varResolver", this.getVarResolver());
    }

    @FluentSetters
    public static class Builder
    extends HtmlStrippedDocSerializerSession.Builder {
        HtmlDocSerializer ctx;

        protected Builder(HtmlDocSerializer ctx) {
            super(ctx);
            this.ctx = ctx;
        }

        @Override
        public HtmlDocSerializerSession build() {
            return new HtmlDocSerializerSession(this);
        }

        @Override
        public <T> Builder apply(Class<T> type, Consumer<T> apply) {
            super.apply((Class)type, (Consumer)apply);
            return this;
        }

        @Override
        public Builder debug(Boolean value) {
            super.debug(value);
            return this;
        }

        @Override
        public Builder properties(Map<String, Object> value) {
            super.properties((Map)value);
            return this;
        }

        @Override
        public Builder property(String key, Object value) {
            super.property(key, value);
            return this;
        }

        @Override
        public Builder unmodifiable() {
            super.unmodifiable();
            return this;
        }

        @Override
        public Builder locale(Locale value) {
            super.locale(value);
            return this;
        }

        @Override
        public Builder localeDefault(Locale value) {
            super.localeDefault(value);
            return this;
        }

        @Override
        public Builder mediaType(MediaType value) {
            super.mediaType(value);
            return this;
        }

        @Override
        public Builder mediaTypeDefault(MediaType value) {
            super.mediaTypeDefault(value);
            return this;
        }

        @Override
        public Builder timeZone(TimeZone value) {
            super.timeZone(value);
            return this;
        }

        @Override
        public Builder timeZoneDefault(TimeZone value) {
            super.timeZoneDefault(value);
            return this;
        }

        @Override
        public Builder javaMethod(Method value) {
            super.javaMethod(value);
            return this;
        }

        @Override
        public Builder resolver(VarResolverSession value) {
            super.resolver(value);
            return this;
        }

        @Override
        public Builder schema(HttpPartSchema value) {
            super.schema(value);
            return this;
        }

        @Override
        public Builder schemaDefault(HttpPartSchema value) {
            super.schemaDefault(value);
            return this;
        }

        @Override
        public Builder uriContext(UriContext value) {
            super.uriContext(value);
            return this;
        }

        @Override
        public Builder fileCharset(Charset value) {
            super.fileCharset(value);
            return this;
        }

        @Override
        public Builder streamCharset(Charset value) {
            super.streamCharset(value);
            return this;
        }

        @Override
        public Builder useWhitespace(Boolean value) {
            super.useWhitespace(value);
            return this;
        }
    }
}

