/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.csv;

import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Consumer;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.MediaType;
import org.apache.juneau.UriContext;
import org.apache.juneau.csv.CsvSerializer;
import org.apache.juneau.csv.CsvWriter;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.Flag;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.SerializerPipe;
import org.apache.juneau.serializer.WriterSerializerSession;
import org.apache.juneau.svl.VarResolverSession;

public final class CsvSerializerSession
extends WriterSerializerSession {
    public static Builder create(CsvSerializer ctx) {
        return new Builder(ctx);
    }

    protected CsvSerializerSession(Builder builder) {
        super(builder);
    }

    @Override
    protected final void doSerialize(SerializerPipe pipe, Object o) throws IOException, SerializeException {
        try (CsvWriter w = this.getCsvWriter(pipe);){
            ClassMeta<Object> cm = this.getClassMetaForObject(o);
            Collection<Object> l = null;
            l = cm.isArray() ? CollectionUtils.alist((Object[])o) : (cm.isCollection() ? (Collection)o : Collections.singleton(o));
            if (l.size() > 0) {
                ClassMeta<Object> entryType = this.getClassMetaForObject(l.iterator().next());
                if (entryType.isBean()) {
                    BeanMeta<Object> bm = entryType.getBeanMeta();
                    Flag addComma = Flag.create();
                    bm.forEachProperty(x -> x.canRead(), x -> {
                        addComma.ifSet(() -> w.w(',')).set();
                        w.writeEntry(x.getName());
                    });
                    w.append('\n');
                    l.forEach(x -> {
                        Flag addComma2 = Flag.create();
                        BeanMap<Object> bean = this.toBeanMap(x);
                        bm.forEachProperty(y -> y.canRead(), y -> {
                            addComma2.ifSet(() -> w.w(',')).set();
                            w.writeEntry(y.get(bean, y.getName()));
                        });
                        w.w('\n');
                    });
                } else if (entryType.isMap()) {
                    Flag addComma = Flag.create();
                    Map first = (Map)l.iterator().next();
                    first.keySet().forEach(x -> {
                        addComma.ifSet(() -> w.w(',')).set();
                        w.writeEntry(x);
                    });
                    w.append('\n');
                    l.stream().forEach(x -> {
                        Flag addComma2 = Flag.create();
                        Map map = (Map)x;
                        map.values().forEach(y -> {
                            addComma2.ifSet(() -> w.w(',')).set();
                            w.writeEntry(y);
                        });
                        w.w('\n');
                    });
                } else {
                    w.writeEntry("value");
                    w.append('\n');
                    l.stream().forEach(x -> {
                        w.writeEntry(x);
                        w.w('\n');
                    });
                }
            }
        }
    }

    final CsvWriter getCsvWriter(SerializerPipe out) {
        Object output = out.getRawOutput();
        if (output instanceof CsvWriter) {
            return (CsvWriter)output;
        }
        CsvWriter w = new CsvWriter(out.getWriter(), this.isUseWhitespace(), this.getMaxIndent(), this.getQuoteChar(), this.isTrimStrings(), this.getUriResolver());
        out.setWriter(w);
        return w;
    }

    @FluentSetters
    public static class Builder
    extends WriterSerializerSession.Builder {
        CsvSerializer ctx;

        protected Builder(CsvSerializer ctx) {
            super(ctx);
            this.ctx = ctx;
        }

        @Override
        public CsvSerializerSession build() {
            return new CsvSerializerSession(this);
        }

        @Override
        public <T> Builder apply(Class<T> type, Consumer<T> apply) {
            super.apply((Class)type, (Consumer)apply);
            return this;
        }

        @Override
        public Builder debug(Boolean value) {
            super.debug(value);
            return this;
        }

        @Override
        public Builder properties(Map<String, Object> value) {
            super.properties((Map)value);
            return this;
        }

        @Override
        public Builder property(String key, Object value) {
            super.property(key, value);
            return this;
        }

        @Override
        public Builder unmodifiable() {
            super.unmodifiable();
            return this;
        }

        @Override
        public Builder locale(Locale value) {
            super.locale(value);
            return this;
        }

        @Override
        public Builder localeDefault(Locale value) {
            super.localeDefault(value);
            return this;
        }

        @Override
        public Builder mediaType(MediaType value) {
            super.mediaType(value);
            return this;
        }

        @Override
        public Builder mediaTypeDefault(MediaType value) {
            super.mediaTypeDefault(value);
            return this;
        }

        @Override
        public Builder timeZone(TimeZone value) {
            super.timeZone(value);
            return this;
        }

        @Override
        public Builder timeZoneDefault(TimeZone value) {
            super.timeZoneDefault(value);
            return this;
        }

        @Override
        public Builder javaMethod(Method value) {
            super.javaMethod(value);
            return this;
        }

        @Override
        public Builder resolver(VarResolverSession value) {
            super.resolver(value);
            return this;
        }

        @Override
        public Builder schema(HttpPartSchema value) {
            super.schema(value);
            return this;
        }

        @Override
        public Builder schemaDefault(HttpPartSchema value) {
            super.schemaDefault(value);
            return this;
        }

        @Override
        public Builder uriContext(UriContext value) {
            super.uriContext(value);
            return this;
        }

        @Override
        public Builder fileCharset(Charset value) {
            super.fileCharset(value);
            return this;
        }

        @Override
        public Builder streamCharset(Charset value) {
            super.streamCharset(value);
            return this;
        }

        @Override
        public Builder useWhitespace(Boolean value) {
            super.useWhitespace(value);
            return this;
        }
    }
}

