/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.widget;

import java.io.IOException;
import org.apache.juneau.common.internal.ThrowableUtils;
import org.apache.juneau.cp.FileFinder;
import org.apache.juneau.html.HtmlWidget;
import org.apache.juneau.http.response.InternalServerError;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.svl.VarResolverSession;

public abstract class Widget
implements HtmlWidget {
    public String getName() {
        return this.getClass().getSimpleName();
    }

    private RestRequest req(VarResolverSession session) {
        return (RestRequest)((Object)session.getBean(RestRequest.class).orElseThrow(InternalServerError::new));
    }

    private RestResponse res(VarResolverSession session) {
        return (RestResponse)((Object)session.getBean(RestResponse.class).orElseThrow(InternalServerError::new));
    }

    public String getHtml(VarResolverSession session) {
        return this.getHtml(this.req(session), this.res(session));
    }

    public String getScript(VarResolverSession session) {
        return this.getScript(this.req(session), this.res(session));
    }

    public String getStyle(VarResolverSession session) {
        return this.getStyle(this.req(session), this.res(session));
    }

    public String getHtml(RestRequest req, RestResponse res) {
        return null;
    }

    public String getScript(RestRequest req, RestResponse res) {
        return null;
    }

    public String getStyle(RestRequest req, RestResponse res) {
        return null;
    }

    protected FileFinder getFileFinder(RestRequest req) {
        return req.getStaticFiles();
    }

    protected String loadScript(RestRequest req, String name) {
        try {
            String s = this.getFileFinder(req).getString(name, null).orElse(null);
            if (s != null) {
                s = s.replaceAll("(?s)\\/\\*(.*?)\\*\\/\\s*", "");
            }
            return s;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected String loadScriptWithVars(RestRequest req, RestResponse res, String name) throws IOException {
        return req.getVarResolverSession().resolve(this.loadScript(req, name));
    }

    protected String loadStyle(RestRequest req, String name) {
        try {
            String s = this.getFileFinder(req).getString(name, null).orElse(null);
            if (s != null) {
                s = s.replaceAll("(?s)\\/\\*(.*?)\\*\\/\\s*", "");
            }
            return s;
        }
        catch (IOException e) {
            throw ThrowableUtils.asRuntimeException((Throwable)e);
        }
    }

    protected String loadStyleWithVars(RestRequest req, RestResponse res, String name) throws IOException {
        return req.getVarResolverSession().resolve(this.loadStyle(req, name));
    }

    protected String loadHtml(RestRequest req, String name) {
        try {
            String s = this.getFileFinder(req).getString(name, null).orElse(null);
            if (s != null) {
                s = s.replaceAll("(?s)<!--(.*?)-->\\s*", "");
            }
            return s;
        }
        catch (IOException e) {
            throw ThrowableUtils.asRuntimeException((Throwable)e);
        }
    }

    protected String loadHtmlWithVars(RestRequest req, RestResponse res, String name) throws IOException {
        return req.getVarResolverSession().resolve(this.loadHtml(req, name));
    }
}

