/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.mock;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.Header;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpConnectionMetrics;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.HttpVersion;
import org.apache.http.NameValuePair;
import org.apache.http.RequestLine;
import org.apache.http.auth.AuthSchemeProvider;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.BackoffManager;
import org.apache.http.client.ConnectionBackoffStrategy;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.UserTokenHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.InputStreamFactory;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Lookup;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.util.PublicSuffixMatcher;
import org.apache.http.cookie.CookieSpecProvider;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.message.BasicStatusLine;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.juneau.AnnotationWorkList;
import org.apache.juneau.BeanContext;
import org.apache.juneau.ConfigException;
import org.apache.juneau.Context;
import org.apache.juneau.DetailLevel;
import org.apache.juneau.Enablement;
import org.apache.juneau.MediaType;
import org.apache.juneau.PropertyNamer;
import org.apache.juneau.UriContext;
import org.apache.juneau.UriRelativity;
import org.apache.juneau.UriResolution;
import org.apache.juneau.Visibility;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.http.header.ContentType;
import org.apache.juneau.httppart.HttpPartCollectionFormat;
import org.apache.juneau.httppart.HttpPartFormat;
import org.apache.juneau.httppart.HttpPartParser;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.internal.Cache;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.marshaller.Marshaller;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.client.RestCallException;
import org.apache.juneau.rest.client.RestCallHandler;
import org.apache.juneau.rest.client.RestClient;
import org.apache.juneau.rest.client.RestOperation;
import org.apache.juneau.rest.client.RestRequest;
import org.apache.juneau.rest.client.RestRequestCreated;
import org.apache.juneau.rest.client.RestResponse;
import org.apache.juneau.rest.logger.BasicTestCallLogger;
import org.apache.juneau.rest.mock.MockHttpClientConnectionManager;
import org.apache.juneau.rest.mock.MockPathResolver;
import org.apache.juneau.rest.mock.MockRestRequest;
import org.apache.juneau.rest.mock.MockRestResponse;
import org.apache.juneau.rest.mock.MockServletRequest;
import org.apache.juneau.rest.mock.MockServletResponse;
import org.apache.juneau.rest.util.RestUtils;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.swap.BeanInterceptor;
import org.apache.juneau.uon.ParamFormat;
import org.apache.juneau.utils.HashKey;
import org.apache.juneau.utils.ThrowingFunction;

public class MockRestClient
extends RestClient
implements HttpClientConnection {
    private static Map<Class<?>, RestContext> REST_CONTEXTS = new ConcurrentHashMap();
    private final RestContext restContext;
    private final Object restObject;
    private final String contextPath;
    private final String servletPath;
    private final Map<String, String> pathVars;
    private final ThreadLocal<HttpRequest> rreq = new ThreadLocal();
    private final ThreadLocal<MockRestResponse> rres = new ThreadLocal();
    private final ThreadLocal<MockServletRequest> sreq = new ThreadLocal();
    private final ThreadLocal<MockServletResponse> sres = new ThreadLocal();

    public static Builder create(Object impl) {
        return new Builder().restBean(impl);
    }

    public static Builder createLax(Object impl) {
        return new Builder().restBean(impl).ignoreErrors().noTrace();
    }

    public static MockRestClient build(Object impl) {
        return MockRestClient.create(impl).build();
    }

    public static MockRestClient buildLax(Object impl) {
        return MockRestClient.create(impl).ignoreErrors().noTrace().build();
    }

    public static MockRestClient buildJson(Object impl) {
        return MockRestClient.create(impl).json().build();
    }

    public static MockRestClient buildJsonLax(Object impl) {
        return MockRestClient.create(impl).json().ignoreErrors().noTrace().build();
    }

    public static MockRestClient buildJson5(Object impl) {
        return MockRestClient.create(impl).json5().build();
    }

    public static MockRestClient buildJson5Lax(Object impl) {
        return MockRestClient.create(impl).json5().ignoreErrors().noTrace().build();
    }

    public MockRestClient(Builder builder) {
        super(MockRestClient.preInit(builder));
        this.restContext = builder.restContext;
        this.contextPath = builder.contextPath != null ? builder.contextPath : "";
        this.servletPath = builder.servletPath != null ? builder.servletPath : "";
        this.pathVars = builder.pathVars != null ? builder.pathVars : Collections.emptyMap();
        this.restObject = this.restContext.getResource();
        HttpClientConnectionManager ccm = this.getHttpClientConnectionManager();
        if (ccm instanceof MockHttpClientConnectionManager) {
            ((MockHttpClientConnectionManager)ccm).init(this);
        }
    }

    private static Builder preInit(Builder builder) {
        try {
            Class<?> c;
            Object restBean = builder.restBean;
            String contextPath = builder.contextPath;
            String servletPath = builder.servletPath;
            Object rootUrl = builder.getRootUri();
            if (rootUrl == null) {
                rootUrl = "http://localhost";
            }
            Class<?> clazz = c = restBean instanceof Class ? (Class<?>)restBean : restBean.getClass();
            if (!REST_CONTEXTS.containsKey(c)) {
                boolean isClass = restBean instanceof Class;
                Object o = isClass ? ((Class)restBean).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]) : restBean;
                RestContext rc = RestContext.create(o.getClass(), null, null).defaultClasses(BasicTestCallLogger.class).debugDefault(Enablement.CONDITIONAL).init(() -> o).build().postInit().postInitChildFirst();
                REST_CONTEXTS.put(c, rc);
            }
            RestContext restBeanCtx = REST_CONTEXTS.get(c);
            builder.restContext(restBeanCtx);
            if (servletPath == null) {
                servletPath = RestUtils.toValidContextPath(restBeanCtx.getFullPath());
            }
            rootUrl = (String)rootUrl + StringUtils.emptyIfNull(contextPath) + StringUtils.emptyIfNull(servletPath);
            builder.servletPath = servletPath;
            builder.rootUrl(rootUrl);
            return builder;
        }
        catch (Exception e) {
            throw new ConfigException(e, "Could not initialize MockRestClient", new Object[0]);
        }
    }

    @Override
    public MockRestRequest request(RestOperation op) throws RestCallException {
        return (MockRestRequest)super.request(op);
    }

    @Override
    public MockRestRequest get(Object url) throws RestCallException {
        return (MockRestRequest)super.get(url);
    }

    @Override
    public MockRestRequest get() throws RestCallException {
        return (MockRestRequest)super.get();
    }

    @Override
    public MockRestRequest put(Object url, Object body) throws RestCallException {
        return (MockRestRequest)super.put(url, body);
    }

    @Override
    public MockRestRequest put(Object url, String body, ContentType contentType) throws RestCallException {
        return (MockRestRequest)super.put(url, body, contentType);
    }

    @Override
    public MockRestRequest put(Object url) throws RestCallException {
        return (MockRestRequest)super.put(url);
    }

    @Override
    public MockRestRequest post(Object url, Object body) throws RestCallException {
        return (MockRestRequest)super.post(url, body);
    }

    @Override
    public MockRestRequest post(Object url, String body, ContentType contentType) throws RestCallException {
        return (MockRestRequest)super.post(url, body, contentType);
    }

    @Override
    public MockRestRequest post(Object url) throws RestCallException {
        return (MockRestRequest)super.post(url);
    }

    @Override
    public MockRestRequest delete(Object url) throws RestCallException {
        return (MockRestRequest)super.delete(url);
    }

    @Override
    public MockRestRequest options(Object url) throws RestCallException {
        return (MockRestRequest)super.options(url);
    }

    @Override
    public MockRestRequest head(Object url) throws RestCallException {
        return (MockRestRequest)super.head(url);
    }

    @Override
    public MockRestRequest formPost(Object url, Object body) throws RestCallException {
        return (MockRestRequest)super.formPost(url, body);
    }

    @Override
    public MockRestRequest formPost(Object url) throws RestCallException {
        return (MockRestRequest)super.formPost(url);
    }

    @Override
    public MockRestRequest formPostPairs(Object url, String ... parameters) throws RestCallException {
        return (MockRestRequest)super.formPostPairs(url, parameters);
    }

    @Override
    public MockRestRequest patch(Object url, Object body) throws RestCallException {
        return (MockRestRequest)super.patch(url, body);
    }

    @Override
    public MockRestRequest patch(Object url, String body, ContentType contentType) throws RestCallException {
        return (MockRestRequest)super.patch(url, body, contentType);
    }

    @Override
    public MockRestRequest patch(Object url) throws RestCallException {
        return (MockRestRequest)super.patch(url);
    }

    @Override
    public MockRestRequest callback(String callString) throws RestCallException {
        return (MockRestRequest)super.callback(callString);
    }

    @Override
    public MockRestRequest request(String method, Object url, Object body) throws RestCallException {
        return (MockRestRequest)super.request(method, url, body);
    }

    @Override
    public MockRestRequest request(String method, Object url) throws RestCallException {
        return (MockRestRequest)super.request(method, url);
    }

    @Override
    public MockRestRequest request(String method, Object url, boolean hasBody) throws RestCallException {
        return (MockRestRequest)super.request(method, url, hasBody);
    }

    public HttpRequest getCurrentClientRequest() {
        return this.rreq.get();
    }

    public MockRestResponse getCurrentClientResponse() {
        return this.rres.get();
    }

    public MockServletRequest getCurrentServerRequest() {
        return this.sreq.get();
    }

    public MockServletResponse getCurrentServerResponse() {
        return this.sres.get();
    }

    MockRestClient currentResponse(MockRestResponse value) {
        this.rres.set(value);
        return this;
    }

    @Override
    protected MockRestRequest createRequest(URI uri, String method, boolean hasBody) throws RestCallException {
        return new MockRestRequest(this, uri, method, hasBody);
    }

    @Override
    protected MockRestResponse createResponse(RestRequest req, HttpResponse httpResponse, Parser parser) throws RestCallException {
        return new MockRestResponse(this, req, httpResponse, parser);
    }

    @Override
    public void close() throws IOException {
        this.rreq.remove();
        this.rres.remove();
        this.sreq.remove();
        this.sres.remove();
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public boolean isStale() {
        return false;
    }

    @Override
    public void setSocketTimeout(int timeout) {
    }

    @Override
    public int getSocketTimeout() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void shutdown() throws IOException {
    }

    @Override
    public HttpConnectionMetrics getMetrics() {
        return null;
    }

    @Override
    public boolean isResponseAvailable(int timeout) throws IOException {
        return true;
    }

    @Override
    public void sendRequestHeader(HttpRequest request) throws HttpException, IOException {
        try {
            RequestLine rl = request.getRequestLine();
            Object path = rl.getUri();
            String target = this.findTarget(request);
            HttpRequest req = this.findRestRequest(request);
            this.rreq.set(req);
            this.rres.remove();
            this.sreq.remove();
            this.sres.remove();
            path = target + (String)path;
            MockPathResolver pr = new MockPathResolver(target, this.contextPath, this.servletPath, (String)path, null);
            if (pr.getError() != null) {
                throw new RuntimeException(pr.getError());
            }
            MockServletRequest r = MockServletRequest.create(request.getRequestLine().getMethod(), pr.getURI(), new Object[0]).contextPath(pr.getContextPath()).servletPath(pr.getServletPath()).pathVars(this.pathVars).debug(this.isDebug());
            for (Header h : request.getAllHeaders()) {
                r.header(h.getName(), h.getValue());
            }
            this.sreq.set(r);
            this.sreq.get().applyOverrides(req);
        }
        catch (Exception e) {
            throw new HttpException(e.getMessage(), e);
        }
    }

    private HttpRequest findRestRequest(HttpRequest req) {
        if (req instanceof RestRequestCreated) {
            return ((RestRequestCreated)((Object)req)).getRestRequest();
        }
        if (req instanceof HttpRequestWrapper) {
            return this.findRestRequest(((HttpRequestWrapper)req).getOriginal());
        }
        return req;
    }

    private String findTarget(HttpRequest req) {
        HttpHost httpHost;
        if (req instanceof HttpRequestWrapper && (httpHost = ((HttpRequestWrapper)req).getTarget()) != null) {
            return httpHost.toURI();
        }
        return "http://localhost";
    }

    @Override
    public void sendRequestEntity(HttpEntityEnclosingRequest request) throws HttpException, IOException {
        byte[] body = new byte[]{};
        HttpEntity entity = request.getEntity();
        if (entity != null) {
            long length = entity.getContentLength();
            if (length < 0L) {
                length = 1024L;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream((int)Math.min(length, 1024L));
            entity.writeTo(baos);
            baos.flush();
            body = baos.toByteArray();
        }
        this.sreq.get().content(body);
    }

    @Override
    public HttpResponse receiveResponseHeader() throws HttpException, IOException {
        try {
            MockServletResponse res = MockServletResponse.create();
            this.restContext.execute(this.restObject, this.sreq.get(), res);
            if (res.getStatus() == 0) {
                throw new RuntimeException("Response status was 0.");
            }
            if (res.getStatus() < 200) {
                res.setStatus(1000 + res.getStatus());
            }
            this.sres.set(res);
            BasicHttpResponse response = new BasicHttpResponse(new BasicStatusLine(HttpVersion.HTTP_1_1, res.getStatus(), res.getMessage()));
            res.getHeaders().forEach((k, v) -> {
                for (String hv : v) {
                    response.addHeader((String)k, hv);
                }
            });
            return response;
        }
        catch (Exception e) {
            throw new HttpException(StringUtils.emptyIfNull(e.getMessage()), e);
        }
    }

    @Override
    public void receiveResponseEntity(HttpResponse response) throws HttpException, IOException {
        InputStream is = new ByteArrayInputStream(this.sres.get().getContent());
        Header contentEncoding = response.getLastHeader("Content-Encoding");
        if (contentEncoding != null && contentEncoding.getValue().equalsIgnoreCase("gzip")) {
            is = new GZIPInputStream(is);
        }
        response.setEntity(new InputStreamEntity(is));
    }

    @Override
    public void flush() throws IOException {
    }

    @FluentSetters(ignore={"debug"})
    public static class Builder
    extends RestClient.Builder {
        Object restBean;
        String contextPath;
        String servletPath;
        RestContext restContext;
        Map<String, String> pathVars;

        protected Builder() {
            this.connectionManager(new MockHttpClientConnectionManager());
        }

        @Override
        public Builder copy() {
            throw new NoSuchMethodError("Not implemented.");
        }

        public Builder restBean(Object value) {
            this.restBean = value;
            return this;
        }

        public Builder restContext(RestContext value) {
            this.restContext = value;
            return this;
        }

        public Builder contextPath(String value) {
            this.contextPath = RestUtils.toValidContextPath(value);
            return this;
        }

        public Builder servletPath(String value) {
            this.servletPath = RestUtils.toValidContextPath(value);
            return this;
        }

        public Builder pathVars(Map<String, String> value) {
            this.pathVars = value;
            return this;
        }

        public Builder pathVars(String ... pairs) {
            return this.pathVars(CollectionUtils.mapBuilder(String.class, String.class, new Type[0]).addPairs(pairs).build());
        }

        public Builder suppressLogging() {
            return this.logRequests(DetailLevel.NONE, (Level)null, (BiPredicate)null);
        }

        @Override
        public Builder debug() {
            this.header("Debug", "true");
            super.debug();
            return this;
        }

        @Override
        public MockRestClient build() {
            return this.build(MockRestClient.class);
        }

        @Override
        public Builder annotations(Annotation ... values) {
            super.annotations(values);
            return this;
        }

        @Override
        public Builder apply(AnnotationWorkList work) {
            super.apply(work);
            return this;
        }

        @Override
        public Builder applyAnnotations(Class<?> ... fromClasses) {
            super.applyAnnotations((Class[])fromClasses);
            return this;
        }

        @Override
        public Builder applyAnnotations(Method ... fromMethods) {
            super.applyAnnotations(fromMethods);
            return this;
        }

        @Override
        public Builder cache(Cache<HashKey, ? extends Context> value) {
            super.cache((Cache)value);
            return this;
        }

        @Override
        public Builder impl(Context value) {
            super.impl(value);
            return this;
        }

        @Override
        public Builder type(Class<? extends Context> value) {
            super.type((Class)value);
            return this;
        }

        @Override
        public Builder beanClassVisibility(Visibility value) {
            super.beanClassVisibility(value);
            return this;
        }

        @Override
        public Builder beanConstructorVisibility(Visibility value) {
            super.beanConstructorVisibility(value);
            return this;
        }

        @Override
        public Builder beanContext(BeanContext value) {
            super.beanContext(value);
            return this;
        }

        @Override
        public Builder beanContext(BeanContext.Builder value) {
            super.beanContext(value);
            return this;
        }

        @Override
        public Builder beanDictionary(Class<?> ... values) {
            super.beanDictionary((Class[])values);
            return this;
        }

        @Override
        public Builder beanFieldVisibility(Visibility value) {
            super.beanFieldVisibility(value);
            return this;
        }

        @Override
        public Builder beanInterceptor(Class<?> on, Class<? extends BeanInterceptor<?>> value) {
            super.beanInterceptor((Class)on, (Class)value);
            return this;
        }

        @Override
        public Builder beanMapPutReturnsOldValue() {
            super.beanMapPutReturnsOldValue();
            return this;
        }

        @Override
        public Builder beanMethodVisibility(Visibility value) {
            super.beanMethodVisibility(value);
            return this;
        }

        @Override
        public Builder beanProperties(Map<String, Object> values) {
            super.beanProperties((Map)values);
            return this;
        }

        @Override
        public Builder beanProperties(Class<?> beanClass, String properties) {
            super.beanProperties((Class)beanClass, properties);
            return this;
        }

        @Override
        public Builder beanProperties(String beanClassName, String properties) {
            super.beanProperties(beanClassName, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesExcludes(Map<String, Object> values) {
            super.beanPropertiesExcludes((Map)values);
            return this;
        }

        @Override
        public Builder beanPropertiesExcludes(Class<?> beanClass, String properties) {
            super.beanPropertiesExcludes((Class)beanClass, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesExcludes(String beanClassName, String properties) {
            super.beanPropertiesExcludes(beanClassName, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesReadOnly(Map<String, Object> values) {
            super.beanPropertiesReadOnly((Map)values);
            return this;
        }

        @Override
        public Builder beanPropertiesReadOnly(Class<?> beanClass, String properties) {
            super.beanPropertiesReadOnly((Class)beanClass, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesReadOnly(String beanClassName, String properties) {
            super.beanPropertiesReadOnly(beanClassName, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesWriteOnly(Map<String, Object> values) {
            super.beanPropertiesWriteOnly((Map)values);
            return this;
        }

        @Override
        public Builder beanPropertiesWriteOnly(Class<?> beanClass, String properties) {
            super.beanPropertiesWriteOnly((Class)beanClass, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesWriteOnly(String beanClassName, String properties) {
            super.beanPropertiesWriteOnly(beanClassName, properties);
            return this;
        }

        @Override
        public Builder beansRequireDefaultConstructor() {
            super.beansRequireDefaultConstructor();
            return this;
        }

        @Override
        public Builder beansRequireSerializable() {
            super.beansRequireSerializable();
            return this;
        }

        @Override
        public Builder beansRequireSettersForGetters() {
            super.beansRequireSettersForGetters();
            return this;
        }

        @Override
        public Builder dictionaryOn(Class<?> on, Class<?> ... values) {
            super.dictionaryOn((Class)on, (Class[])values);
            return this;
        }

        @Override
        public Builder disableBeansRequireSomeProperties() {
            super.disableBeansRequireSomeProperties();
            return this;
        }

        @Override
        public Builder disableIgnoreMissingSetters() {
            super.disableIgnoreMissingSetters();
            return this;
        }

        @Override
        public Builder disableIgnoreTransientFields() {
            super.disableIgnoreTransientFields();
            return this;
        }

        @Override
        public Builder disableIgnoreUnknownNullBeanProperties() {
            super.disableIgnoreUnknownNullBeanProperties();
            return this;
        }

        @Override
        public Builder disableInterfaceProxies() {
            super.disableInterfaceProxies();
            return this;
        }

        @Override
        public <T> Builder example(Class<T> pojoClass, T o) {
            super.example(pojoClass, o);
            return this;
        }

        @Override
        public <T> Builder example(Class<T> pojoClass, String json) {
            super.example(pojoClass, json);
            return this;
        }

        @Override
        public Builder findFluentSetters() {
            super.findFluentSetters();
            return this;
        }

        @Override
        public Builder findFluentSetters(Class<?> on) {
            super.findFluentSetters((Class)on);
            return this;
        }

        @Override
        public Builder ignoreInvocationExceptionsOnGetters() {
            super.ignoreInvocationExceptionsOnGetters();
            return this;
        }

        @Override
        public Builder ignoreInvocationExceptionsOnSetters() {
            super.ignoreInvocationExceptionsOnSetters();
            return this;
        }

        @Override
        public Builder ignoreUnknownBeanProperties() {
            super.ignoreUnknownBeanProperties();
            return this;
        }

        @Override
        public Builder ignoreUnknownEnumValues() {
            super.ignoreUnknownEnumValues();
            return this;
        }

        @Override
        public Builder implClass(Class<?> interfaceClass, Class<?> implClass) {
            super.implClass((Class)interfaceClass, (Class)implClass);
            return this;
        }

        @Override
        public Builder implClasses(Map<Class<?>, Class<?>> values) {
            super.implClasses((Map)values);
            return this;
        }

        @Override
        public Builder interfaceClass(Class<?> on, Class<?> value) {
            super.interfaceClass((Class)on, (Class)value);
            return this;
        }

        @Override
        public Builder interfaces(Class<?> ... value) {
            super.interfaces((Class[])value);
            return this;
        }

        @Override
        public Builder locale(Locale value) {
            super.locale(value);
            return this;
        }

        @Override
        public Builder mediaType(MediaType value) {
            super.mediaType(value);
            return this;
        }

        @Override
        public Builder notBeanClasses(Class<?> ... values) {
            super.notBeanClasses((Class[])values);
            return this;
        }

        @Override
        public Builder notBeanPackages(String ... values) {
            super.notBeanPackages(values);
            return this;
        }

        @Override
        public Builder propertyNamer(Class<? extends PropertyNamer> value) {
            super.propertyNamer((Class)value);
            return this;
        }

        @Override
        public Builder propertyNamer(Class<?> on, Class<? extends PropertyNamer> value) {
            super.propertyNamer((Class)on, (Class)value);
            return this;
        }

        @Override
        public Builder sortProperties() {
            super.sortProperties();
            return this;
        }

        @Override
        public Builder sortProperties(Class<?> ... on) {
            super.sortProperties((Class[])on);
            return this;
        }

        @Override
        public Builder stopClass(Class<?> on, Class<?> value) {
            super.stopClass((Class)on, (Class)value);
            return this;
        }

        @Override
        public <T, S> Builder swap(Class<T> normalClass, Class<S> swappedClass, ThrowingFunction<T, S> swapFunction) {
            super.swap((Class)normalClass, (Class)swappedClass, (ThrowingFunction)swapFunction);
            return this;
        }

        @Override
        public <T, S> Builder swap(Class<T> normalClass, Class<S> swappedClass, ThrowingFunction<T, S> swapFunction, ThrowingFunction<S, T> unswapFunction) {
            super.swap((Class)normalClass, (Class)swappedClass, (ThrowingFunction)swapFunction, (ThrowingFunction)unswapFunction);
            return this;
        }

        @Override
        public Builder swaps(Class<?> ... values) {
            super.swaps((Class[])values);
            return this;
        }

        @Override
        public Builder timeZone(TimeZone value) {
            super.timeZone(value);
            return this;
        }

        @Override
        public Builder typeName(Class<?> on, String value) {
            super.typeName((Class)on, value);
            return this;
        }

        @Override
        public Builder typePropertyName(String value) {
            super.typePropertyName(value);
            return this;
        }

        @Override
        public Builder typePropertyName(Class<?> on, String value) {
            super.typePropertyName((Class)on, value);
            return this;
        }

        @Override
        public Builder useEnumNames() {
            super.useEnumNames();
            return this;
        }

        @Override
        public Builder useJavaBeanIntrospector() {
            super.useJavaBeanIntrospector();
            return this;
        }

        @Override
        public Builder accept(String value) {
            super.accept(value);
            return this;
        }

        @Override
        public Builder acceptCharset(String value) {
            super.acceptCharset(value);
            return this;
        }

        @Override
        public Builder addBeanTypes() {
            super.addBeanTypes();
            return this;
        }

        @Override
        public Builder addInterceptorFirst(HttpRequestInterceptor itcp) {
            super.addInterceptorFirst(itcp);
            return this;
        }

        @Override
        public Builder addInterceptorFirst(HttpResponseInterceptor itcp) {
            super.addInterceptorFirst(itcp);
            return this;
        }

        @Override
        public Builder addInterceptorLast(HttpRequestInterceptor itcp) {
            super.addInterceptorLast(itcp);
            return this;
        }

        @Override
        public Builder addInterceptorLast(HttpResponseInterceptor itcp) {
            super.addInterceptorLast(itcp);
            return this;
        }

        @Override
        public Builder addRootType() {
            super.addRootType();
            return this;
        }

        @Override
        public Builder backoffManager(BackoffManager backoffManager) {
            super.backoffManager(backoffManager);
            return this;
        }

        @Override
        public Builder basicAuth(String host, int port, String user, String pw) {
            super.basicAuth(host, port, user, pw);
            return this;
        }

        @Override
        public Builder callHandler(Class<? extends RestCallHandler> value) {
            super.callHandler(value);
            return this;
        }

        @Override
        public Builder clientVersion(String value) {
            super.clientVersion(value);
            return this;
        }

        @Override
        public Builder connectionBackoffStrategy(ConnectionBackoffStrategy connectionBackoffStrategy) {
            super.connectionBackoffStrategy(connectionBackoffStrategy);
            return this;
        }

        @Override
        public Builder connectionManager(HttpClientConnectionManager value) {
            super.connectionManager(value);
            return this;
        }

        @Override
        public Builder connectionManagerShared(boolean shared) {
            super.connectionManagerShared(shared);
            return this;
        }

        @Override
        public Builder connectionReuseStrategy(ConnectionReuseStrategy reuseStrategy) {
            super.connectionReuseStrategy(reuseStrategy);
            return this;
        }

        @Override
        public Builder connectionTimeToLive(long connTimeToLive, TimeUnit connTimeToLiveTimeUnit) {
            super.connectionTimeToLive(connTimeToLive, connTimeToLiveTimeUnit);
            return this;
        }

        @Override
        public Builder console(PrintStream value) {
            super.console(value);
            return this;
        }

        @Override
        public Builder contentDecoderRegistry(Map<String, InputStreamFactory> contentDecoderMap) {
            super.contentDecoderRegistry(contentDecoderMap);
            return this;
        }

        @Override
        public Builder contentType(String value) {
            super.contentType(value);
            return this;
        }

        @Override
        public Builder debugOutputLines(int value) {
            super.debugOutputLines(value);
            return this;
        }

        @Override
        public Builder defaultAuthSchemeRegistry(Lookup<AuthSchemeProvider> authSchemeRegistry) {
            super.defaultAuthSchemeRegistry(authSchemeRegistry);
            return this;
        }

        @Override
        public Builder defaultConnectionConfig(ConnectionConfig config) {
            super.defaultConnectionConfig(config);
            return this;
        }

        @Override
        public Builder defaultCookieSpecRegistry(Lookup<CookieSpecProvider> cookieSpecRegistry) {
            super.defaultCookieSpecRegistry(cookieSpecRegistry);
            return this;
        }

        @Override
        public Builder defaultCookieStore(CookieStore cookieStore) {
            super.defaultCookieStore(cookieStore);
            return this;
        }

        @Override
        public Builder defaultCredentialsProvider(CredentialsProvider credentialsProvider) {
            super.defaultCredentialsProvider(credentialsProvider);
            return this;
        }

        @Override
        public Builder defaultRequestConfig(RequestConfig config) {
            super.defaultRequestConfig(config);
            return this;
        }

        @Override
        public Builder defaultSocketConfig(SocketConfig config) {
            super.defaultSocketConfig(config);
            return this;
        }

        @Override
        public Builder detectLeaks() {
            super.detectLeaks();
            return this;
        }

        @Override
        public Builder detectRecursions() {
            super.detectRecursions();
            return this;
        }

        @Override
        public Builder disableAuthCaching() {
            super.disableAuthCaching();
            return this;
        }

        @Override
        public Builder disableAutomaticRetries() {
            super.disableAutomaticRetries();
            return this;
        }

        @Override
        public Builder disableConnectionState() {
            super.disableConnectionState();
            return this;
        }

        @Override
        public Builder disableContentCompression() {
            super.disableContentCompression();
            return this;
        }

        @Override
        public Builder disableCookieManagement() {
            super.disableCookieManagement();
            return this;
        }

        @Override
        public Builder disableRedirectHandling() {
            super.disableRedirectHandling();
            return this;
        }

        @Override
        public Builder errorCodes(Predicate<Integer> value) {
            super.errorCodes(value);
            return this;
        }

        @Override
        public Builder evictExpiredConnections() {
            super.evictExpiredConnections();
            return this;
        }

        @Override
        public Builder evictIdleConnections(long maxIdleTime, TimeUnit maxIdleTimeUnit) {
            super.evictIdleConnections(maxIdleTime, maxIdleTimeUnit);
            return this;
        }

        @Override
        public Builder executorService(ExecutorService executorService, boolean shutdownOnClose) {
            super.executorService(executorService, shutdownOnClose);
            return this;
        }

        @Override
        public Builder formData(NameValuePair ... parts) {
            super.formData(parts);
            return this;
        }

        @Override
        public Builder formData(String name, String value) {
            super.formData(name, value);
            return this;
        }

        @Override
        public Builder formData(String name, Supplier<String> value) {
            super.formData(name, value);
            return this;
        }

        @Override
        public Builder header(String name, String value) {
            super.header(name, value);
            return this;
        }

        @Override
        public Builder header(String name, Supplier<String> value) {
            super.header(name, value);
            return this;
        }

        @Override
        public Builder headers(Header ... parts) {
            super.headers(parts);
            return this;
        }

        @Override
        public Builder html() {
            super.html();
            return this;
        }

        @Override
        public Builder htmlDoc() {
            super.htmlDoc();
            return this;
        }

        @Override
        public Builder htmlStrippedDoc() {
            super.htmlStrippedDoc();
            return this;
        }

        @Override
        public Builder httpClient(CloseableHttpClient value) {
            super.httpClient(value);
            return this;
        }

        @Override
        public Builder httpClientBuilder(HttpClientBuilder value) {
            super.httpClientBuilder(value);
            return this;
        }

        @Override
        public Builder httpProcessor(HttpProcessor httpprocessor) {
            super.httpProcessor(httpprocessor);
            return this;
        }

        @Override
        public Builder ignoreErrors() {
            super.ignoreErrors();
            return this;
        }

        @Override
        public Builder ignoreRecursions() {
            super.ignoreRecursions();
            return this;
        }

        @Override
        public Builder initialDepth(int value) {
            super.initialDepth(value);
            return this;
        }

        @Override
        public Builder interceptors(Class<?> ... values) throws Exception {
            super.interceptors(values);
            return this;
        }

        @Override
        public Builder interceptors(Object ... value) {
            super.interceptors(value);
            return this;
        }

        @Override
        public Builder json() {
            super.json();
            return this;
        }

        @Override
        public Builder keepAliveStrategy(ConnectionKeepAliveStrategy keepAliveStrategy) {
            super.keepAliveStrategy(keepAliveStrategy);
            return this;
        }

        @Override
        public Builder keepHttpClientOpen() {
            super.keepHttpClientOpen();
            return this;
        }

        @Override
        public Builder keepNullProperties() {
            super.keepNullProperties();
            return this;
        }

        @Override
        public Builder logRequests(DetailLevel detail, Level level, BiPredicate<RestRequest, RestResponse> test) {
            super.logRequests(detail, level, test);
            return this;
        }

        @Override
        public Builder logToConsole() {
            super.logToConsole();
            return this;
        }

        @Override
        public Builder logger(Logger value) {
            super.logger(value);
            return this;
        }

        @Override
        public Builder marshaller(Marshaller value) {
            super.marshaller(value);
            return this;
        }

        @Override
        public Builder marshallers(Marshaller ... value) {
            super.marshallers(value);
            return this;
        }

        @Override
        public Builder maxConnPerRoute(int maxConnPerRoute) {
            super.maxConnPerRoute(maxConnPerRoute);
            return this;
        }

        @Override
        public Builder maxConnTotal(int maxConnTotal) {
            super.maxConnTotal(maxConnTotal);
            return this;
        }

        @Override
        public Builder maxDepth(int value) {
            super.maxDepth(value);
            return this;
        }

        @Override
        public Builder maxIndent(int value) {
            super.maxIndent(value);
            return this;
        }

        @Override
        public Builder mediaType(String value) {
            super.mediaType(value);
            return this;
        }

        @Override
        public Builder msgPack() {
            super.msgPack();
            return this;
        }

        @Override
        public Builder noTrace() {
            super.noTrace();
            return this;
        }

        @Override
        public Builder oapiCollectionFormat(HttpPartCollectionFormat value) {
            super.oapiCollectionFormat(value);
            return this;
        }

        @Override
        public Builder oapiFormat(HttpPartFormat value) {
            super.oapiFormat(value);
            return this;
        }

        @Override
        public Builder openApi() {
            super.openApi();
            return this;
        }

        @Override
        public Builder paramFormat(ParamFormat value) {
            super.paramFormat(value);
            return this;
        }

        @Override
        public Builder paramFormatPlain() {
            super.paramFormatPlain();
            return this;
        }

        @Override
        public Builder parser(Class<? extends Parser> value) {
            super.parser(value);
            return this;
        }

        @Override
        public Builder parser(Parser value) {
            super.parser(value);
            return this;
        }

        @Override
        public Builder parsers(Class<? extends Parser> ... value) {
            super.parsers(value);
            return this;
        }

        @Override
        public Builder parsers(Parser ... value) {
            super.parsers(value);
            return this;
        }

        @Override
        public Builder partParser(Class<? extends HttpPartParser> value) {
            super.partParser(value);
            return this;
        }

        @Override
        public Builder partParser(HttpPartParser value) {
            super.partParser(value);
            return this;
        }

        @Override
        public Builder partSerializer(Class<? extends HttpPartSerializer> value) {
            super.partSerializer(value);
            return this;
        }

        @Override
        public Builder partSerializer(HttpPartSerializer value) {
            super.partSerializer(value);
            return this;
        }

        @Override
        public Builder pathData(NameValuePair ... parts) {
            super.pathData(parts);
            return this;
        }

        @Override
        public Builder pathData(String name, String value) {
            super.pathData(name, value);
            return this;
        }

        @Override
        public Builder pathData(String name, Supplier<String> value) {
            super.pathData(name, value);
            return this;
        }

        @Override
        public Builder plainText() {
            super.plainText();
            return this;
        }

        @Override
        public Builder pooled() {
            super.pooled();
            return this;
        }

        @Override
        public Builder proxy(HttpHost proxy) {
            super.proxy(proxy);
            return this;
        }

        @Override
        public Builder proxyAuthenticationStrategy(AuthenticationStrategy proxyAuthStrategy) {
            super.proxyAuthenticationStrategy(proxyAuthStrategy);
            return this;
        }

        @Override
        public Builder publicSuffixMatcher(PublicSuffixMatcher publicSuffixMatcher) {
            super.publicSuffixMatcher(publicSuffixMatcher);
            return this;
        }

        @Override
        public Builder queryData(NameValuePair ... parts) {
            super.queryData(parts);
            return this;
        }

        @Override
        public Builder queryData(String name, String value) {
            super.queryData(name, value);
            return this;
        }

        @Override
        public Builder queryData(String name, Supplier<String> value) {
            super.queryData(name, value);
            return this;
        }

        @Override
        public Builder quoteChar(char value) {
            super.quoteChar(value);
            return this;
        }

        @Override
        public Builder redirectStrategy(RedirectStrategy redirectStrategy) {
            super.redirectStrategy(redirectStrategy);
            return this;
        }

        @Override
        public Builder requestExecutor(HttpRequestExecutor requestExec) {
            super.requestExecutor(requestExec);
            return this;
        }

        @Override
        public Builder retryHandler(HttpRequestRetryHandler retryHandler) {
            super.retryHandler(retryHandler);
            return this;
        }

        @Override
        public Builder rootUrl(Object value) {
            super.rootUrl(value);
            return this;
        }

        @Override
        public Builder routePlanner(HttpRoutePlanner routePlanner) {
            super.routePlanner(routePlanner);
            return this;
        }

        @Override
        public Builder schemePortResolver(SchemePortResolver schemePortResolver) {
            super.schemePortResolver(schemePortResolver);
            return this;
        }

        @Override
        public Builder serializer(Class<? extends Serializer> value) {
            super.serializer(value);
            return this;
        }

        @Override
        public Builder serializer(Serializer value) {
            super.serializer(value);
            return this;
        }

        @Override
        public Builder serializers(Class<? extends Serializer> ... value) {
            super.serializers(value);
            return this;
        }

        @Override
        public Builder serializers(Serializer ... value) {
            super.serializers(value);
            return this;
        }

        @Override
        public Builder serviceUnavailableRetryStrategy(ServiceUnavailableRetryStrategy serviceUnavailStrategy) {
            super.serviceUnavailableRetryStrategy(serviceUnavailStrategy);
            return this;
        }

        @Override
        public Builder json5() {
            super.json5();
            return this;
        }

        @Override
        public Builder skipEmptyFormData() {
            super.skipEmptyFormData();
            return this;
        }

        @Override
        public Builder skipEmptyFormData(boolean value) {
            super.skipEmptyFormData(value);
            return this;
        }

        @Override
        public Builder skipEmptyHeaderData() {
            super.skipEmptyHeaderData();
            return this;
        }

        @Override
        public Builder skipEmptyHeaderData(boolean value) {
            super.skipEmptyHeaderData(value);
            return this;
        }

        @Override
        public Builder skipEmptyQueryData() {
            super.skipEmptyQueryData();
            return this;
        }

        @Override
        public Builder skipEmptyQueryData(boolean value) {
            super.skipEmptyQueryData(value);
            return this;
        }

        @Override
        public Builder sortCollections() {
            super.sortCollections();
            return this;
        }

        @Override
        public Builder sortMaps() {
            super.sortMaps();
            return this;
        }

        @Override
        public Builder sq() {
            super.sq();
            return this;
        }

        @Override
        public Builder sslContext(SSLContext sslContext) {
            super.sslContext(sslContext);
            return this;
        }

        @Override
        public Builder sslHostnameVerifier(HostnameVerifier hostnameVerifier) {
            super.sslHostnameVerifier(hostnameVerifier);
            return this;
        }

        @Override
        public Builder sslSocketFactory(LayeredConnectionSocketFactory sslSocketFactory) {
            super.sslSocketFactory(sslSocketFactory);
            return this;
        }

        @Override
        public Builder strict() {
            super.strict();
            return this;
        }

        @Override
        public Builder targetAuthenticationStrategy(AuthenticationStrategy targetAuthStrategy) {
            super.targetAuthenticationStrategy(targetAuthStrategy);
            return this;
        }

        @Override
        public Builder trimEmptyCollections() {
            super.trimEmptyCollections();
            return this;
        }

        @Override
        public Builder trimEmptyMaps() {
            super.trimEmptyMaps();
            return this;
        }

        @Override
        public Builder trimStringsOnRead() {
            super.trimStringsOnRead();
            return this;
        }

        @Override
        public Builder trimStringsOnWrite() {
            super.trimStringsOnWrite();
            return this;
        }

        @Override
        public Builder uon() {
            super.uon();
            return this;
        }

        @Override
        public Builder uriContext(UriContext value) {
            super.uriContext(value);
            return this;
        }

        @Override
        public Builder uriRelativity(UriRelativity value) {
            super.uriRelativity(value);
            return this;
        }

        @Override
        public Builder uriResolution(UriResolution value) {
            super.uriResolution(value);
            return this;
        }

        @Override
        public Builder urlEnc() {
            super.urlEnc();
            return this;
        }

        @Override
        public Builder useSystemProperties() {
            super.useSystemProperties();
            return this;
        }

        @Override
        public Builder useWhitespace() {
            super.useWhitespace();
            return this;
        }

        @Override
        public Builder userTokenHandler(UserTokenHandler userTokenHandler) {
            super.userTokenHandler(userTokenHandler);
            return this;
        }

        @Override
        public Builder ws() {
            super.ws();
            return this;
        }

        @Override
        public Builder xml() {
            super.xml();
            return this;
        }
    }
}

