/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.arg;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.apache.juneau.AnnotationWorkList;
import org.apache.juneau.Value;
import org.apache.juneau.ValueListener;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.annotation.HeaderAnnotation;
import org.apache.juneau.http.header.SerializedHeader;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.httppart.HttpPartSerializerSession;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.reflect.ParamInfo;
import org.apache.juneau.rest.RestOpSession;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.arg.ArgException;
import org.apache.juneau.rest.arg.RestOpArg;
import org.apache.juneau.rest.httppart.ResponsePartMeta;

public class ResponseHeaderArg
implements RestOpArg {
    final ResponsePartMeta meta;
    final String name;
    private final Type type;

    public static ResponseHeaderArg create(ParamInfo paramInfo, AnnotationWorkList annotations) {
        if (paramInfo.getParameterType().is(Value.class) && (paramInfo.hasAnnotation(Header.class) || paramInfo.getParameterType().hasAnnotation(Header.class))) {
            return new ResponseHeaderArg(paramInfo, annotations);
        }
        return null;
    }

    protected ResponseHeaderArg(ParamInfo pi, AnnotationWorkList annotations) {
        Class c;
        this.name = HeaderAnnotation.findName(pi).orElseThrow(() -> new ArgException(pi, "@Header used without name or value", new Object[0]));
        this.type = pi.getParameterType().innerType();
        HttpPartSchema schema = HttpPartSchema.create(Header.class, pi);
        Class<? extends HttpPartSerializer> ps = schema.getSerializer();
        this.meta = new ResponsePartMeta(HttpPartType.HEADER, schema, ps != null ? (HttpPartSerializer)HttpPartSerializer.creator().type((Class)ps).apply(annotations).create() : null);
        Class clazz = this.type instanceof Class ? (Class)this.type : (c = this.type instanceof ParameterizedType ? (Class)((ParameterizedType)this.type).getRawType() : null);
        if (c != Value.class) {
            throw new ArgException(pi, "Type must be Value<?> on parameter annotated with @Header annotation", new Object[0]);
        }
    }

    @Override
    public Object resolve(final RestOpSession opSession) throws Exception {
        Value v = new Value();
        v.listener(new ValueListener(){

            public void onSet(Object o) {
                RestRequest req = opSession.getRequest();
                RestResponse res = opSession.getResponse();
                ResponsePartMeta rpm = req.getOpContext().getResponseHeaderMeta(o);
                if (rpm == null) {
                    rpm = ResponseHeaderArg.this.meta;
                }
                HttpPartSerializerSession pss = rpm.getSerializer() == null ? req.getPartSerializerSession() : rpm.getSerializer().getPartSession();
                res.setHeader((org.apache.http.Header)new SerializedHeader(ResponseHeaderArg.this.name, o, pss, rpm.getSchema(), false));
            }
        });
        return v;
    }
}

