/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.arg;

import java.lang.reflect.Type;
import org.apache.juneau.BeanSession;
import org.apache.juneau.Value;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.http.annotation.HasFormData;
import org.apache.juneau.reflect.ParamInfo;
import org.apache.juneau.rest.RestOpSession;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.arg.ArgException;
import org.apache.juneau.rest.arg.RestOpArg;

public class HasFormDataArg
implements RestOpArg {
    private final String name;
    private final Type type;

    public static HasFormDataArg create(ParamInfo paramInfo) {
        if (paramInfo.hasAnnotation(HasFormData.class)) {
            return new HasFormDataArg(paramInfo);
        }
        return null;
    }

    protected HasFormDataArg(ParamInfo pi) {
        Value _name = Value.empty();
        pi.forEachAnnotation(HasFormData.class, x -> HasFormDataArg.hasName(x), x -> _name.set(HasFormDataArg.getName(x)));
        this.name = (String)_name.orElseThrow(() -> new ArgException(pi, "@HasFormData used without name or value", new Object[0]));
        this.type = pi.getParameterType().innerType();
    }

    private static boolean hasName(HasFormData x) {
        return StringUtils.isNotEmpty(x.name()) || StringUtils.isNotEmpty(x.value());
    }

    private static String getName(HasFormData x) {
        return StringUtils.firstNonEmpty(x.name(), x.value());
    }

    @Override
    public Object resolve(RestOpSession opSession) throws Exception {
        RestRequest req = opSession.getRequest();
        BeanSession bs = req.getBeanSession();
        return bs.convertToType((Object)req.getFormParams().contains(this.name), bs.getClassMeta(this.type, new Type[0]));
    }
}

