/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.http.NameValuePair;
import org.apache.juneau.AnnotationWorkList;
import org.apache.juneau.BeanContext;
import org.apache.juneau.ConfigException;
import org.apache.juneau.Context;
import org.apache.juneau.Enablement;
import org.apache.juneau.MediaType;
import org.apache.juneau.Value;
import org.apache.juneau.annotation.Schema;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.common.internal.ThrowableUtils;
import org.apache.juneau.cp.BeanCreator;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.cp.DefaultClassList;
import org.apache.juneau.encoders.Encoder;
import org.apache.juneau.encoders.EncoderSet;
import org.apache.juneau.http.HttpHeaders;
import org.apache.juneau.http.HttpParts;
import org.apache.juneau.http.annotation.FormData;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.annotation.Query;
import org.apache.juneau.http.header.HeaderList;
import org.apache.juneau.http.part.PartList;
import org.apache.juneau.http.response.InternalServerError;
import org.apache.juneau.httppart.HttpPartParser;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.httppart.bean.ResponseBeanMeta;
import org.apache.juneau.internal.Cache;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.FluentSetter;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.HttpUtils;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.jsonschema.JsonSchemaGenerator;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.parser.ParserSet;
import org.apache.juneau.reflect.MethodInfo;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.RestOpInvoker;
import org.apache.juneau.rest.RestOpSession;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.RestSession;
import org.apache.juneau.rest.annotation.RestDelete;
import org.apache.juneau.rest.annotation.RestGet;
import org.apache.juneau.rest.annotation.RestInject;
import org.apache.juneau.rest.annotation.RestOp;
import org.apache.juneau.rest.annotation.RestPost;
import org.apache.juneau.rest.annotation.RestPut;
import org.apache.juneau.rest.converter.RestConverter;
import org.apache.juneau.rest.converter.RestConverterList;
import org.apache.juneau.rest.debug.DebugEnablement;
import org.apache.juneau.rest.guard.RestGuard;
import org.apache.juneau.rest.guard.RestGuardList;
import org.apache.juneau.rest.guard.RoleBasedRestGuard;
import org.apache.juneau.rest.httppart.NamedAttribute;
import org.apache.juneau.rest.httppart.NamedAttributeMap;
import org.apache.juneau.rest.httppart.ResponsePartMeta;
import org.apache.juneau.rest.logger.CallLogger;
import org.apache.juneau.rest.matcher.ClientVersionMatcher;
import org.apache.juneau.rest.matcher.RestMatcher;
import org.apache.juneau.rest.matcher.RestMatcherList;
import org.apache.juneau.rest.util.RestUtils;
import org.apache.juneau.rest.util.UrlPathMatch;
import org.apache.juneau.rest.util.UrlPathMatcher;
import org.apache.juneau.rest.util.UrlPathMatcherList;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.serializer.SerializerSet;
import org.apache.juneau.svl.VarResolver;
import org.apache.juneau.svl.VarResolverSession;
import org.apache.juneau.utils.HashKey;

public class RestOpContext
extends Context
implements Comparable<RestOpContext> {
    private final String httpMethod;
    private final UrlPathMatcher[] pathMatchers;
    private final RestGuard[] guards;
    private final RestMatcher[] requiredMatchers;
    private final RestMatcher[] optionalMatchers;
    private final RestConverter[] converters;
    private final RestContext context;
    private final Method method;
    private final RestOpInvoker methodInvoker;
    private final RestOpInvoker[] preCallMethods;
    private final RestOpInvoker[] postCallMethods;
    private final MethodInfo mi;
    private final BeanContext beanContext;
    private final SerializerSet serializers;
    private final ParserSet parsers;
    private final EncoderSet encoders;
    private final HttpPartSerializer partSerializer;
    private final HttpPartParser partParser;
    private final JsonSchemaGenerator jsonSchemaGenerator;
    private final HeaderList defaultRequestHeaders;
    private final HeaderList defaultResponseHeaders;
    private final PartList defaultRequestQueryData;
    private final PartList defaultRequestFormData;
    private final NamedAttributeMap defaultRequestAttributes;
    private final Charset defaultCharset;
    private final long maxInput;
    private final List<MediaType> supportedAcceptTypes;
    private final List<MediaType> supportedContentTypes;
    private final CallLogger callLogger;
    private final Map<Class<?>, ResponseBeanMeta> responseBeanMetas = new ConcurrentHashMap();
    private final Map<Class<?>, ResponsePartMeta> headerPartMetas = new ConcurrentHashMap();
    private final ResponseBeanMeta responseMeta;
    private final int hierarchyDepth;
    private final DebugEnablement debug;

    public static Builder create(Method method, RestContext context) {
        return new Builder(method, context);
    }

    protected RestOpContext(Builder builder) throws ServletException {
        super(builder);
        try {
            this.context = builder.restContext;
            this.method = builder.restMethod;
            this.debug = builder.debug == null ? this.context.getDebugEnablement() : DebugEnablement.create(this.context.getBeanStore()).enable(builder.debug, "*").build();
            this.mi = MethodInfo.of(this.method).accessible();
            Object r = this.context.getResource();
            BeanStore bs = BeanStore.of(this.context.getRootBeanStore(), r).addBean(RestOpContext.class, this).addBean(Method.class, this.method).addBean(AnnotationWorkList.class, builder.getApplied());
            bs.addBean(BeanStore.class, bs);
            this.beanContext = bs.add(BeanContext.class, builder.getBeanContext().orElse(this.context.getBeanContext()));
            this.encoders = bs.add(EncoderSet.class, builder.getEncoders().orElse(this.context.getEncoders()));
            this.serializers = bs.add(SerializerSet.class, builder.getSerializers().orElse(this.context.getSerializers()));
            this.parsers = bs.add(ParserSet.class, builder.getParsers().orElse(this.context.getParsers()));
            this.partSerializer = bs.add(HttpPartSerializer.class, builder.getPartSerializer().orElse(this.context.getPartSerializer()));
            this.partParser = bs.add(HttpPartParser.class, builder.getPartParser().orElse(this.context.getPartParser()));
            this.jsonSchemaGenerator = bs.add(JsonSchemaGenerator.class, builder.getJsonSchemaGenerator().orElse(this.context.getJsonSchemaGenerator()));
            this.converters = bs.add(RestConverter[].class, ((RestConverterList)builder.converters().build()).asArray());
            this.guards = bs.add(RestGuard[].class, builder.getGuards().asArray());
            RestMatcherList matchers = builder.getMatchers(this.context);
            this.optionalMatchers = matchers.getOptionalEntries();
            this.requiredMatchers = matchers.getRequiredEntries();
            this.pathMatchers = bs.add(UrlPathMatcher[].class, builder.getPathMatchers().asArray());
            bs.addBean(UrlPathMatcher.class, this.pathMatchers.length > 0 ? this.pathMatchers[0] : null);
            this.supportedAcceptTypes = CollectionUtils.unmodifiable(builder.produces != null ? builder.produces : this.serializers.getSupportedMediaTypes());
            this.supportedContentTypes = CollectionUtils.unmodifiable(builder.consumes != null ? builder.consumes : this.parsers.getSupportedMediaTypes());
            this.defaultRequestHeaders = builder.defaultRequestHeaders();
            this.defaultResponseHeaders = builder.defaultResponseHeaders();
            this.defaultRequestQueryData = builder.defaultRequestQueryData();
            this.defaultRequestFormData = builder.defaultRequestFormData();
            this.defaultRequestAttributes = builder.defaultRequestAttributes();
            int _hierarchyDepth = 0;
            for (Class<?> sc = this.method.getDeclaringClass().getSuperclass(); sc != null; sc = sc.getSuperclass()) {
                ++_hierarchyDepth;
            }
            this.hierarchyDepth = _hierarchyDepth;
            String _httpMethod = builder.httpMethod;
            if (_httpMethod == null) {
                _httpMethod = HttpUtils.detectHttpMethod(this.method, true, "GET");
            }
            if ("METHOD".equals(_httpMethod)) {
                _httpMethod = "*";
            }
            this.httpMethod = _httpMethod.toUpperCase(Locale.ENGLISH);
            this.defaultCharset = builder.defaultCharset != null ? builder.defaultCharset : this.context.defaultCharset;
            this.maxInput = builder.maxInput != null ? builder.maxInput : this.context.maxInput;
            this.responseMeta = ResponseBeanMeta.create(this.mi, builder.getApplied());
            this.preCallMethods = (RestOpInvoker[])this.context.getPreCallMethods().stream().map(x -> new RestOpInvoker((Method)x, this.context.findRestOperationArgs((Method)x, bs), this.context.getMethodExecStats((Method)x))).toArray(RestOpInvoker[]::new);
            this.postCallMethods = (RestOpInvoker[])this.context.getPostCallMethods().stream().map(x -> new RestOpInvoker((Method)x, this.context.findRestOperationArgs((Method)x, bs), this.context.getMethodExecStats((Method)x))).toArray(RestOpInvoker[]::new);
            this.methodInvoker = new RestOpInvoker(this.method, this.context.findRestOperationArgs(this.method, bs), this.context.getMethodExecStats(this.method));
            this.callLogger = this.context.getCallLogger();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public RestOpSession.Builder createSession(RestSession session) throws Exception {
        return RestOpSession.create(this, session).logger(this.callLogger).debug(this.debug.isDebug(this, session.getRequest()));
    }

    public RestRequest createRequest(RestSession session) throws Exception {
        return new RestRequest(this, session);
    }

    public RestResponse createResponse(RestSession session, RestRequest req) throws Exception {
        return new RestResponse(this, session, req);
    }

    public BeanContext getBeanContext() {
        return this.beanContext;
    }

    public ResponseBeanMeta getResponseBeanMeta(Object o) {
        if (o == null) {
            return null;
        }
        Class<?> c = o.getClass();
        ResponseBeanMeta rbm = this.responseBeanMetas.get(c);
        if (rbm == null) {
            rbm = ResponseBeanMeta.create(c, AnnotationWorkList.create());
            if (rbm == null) {
                rbm = ResponseBeanMeta.NULL;
            }
            this.responseBeanMetas.put(c, rbm);
        }
        if (rbm == ResponseBeanMeta.NULL) {
            return null;
        }
        return rbm;
    }

    public ResponsePartMeta getResponseHeaderMeta(Object o) {
        if (o == null) {
            return null;
        }
        Class<?> c = o.getClass();
        ResponsePartMeta pm = this.headerPartMetas.get(c);
        if (pm == null) {
            Header a = c.getAnnotation(Header.class);
            if (a != null) {
                HttpPartSchema schema = HttpPartSchema.create(a);
                HttpPartSerializer serializer = RestOpContext.createPartSerializer(schema.getSerializer(), this.partSerializer);
                pm = new ResponsePartMeta(HttpPartType.HEADER, schema, serializer);
            }
            if (pm == null) {
                pm = ResponsePartMeta.NULL;
            }
            this.headerPartMetas.put(c, pm);
        }
        if (pm == ResponsePartMeta.NULL) {
            return null;
        }
        return pm;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public String getPathPattern() {
        return this.pathMatchers[0].toString();
    }

    public SerializerSet getSerializers() {
        return this.serializers;
    }

    public ParserSet getParsers() {
        return this.parsers;
    }

    public EncoderSet getEncoders() {
        return this.encoders;
    }

    public HttpPartSerializer getPartSerializer() {
        return this.partSerializer;
    }

    public HttpPartParser getPartParser() {
        return this.partParser;
    }

    public JsonSchemaGenerator getJsonSchemaGenerator() {
        return this.jsonSchemaGenerator;
    }

    public Method getJavaMethod() {
        return this.method;
    }

    public HeaderList getDefaultRequestHeaders() {
        return this.defaultRequestHeaders;
    }

    public HeaderList getDefaultResponseHeaders() {
        return this.defaultResponseHeaders;
    }

    public PartList getDefaultRequestQueryData() {
        return this.defaultRequestQueryData;
    }

    public PartList getDefaultRequestFormData() {
        return this.defaultRequestFormData;
    }

    public NamedAttributeMap getDefaultRequestAttributes() {
        return this.defaultRequestAttributes;
    }

    public Charset getDefaultCharset() {
        return this.defaultCharset;
    }

    public long getMaxInput() {
        return this.maxInput;
    }

    public List<MediaType> getSupportedContentTypes() {
        return this.supportedContentTypes;
    }

    public List<MediaType> getSupportedAcceptTypes() {
        return this.supportedAcceptTypes;
    }

    public ResponseBeanMeta getResponseMeta() {
        return this.responseMeta;
    }

    protected int match(RestSession session) {
        UrlPathMatch pm = this.matchPattern(session);
        if (pm == null) {
            return 0;
        }
        if (this.requiredMatchers.length == 0 && this.optionalMatchers.length == 0) {
            session.urlPathMatch(pm);
            return 2;
        }
        try {
            HttpServletRequest req = session.getRequest();
            for (RestMatcher m : this.requiredMatchers) {
                if (m.matches(req)) continue;
                return 1;
            }
            if (this.optionalMatchers.length > 0) {
                boolean matches = false;
                for (RestMatcher m : this.optionalMatchers) {
                    matches |= m.matches(req);
                }
                if (!matches) {
                    return 1;
                }
            }
            session.urlPathMatch(pm);
            return 2;
        }
        catch (Exception e) {
            throw new InternalServerError((Throwable)e);
        }
    }

    RestOpInvoker getMethodInvoker() {
        return this.methodInvoker;
    }

    RestGuard[] getGuards() {
        return this.guards;
    }

    RestConverter[] getConverters() {
        return this.converters;
    }

    RestOpInvoker[] getPreCallMethods() {
        return this.preCallMethods;
    }

    RestOpInvoker[] getPostCallMethods() {
        return this.postCallMethods;
    }

    @Override
    public Context.Builder copy() {
        throw new UnsupportedOperationException("Method not implemented.");
    }

    @Override
    public int compareTo(RestOpContext o) {
        int c;
        int i;
        for (i = 0; i < Math.min(this.pathMatchers.length, o.pathMatchers.length); ++i) {
            c = this.pathMatchers[i].compareTo(o.pathMatchers[i]);
            if (c == 0) continue;
            return c;
        }
        c = ObjectUtils.compare(o.hierarchyDepth, this.hierarchyDepth);
        if (c != 0) {
            return c;
        }
        c = ObjectUtils.compare(o.requiredMatchers.length, this.requiredMatchers.length);
        if (c != 0) {
            return c;
        }
        c = ObjectUtils.compare(o.optionalMatchers.length, this.optionalMatchers.length);
        if (c != 0) {
            return c;
        }
        c = ObjectUtils.compare(o.guards.length, this.guards.length);
        if (c != 0) {
            return c;
        }
        c = StringUtils.compare(this.method.getName(), o.method.getName());
        if (c != 0) {
            return c;
        }
        c = ObjectUtils.compare(this.method.getParameterCount(), o.method.getParameterCount());
        if (c != 0) {
            return c;
        }
        for (i = 0; i < this.method.getParameterCount(); ++i) {
            c = StringUtils.compare(this.method.getParameterTypes()[i].getName(), o.method.getParameterTypes()[i].getName());
            if (c == 0) continue;
            return c;
        }
        c = StringUtils.compare(this.method.getReturnType().getName(), o.method.getReturnType().getName());
        if (c != 0) {
            return c;
        }
        return 0;
    }

    public boolean equals(Object o) {
        return o instanceof RestOpContext && ObjectUtils.eq(this, (RestOpContext)o, (x, y) -> x.method.equals(y.method));
    }

    public int hashCode() {
        return this.method.hashCode();
    }

    @Override
    protected JsonMap properties() {
        return JsonMap.filteredMap().append("defaultRequestFormData", this.defaultRequestFormData).append("defaultRequestHeaders", this.defaultRequestHeaders).append("defaultRequestQueryData", this.defaultRequestQueryData).append("httpMethod", this.httpMethod);
    }

    private static HttpPartSerializer createPartSerializer(Class<? extends HttpPartSerializer> c, HttpPartSerializer _default) {
        return BeanCreator.of(HttpPartSerializer.class).type(c).orElse(_default);
    }

    private UrlPathMatch matchPattern(RestSession call) {
        UrlPathMatch pm = null;
        for (UrlPathMatcher pp : this.pathMatchers) {
            if (pm != null) continue;
            pm = pp.match(call.getUrlPath());
        }
        return pm;
    }

    @FluentSetters
    public static final class Builder
    extends Context.Builder {
        RestContext restContext;
        RestContext.Builder parent;
        Method restMethod;
        String httpMethod;
        String clientVersion;
        Enablement debug;
        List<String> path;
        private RestConverterList.Builder converters;
        private BeanContext.Builder beanContext;
        private RestGuardList.Builder guards;
        private EncoderSet.Builder encoders;
        private SerializerSet.Builder serializers;
        private ParserSet.Builder parsers;
        private HttpPartSerializer.Creator partSerializer;
        private HttpPartParser.Creator partParser;
        private RestMatcherList.Builder matchers;
        private JsonSchemaGenerator.Builder jsonSchemaGenerator;
        PartList defaultRequestFormData;
        PartList defaultRequestQueryData;
        NamedAttributeMap defaultRequestAttributes;
        HeaderList defaultRequestHeaders;
        HeaderList defaultResponseHeaders;
        RestMatcherList.Builder restMatchers;
        List<MediaType> produces;
        List<MediaType> consumes;
        Set<String> roleGuard;
        Set<String> rolesDeclared;
        boolean dotAll;
        Charset defaultCharset;
        Long maxInput;
        private BeanStore beanStore;

        @Override
        public Builder copy() {
            throw new NoSuchMethodError("Not implemented.");
        }

        @Override
        public RestOpContext build() {
            try {
                return this.beanStore.createBean(RestOpContext.class).type(this.getType().orElse(this.getDefaultImplClass())).builder(Builder.class, this).run();
            }
            catch (Exception e) {
                throw new InternalServerError((Throwable)e);
            }
        }

        protected Class<? extends RestOpContext> getDefaultImplClass() {
            return RestOpContext.class;
        }

        Builder(Method method, RestContext context) {
            this.restContext = context;
            this.parent = context.builder;
            this.restMethod = method;
            this.beanStore = BeanStore.of(context.getBeanStore(), context.builder.resource().get()).addBean(Method.class, method);
            MethodInfo mi = MethodInfo.of(context.getResourceClass(), method);
            try {
                VarResolver vr = context.getVarResolver();
                VarResolverSession vrs = vr.createSession();
                AnnotationWorkList work = AnnotationWorkList.of(vrs, mi.getAnnotationList(Context.CONTEXT_APPLY_FILTER));
                this.apply(work);
                if (context.builder.beanContext().canApply(work)) {
                    this.beanContext().apply(work);
                }
                if (context.builder.serializers().canApply(work)) {
                    this.serializers().apply(work);
                }
                if (context.builder.parsers().canApply(work)) {
                    this.parsers().apply(work);
                }
                if (context.builder.partSerializer().canApply(work)) {
                    this.partSerializer().apply(work);
                }
                if (context.builder.partParser().canApply(work)) {
                    this.partParser().apply(work);
                }
                if (context.builder.jsonSchemaGenerator().canApply(work)) {
                    this.jsonSchemaGenerator().apply(work);
                }
                this.processParameterAnnotations();
            }
            catch (Exception e) {
                throw new InternalServerError((Throwable)e);
            }
        }

        public Supplier<?> resource() {
            return this.restContext.builder.resource();
        }

        public DefaultClassList defaultClasses() {
            return this.restContext.builder.defaultClasses();
        }

        public BeanStore beanStore() {
            return this.beanStore;
        }

        protected Builder beanStore(BeanStore beanStore) {
            this.beanStore = beanStore;
            return this;
        }

        public <T> Builder beanStore(Class<T> beanType, T bean) {
            this.beanStore().addBean(beanType, bean);
            return this;
        }

        public <T> Builder beanStore(Class<T> beanType, T bean, String name) {
            this.beanStore().addBean(beanType, bean, name);
            return this;
        }

        public BeanContext.Builder beanContext() {
            if (this.beanContext == null) {
                this.beanContext = this.createBeanContext(this.beanStore(), this.parent, this.resource());
            }
            return this.beanContext;
        }

        protected BeanContext.Builder createBeanContext(BeanStore beanStore, RestContext.Builder parent, Supplier<?> resource) {
            Value<BeanContext.Builder> v = Value.of(parent.beanContext().copy());
            BeanStore.of(beanStore, resource).addBean(BeanContext.Builder.class, v.get()).createMethodFinder(BeanContext.class, resource).find(x -> this.matches((MethodInfo)x)).run(x -> ((BeanContext.Builder)v.get()).impl((Context)x));
            return v.get();
        }

        Optional<BeanContext> getBeanContext() {
            return CollectionUtils.optional(this.beanContext).map(x -> x.build());
        }

        public EncoderSet.Builder encoders() {
            if (this.encoders == null) {
                this.encoders = this.createEncoders(this.beanStore(), this.parent, this.resource());
            }
            return this.encoders;
        }

        @SafeVarargs
        public final Builder encoders(Class<? extends Encoder> ... value) {
            this.encoders().add(value);
            return this;
        }

        public Builder encoders(Encoder ... value) {
            this.encoders().add(value);
            return this;
        }

        protected EncoderSet.Builder createEncoders(BeanStore beanStore, RestContext.Builder parent, Supplier<?> resource) {
            Value<EncoderSet.Builder> v = Value.of(parent.encoders().copy());
            BeanStore.of(beanStore, resource).addBean(EncoderSet.Builder.class, v.get()).createMethodFinder(EncoderSet.class, resource).find(x -> this.matches((MethodInfo)x)).run(x -> ((EncoderSet.Builder)v.get()).impl(x));
            return v.get();
        }

        Optional<EncoderSet> getEncoders() {
            return CollectionUtils.optional(this.encoders).map(x -> (EncoderSet)x.build());
        }

        public SerializerSet.Builder serializers() {
            if (this.serializers == null) {
                this.serializers = this.createSerializers(this.beanStore(), this.parent, this.resource());
            }
            return this.serializers;
        }

        @SafeVarargs
        public final Builder serializers(Class<? extends Serializer> ... value) {
            this.serializers().add(value);
            return this;
        }

        public Builder serializers(Serializer ... value) {
            this.serializers().add(value);
            return this;
        }

        protected SerializerSet.Builder createSerializers(BeanStore beanStore, RestContext.Builder parent, Supplier<?> resource) {
            Value<SerializerSet.Builder> v = Value.of(parent.serializers().copy());
            BeanStore.of(beanStore, resource).addBean(SerializerSet.Builder.class, v.get()).createMethodFinder(SerializerSet.class, resource).find(x -> this.matches((MethodInfo)x)).run(x -> ((SerializerSet.Builder)v.get()).impl(x));
            return v.get();
        }

        Optional<SerializerSet> getSerializers() {
            return CollectionUtils.optional(this.serializers).map(x -> (SerializerSet)x.build());
        }

        public ParserSet.Builder parsers() {
            if (this.parsers == null) {
                this.parsers = this.createParsers(this.beanStore(), this.parent, this.resource());
            }
            return this.parsers;
        }

        @SafeVarargs
        public final Builder parsers(Class<? extends Parser> ... value) {
            this.parsers().add(value);
            return this;
        }

        public Builder parsers(Parser ... value) {
            this.parsers().add(value);
            return this;
        }

        protected ParserSet.Builder createParsers(BeanStore beanStore, RestContext.Builder parent, Supplier<?> resource) {
            Value<ParserSet.Builder> v = Value.of(parent.parsers().copy());
            BeanStore.of(beanStore, resource).addBean(ParserSet.Builder.class, v.get()).createMethodFinder(ParserSet.class, resource).find(x -> this.matches((MethodInfo)x)).run(x -> ((ParserSet.Builder)v.get()).impl(x));
            return v.get();
        }

        Optional<ParserSet> getParsers() {
            return CollectionUtils.optional(this.parsers).map(x -> (ParserSet)x.build());
        }

        public HttpPartSerializer.Creator partSerializer() {
            if (this.partSerializer == null) {
                this.partSerializer = this.createPartSerializer(this.beanStore(), this.parent, this.resource());
            }
            return this.partSerializer;
        }

        public Builder partSerializer(Class<? extends HttpPartSerializer> value) {
            this.partSerializer().type((Class)value);
            return this;
        }

        public Builder partSerializer(HttpPartSerializer value) {
            this.partSerializer().impl(value);
            return this;
        }

        protected HttpPartSerializer.Creator createPartSerializer(BeanStore beanStore, RestContext.Builder parent, Supplier<?> resource) {
            Value<HttpPartSerializer.Creator> v = Value.of(parent.partSerializer().copy());
            BeanStore.of(beanStore, resource).addBean(HttpPartSerializer.Creator.class, v.get()).createMethodFinder(HttpPartSerializer.class, resource).find(x -> this.matches((MethodInfo)x)).run(x -> ((HttpPartSerializer.Creator)v.get()).impl(x));
            return v.get();
        }

        Optional<HttpPartSerializer> getPartSerializer() {
            return CollectionUtils.optional(this.partSerializer).map(x -> (HttpPartSerializer)x.create());
        }

        public HttpPartParser.Creator partParser() {
            if (this.partParser == null) {
                this.partParser = this.createPartParser(this.beanStore(), this.parent, this.resource());
            }
            return this.partParser;
        }

        public Builder partParser(Class<? extends HttpPartParser> value) {
            this.partParser().type((Class)value);
            return this;
        }

        public Builder partParser(HttpPartParser value) {
            this.partParser().impl(value);
            return this;
        }

        protected HttpPartParser.Creator createPartParser(BeanStore beanStore, RestContext.Builder parent, Supplier<?> resource) {
            Value<HttpPartParser.Creator> v = Value.of(parent.partParser().copy());
            BeanStore.of(beanStore, resource).addBean(HttpPartParser.Creator.class, v.get()).createMethodFinder(HttpPartParser.class, resource).find(x -> this.matches((MethodInfo)x)).run(x -> ((HttpPartParser.Creator)v.get()).impl(x));
            return v.get();
        }

        Optional<HttpPartParser> getPartParser() {
            return CollectionUtils.optional(this.partParser).map(x -> (HttpPartParser)x.create());
        }

        public JsonSchemaGenerator.Builder jsonSchemaGenerator() {
            if (this.jsonSchemaGenerator == null) {
                this.jsonSchemaGenerator = this.createJsonSchemaGenerator(this.beanStore(), this.parent, this.resource());
            }
            return this.jsonSchemaGenerator;
        }

        public Builder jsonSchemaGenerator(Class<? extends JsonSchemaGenerator> value) {
            this.jsonSchemaGenerator().type(value);
            return this;
        }

        public Builder jsonSchemaGenerator(JsonSchemaGenerator value) {
            this.jsonSchemaGenerator().impl(value);
            return this;
        }

        protected JsonSchemaGenerator.Builder createJsonSchemaGenerator(BeanStore beanStore, RestContext.Builder parent, Supplier<?> resource) {
            Value<JsonSchemaGenerator.Builder> v = Value.of(parent.jsonSchemaGenerator().copy());
            BeanStore.of(beanStore, resource).addBean(JsonSchemaGenerator.Builder.class, v.get()).createMethodFinder(JsonSchemaGenerator.class, resource).find(x -> this.matches((MethodInfo)x)).run(x -> ((JsonSchemaGenerator.Builder)v.get()).impl((Context)x));
            return v.get();
        }

        Optional<JsonSchemaGenerator> getJsonSchemaGenerator() {
            return CollectionUtils.optional(this.jsonSchemaGenerator).map(x -> x.build());
        }

        public RestConverterList.Builder converters() {
            if (this.converters == null) {
                this.converters = this.createConverters(this.beanStore(), this.resource());
            }
            return this.converters;
        }

        @SafeVarargs
        public final Builder converters(Class<? extends RestConverter> ... value) {
            this.converters().append(value);
            return this;
        }

        public Builder converters(RestConverter ... value) {
            this.converters().append(value);
            return this;
        }

        protected RestConverterList.Builder createConverters(BeanStore beanStore, Supplier<?> resource) {
            Value<RestConverterList.Builder> v = Value.of(RestConverterList.create(beanStore));
            this.defaultClasses().get(RestConverterList.class).ifPresent(x -> ((RestConverterList.Builder)v.get()).type((Class)x));
            beanStore.getBean(RestConverterList.class).ifPresent(x -> ((RestConverterList.Builder)v.get()).impl(x));
            beanStore.createMethodFinder(RestConverterList.class).addBean(RestConverterList.Builder.class, v.get()).find(x -> this.matches((MethodInfo)x)).run(x -> ((RestConverterList.Builder)v.get()).impl(x));
            return v.get();
        }

        public RestGuardList.Builder guards() {
            if (this.guards == null) {
                this.guards = this.createGuards(this.beanStore(), this.resource());
            }
            return this.guards;
        }

        @SafeVarargs
        public final Builder guards(Class<? extends RestGuard> ... value) {
            this.guards().append(value);
            return this;
        }

        public Builder guards(RestGuard ... value) {
            this.guards().append(value);
            return this;
        }

        protected RestGuardList.Builder createGuards(BeanStore beanStore, Supplier<?> resource) {
            Value<RestGuardList.Builder> v = Value.of(RestGuardList.create(beanStore));
            this.defaultClasses().get(RestGuardList.class).ifPresent(x -> ((RestGuardList.Builder)v.get()).type((Class)x));
            beanStore.getBean(RestGuardList.class).ifPresent(x -> ((RestGuardList.Builder)v.get()).impl(x));
            beanStore.createMethodFinder(RestGuardList.class).addBean(RestGuardList.Builder.class, v.get()).find(x -> this.matches((MethodInfo)x)).run(x -> ((RestGuardList.Builder)v.get()).impl(x));
            return v.get();
        }

        RestGuardList getGuards() {
            RestGuardList.Builder b = this.guards();
            Set roleGuard = CollectionUtils.optional(this.roleGuard).orElseGet(() -> CollectionUtils.set(new String[0]));
            for (String rg : roleGuard) {
                try {
                    b.append(new RoleBasedRestGuard(this.rolesDeclared, rg));
                }
                catch (java.text.ParseException e1) {
                    throw ThrowableUtils.asRuntimeException(e1);
                }
            }
            return (RestGuardList)this.guards.build();
        }

        public RestMatcherList.Builder matchers() {
            if (this.matchers == null) {
                this.matchers = this.createMatchers(this.beanStore(), this.resource());
            }
            return this.matchers;
        }

        @SafeVarargs
        public final Builder matchers(Class<? extends RestMatcher> ... value) {
            this.matchers().append(value);
            return this;
        }

        public Builder matchers(RestMatcher ... value) {
            this.matchers().append(value);
            return this;
        }

        protected RestMatcherList.Builder createMatchers(BeanStore beanStore, Supplier<?> resource) {
            Value<RestMatcherList.Builder> v = Value.of(RestMatcherList.create(beanStore));
            this.defaultClasses().get(RestMatcherList.class).ifPresent(x -> ((RestMatcherList.Builder)v.get()).type((Class)x));
            beanStore.getBean(RestMatcherList.class).ifPresent(x -> ((RestMatcherList.Builder)v.get()).impl(x));
            beanStore.createMethodFinder(RestMatcherList.class).addBean(RestMatcherList.Builder.class, v.get()).find(x -> this.matches((MethodInfo)x)).run(x -> ((RestMatcherList.Builder)v.get()).impl(x));
            return v.get();
        }

        RestMatcherList getMatchers(RestContext restContext) {
            RestMatcherList.Builder b = this.matchers();
            if (this.clientVersion != null) {
                b.append(new ClientVersionMatcher(restContext.getClientVersionHeader(), MethodInfo.of(this.restMethod)));
            }
            return (RestMatcherList)b.build();
        }

        /*
         * WARNING - void declaration
         */
        protected UrlPathMatcherList getPathMatchers() {
            Value<UrlPathMatcherList> v = Value.of(UrlPathMatcherList.create());
            if (this.path != null) {
                for (String string : this.path) {
                    void var3_3;
                    if (this.dotAll && !string.endsWith("/*")) {
                        String string2 = string + "/*";
                    }
                    v.get().add(UrlPathMatcher.of((String)var3_3));
                }
            }
            if (v.get().isEmpty()) {
                void var3_9;
                MethodInfo mi = MethodInfo.of(this.restMethod);
                Object var3_6 = null;
                String httpMethod = null;
                if (mi.hasAnnotation(RestGet.class)) {
                    httpMethod = "get";
                } else if (mi.hasAnnotation(RestPut.class)) {
                    httpMethod = "put";
                } else if (mi.hasAnnotation(RestPost.class)) {
                    httpMethod = "post";
                } else if (mi.hasAnnotation(RestDelete.class)) {
                    httpMethod = "delete";
                } else if (mi.hasAnnotation(RestOp.class)) {
                    Value<Object> _httpMethod = Value.empty();
                    mi.forEachAnnotation(RestOp.class, x -> StringUtils.isNotEmpty(x.method()), x -> _httpMethod.set(x.method()));
                    httpMethod = _httpMethod.orElse(null);
                }
                String string = HttpUtils.detectHttpPath(this.restMethod, httpMethod);
                if (this.dotAll && !string.endsWith("/*")) {
                    String string3 = string + "/*";
                }
                v.get().add(UrlPathMatcher.of((String)var3_9));
            }
            this.beanStore.createMethodFinder(UrlPathMatcherList.class, this.resource().get()).addBean(UrlPathMatcherList.class, v.get()).find(x -> this.matches((MethodInfo)x)).run(x -> v.set((UrlPathMatcherList)x));
            return v.get();
        }

        public Builder dotAll() {
            this.dotAll = true;
            return this;
        }

        public HeaderList defaultRequestHeaders() {
            if (this.defaultRequestHeaders == null) {
                this.defaultRequestHeaders = this.createDefaultRequestHeaders(this.beanStore(), this.parent, this.resource());
            }
            return this.defaultRequestHeaders;
        }

        public Builder defaultRequestHeaders(org.apache.http.Header ... value) {
            this.defaultRequestHeaders().append(value);
            return this;
        }

        protected HeaderList createDefaultRequestHeaders(BeanStore beanStore, RestContext.Builder parent, Supplier<?> resource) {
            Value<HeaderList> v = Value.of(parent.defaultRequestHeaders().copy());
            BeanStore.of(beanStore, resource).addBean(HeaderList.class, v.get()).createMethodFinder(HeaderList.class, resource).find(x -> this.matches((MethodInfo)x, "defaultRequestHeaders")).run(x -> v.set((HeaderList)x));
            return v.get();
        }

        public HeaderList defaultResponseHeaders() {
            if (this.defaultResponseHeaders == null) {
                this.defaultResponseHeaders = this.createDefaultResponseHeaders(this.beanStore(), this.parent, this.resource());
            }
            return this.defaultResponseHeaders;
        }

        public Builder defaultResponseHeaders(org.apache.http.Header ... value) {
            this.defaultResponseHeaders().append(value);
            return this;
        }

        protected HeaderList createDefaultResponseHeaders(BeanStore beanStore, RestContext.Builder parent, Supplier<?> resource) {
            Value<HeaderList> v = Value.of(parent.defaultResponseHeaders().copy());
            BeanStore.of(beanStore, resource).addBean(HeaderList.class, v.get()).createMethodFinder(HeaderList.class, resource).find(x -> this.matches((MethodInfo)x, "defaultResponseHeaders")).run(x -> v.set((HeaderList)x));
            return v.get();
        }

        public NamedAttributeMap defaultRequestAttributes() {
            if (this.defaultRequestAttributes == null) {
                this.defaultRequestAttributes = this.createDefaultRequestAttributes(this.beanStore(), this.parent, this.resource());
            }
            return this.defaultRequestAttributes;
        }

        public Builder defaultRequestAttributes(NamedAttribute ... value) {
            this.defaultRequestAttributes().add(value);
            return this;
        }

        protected NamedAttributeMap createDefaultRequestAttributes(BeanStore beanStore, RestContext.Builder parent, Supplier<?> resource) {
            Value<NamedAttributeMap> v = Value.of(parent.defaultRequestAttributes().copy());
            BeanStore.of(beanStore, resource).addBean(NamedAttributeMap.class, v.get()).createMethodFinder(NamedAttributeMap.class, resource).find(x -> this.matches((MethodInfo)x, "defaultRequestAttributes")).run(x -> v.set((NamedAttributeMap)x));
            return v.get();
        }

        public PartList defaultRequestQueryData() {
            if (this.defaultRequestQueryData == null) {
                this.defaultRequestQueryData = this.createDefaultRequestQueryData(this.beanStore(), this.parent, this.resource());
            }
            return this.defaultRequestQueryData;
        }

        public Builder defaultRequestQueryData(NameValuePair ... value) {
            this.defaultRequestQueryData().append(value);
            return this;
        }

        protected PartList createDefaultRequestQueryData(BeanStore beanStore, RestContext.Builder parent, Supplier<?> resource) {
            Value<PartList> v = Value.of(PartList.create());
            BeanStore.of(beanStore, resource).addBean(PartList.class, v.get()).createMethodFinder(PartList.class, resource).find(x -> this.matches((MethodInfo)x, "defaultRequestQueryData")).run(x -> v.set((PartList)x));
            return v.get();
        }

        public PartList defaultRequestFormData() {
            if (this.defaultRequestFormData == null) {
                this.defaultRequestFormData = this.createDefaultRequestFormData(this.beanStore(), this.parent, this.resource());
            }
            return this.defaultRequestFormData;
        }

        public Builder defaultRequestFormData(NameValuePair ... value) {
            this.defaultRequestFormData().append(value);
            return this;
        }

        protected PartList createDefaultRequestFormData(BeanStore beanStore, RestContext.Builder parent, Supplier<?> resource) {
            Value<PartList> v = Value.of(PartList.create());
            BeanStore.of(beanStore, resource).addBean(PartList.class, v.get()).createMethodFinder(PartList.class, resource).find(x -> this.matches((MethodInfo)x, "defaultRequestFormData")).run(x -> v.set((PartList)x));
            return v.get();
        }

        protected void processParameterAnnotations() {
            for (Annotation[] aa : this.restMethod.getParameterAnnotations()) {
                String def = null;
                for (Annotation a : aa) {
                    if (!(a instanceof Schema)) continue;
                    Schema s = (Schema)a;
                    def = this.joinnlFirstNonEmptyArray(s._default(), s.df());
                }
                for (Annotation a : aa) {
                    Annotation h;
                    if (a instanceof Header) {
                        h = (Header)a;
                        if (def != null) {
                            try {
                                this.defaultRequestHeaders().set((org.apache.http.Header)HttpHeaders.basicHeader((String)StringUtils.firstNonEmpty(h.name(), h.value()), (Object)RestUtils.parseAnything(def)));
                            }
                            catch (ParseException e) {
                                throw new ConfigException(e, "Malformed @Header annotation", new Object[0]);
                            }
                        }
                    }
                    if (a instanceof Query) {
                        h = (Query)a;
                        if (def != null) {
                            try {
                                this.defaultRequestQueryData().setDefault(new NameValuePair[]{HttpParts.basicPart((String)StringUtils.firstNonEmpty(h.name(), h.value()), (Object)RestUtils.parseAnything(def))});
                            }
                            catch (ParseException e) {
                                throw new ConfigException(e, "Malformed @Query annotation", new Object[0]);
                            }
                        }
                    }
                    if (!(a instanceof FormData)) continue;
                    h = (FormData)a;
                    if (def == null) continue;
                    try {
                        this.defaultRequestFormData().setDefault(new NameValuePair[]{HttpParts.basicPart((String)StringUtils.firstNonEmpty(h.name(), h.value()), (Object)RestUtils.parseAnything(def))});
                    }
                    catch (ParseException e) {
                        throw new ConfigException(e, "Malformed @FormData annotation", new Object[0]);
                    }
                }
            }
        }

        @FluentSetter
        public Builder clientVersion(String value) {
            this.clientVersion = value;
            return this;
        }

        @FluentSetter
        public Builder debug(Enablement value) {
            this.debug = value;
            return this;
        }

        @FluentSetter
        public Builder defaultCharset(Charset value) {
            this.defaultCharset = value;
            return this;
        }

        @FluentSetter
        public Builder httpMethod(String value) {
            this.httpMethod = value;
            return this;
        }

        @FluentSetter
        public Builder maxInput(String value) {
            this.maxInput = StringUtils.parseLongWithSuffix(value);
            return this;
        }

        @FluentSetter
        public Builder path(String ... values) {
            this.path = CollectionUtils.prependAll(this.path, values);
            return this;
        }

        @FluentSetter
        public Builder produces(MediaType ... values) {
            this.produces = CollectionUtils.addAll(this.produces, values);
            return this;
        }

        @FluentSetter
        public Builder rolesDeclared(String ... values) {
            this.rolesDeclared = CollectionUtils.addAll(this.rolesDeclared, values);
            return this;
        }

        @FluentSetter
        public Builder roleGuard(String value) {
            if (this.roleGuard == null) {
                this.roleGuard = CollectionUtils.set(value);
            } else {
                this.roleGuard.add(value);
            }
            return this;
        }

        @FluentSetter
        public Builder consumes(MediaType ... values) {
            this.consumes = CollectionUtils.addAll(this.consumes, values);
            return this;
        }

        @Override
        public Builder annotations(Annotation ... values) {
            super.annotations(values);
            return this;
        }

        @Override
        public Builder apply(AnnotationWorkList work) {
            super.apply(work);
            return this;
        }

        @Override
        public Builder applyAnnotations(Class<?> ... fromClasses) {
            super.applyAnnotations(fromClasses);
            return this;
        }

        @Override
        public Builder applyAnnotations(Method ... fromMethods) {
            super.applyAnnotations(fromMethods);
            return this;
        }

        @Override
        public Builder cache(Cache<HashKey, ? extends Context> value) {
            super.cache(value);
            return this;
        }

        @Override
        public Builder debug() {
            super.debug();
            return this;
        }

        @Override
        public Builder debug(boolean value) {
            super.debug(value);
            return this;
        }

        @Override
        public Builder impl(Context value) {
            super.impl(value);
            return this;
        }

        @Override
        public Builder type(Class<? extends Context> value) {
            super.type(value);
            return this;
        }

        private boolean matches(MethodInfo annotated) {
            RestInject a = annotated.getAnnotation(RestInject.class);
            if (a != null) {
                for (String n : a.methodScope()) {
                    if ("*".equals(n)) {
                        return true;
                    }
                    if (!this.restMethod.getName().equals(n)) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean matches(MethodInfo annotated, String beanName) {
            RestInject a = annotated.getAnnotation(RestInject.class);
            if (a != null) {
                if (!a.name().equals(beanName)) {
                    return false;
                }
                for (String n : a.methodScope()) {
                    if ("*".equals(n)) {
                        return true;
                    }
                    if (!this.restMethod.getName().equals(n)) continue;
                    return true;
                }
            }
            return false;
        }

        private String joinnlFirstNonEmptyArray(String[] ... s) {
            for (Object[] objectArray : s) {
                if (objectArray.length <= 0) continue;
                return StringUtils.joinnl(objectArray);
            }
            return null;
        }
    }
}

