/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.time.Instant;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.Header;
import org.apache.juneau.AnnotationWorkList;
import org.apache.juneau.BeanBuilder;
import org.apache.juneau.BeanContext;
import org.apache.juneau.Context;
import org.apache.juneau.Enablement;
import org.apache.juneau.ExecutableException;
import org.apache.juneau.InvalidDataConversionException;
import org.apache.juneau.MediaType;
import org.apache.juneau.UriRelativity;
import org.apache.juneau.UriResolution;
import org.apache.juneau.Value;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.common.internal.IOUtils;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.config.Config;
import org.apache.juneau.config.vars.ConfigVar;
import org.apache.juneau.cp.BeanCreator;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.cp.ContextBeanCreator;
import org.apache.juneau.cp.DefaultClassList;
import org.apache.juneau.cp.DefaultSettingsMap;
import org.apache.juneau.cp.FileFinder;
import org.apache.juneau.cp.Messages;
import org.apache.juneau.cp.MethodList;
import org.apache.juneau.dto.swagger.Swagger;
import org.apache.juneau.encoders.Encoder;
import org.apache.juneau.encoders.EncoderSet;
import org.apache.juneau.encoders.IdentityEncoder;
import org.apache.juneau.html.HtmlWidgetVar;
import org.apache.juneau.http.HttpHeaders;
import org.apache.juneau.http.annotation.Response;
import org.apache.juneau.http.annotation.StatusCode;
import org.apache.juneau.http.header.HeaderList;
import org.apache.juneau.http.header.Thrown;
import org.apache.juneau.http.response.BadRequest;
import org.apache.juneau.http.response.BasicHttpException;
import org.apache.juneau.http.response.InternalServerError;
import org.apache.juneau.http.response.MethodNotAllowed;
import org.apache.juneau.http.response.NotFound;
import org.apache.juneau.http.response.NotImplemented;
import org.apache.juneau.http.response.PreconditionFailed;
import org.apache.juneau.http.response.Unauthorized;
import org.apache.juneau.httppart.HttpPartParser;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.internal.Cache;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.FluentSetter;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.jsonschema.JsonSchemaGenerator;
import org.apache.juneau.oapi.OpenApiParser;
import org.apache.juneau.oapi.OpenApiSerializer;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.parser.ParserListener;
import org.apache.juneau.parser.ParserSet;
import org.apache.juneau.reflect.AnnotationInfo;
import org.apache.juneau.reflect.AnnotationList;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.MethodInfo;
import org.apache.juneau.reflect.ParamInfo;
import org.apache.juneau.rest.OverrideableHttpServletRequest;
import org.apache.juneau.rest.ResourceSupplier;
import org.apache.juneau.rest.RestChild;
import org.apache.juneau.rest.RestChildMatch;
import org.apache.juneau.rest.RestChildren;
import org.apache.juneau.rest.RestOpContext;
import org.apache.juneau.rest.RestOpInvoker;
import org.apache.juneau.rest.RestOpSession;
import org.apache.juneau.rest.RestOperations;
import org.apache.juneau.rest.RestSession;
import org.apache.juneau.rest.annotation.Rest;
import org.apache.juneau.rest.annotation.RestDestroy;
import org.apache.juneau.rest.annotation.RestEndCall;
import org.apache.juneau.rest.annotation.RestInit;
import org.apache.juneau.rest.annotation.RestInject;
import org.apache.juneau.rest.annotation.RestInjectAnnotation;
import org.apache.juneau.rest.annotation.RestOpAnnotation;
import org.apache.juneau.rest.annotation.RestPostCall;
import org.apache.juneau.rest.annotation.RestPostInit;
import org.apache.juneau.rest.annotation.RestPreCall;
import org.apache.juneau.rest.annotation.RestStartCall;
import org.apache.juneau.rest.arg.AttributeArg;
import org.apache.juneau.rest.arg.ContentArg;
import org.apache.juneau.rest.arg.DefaultArg;
import org.apache.juneau.rest.arg.FormDataArg;
import org.apache.juneau.rest.arg.HasFormDataArg;
import org.apache.juneau.rest.arg.HasQueryArg;
import org.apache.juneau.rest.arg.HeaderArg;
import org.apache.juneau.rest.arg.HttpServletRequestArgs;
import org.apache.juneau.rest.arg.HttpServletResponseArgs;
import org.apache.juneau.rest.arg.HttpSessionArgs;
import org.apache.juneau.rest.arg.InputStreamParserArg;
import org.apache.juneau.rest.arg.MethodArg;
import org.apache.juneau.rest.arg.ParserArg;
import org.apache.juneau.rest.arg.PathArg;
import org.apache.juneau.rest.arg.QueryArg;
import org.apache.juneau.rest.arg.ReaderParserArg;
import org.apache.juneau.rest.arg.RequestBeanArg;
import org.apache.juneau.rest.arg.ResponseBeanArg;
import org.apache.juneau.rest.arg.ResponseCodeArg;
import org.apache.juneau.rest.arg.ResponseHeaderArg;
import org.apache.juneau.rest.arg.RestContextArgs;
import org.apache.juneau.rest.arg.RestOpArg;
import org.apache.juneau.rest.arg.RestOpArgList;
import org.apache.juneau.rest.arg.RestOpContextArgs;
import org.apache.juneau.rest.arg.RestOpSessionArgs;
import org.apache.juneau.rest.arg.RestRequestArgs;
import org.apache.juneau.rest.arg.RestResponseArgs;
import org.apache.juneau.rest.arg.RestSessionArgs;
import org.apache.juneau.rest.debug.BasicDebugEnablement;
import org.apache.juneau.rest.debug.DebugEnablement;
import org.apache.juneau.rest.httppart.NamedAttribute;
import org.apache.juneau.rest.httppart.NamedAttributeMap;
import org.apache.juneau.rest.logger.BasicCallLogger;
import org.apache.juneau.rest.logger.CallLogger;
import org.apache.juneau.rest.processor.HttpEntityProcessor;
import org.apache.juneau.rest.processor.HttpResourceProcessor;
import org.apache.juneau.rest.processor.HttpResponseProcessor;
import org.apache.juneau.rest.processor.InputStreamProcessor;
import org.apache.juneau.rest.processor.PlainTextPojoProcessor;
import org.apache.juneau.rest.processor.ReaderProcessor;
import org.apache.juneau.rest.processor.ResponseBeanProcessor;
import org.apache.juneau.rest.processor.ResponseProcessor;
import org.apache.juneau.rest.processor.ResponseProcessorList;
import org.apache.juneau.rest.processor.SerializedPojoProcessor;
import org.apache.juneau.rest.processor.ThrowableProcessor;
import org.apache.juneau.rest.rrpc.RrpcRestOpContext;
import org.apache.juneau.rest.staticfile.BasicStaticFiles;
import org.apache.juneau.rest.staticfile.StaticFiles;
import org.apache.juneau.rest.stats.MethodExecStats;
import org.apache.juneau.rest.stats.MethodExecStore;
import org.apache.juneau.rest.stats.MethodInvoker;
import org.apache.juneau.rest.stats.RestContextStats;
import org.apache.juneau.rest.stats.ThrownStore;
import org.apache.juneau.rest.swagger.BasicSwaggerProvider;
import org.apache.juneau.rest.swagger.SwaggerProvider;
import org.apache.juneau.rest.util.RestUtils;
import org.apache.juneau.rest.util.UrlPath;
import org.apache.juneau.rest.util.UrlPathMatch;
import org.apache.juneau.rest.util.UrlPathMatcher;
import org.apache.juneau.rest.vars.FileVar;
import org.apache.juneau.rest.vars.LocalizationVar;
import org.apache.juneau.rest.vars.RequestAttributeVar;
import org.apache.juneau.rest.vars.RequestFormDataVar;
import org.apache.juneau.rest.vars.RequestHeaderVar;
import org.apache.juneau.rest.vars.RequestPathVar;
import org.apache.juneau.rest.vars.RequestQueryVar;
import org.apache.juneau.rest.vars.RequestSwaggerVar;
import org.apache.juneau.rest.vars.RequestVar;
import org.apache.juneau.rest.vars.SerializedRequestAttrVar;
import org.apache.juneau.rest.vars.ServletInitParamVar;
import org.apache.juneau.rest.vars.SwaggerVar;
import org.apache.juneau.rest.vars.UrlEncodeVar;
import org.apache.juneau.rest.vars.UrlVar;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.serializer.SerializerListener;
import org.apache.juneau.serializer.SerializerSet;
import org.apache.juneau.svl.Var;
import org.apache.juneau.svl.VarList;
import org.apache.juneau.svl.VarResolver;
import org.apache.juneau.svl.VarResolverSession;
import org.apache.juneau.utils.HashKey;

public class RestContext
extends Context {
    private static final Map<Class<?>, RestContext> REGISTRY = new ConcurrentHashMap();
    private final Supplier<?> resource;
    private final Class<?> resourceClass;
    final Builder builder;
    private final boolean allowContentParam;
    private final boolean renderResponseStackTraces;
    private final String clientVersionHeader;
    private final String uriAuthority;
    private final String uriContext;
    private final String path;
    private final String fullPath;
    private final UrlPathMatcher pathMatcher;
    private final Set<String> allowedMethodParams;
    private final Set<String> allowedHeaderParams;
    private final Set<String> allowedMethodHeaders;
    private final Class<? extends RestOpArg>[] restOpArgs;
    private final BeanContext beanContext;
    private final EncoderSet encoders;
    private final SerializerSet serializers;
    private final ParserSet parsers;
    private final HttpPartSerializer partSerializer;
    private final HttpPartParser partParser;
    private final JsonSchemaGenerator jsonSchemaGenerator;
    private final List<MediaType> consumes;
    private final List<MediaType> produces;
    private final HeaderList defaultRequestHeaders;
    private final HeaderList defaultResponseHeaders;
    private final NamedAttributeMap defaultRequestAttributes;
    private final ResponseProcessor[] responseProcessors;
    private final Messages messages;
    private final Config config;
    private final VarResolver varResolver;
    private final RestOperations restOperations;
    private final RestChildren restChildren;
    private final Logger logger;
    private final SwaggerProvider swaggerProvider;
    private final BasicHttpException initException;
    private final RestContext parentContext;
    private final BeanStore beanStore;
    private final UriResolution uriResolution;
    private final UriRelativity uriRelativity;
    private final MethodExecStore methodExecStore;
    private final ThrownStore thrownStore;
    private final ConcurrentHashMap<Locale, Swagger> swaggerCache = new ConcurrentHashMap();
    private final Instant startTime;
    final Charset defaultCharset;
    final long maxInput;
    final DefaultClassList defaultClasses;
    final DefaultSettingsMap defaultSettings;
    final BeanStore rootBeanStore;
    private final MethodInvoker[] postInitMethods;
    private final MethodInvoker[] postInitChildFirstMethods;
    private final MethodInvoker[] startCallMethods;
    private final MethodInvoker[] endCallMethods;
    private final MethodInvoker[] destroyMethods;
    private final MethodList preCallMethods;
    private final MethodList postCallMethods;
    private final StaticFiles staticFiles;
    private final CallLogger callLogger;
    private final DebugEnablement debugEnablement;
    private final ThreadLocal<RestSession> localSession = new ThreadLocal();
    private final AtomicBoolean initialized = new AtomicBoolean(false);

    public static final Map<Class<?>, RestContext> getGlobalRegistry() {
        return CollectionUtils.unmodifiable(REGISTRY);
    }

    public static Builder create(Class<?> resourceClass, RestContext parentContext, ServletConfig servletConfig) throws ServletException {
        return new Builder(resourceClass, parentContext, servletConfig);
    }

    public RestContext(Builder builder) throws Exception {
        super(builder);
        this.startTime = Instant.now();
        REGISTRY.put(builder.resourceClass, this);
        BasicHttpException _initException = null;
        try {
            this.builder = builder;
            this.resourceClass = builder.resourceClass;
            this.resource = builder.resource;
            this.parentContext = builder.parentContext;
            this.rootBeanStore = builder.rootBeanStore();
            this.defaultClasses = builder.defaultClasses();
            this.defaultSettings = builder.defaultSettings();
            BeanStore bs = this.beanStore = builder.beanStore();
            this.beanStore.addBean(BeanStore.class, this.beanStore).addBean(RestContext.class, this).addBean(Object.class, this.resource.get()).addBean(DefaultSettingsMap.class, this.defaultSettings).addBean(Builder.class, builder).addBean(AnnotationWorkList.class, builder.getApplied());
            this.path = builder.path != null ? builder.path : "";
            this.fullPath = (String)(this.parentContext == null ? "" : this.parentContext.fullPath + "/") + this.path;
            Object p = this.path;
            if (!((String)p).endsWith("/*")) {
                p = (String)p + "/*";
            }
            this.pathMatcher = UrlPathMatcher.of((String)p);
            this.allowContentParam = !builder.disableContentParam;
            this.allowedHeaderParams = this.newCaseInsensitiveSet(Optional.ofNullable(builder.allowedHeaderParams).map(x -> "NONE".equals(x) ? "" : x).orElse(""));
            this.allowedMethodParams = this.newCaseInsensitiveSet(Optional.ofNullable(builder.allowedMethodParams).map(x -> "NONE".equals(x) ? "" : x).orElse(""));
            this.allowedMethodHeaders = this.newCaseInsensitiveSet(Optional.ofNullable(builder.allowedMethodHeaders).map(x -> "NONE".equals(x) ? "" : x).orElse(""));
            this.clientVersionHeader = builder.clientVersionHeader;
            this.defaultCharset = builder.defaultCharset;
            this.maxInput = builder.maxInput;
            this.renderResponseStackTraces = builder.renderResponseStackTraces;
            this.uriContext = builder.uriContext;
            this.uriAuthority = builder.uriAuthority;
            this.uriResolution = builder.uriResolution;
            this.uriRelativity = builder.uriRelativity;
            this.beanContext = bs.add(BeanContext.class, builder.beanContext().build());
            this.encoders = bs.add(EncoderSet.class, (EncoderSet)builder.encoders().build());
            this.serializers = bs.add(SerializerSet.class, (SerializerSet)builder.serializers().build());
            this.parsers = bs.add(ParserSet.class, (ParserSet)builder.parsers().build());
            this.logger = bs.add(Logger.class, builder.logger());
            this.thrownStore = bs.add(ThrownStore.class, (ThrownStore)builder.thrownStore().build());
            this.methodExecStore = bs.add(MethodExecStore.class, (MethodExecStore)builder.methodExecStore().thrownStoreOnce(this.thrownStore).build());
            this.messages = bs.add(Messages.class, (Messages)builder.messages().build());
            this.varResolver = bs.add(VarResolver.class, (VarResolver)builder.varResolver().bean(Messages.class, this.messages).build());
            this.config = bs.add(Config.class, builder.config().resolving(this.varResolver.createSession()));
            this.responseProcessors = bs.add(ResponseProcessor[].class, ((ResponseProcessorList)builder.responseProcessors().build()).toArray());
            this.callLogger = bs.add(CallLogger.class, builder.callLogger().orElse(null));
            this.partSerializer = bs.add(HttpPartSerializer.class, (HttpPartSerializer)builder.partSerializer().create());
            this.partParser = bs.add(HttpPartParser.class, (HttpPartParser)builder.partParser().create());
            this.jsonSchemaGenerator = bs.add(JsonSchemaGenerator.class, builder.jsonSchemaGenerator().build());
            this.staticFiles = bs.add(StaticFiles.class, builder.staticFiles().orElse(null));
            bs.add(FileFinder.class, this.staticFiles);
            this.defaultRequestHeaders = bs.add(HeaderList.class, builder.defaultRequestHeaders(), "defaultRequestHeaders");
            this.defaultResponseHeaders = bs.add(HeaderList.class, builder.defaultResponseHeaders(), "defaultResponseHeaders");
            this.defaultRequestAttributes = bs.add(NamedAttributeMap.class, builder.defaultRequestAttributes(), "defaultRequestAttributes");
            this.restOpArgs = ((RestOpArgList)builder.restOpArgs().build()).asArray();
            this.debugEnablement = bs.add(DebugEnablement.class, builder.debugEnablement().orElse(null));
            this.startCallMethods = (MethodInvoker[])builder.startCallMethods().stream().map(this::toMethodInvoker).toArray(MethodInvoker[]::new);
            this.endCallMethods = (MethodInvoker[])builder.endCallMethods().stream().map(this::toMethodInvoker).toArray(MethodInvoker[]::new);
            this.postInitMethods = (MethodInvoker[])builder.postInitMethods().stream().map(this::toMethodInvoker).toArray(MethodInvoker[]::new);
            this.postInitChildFirstMethods = (MethodInvoker[])builder.postInitChildFirstMethods().stream().map(this::toMethodInvoker).toArray(MethodInvoker[]::new);
            this.destroyMethods = (MethodInvoker[])builder.destroyMethods().stream().map(this::toMethodInvoker).toArray(MethodInvoker[]::new);
            this.preCallMethods = builder.preCallMethods();
            this.postCallMethods = builder.postCallMethods();
            this.restOperations = (RestOperations)builder.restOperations(this).build();
            this.restChildren = (RestChildren)builder.restChildren(this).build();
            this.swaggerProvider = bs.add(SwaggerProvider.class, builder.swaggerProvider().orElse(null));
            List<RestOpContext> opContexts = this.restOperations.getOpContexts();
            this.produces = builder.produces().orElseGet(() -> {
                Set s = opContexts.isEmpty() ? Collections.emptySet() : CollectionUtils.setFrom(((RestOpContext)opContexts.get(0)).getSerializers().getSupportedMediaTypes());
                opContexts.forEach(x -> s.retainAll(x.getSerializers().getSupportedMediaTypes()));
                return CollectionUtils.unmodifiable(CollectionUtils.listFrom(s));
            });
            this.consumes = builder.consumes().orElseGet(() -> {
                Set s = opContexts.isEmpty() ? Collections.emptySet() : CollectionUtils.setFrom(((RestOpContext)opContexts.get(0)).getParsers().getSupportedMediaTypes());
                opContexts.forEach(x -> s.retainAll(x.getParsers().getSupportedMediaTypes()));
                return CollectionUtils.unmodifiable(CollectionUtils.listFrom(s));
            });
        }
        catch (BasicHttpException e) {
            _initException = e;
            throw e;
        }
        catch (Exception e) {
            _initException = new InternalServerError((Throwable)e);
            throw e;
        }
        finally {
            this.initException = _initException;
        }
    }

    private MethodInvoker toMethodInvoker(Method m) {
        return new MethodInvoker(m, this.getMethodExecStats(m));
    }

    private Set<String> newCaseInsensitiveSet(String value) {
        TreeSet<String> s = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean contains(Object v) {
                return v == null ? false : super.contains(v);
            }
        };
        StringUtils.split(value, x -> s.add((String)x));
        return CollectionUtils.unmodifiable(s);
    }

    @Override
    public RestSession.Builder createSession() {
        return RestSession.create(this);
    }

    public BeanStore getBeanStore() {
        return this.beanStore;
    }

    public BeanContext getBeanContext() {
        return this.beanContext;
    }

    public EncoderSet getEncoders() {
        return this.encoders;
    }

    public SerializerSet getSerializers() {
        return this.serializers;
    }

    public ParserSet getParsers() {
        return this.parsers;
    }

    protected MethodExecStats getMethodExecStats(Method m) {
        return this.methodExecStore.getStats(m);
    }

    public VarResolver getVarResolver() {
        return this.varResolver;
    }

    public Config getConfig() {
        return this.config;
    }

    public String getPath() {
        return this.path;
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public CallLogger getCallLogger() {
        return this.callLogger;
    }

    public Messages getMessages() {
        return this.messages;
    }

    public SwaggerProvider getSwaggerProvider() {
        return this.swaggerProvider;
    }

    public Object getResource() {
        return this.resource.get();
    }

    public String getServletInitParameter(String name) {
        return this.builder.getInitParameter(name);
    }

    public RestChildren getRestChildren() {
        return this.restChildren;
    }

    public boolean isRenderResponseStackTraces() {
        return this.renderResponseStackTraces;
    }

    public boolean isAllowContentParam() {
        return this.allowContentParam;
    }

    public Set<String> getAllowedHeaderParams() {
        return this.allowedHeaderParams;
    }

    public Set<String> getAllowedMethodHeaders() {
        return this.allowedMethodHeaders;
    }

    public Set<String> getAllowedMethodParams() {
        return this.allowedMethodParams;
    }

    public String getClientVersionHeader() {
        return this.clientVersionHeader;
    }

    public StaticFiles getStaticFiles() {
        return this.staticFiles;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public ThrownStore getThrownStore() {
        return this.thrownStore;
    }

    public HttpPartParser getPartParser() {
        return this.partParser;
    }

    public HttpPartSerializer getPartSerializer() {
        return this.partSerializer;
    }

    public JsonSchemaGenerator getJsonSchemaGenerator() {
        return this.jsonSchemaGenerator;
    }

    public List<MediaType> getProduces() {
        return this.produces;
    }

    public List<MediaType> getConsumes() {
        return this.consumes;
    }

    public HeaderList getDefaultRequestHeaders() {
        return this.defaultRequestHeaders;
    }

    public NamedAttributeMap getDefaultRequestAttributes() {
        return this.defaultRequestAttributes;
    }

    public HeaderList getDefaultResponseHeaders() {
        return this.defaultResponseHeaders;
    }

    public String getUriAuthority() {
        if (this.uriAuthority != null) {
            return this.uriAuthority;
        }
        if (this.parentContext != null) {
            return this.parentContext.getUriAuthority();
        }
        return null;
    }

    public String getUriContext() {
        if (this.uriContext != null) {
            return this.uriContext;
        }
        if (this.parentContext != null) {
            return this.parentContext.getUriContext();
        }
        return null;
    }

    public UriRelativity getUriRelativity() {
        return this.uriRelativity;
    }

    public UriResolution getUriResolution() {
        return this.uriResolution;
    }

    public RestOperations getRestOperations() {
        return this.restOperations;
    }

    public MethodExecStore getMethodExecStore() {
        return this.methodExecStore;
    }

    public RestContextStats getStats() {
        return new RestContextStats(this.startTime, this.getMethodExecStore().getStatsByTotalTime());
    }

    public Class<?> getResourceClass() {
        return this.resourceClass;
    }

    public ServletConfig getBuilder() {
        return this.builder;
    }

    public UrlPathMatcher getPathMatcher() {
        return this.pathMatcher;
    }

    public BeanStore getRootBeanStore() {
        return this.rootBeanStore;
    }

    public Optional<Swagger> getSwagger(Locale locale) {
        Swagger s = this.swaggerCache.get(locale);
        if (s == null) {
            try {
                s = this.swaggerProvider.getSwagger(this, locale);
                if (s != null) {
                    this.swaggerCache.put(locale, s);
                }
            }
            catch (Exception e) {
                throw new InternalServerError((Throwable)e);
            }
        }
        return CollectionUtils.optional(s);
    }

    protected RestOpArg[] findRestOperationArgs(Method m, BeanStore beanStore) {
        MethodInfo mi = MethodInfo.of(m);
        List<ClassInfo> pt = mi.getParamTypes();
        RestOpArg[] ra = new RestOpArg[pt.size()];
        beanStore = BeanStore.of(beanStore, this.getResource());
        for (int i = 0; i < pt.size(); ++i) {
            ParamInfo pi = mi.getParam(i);
            beanStore.addBean(ParamInfo.class, pi);
            for (Class<? extends RestOpArg> c : this.restOpArgs) {
                try {
                    ra[i] = beanStore.createBean(RestOpArg.class).type(c).run();
                    if (ra[i] == null) continue;
                    break;
                }
                catch (ExecutableException e) {
                    throw new InternalServerError(e.unwrap(), "Could not resolve parameter {0} on method {1}.", new Object[]{i, mi.getFullName()});
                }
            }
            if (ra[i] != null) continue;
            throw new InternalServerError("Could not resolve parameter {0} on method {1}.", new Object[]{i, mi.getFullName()});
        }
        return ra;
    }

    protected MethodList getPreCallMethods() {
        return this.preCallMethods;
    }

    protected MethodList getPostCallMethods() {
        return this.postCallMethods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Object resource, HttpServletRequest r1, HttpServletResponse r2) throws ServletException, IOException {
        if (this.localSession.get() != null) {
            System.err.println("WARNING:  Thread-local call object was not cleaned up from previous request.  " + this + ", thread=[" + Thread.currentThread().getId() + "]");
        }
        RestSession.Builder sb = this.createSession().resource(resource).req(r1).res(r2).logger(this.getCallLogger());
        try {
            Optional<RestChildMatch> childMatch;
            if (this.initException != null) {
                throw this.initException;
            }
            if (this.pathMatcher.hasVars() && this.parentContext == null) {
                String sp = sb.req().getServletPath();
                String pi = sb.getPathInfoUndecoded();
                UrlPath upi2 = UrlPath.of((String)(pi == null ? sp : sp + pi));
                UrlPathMatch uppm = this.pathMatcher.match(upi2);
                if (uppm != null && !uppm.hasEmptyVars()) {
                    sb.pathVars(uppm.getVars());
                    sb.req((HttpServletRequest)new OverrideableHttpServletRequest(sb.req()).pathInfo(StringUtils.nullIfEmpty(StringUtils.urlDecode(uppm.getSuffix()))).servletPath(uppm.getPrefix()));
                } else {
                    RestSession call = sb.build();
                    call.debug(this.isDebug(call)).status(404).finish();
                    return;
                }
            }
            if ((childMatch = this.restChildren.findMatch(sb)).isPresent()) {
                UrlPathMatch uppm = childMatch.get().getPathMatch();
                RestContext rc = childMatch.get().getChildContext();
                if (!uppm.hasEmptyVars()) {
                    sb.pathVars(uppm.getVars());
                    OverrideableHttpServletRequest childRequest = new OverrideableHttpServletRequest(sb.req()).pathInfo(StringUtils.nullIfEmpty(StringUtils.urlDecode(uppm.getSuffix()))).servletPath(sb.req().getServletPath() + uppm.getPrefix());
                    rc.execute(rc.getResource(), (HttpServletRequest)childRequest, sb.res());
                } else {
                    RestSession call = sb.build();
                    call.debug(this.isDebug(call)).status(404).finish();
                }
                return;
            }
        }
        catch (Throwable e) {
            this.handleError(sb.build(), this.convertThrowable(e));
        }
        RestSession s = sb.build();
        try {
            this.localSession.set(s);
            s.debug(this.isDebug(s));
            this.startCall(s);
            s.run();
        }
        catch (Throwable e) {
            this.handleError(s, this.convertThrowable(e));
        }
        finally {
            try {
                s.finish();
                this.endCall(s);
            }
            finally {
                this.localSession.remove();
            }
        }
    }

    private boolean isDebug(RestSession call) {
        return this.debugEnablement.isDebug(this, call.getRequest());
    }

    public DebugEnablement getDebugEnablement() {
        return this.debugEnablement;
    }

    protected void processResponse(RestOpSession opSession) throws IOException, BasicHttpException, NotImplemented {
        int loops = 5;
        for (int i = 0; i < this.responseProcessors.length; ++i) {
            int j = this.responseProcessors[i].process(opSession);
            if (j == 1) {
                return;
            }
            if (j != 2) continue;
            if (loops-- < 0) {
                throw new InternalServerError("Too many processing loops.", new Object[0]);
            }
            i = -1;
        }
        Object output = opSession.getResponse().getContent().orElse(null);
        throw new NotImplemented("No response processors found to process output of type ''{0}''", new Object[]{ClassUtils.className(output)});
    }

    protected Throwable convertThrowable(Throwable t) {
        if (t instanceof InvocationTargetException) {
            t = ((InvocationTargetException)t).getTargetException();
        }
        if (t instanceof ExecutableException) {
            t = ((ExecutableException)t).getTargetException();
        }
        if (t instanceof BasicHttpException) {
            return t;
        }
        ClassInfo ci = ClassInfo.of(t);
        if (ci.hasAnnotation(Response.class)) {
            return t;
        }
        if (ci.isChildOf(ParseException.class) || ci.is(InvalidDataConversionException.class)) {
            return new BadRequest(t);
        }
        String n = ClassUtils.className(t);
        if (n.contains("AccessDenied") || n.contains("Unauthorized")) {
            return new Unauthorized(t);
        }
        if (n.contains("Empty") || n.contains("NotFound")) {
            return new NotFound(t);
        }
        return t;
    }

    protected void handleNotFound(RestSession session) throws Exception {
        String onPath;
        String pathInfo = session.getPathInfo();
        String methodUC = session.getMethod();
        int rc = session.getStatus();
        String string = onPath = pathInfo == null ? " on no pathInfo" : String.format(" on path '%s'", pathInfo);
        if (rc == 404) {
            throw new NotFound("Method ''{0}'' not found on resource with matching pattern{1}.", new Object[]{methodUC, onPath});
        }
        if (rc == 412) {
            throw new PreconditionFailed("Method ''{0}'' not found on resource{1} with matching matcher.", new Object[]{methodUC, onPath});
        }
        if (rc == 405) {
            throw new MethodNotAllowed("Method ''{0}'' not found on resource{1}.", new Object[]{methodUC, onPath});
        }
        throw new ServletException("Invalid method response: " + rc, session.getException());
    }

    protected synchronized void handleError(RestSession session, Throwable e) throws IOException {
        session.exception(e);
        if (session.isDebug()) {
            e.printStackTrace();
        }
        int code = 500;
        ClassInfo ci = ClassInfo.of(e);
        StatusCode r = ci.getAnnotation(StatusCode.class);
        if (r != null && r.value().length > 0) {
            code = r.value()[0];
        }
        BasicHttpException e2 = e instanceof BasicHttpException ? (BasicHttpException)e : new BasicHttpException(code, e);
        HttpServletRequest req = session.getRequest();
        HttpServletResponse res = session.getResponse();
        Throwable t = e2.getRootCause();
        if (t != null) {
            Thrown t2 = HttpHeaders.thrown((Throwable[])new Throwable[]{t});
            res.setHeader(t2.getName(), t2.getValue());
        }
        try {
            res.setContentType("text/plain");
            res.setHeader("Content-Encoding", "identity");
            int statusCode = e2.getStatusLine().getStatusCode();
            res.setStatus(statusCode);
            PrintWriter w = null;
            try {
                w = res.getWriter();
            }
            catch (IllegalStateException x) {
                w = new PrintWriter(new OutputStreamWriter((OutputStream)res.getOutputStream(), IOUtils.UTF8));
            }
            try (PrintWriter w2 = w;){
                String httpMessage = RestUtils.getHttpResponseText(statusCode);
                if (httpMessage != null) {
                    w2.append("HTTP ").append(String.valueOf(statusCode)).append(": ").append(httpMessage).append("\n\n");
                }
                if (this.isRenderResponseStackTraces()) {
                    e.printStackTrace(w2);
                } else {
                    w2.append(e2.getFullStackMessage(true));
                }
            }
        }
        catch (Exception e1) {
            req.setAttribute("Exception", (Object)e1);
        }
    }

    protected void startCall(RestSession session) throws BasicHttpException {
        for (MethodInvoker x : this.startCallMethods) {
            try {
                x.invoke(session.getBeanStore(), session.getContext().getResource());
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new InternalServerError((Throwable)e, "Error occurred invoking start-call method ''{0}''.", new Object[]{x.getFullName()});
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (t instanceof BasicHttpException) {
                    throw (BasicHttpException)t;
                }
                throw new InternalServerError(t);
            }
        }
    }

    protected void preCall(RestOpSession session) throws Throwable {
        for (RestOpInvoker m : session.getContext().getPreCallMethods()) {
            m.invoke(session);
        }
    }

    protected void postCall(RestOpSession session) throws Throwable {
        for (RestOpInvoker m : session.getContext().getPostCallMethods()) {
            m.invoke(session);
        }
    }

    protected void endCall(RestSession session) {
        for (MethodInvoker x : this.endCallMethods) {
            try {
                x.invoke(session.getBeanStore(), session.getResource());
            }
            catch (Exception e) {
                this.getLogger().log(Level.WARNING, this.unwrap(e), () -> StringUtils.format("Error occurred invoking finish-call method ''{0}''.", x.getFullName()));
            }
        }
    }

    public synchronized RestContext postInit() throws ServletException {
        if (this.initialized.get()) {
            return this;
        }
        Object resource = this.getResource();
        MethodInfo mi = ClassInfo.of(this.getResource()).getPublicMethod(x -> x.hasName("setContext") && x.hasParamTypes(RestContext.class));
        if (mi != null) {
            try {
                mi.accessible().invoke(resource, this);
            }
            catch (ExecutableException e) {
                throw new ServletException(e.unwrap());
            }
        }
        for (MethodInvoker x2 : this.postInitMethods) {
            try {
                x2.invoke(this.beanStore, this.getResource());
            }
            catch (Exception e) {
                throw new ServletException(this.unwrap(e));
            }
        }
        this.restChildren.postInit();
        return this;
    }

    public RestContext postInitChildFirst() throws ServletException {
        if (this.initialized.get()) {
            return this;
        }
        this.restChildren.postInitChildFirst();
        for (MethodInvoker x : this.postInitChildFirstMethods) {
            try {
                x.invoke(this.beanStore, this.getResource());
            }
            catch (Exception e) {
                throw new ServletException(this.unwrap(e));
            }
        }
        this.initialized.set(true);
        return this;
    }

    public void destroy() {
        for (MethodInvoker x : this.destroyMethods) {
            try {
                x.invoke(this.beanStore, this.getResource());
            }
            catch (Exception e) {
                this.getLogger().log(Level.WARNING, this.unwrap(e), () -> StringUtils.format("Error occurred invoking servlet-destroy method ''{0}''.", x.getFullName()));
            }
        }
        this.restChildren.destroy();
    }

    public RestSession getLocalSession() {
        RestSession rc = this.localSession.get();
        if (rc == null) {
            throw new InternalServerError("No active request on current thread.", new Object[0]);
        }
        return rc;
    }

    public AnnotationWorkList getAnnotations() {
        return this.builder.getApplied();
    }

    private Throwable unwrap(Throwable t) {
        if (t instanceof InvocationTargetException) {
            return ((InvocationTargetException)t).getTargetException();
        }
        return t;
    }

    static ServletException servletException(String msg, Object ... args) {
        return new ServletException(StringUtils.format(msg, args));
    }

    static ServletException servletException(Throwable t, String msg, Object ... args) {
        return new ServletException(StringUtils.format(msg, args), t);
    }

    @Override
    protected JsonMap properties() {
        return JsonMap.filteredMap().append("allowContentParam", this.allowContentParam).append("allowedMethodHeader", this.allowedMethodHeaders).append("allowedMethodParams", this.allowedMethodParams).append("allowedHeaderParams", this.allowedHeaderParams).append("beanStore", this.beanStore).append("clientVersionHeader", this.clientVersionHeader).append("consumes", this.consumes).append("defaultRequestHeaders", this.defaultRequestHeaders).append("defaultResponseHeaders", this.defaultResponseHeaders).append("restOpArgs", this.restOpArgs).append("partParser", this.partParser).append("partSerializer", this.partSerializer).append("produces", this.produces).append("renderResponseStackTraces", this.renderResponseStackTraces).append("responseProcessors", this.responseProcessors).append("staticFiles", this.staticFiles).append("swaggerProvider", this.swaggerProvider).append("uriAuthority", this.uriAuthority).append("uriContext", this.uriContext).append("uriRelativity", (Object)this.uriRelativity).append("uriResolution", (Object)this.uriResolution);
    }

    @FluentSetters(ignore={"set"})
    public static final class Builder
    extends Context.Builder
    implements ServletConfig {
        private static final Set<Class<?>> DELAYED_INJECTION = CollectionUtils.set(BeanContext.Builder.class, BeanStore.Builder.class, BeanStore.class, CallLogger.Builder.class, CallLogger.class, Config.class, DebugEnablement.Builder.class, DebugEnablement.class, EncoderSet.Builder.class, EncoderSet.class, FileFinder.Builder.class, FileFinder.class, HttpPartParser.class, HttpPartParser.Creator.class, HttpPartSerializer.class, HttpPartSerializer.Creator.class, JsonSchemaGenerator.Builder.class, JsonSchemaGenerator.class, Logger.class, Messages.Builder.class, Messages.class, MethodExecStore.Builder.class, MethodExecStore.class, ParserSet.Builder.class, ParserSet.class, ResponseProcessorList.Builder.class, ResponseProcessorList.class, RestChildren.Builder.class, RestChildren.class, RestOpArgList.Builder.class, RestOpArgList.class, RestOperations.Builder.class, RestOperations.class, SerializerSet.Builder.class, SerializerSet.class, StaticFiles.Builder.class, StaticFiles.class, SwaggerProvider.Builder.class, SwaggerProvider.class, ThrownStore.Builder.class, ThrownStore.class, VarList.class, VarResolver.Builder.class, VarResolver.class);
        private static final Set<String> DELAYED_INJECTION_NAMES = CollectionUtils.set("defaultRequestAttributes", "defaultRequestHeaders", "defaultResponseHeaders", "destroyMethods", "endCallMethods", "postCallMethods", "postInitChildFirstMethods", "postInitMethods", "preCallMethods", "startCallMethods");
        private boolean initialized;
        ResourceSupplier resource;
        ServletContext servletContext;
        final ServletConfig inner;
        final Class<?> resourceClass;
        final RestContext parentContext;
        private DefaultClassList defaultClasses;
        private DefaultSettingsMap defaultSettings;
        private BeanStore rootBeanStore;
        private BeanStore beanStore;
        private Config config;
        private VarResolver.Builder varResolver;
        private Logger logger;
        private ThrownStore.Builder thrownStore;
        private MethodExecStore.Builder methodExecStore;
        private Messages.Builder messages;
        private ResponseProcessorList.Builder responseProcessors;
        private BeanCreator<CallLogger> callLogger;
        private HttpPartSerializer.Creator partSerializer;
        private HttpPartParser.Creator partParser;
        private JsonSchemaGenerator.Builder jsonSchemaGenerator;
        private BeanCreator<StaticFiles> staticFiles;
        private HeaderList defaultRequestHeaders;
        private HeaderList defaultResponseHeaders;
        private NamedAttributeMap defaultRequestAttributes;
        private RestOpArgList.Builder restOpArgs;
        private BeanCreator<DebugEnablement> debugEnablement;
        private MethodList startCallMethods;
        private MethodList endCallMethods;
        private MethodList postInitMethods;
        private MethodList postInitChildFirstMethods;
        private MethodList destroyMethods;
        private MethodList preCallMethods;
        private MethodList postCallMethods;
        private RestOperations.Builder restOperations;
        private RestChildren.Builder restChildren;
        private BeanCreator<SwaggerProvider> swaggerProvider;
        private BeanContext.Builder beanContext;
        private EncoderSet.Builder encoders;
        private SerializerSet.Builder serializers;
        private ParserSet.Builder parsers;
        String allowedHeaderParams = this.env("RestContext.allowedHeaderParams", "Accept,Content-Type");
        String allowedMethodHeaders = this.env("RestContext.allowedMethodHeaders", "");
        String allowedMethodParams = this.env("RestContext.allowedMethodParams", "HEAD,OPTIONS");
        String clientVersionHeader = this.env("RestContext.clientVersionHeader", "Client-Version");
        String debugOn = this.env("RestContext.debugOn", null);
        String path = null;
        String uriAuthority = this.env("RestContext.uriAuthority", null);
        String uriContext = this.env("RestContext.uriContext", null);
        UriRelativity uriRelativity = this.env("RestContext.uriRelativity", UriRelativity.RESOURCE);
        UriResolution uriResolution = this.env("RestContext.uriResolution", UriResolution.ROOT_RELATIVE);
        Charset defaultCharset = this.env("RestContext.defaultCharset", IOUtils.UTF8);
        long maxInput = StringUtils.parseLongWithSuffix(this.env("RestContext.maxInput", "100M"));
        List<MediaType> consumes;
        List<MediaType> produces;
        boolean disableContentParam = this.env("RestContext.disableContentParam", false);
        boolean renderResponseStackTraces = this.env("RestContext.renderResponseStackTraces", false);
        Class<? extends RestChildren> childrenClass = RestChildren.class;
        Class<? extends RestOpContext> opContextClass = RestOpContext.class;
        Class<? extends RestOperations> operationsClass = RestOperations.class;
        List<Object> children = CollectionUtils.list(new Object[0]);

        protected Builder(Class<?> resourceClass, RestContext parentContext, ServletConfig servletConfig) {
            this.resourceClass = resourceClass;
            this.inner = servletConfig;
            this.parentContext = parentContext;
            if (parentContext != null) {
                this.defaultClasses = parentContext.defaultClasses.copy();
                this.defaultSettings = parentContext.defaultSettings.copy();
                this.rootBeanStore = parentContext.rootBeanStore;
            } else {
                this.defaultClasses = DefaultClassList.create();
                this.defaultSettings = DefaultSettingsMap.create();
            }
        }

        @Override
        public Builder copy() {
            throw new NoSuchMethodError("Not implemented.");
        }

        @Override
        public RestContext build() {
            try {
                return this.beanStore().createBean(RestContext.class).type(this.getType().orElse(RestContext.class)).builder(Builder.class, this).run();
            }
            catch (Exception e) {
                throw new InternalServerError((Throwable)e, "Could not instantiate RestContext.", new Object[0]);
            }
        }

        public Builder init(Supplier<?> resource) throws ServletException {
            if (this.initialized) {
                return this;
            }
            this.initialized = true;
            ResourceSupplier r = this.resource = new ResourceSupplier(this.resourceClass, resource);
            Class<?> rc = this.resourceClass;
            this.beanStore = this.createBeanStore(resource).build().addBean(Builder.class, this).addBean(ResourceSupplier.class, this.resource).addBean(ServletConfig.class, this.inner != null ? this.inner : this).addBean(ServletContext.class, (this.inner != null ? this.inner : this).getServletContext());
            if (this.rootBeanStore == null) {
                this.rootBeanStore = this.beanStore;
                this.beanStore = BeanStore.of(this.rootBeanStore, r.get());
            }
            BeanStore bs = this.beanStore;
            this.beanStore.add(BeanStore.class, bs);
            this.varResolver = this.createVarResolver(bs, r, rc);
            this.beanStore.add(VarResolver.class, (VarResolver)this.varResolver.build());
            this.config = this.beanStore.add(Config.class, this.createConfig(bs, r, rc));
            this.beanStore.add(VarResolver.class, (VarResolver)this.varResolver.bean(Config.class, this.config).build());
            ClassInfo rci = ClassInfo.of(this.resourceClass);
            rci.forEachAllField(x -> x.hasAnnotation(RestInject.class), x -> x.getOptional(resource.get()).ifPresent(y -> this.beanStore.add(x.getType().inner(), y, RestInjectAnnotation.name(x.getAnnotation(RestInject.class)))));
            rci.forEachMethod(x -> x.hasAnnotation(RestInject.class), x -> {
                Class rt = x.getReturnType().inner();
                String name = RestInjectAnnotation.name(x.getAnnotation(RestInject.class));
                if (!DELAYED_INJECTION.contains(rt) && !DELAYED_INJECTION_NAMES.contains(name)) {
                    this.beanStore.createMethodFinder(rt).find(Builder::isRestBeanMethod).run(y -> this.beanStore.add(rt, y, name));
                }
            });
            VarResolverSession vrs = ((VarResolver)this.varResolver().build()).createSession();
            AnnotationWorkList work = AnnotationWorkList.of(vrs, rci.getAnnotationList(Context.CONTEXT_APPLY_FILTER));
            this.apply(work);
            this.beanContext().apply(work);
            this.partSerializer().apply(work);
            this.partParser().apply(work);
            this.jsonSchemaGenerator().apply(work);
            this.runInitHooks(bs, this.resource());
            rci.forEachAllField(x -> x.hasAnnotation(RestInject.class), x -> x.setIfNull(resource.get(), this.beanStore.getBean(x.getType().inner(), RestInjectAnnotation.name(x.getAnnotation(RestInject.class))).orElse(null)));
            return this;
        }

        private void runInitHooks(BeanStore beanStore, Supplier<?> resource) throws ServletException {
            Object r = resource.get();
            LinkedHashMap map = CollectionUtils.map();
            ClassInfo.ofProxy(r).forEachAllMethodParentFirst(y -> y.hasAnnotation(RestInit.class) && !y.hasArg(RestOpContext.Builder.class), y -> {
                String sig = y.getSignature();
                if (!map.containsKey(sig)) {
                    map.put(sig, y.accessible());
                }
            });
            for (MethodInfo m : map.values()) {
                if (!beanStore.hasAllParams(m)) {
                    throw RestContext.servletException("Could not call @RestInit method {0}.{1}.  Could not find prerequisites: {2}.", m.getDeclaringClass().getSimpleName(), m.getSignature(), beanStore.getMissingParams(m));
                }
                try {
                    m.invoke(r, beanStore.getParams(m));
                }
                catch (Exception e) {
                    throw RestContext.servletException(e, "Exception thrown from @RestInit method {0}.{1}.", m.getDeclaringClass().getSimpleName(), m.getSignature());
                }
            }
        }

        public Supplier<?> resource() {
            if (this.resource == null) {
                throw new RuntimeException("Resource not available.  init(Object) has not been called.");
            }
            return this.resource;
        }

        public <T> Optional<T> resourceAs(Class<T> type) {
            Object r = this.resource().get();
            return CollectionUtils.optional(type.isInstance(r) ? (Object)type.cast(r) : null);
        }

        public DefaultClassList defaultClasses() {
            return this.defaultClasses;
        }

        public Builder defaultClasses(Class<?> ... values) {
            this.defaultClasses().add(values);
            return this;
        }

        public DefaultSettingsMap defaultSettings() {
            return this.defaultSettings;
        }

        public Builder defaultSetting(String key, Object value) {
            this.defaultSettings().set(key, value);
            return this;
        }

        public BeanStore beanStore() {
            return this.beanStore;
        }

        public <T> Builder beanStore(Class<T> beanType, T bean) {
            this.beanStore().addBean(beanType, bean);
            return this;
        }

        public <T> Builder beanStore(Class<T> beanType, T bean, String name) {
            this.beanStore().addBean(beanType, bean, name);
            return this;
        }

        public BeanStore rootBeanStore() {
            return this.rootBeanStore;
        }

        protected BeanStore.Builder createBeanStore(Supplier<?> resource) {
            Value<BeanStore.Builder> v = Value.of(BeanStore.create().parent(this.rootBeanStore()).outer(resource.get()));
            ClassInfo.of(this.resourceClass).forEachAnnotation(Rest.class, x -> ClassUtils.isNotVoid(x.beanStore()), x -> ((BeanStore.Builder)v.get()).type(x.beanStore()));
            v.get().build().createMethodFinder(BeanStore.class).find(Builder::isRestBeanMethod).run(x -> ((BeanStore.Builder)v.get()).impl((BeanStore)x));
            return v.get();
        }

        public VarResolver.Builder varResolver() {
            return this.varResolver;
        }

        @SafeVarargs
        public final Builder vars(Class<? extends Var> ... value) {
            this.varResolver.vars(value);
            return this;
        }

        public Builder vars(Var ... value) {
            this.varResolver.vars(value);
            return this;
        }

        protected VarResolver.Builder createVarResolver(BeanStore beanStore, Supplier<?> resource, Class<?> resourceClass) {
            Value<VarResolver.Builder> v = Value.of(VarResolver.create().defaultVars().vars(VarList.of(ConfigVar.class, FileVar.class, LocalizationVar.class, RequestAttributeVar.class, RequestFormDataVar.class, RequestHeaderVar.class, RequestPathVar.class, RequestQueryVar.class, RequestVar.class, RequestSwaggerVar.class, SerializedRequestAttrVar.class, ServletInitParamVar.class, SwaggerVar.class, UrlVar.class, UrlEncodeVar.class, HtmlWidgetVar.class).addDefault()).bean(FileFinder.class, (FileFinder)FileFinder.create(beanStore).cp(resourceClass, null, true).build()));
            beanStore.getBean(VarResolver.class).ifPresent(x -> ((VarResolver.Builder)v.get()).impl(x));
            beanStore.createMethodFinder(VarResolver.class).addBean(VarResolver.Builder.class, v.get()).find(Builder::isRestBeanMethod).run(x -> ((VarResolver.Builder)v.get()).impl(x));
            return v.get();
        }

        public Config config() {
            return this.config;
        }

        @FluentSetter
        public Builder config(Config config) {
            this.config = config;
            return this;
        }

        protected Config createConfig(BeanStore beanStore, Supplier<?> resource, Class<?> resourceClass) {
            Value<Config> v = Value.empty();
            VarResolver vr = beanStore.getBean(VarResolver.class).orElseThrow(() -> new RuntimeException("VarResolver not found."));
            Value<String> cfv = Value.empty();
            ClassInfo.of(resourceClass).forEachAnnotation(Rest.class, x -> StringUtils.isNotEmpty(x.config()), x -> cfv.set(vr.resolve(x.config())));
            String cf = cfv.orElse("");
            if (v.isEmpty() && "SYSTEM_DEFAULT".equals(cf)) {
                v.set(Config.getSystemDefault());
            }
            if (v.isEmpty()) {
                Config.Builder cb = Config.create().varResolver(vr);
                if (!cf.isEmpty()) {
                    cb.name(cf);
                }
                v.set(cb.build());
            }
            beanStore.getBean(Config.class).ifPresent(x -> v.set((Config)x));
            beanStore.createMethodFinder(Config.class).addBean(Config.class, (Config)v.get()).find(Builder::isRestBeanMethod).run(x -> v.set((Config)x));
            return (Config)v.get();
        }

        public Logger logger() {
            if (this.logger == null) {
                this.logger = this.createLogger(this.beanStore(), this.resource, this.resourceClass);
            }
            return this.logger;
        }

        public Builder logger(Logger value) {
            this.logger = value;
            return this;
        }

        protected Logger createLogger(BeanStore beanStore, Supplier<?> resource, Class<?> resourceClass) {
            Value<Logger> v = Value.of(Logger.getLogger(resourceClass.getClass().getName()));
            beanStore.getBean(Logger.class).ifPresent(x -> v.set((Logger)x));
            beanStore.createMethodFinder(Logger.class).addBean(Logger.class, v.get()).find(Builder::isRestBeanMethod).run(x -> v.set((Logger)x));
            return v.get();
        }

        public ThrownStore.Builder thrownStore() {
            if (this.thrownStore == null) {
                this.thrownStore = this.createThrownStore(this.beanStore(), this.resource(), this.parentContext);
            }
            return this.thrownStore;
        }

        public Builder thrownStore(Class<? extends ThrownStore> value) {
            this.thrownStore().type((Class)value);
            return this;
        }

        public Builder thrownStore(ThrownStore value) {
            this.thrownStore().impl(value);
            return this;
        }

        protected ThrownStore.Builder createThrownStore(BeanStore beanStore, Supplier<?> resource, RestContext parent) {
            Value<ThrownStore.Builder> v = Value.of(ThrownStore.create(beanStore).impl(parent == null ? null : parent.getThrownStore()));
            this.defaultClasses().get(ThrownStore.class).ifPresent(x -> ((ThrownStore.Builder)v.get()).type((Class)x));
            beanStore.getBean(ThrownStore.class).ifPresent(x -> ((ThrownStore.Builder)v.get()).impl(x));
            beanStore.createMethodFinder(ThrownStore.class).addBean(ThrownStore.Builder.class, v.get()).find(Builder::isRestBeanMethod).run(x -> ((ThrownStore.Builder)v.get()).impl(x));
            return v.get();
        }

        public EncoderSet.Builder encoders() {
            if (this.encoders == null) {
                this.encoders = this.createEncoders(this.beanStore(), this.resource());
            }
            return this.encoders;
        }

        @SafeVarargs
        public final Builder encoders(Class<? extends Encoder> ... value) {
            this.encoders().add(value);
            return this;
        }

        public Builder encoders(Encoder ... value) {
            this.encoders().add(value);
            return this;
        }

        protected EncoderSet.Builder createEncoders(BeanStore beanStore, Supplier<?> resource) {
            Value<EncoderSet.Builder> v = Value.of(EncoderSet.create(beanStore).add(IdentityEncoder.INSTANCE));
            this.defaultClasses().get(EncoderSet.class).ifPresent(x -> ((EncoderSet.Builder)v.get()).type((Class)x));
            beanStore.getBean(EncoderSet.class).ifPresent(x -> ((EncoderSet.Builder)v.get()).impl(x));
            beanStore.createMethodFinder(EncoderSet.class).addBean(EncoderSet.Builder.class, v.get()).find(Builder::isRestBeanMethod).run(x -> ((EncoderSet.Builder)v.get()).impl(x));
            return v.get();
        }

        public SerializerSet.Builder serializers() {
            if (this.serializers == null) {
                this.serializers = this.createSerializers(this.beanStore(), this.resource());
            }
            return this.serializers;
        }

        @SafeVarargs
        public final Builder serializers(Class<? extends Serializer> ... value) {
            this.serializers().add(value);
            return this;
        }

        public Builder serializers(Serializer ... value) {
            this.serializers().add(value);
            return this;
        }

        protected SerializerSet.Builder createSerializers(BeanStore beanStore, Supplier<?> resource) {
            Value<SerializerSet.Builder> v = Value.of(SerializerSet.create(beanStore));
            this.defaultClasses().get(SerializerSet.class).ifPresent(x -> ((SerializerSet.Builder)v.get()).type((Class)x));
            beanStore.getBean(SerializerSet.class).ifPresent(x -> ((SerializerSet.Builder)v.get()).impl(x));
            beanStore.createMethodFinder(SerializerSet.class).addBean(SerializerSet.Builder.class, v.get()).find(Builder::isRestBeanMethod).run(x -> ((SerializerSet.Builder)v.get()).impl(x));
            return v.get();
        }

        public ParserSet.Builder parsers() {
            if (this.parsers == null) {
                this.parsers = this.createParsers(this.beanStore(), this.resource());
            }
            return this.parsers;
        }

        @SafeVarargs
        public final Builder parsers(Class<? extends Parser> ... value) {
            this.parsers().add(value);
            return this;
        }

        public Builder parsers(Parser ... value) {
            this.parsers().add(value);
            return this;
        }

        protected ParserSet.Builder createParsers(BeanStore beanStore, Supplier<?> resource) {
            Value<ParserSet.Builder> v = Value.of(ParserSet.create(beanStore));
            this.defaultClasses().get(ParserSet.class).ifPresent(x -> ((ParserSet.Builder)v.get()).type((Class)x));
            beanStore.getBean(ParserSet.class).ifPresent(x -> ((ParserSet.Builder)v.get()).impl(x));
            beanStore.createMethodFinder(ParserSet.class).addBean(ParserSet.Builder.class, v.get()).find(Builder::isRestBeanMethod).run(x -> ((ParserSet.Builder)v.get()).impl(x));
            return v.get();
        }

        public MethodExecStore.Builder methodExecStore() {
            if (this.methodExecStore == null) {
                this.methodExecStore = this.createMethodExecStore(this.beanStore(), this.resource());
            }
            return this.methodExecStore;
        }

        public Builder methodExecStore(Class<? extends MethodExecStore> value) {
            this.methodExecStore().type((Class)value);
            return this;
        }

        public Builder methodExecStore(MethodExecStore value) {
            this.methodExecStore().impl(value);
            return this;
        }

        protected MethodExecStore.Builder createMethodExecStore(BeanStore beanStore, Supplier<?> resource) {
            Value<MethodExecStore.Builder> v = Value.of(MethodExecStore.create(beanStore));
            this.defaultClasses().get(MethodExecStore.class).ifPresent(x -> ((MethodExecStore.Builder)v.get()).type((Class)x));
            beanStore.getBean(MethodExecStore.class).ifPresent(x -> ((MethodExecStore.Builder)v.get()).impl(x));
            beanStore.createMethodFinder(MethodExecStore.class).addBean(MethodExecStore.Builder.class, v.get()).find(Builder::isRestBeanMethod).run(x -> ((MethodExecStore.Builder)v.get()).impl(x));
            return v.get();
        }

        public Messages.Builder messages() {
            if (this.messages == null) {
                this.messages = this.createMessages(this.beanStore(), this.resource());
            }
            return this.messages;
        }

        public Builder messages(Class<? extends Messages> value) {
            this.messages().type((Class)value);
            return this;
        }

        public Builder messages(Messages value) {
            this.messages().impl(value);
            return this;
        }

        protected Messages.Builder createMessages(BeanStore beanStore, Supplier<?> resource) {
            Value<Messages.Builder> v = Value.of(Messages.create(this.resourceClass));
            beanStore.getBean(Messages.class).ifPresent(x -> ((Messages.Builder)v.get()).impl(x));
            beanStore.createMethodFinder(Messages.class).addBean(Messages.Builder.class, v.get()).find(Builder::isRestBeanMethod).run(x -> ((Messages.Builder)v.get()).impl(x));
            return v.get();
        }

        public ResponseProcessorList.Builder responseProcessors() {
            if (this.responseProcessors == null) {
                this.responseProcessors = this.createResponseProcessors(this.beanStore(), this.resource());
            }
            return this.responseProcessors;
        }

        @SafeVarargs
        public final Builder responseProcessors(Class<? extends ResponseProcessor> ... value) {
            this.responseProcessors().add(value);
            return this;
        }

        public Builder responseProcessors(ResponseProcessor ... value) {
            this.responseProcessors().add(value);
            return this;
        }

        protected ResponseProcessorList.Builder createResponseProcessors(BeanStore beanStore, Supplier<?> resource) {
            Value<ResponseProcessorList.Builder> v = Value.of(ResponseProcessorList.create(beanStore).add(ReaderProcessor.class, InputStreamProcessor.class, ThrowableProcessor.class, HttpResponseProcessor.class, HttpResourceProcessor.class, HttpEntityProcessor.class, ResponseBeanProcessor.class, PlainTextPojoProcessor.class, SerializedPojoProcessor.class));
            beanStore.getBean(ResponseProcessorList.class).ifPresent(x -> ((ResponseProcessorList.Builder)v.get()).impl(x));
            beanStore.createMethodFinder(ResponseProcessorList.class).addBean(ResponseProcessorList.Builder.class, v.get()).find(Builder::isRestBeanMethod).run(x -> ((ResponseProcessorList.Builder)v.get()).impl(x));
            return v.get();
        }

        public BeanCreator<CallLogger> callLogger() {
            if (this.callLogger == null) {
                this.callLogger = this.createCallLogger(this.beanStore, this.resource);
            }
            return this.callLogger;
        }

        public Builder callLogger(Class<? extends CallLogger> value) {
            this.callLogger().type(value);
            return this;
        }

        public Builder callLogger(CallLogger value) {
            this.callLogger().impl(value);
            return this;
        }

        protected BeanCreator<CallLogger> createCallLogger(BeanStore beanStore, Supplier<?> resource) {
            BeanCreator<CallLogger> creator = beanStore.createBean(CallLogger.class).type(BasicCallLogger.class);
            this.defaultClasses().get(CallLogger.class).ifPresent(x -> creator.type((Class<?>)x));
            beanStore.getBean(CallLogger.class).ifPresent(x -> creator.impl((CallLogger)x));
            beanStore.createMethodFinder(CallLogger.class).find(Builder::isRestBeanMethod).run(x -> creator.impl((CallLogger)x));
            return creator;
        }

        public BeanContext.Builder beanContext() {
            if (this.beanContext == null) {
                this.beanContext = this.createBeanContext(this.beanStore(), this.resource());
            }
            return this.beanContext;
        }

        protected BeanContext.Builder createBeanContext(BeanStore beanStore, Supplier<?> resource) {
            Value<BeanContext.Builder> v = Value.of(BeanContext.create());
            beanStore.getBean(BeanContext.Builder.class).map(x -> x.copy()).ifPresent(x -> v.set((BeanContext.Builder)x));
            beanStore.getBean(BeanContext.class).ifPresent(x -> ((BeanContext.Builder)v.get()).impl((Context)x));
            return v.get();
        }

        public HttpPartSerializer.Creator partSerializer() {
            if (this.partSerializer == null) {
                this.partSerializer = this.createPartSerializer(this.beanStore(), this.resource());
            }
            return this.partSerializer;
        }

        public Builder partSerializer(Class<? extends HttpPartSerializer> value) {
            this.partSerializer().type((Class)value);
            return this;
        }

        public Builder partSerializer(HttpPartSerializer value) {
            this.partSerializer().impl(value);
            return this;
        }

        protected HttpPartSerializer.Creator createPartSerializer(BeanStore beanStore, Supplier<?> resource) {
            Value<ContextBeanCreator> v = Value.of(HttpPartSerializer.creator().type(OpenApiSerializer.class));
            beanStore.getBean(HttpPartSerializer.Creator.class).map(x -> x.copy()).ifPresent(x -> v.set((ContextBeanCreator)x));
            beanStore.getBean(HttpPartSerializer.class).ifPresent(x -> ((HttpPartSerializer.Creator)v.get()).impl(x));
            this.resourceAs(HttpPartSerializer.class).ifPresent(x -> ((HttpPartSerializer.Creator)v.get()).impl(x));
            this.defaultClasses().get(HttpPartSerializer.class).ifPresent(x -> ((HttpPartSerializer.Creator)v.get()).type((Class)x));
            beanStore.createMethodFinder(HttpPartSerializer.class).addBean(HttpPartSerializer.Creator.class, (HttpPartSerializer.Creator)v.get()).find(Builder::isRestBeanMethod).run(x -> ((HttpPartSerializer.Creator)v.get()).impl(x));
            return (HttpPartSerializer.Creator)v.get();
        }

        public HttpPartParser.Creator partParser() {
            if (this.partParser == null) {
                this.partParser = this.createPartParser(this.beanStore(), this.resource());
            }
            return this.partParser;
        }

        public Builder partParser(Class<? extends HttpPartParser> value) {
            this.partParser().type((Class)value);
            return this;
        }

        public Builder partParser(HttpPartParser value) {
            this.partParser().impl(value);
            return this;
        }

        protected HttpPartParser.Creator createPartParser(BeanStore beanStore, Supplier<?> resource) {
            Value<ContextBeanCreator> v = Value.of(HttpPartParser.creator().type(OpenApiParser.class));
            beanStore.getBean(HttpPartParser.Creator.class).map(x -> x.copy()).ifPresent(x -> v.set((ContextBeanCreator)x));
            beanStore.getBean(HttpPartParser.class).ifPresent(x -> ((HttpPartParser.Creator)v.get()).impl(x));
            this.resourceAs(HttpPartParser.class).ifPresent(x -> ((HttpPartParser.Creator)v.get()).impl(x));
            this.defaultClasses().get(HttpPartParser.class).ifPresent(x -> ((HttpPartParser.Creator)v.get()).type((Class)x));
            beanStore.createMethodFinder(HttpPartParser.class).addBean(HttpPartParser.Creator.class, (HttpPartParser.Creator)v.get()).find(Builder::isRestBeanMethod).run(x -> ((HttpPartParser.Creator)v.get()).impl(x));
            return (HttpPartParser.Creator)v.get();
        }

        public JsonSchemaGenerator.Builder jsonSchemaGenerator() {
            if (this.jsonSchemaGenerator == null) {
                this.jsonSchemaGenerator = this.createJsonSchemaGenerator(this.beanStore(), this.resource());
            }
            return this.jsonSchemaGenerator;
        }

        public Builder jsonSchemaGenerator(Class<? extends JsonSchemaGenerator> value) {
            this.jsonSchemaGenerator().type(value);
            return this;
        }

        public Builder jsonSchemaGenerator(JsonSchemaGenerator value) {
            this.jsonSchemaGenerator().impl(value);
            return this;
        }

        protected JsonSchemaGenerator.Builder createJsonSchemaGenerator(BeanStore beanStore, Supplier<?> resource) {
            Value<JsonSchemaGenerator.Builder> v = Value.of(JsonSchemaGenerator.create());
            beanStore.getBean(JsonSchemaGenerator.Builder.class).map(x -> x.copy()).ifPresent(x -> v.set((JsonSchemaGenerator.Builder)x));
            beanStore.getBean(JsonSchemaGenerator.class).ifPresent(x -> ((JsonSchemaGenerator.Builder)v.get()).impl((Context)x));
            beanStore.createMethodFinder(JsonSchemaGenerator.class).addBean(JsonSchemaGenerator.Builder.class, v.get()).find(Builder::isRestBeanMethod).run(x -> ((JsonSchemaGenerator.Builder)v.get()).impl((Context)x));
            return v.get();
        }

        public BeanCreator<StaticFiles> staticFiles() {
            if (this.staticFiles == null) {
                this.staticFiles = this.createStaticFiles(this.beanStore, this.resource);
            }
            return this.staticFiles;
        }

        public Builder staticFiles(Class<? extends StaticFiles> value) {
            this.staticFiles().type(value);
            return this;
        }

        public Builder staticFiles(StaticFiles value) {
            this.staticFiles().impl(value);
            return this;
        }

        protected BeanCreator<StaticFiles> createStaticFiles(BeanStore beanStore, Supplier<?> resource) {
            BeanCreator<StaticFiles> creator = beanStore.createBean(StaticFiles.class).type(BasicStaticFiles.class);
            this.defaultClasses().get(StaticFiles.class).ifPresent(x -> creator.type((Class<?>)x));
            beanStore.getBean(StaticFiles.class).ifPresent(x -> creator.impl((StaticFiles)x));
            beanStore.createMethodFinder(StaticFiles.class).find(Builder::isRestBeanMethod).run(x -> creator.impl((StaticFiles)x));
            return creator;
        }

        public HeaderList defaultRequestHeaders() {
            if (this.defaultRequestHeaders == null) {
                this.defaultRequestHeaders = this.createDefaultRequestHeaders(this.beanStore(), this.resource());
            }
            return this.defaultRequestHeaders;
        }

        @FluentSetter
        public Builder defaultRequestHeaders(Header ... values) {
            this.defaultRequestHeaders().setDefault(values);
            return this;
        }

        @FluentSetter
        public Builder defaultAccept(String value) {
            if (StringUtils.isNotEmpty(value)) {
                this.defaultRequestHeaders(new Header[]{HttpHeaders.accept((String)value)});
            }
            return this;
        }

        @FluentSetter
        public Builder defaultContentType(String value) {
            if (StringUtils.isNotEmpty(value)) {
                this.defaultRequestHeaders(new Header[]{HttpHeaders.contentType((String)value)});
            }
            return this;
        }

        protected HeaderList createDefaultRequestHeaders(BeanStore beanStore, Supplier<?> resource) {
            Value<HeaderList> v = Value.of(HeaderList.create());
            beanStore.getBean(HeaderList.class, "defaultRequestHeaders").ifPresent(x -> v.set((HeaderList)x));
            beanStore.createMethodFinder(HeaderList.class).addBean(HeaderList.class, v.get()).find(x -> Builder.isRestBeanMethod(x, "defaultRequestHeaders")).run(x -> v.set((HeaderList)x));
            return v.get();
        }

        public HeaderList defaultResponseHeaders() {
            if (this.defaultResponseHeaders == null) {
                this.defaultResponseHeaders = this.createDefaultResponseHeaders(this.beanStore(), this.resource());
            }
            return this.defaultResponseHeaders;
        }

        @FluentSetter
        public Builder defaultResponseHeaders(Header ... values) {
            this.defaultResponseHeaders().setDefault(values);
            return this;
        }

        protected HeaderList createDefaultResponseHeaders(BeanStore beanStore, Supplier<?> resource) {
            Value<HeaderList> v = Value.of(HeaderList.create());
            beanStore.getBean(HeaderList.class, "defaultResponseHeaders").ifPresent(x -> v.set((HeaderList)x));
            beanStore.createMethodFinder(HeaderList.class).addBean(HeaderList.class, v.get()).find(x -> Builder.isRestBeanMethod(x, "defaultResponseHeaders")).run(x -> v.set((HeaderList)x));
            return v.get();
        }

        public NamedAttributeMap defaultRequestAttributes() {
            if (this.defaultRequestAttributes == null) {
                this.defaultRequestAttributes = this.createDefaultRequestAttributes(this.beanStore(), this.resource());
            }
            return this.defaultRequestAttributes;
        }

        @FluentSetter
        public Builder defaultRequestAttributes(NamedAttribute ... values) {
            this.defaultRequestAttributes().add(values);
            return this;
        }

        protected NamedAttributeMap createDefaultRequestAttributes(BeanStore beanStore, Supplier<?> resource) {
            Value<NamedAttributeMap> v = Value.of(NamedAttributeMap.create());
            beanStore.getBean(NamedAttributeMap.class, "defaultRequestAttributes").ifPresent(x -> v.set((NamedAttributeMap)x));
            beanStore.createMethodFinder(NamedAttributeMap.class).addBean(NamedAttributeMap.class, v.get()).find(x -> Builder.isRestBeanMethod(x, "defaultRequestAttributes")).run(x -> v.set((NamedAttributeMap)x));
            return v.get();
        }

        public RestOpArgList.Builder restOpArgs() {
            if (this.restOpArgs == null) {
                this.restOpArgs = this.createRestOpArgs(this.beanStore(), this.resource());
            }
            return this.restOpArgs;
        }

        @SafeVarargs
        @FluentSetter
        public final Builder restOpArgs(Class<? extends RestOpArg> ... value) {
            this.restOpArgs().add(value);
            return this;
        }

        protected RestOpArgList.Builder createRestOpArgs(BeanStore beanStore, Supplier<?> resource) {
            Value<RestOpArgList.Builder> v = Value.of(RestOpArgList.create(beanStore).add(AttributeArg.class, ContentArg.class, FormDataArg.class, HasFormDataArg.class, HasQueryArg.class, HeaderArg.class, HttpServletRequestArgs.class, HttpServletResponseArgs.class, HttpSessionArgs.class, InputStreamParserArg.class, MethodArg.class, ParserArg.class, PathArg.class, QueryArg.class, ReaderParserArg.class, RequestBeanArg.class, ResponseBeanArg.class, ResponseHeaderArg.class, ResponseCodeArg.class, RestContextArgs.class, RestSessionArgs.class, RestOpContextArgs.class, RestOpSessionArgs.class, RestRequestArgs.class, RestResponseArgs.class, DefaultArg.class));
            beanStore.getBean(RestOpArgList.class).ifPresent(x -> ((RestOpArgList.Builder)v.get()).impl(x));
            beanStore.createMethodFinder(RestOpArgList.class).addBean(RestOpArgList.Builder.class, v.get()).find(Builder::isRestBeanMethod).run(x -> ((RestOpArgList.Builder)v.get()).impl(x));
            return v.get();
        }

        public BeanCreator<DebugEnablement> debugEnablement() {
            if (this.debugEnablement == null) {
                this.debugEnablement = this.createDebugEnablement(this.beanStore, this.resource);
            }
            return this.debugEnablement;
        }

        public Builder debugEnablement(Class<? extends DebugEnablement> value) {
            this.debugEnablement().type(value);
            return this;
        }

        public Builder debugEnablement(DebugEnablement value) {
            this.debugEnablement().impl(value);
            return this;
        }

        @FluentSetter
        public Builder debugDefault(Enablement value) {
            this.defaultSettings().set("RestContext.debugDefault", (Object)value);
            return this;
        }

        protected BeanCreator<DebugEnablement> createDebugEnablement(BeanStore beanStore, Supplier<?> resource) {
            BeanCreator<DebugEnablement> creator = beanStore.createBean(DebugEnablement.class).type(BasicDebugEnablement.class);
            this.defaultClasses().get(DebugEnablement.class).ifPresent(x -> creator.type((Class<?>)x));
            beanStore.getBean(DebugEnablement.class).ifPresent(x -> creator.impl((DebugEnablement)x));
            beanStore.createMethodFinder(DebugEnablement.class).find(Builder::isRestBeanMethod).run(x -> creator.impl((DebugEnablement)x));
            return creator;
        }

        public MethodList startCallMethods() {
            if (this.startCallMethods == null) {
                this.startCallMethods = this.createStartCallMethods(this.beanStore(), this.resource());
            }
            return this.startCallMethods;
        }

        protected MethodList createStartCallMethods(BeanStore beanStore, Supplier<?> resource) {
            Value<MethodList> v = Value.of(Builder.getAnnotatedMethods(resource, RestStartCall.class, x -> true));
            beanStore.createMethodFinder(MethodList.class).addBean(MethodList.class, v.get()).find(x -> Builder.isRestBeanMethod(x, "startCallMethods")).run(x -> v.set((MethodList)x));
            return v.get();
        }

        public MethodList endCallMethods() {
            if (this.endCallMethods == null) {
                this.endCallMethods = this.createEndCallMethods(this.beanStore(), this.resource());
            }
            return this.endCallMethods;
        }

        protected MethodList createEndCallMethods(BeanStore beanStore, Supplier<?> resource) {
            Value<MethodList> v = Value.of(Builder.getAnnotatedMethods(resource, RestEndCall.class, x -> true));
            beanStore.createMethodFinder(MethodList.class).addBean(MethodList.class, v.get()).find(x -> Builder.isRestBeanMethod(x, "endCallMethods")).run(x -> v.set((MethodList)x));
            return v.get();
        }

        public MethodList postInitMethods() {
            if (this.postInitMethods == null) {
                this.postInitMethods = this.createPostInitMethods(this.beanStore(), this.resource());
            }
            return this.postInitMethods;
        }

        protected MethodList createPostInitMethods(BeanStore beanStore, Supplier<?> resource) {
            Value<MethodList> v = Value.of(Builder.getAnnotatedMethods(resource, RestPostInit.class, x -> !x.childFirst()));
            beanStore.createMethodFinder(MethodList.class).addBean(MethodList.class, v.get()).find(x -> Builder.isRestBeanMethod(x, "postInitMethods")).run(x -> v.set((MethodList)x));
            return v.get();
        }

        public MethodList postInitChildFirstMethods() {
            if (this.postInitChildFirstMethods == null) {
                this.postInitChildFirstMethods = this.createPostInitChildFirstMethods(this.beanStore(), this.resource());
            }
            return this.postInitChildFirstMethods;
        }

        protected MethodList createPostInitChildFirstMethods(BeanStore beanStore, Supplier<?> resource) {
            Value<MethodList> v = Value.of(Builder.getAnnotatedMethods(resource, RestPostInit.class, x -> x.childFirst()));
            beanStore.createMethodFinder(MethodList.class).addBean(MethodList.class, v.get()).find(x -> Builder.isRestBeanMethod(x, "postInitChildFirstMethods")).run(x -> v.set((MethodList)x));
            return v.get();
        }

        public MethodList destroyMethods() {
            if (this.destroyMethods == null) {
                this.destroyMethods = this.createDestroyMethods(this.beanStore(), this.resource());
            }
            return this.destroyMethods;
        }

        protected MethodList createDestroyMethods(BeanStore beanStore, Supplier<?> resource) {
            Value<MethodList> v = Value.of(Builder.getAnnotatedMethods(resource, RestDestroy.class, x -> true));
            beanStore.createMethodFinder(MethodList.class).addBean(MethodList.class, v.get()).find(x -> Builder.isRestBeanMethod(x, "destroyMethods")).run(x -> v.set((MethodList)x));
            return v.get();
        }

        public MethodList preCallMethods() {
            if (this.preCallMethods == null) {
                this.preCallMethods = this.createPreCallMethods(this.beanStore(), this.resource());
            }
            return this.preCallMethods;
        }

        protected MethodList createPreCallMethods(BeanStore beanStore, Supplier<?> resource) {
            Value<MethodList> v = Value.of(Builder.getAnnotatedMethods(resource, RestPreCall.class, x -> true));
            beanStore.createMethodFinder(MethodList.class).addBean(MethodList.class, v.get()).find(x -> Builder.isRestBeanMethod(x, "preCallMethods")).run(x -> v.set((MethodList)x));
            return v.get();
        }

        public MethodList postCallMethods() {
            if (this.postCallMethods == null) {
                this.postCallMethods = this.createPostCallMethods(this.beanStore(), this.resource());
            }
            return this.postCallMethods;
        }

        protected MethodList createPostCallMethods(BeanStore beanStore, Supplier<?> resource) {
            Value<MethodList> v = Value.of(Builder.getAnnotatedMethods(resource, RestPostCall.class, x -> true));
            beanStore.createMethodFinder(MethodList.class).addBean(MethodList.class, v.get()).find(x -> Builder.isRestBeanMethod(x, "postCallMethods")).run(x -> v.set((MethodList)x));
            return v.get();
        }

        public RestOperations.Builder restOperations(RestContext restContext) throws ServletException {
            if (this.restOperations == null) {
                this.restOperations = this.createRestOperations(this.beanStore(), this.resource(), restContext);
            }
            return this.restOperations;
        }

        protected RestOperations.Builder createRestOperations(BeanStore beanStore, Supplier<?> resource, RestContext restContext) throws ServletException {
            Value<RestOperations.Builder> v = Value.of(RestOperations.create(beanStore));
            ClassInfo rci = ClassInfo.of(resource.get());
            LinkedHashMap initMap = CollectionUtils.map();
            ClassInfo.ofProxy(resource.get()).forEachAllMethodParentFirst(y -> y.hasAnnotation(RestInit.class) && y.hasArg(RestOpContext.Builder.class), y -> {
                String sig = y.getSignature();
                if (!initMap.containsKey(sig)) {
                    initMap.put(sig, y.accessible());
                }
            });
            for (MethodInfo mi : rci.getPublicMethods()) {
                AnnotationList al = mi.getAnnotationList(RestOpAnnotation.REST_OP_GROUP);
                if (al.size() == 0) {
                    Predicate<MethodInfo> isRestAnnotatedInterface = x -> x.getDeclaringClass().isInterface() && x.getDeclaringClass().getAnnotation(Rest.class) != null;
                    mi.forEachMatching(isRestAnnotatedInterface, x -> al.add(AnnotationInfo.of(x, RestOpAnnotation.DEFAULT)));
                }
                if (al.size() <= 0) continue;
                try {
                    if (mi.isNotPublic()) {
                        throw RestContext.servletException("@RestOp method {0}.{1} must be defined as public.", rci.inner().getName(), mi.getSimpleName());
                    }
                    Context.Builder rocb = RestOpContext.create(mi.inner(), restContext).beanStore(beanStore).type(this.opContextClass);
                    beanStore = BeanStore.of(beanStore, resource.get()).addBean(RestOpContext.Builder.class, rocb);
                    for (MethodInfo m : initMap.values()) {
                        if (!beanStore.hasAllParams(m)) {
                            throw RestContext.servletException("Could not call @RestInit method {0}.{1}.  Could not find prerequisites: {2}.", m.getDeclaringClass().getSimpleName(), m.getSignature(), beanStore.getMissingParams(m));
                        }
                        try {
                            m.invoke(resource.get(), beanStore.getParams(m));
                        }
                        catch (Exception e) {
                            throw RestContext.servletException(e, "Exception thrown from @RestInit method {0}.{1}.", m.getDeclaringClass().getSimpleName(), m.getSignature());
                        }
                    }
                    RestOpContext roc = ((RestOpContext.Builder)rocb).build();
                    String httpMethod = roc.getHttpMethod();
                    if ("RRPC".equals(httpMethod)) {
                        RestOpContext roc2 = ((RestOpContext.Builder)RestOpContext.create(mi.inner(), restContext).dotAll().beanStore(restContext.getRootBeanStore()).type(RrpcRestOpContext.class)).build();
                        v.get().add("GET", roc2).add("POST", roc2);
                        continue;
                    }
                    v.get().add(roc);
                }
                catch (Throwable e) {
                    throw RestContext.servletException(e, "Problem occurred trying to initialize methods on class {0}", rci.inner().getName());
                }
            }
            beanStore.createMethodFinder(RestOperations.class).addBean(RestOperations.Builder.class, v.get()).find(Builder::isRestBeanMethod).run(x -> ((RestOperations.Builder)v.get()).impl(x));
            return v.get();
        }

        public RestChildren.Builder restChildren(RestContext restContext) throws Exception {
            if (this.restChildren == null) {
                this.restChildren = this.createRestChildren(this.beanStore(), this.resource(), restContext);
            }
            return this.restChildren;
        }

        protected RestChildren.Builder createRestChildren(BeanStore beanStore, Supplier<?> resource, RestContext restContext) throws Exception {
            Value<BeanBuilder> v = Value.of(RestChildren.create(beanStore).type((Class)this.childrenClass));
            for (Object o : this.children) {
                Supplier<Object> so;
                String path = null;
                if (o instanceof RestChild) {
                    RestChild rc = (RestChild)o;
                    path = rc.path;
                    Object o2 = rc.resource;
                    Supplier<Object> supplier = () -> o2;
                }
                Builder cb = null;
                if (o instanceof Class) {
                    Class oc = (Class)o;
                    if (oc == this.resourceClass) continue;
                    cb = RestContext.create(oc, restContext, this.inner);
                    if (beanStore.getBean(oc).isPresent()) {
                        so = () -> beanStore.getBean(oc).get();
                    } else {
                        Object o2 = beanStore.createBean(oc).builder(Builder.class, cb).run();
                        so = () -> o2;
                    }
                } else {
                    cb = RestContext.create(o.getClass(), restContext, this.inner);
                    so = () -> o;
                }
                if (path != null) {
                    cb.path(path);
                }
                RestContext cc = cb.init(so).build();
                MethodInfo mi = ClassInfo.of(so.get()).getMethod(x -> x.hasName("setContext") && x.hasParamTypes(RestContext.class));
                if (mi != null) {
                    mi.accessible().invoke(so.get(), cc);
                }
                ((RestChildren.Builder)v.get()).add(cc);
            }
            beanStore.createMethodFinder(RestChildren.class).addBean(RestChildren.Builder.class, (RestChildren.Builder)v.get()).find(Builder::isRestBeanMethod).run(x -> ((RestChildren.Builder)v.get()).impl(x));
            return (RestChildren.Builder)v.get();
        }

        public BeanCreator<SwaggerProvider> swaggerProvider() {
            if (this.swaggerProvider == null) {
                this.swaggerProvider = this.createSwaggerProvider(this.beanStore, this.resource);
            }
            return this.swaggerProvider;
        }

        public Builder swaggerProvider(Class<? extends SwaggerProvider> value) {
            this.swaggerProvider().type(value);
            return this;
        }

        public Builder swaggerProvider(SwaggerProvider value) {
            this.swaggerProvider().impl(value);
            return this;
        }

        protected BeanCreator<SwaggerProvider> createSwaggerProvider(BeanStore beanStore, Supplier<?> resource) {
            BeanCreator<SwaggerProvider> creator = beanStore.createBean(SwaggerProvider.class).type(BasicSwaggerProvider.class);
            this.defaultClasses().get(SwaggerProvider.class).ifPresent(x -> creator.type((Class<?>)x));
            beanStore.getBean(SwaggerProvider.class).ifPresent(x -> creator.impl((SwaggerProvider)x));
            beanStore.createMethodFinder(SwaggerProvider.class).find(Builder::isRestBeanMethod).run(x -> creator.impl((SwaggerProvider)x));
            return creator;
        }

        @FluentSetter
        public Builder allowedHeaderParams(String value) {
            this.allowedHeaderParams = value;
            return this;
        }

        @FluentSetter
        public Builder allowedMethodHeaders(String value) {
            this.allowedMethodHeaders = value;
            return this;
        }

        @FluentSetter
        public Builder allowedMethodParams(String value) {
            this.allowedMethodParams = value;
            return this;
        }

        @FluentSetter
        public Builder clientVersionHeader(String value) {
            this.clientVersionHeader = value;
            return this;
        }

        @FluentSetter
        public Builder defaultCharset(Charset value) {
            this.defaultCharset = value;
            return this;
        }

        @FluentSetter
        public Builder disableContentParam() {
            return this.disableContentParam(true);
        }

        @FluentSetter
        public Builder disableContentParam(boolean value) {
            this.disableContentParam = value;
            return this;
        }

        @FluentSetter
        public Builder maxInput(String value) {
            this.maxInput = StringUtils.parseLongWithSuffix(value);
            return this;
        }

        @FluentSetter
        public Builder renderResponseStackTraces(boolean value) {
            this.renderResponseStackTraces = value;
            return this;
        }

        @FluentSetter
        public Builder renderResponseStackTraces() {
            this.renderResponseStackTraces = true;
            return this;
        }

        @FluentSetter
        public Builder uriAuthority(String value) {
            this.uriAuthority = value;
            return this;
        }

        @FluentSetter
        public Builder uriContext(String value) {
            this.uriContext = value;
            return this;
        }

        @FluentSetter
        public Builder uriRelativity(UriRelativity value) {
            this.uriRelativity = value;
            return this;
        }

        @FluentSetter
        public Builder uriResolution(UriResolution value) {
            this.uriResolution = value;
            return this;
        }

        public SerializerSet.Builder getSerializers() {
            return this.serializers;
        }

        public ParserSet.Builder getParsers() {
            return this.parsers;
        }

        public EncoderSet.Builder getEncoders() {
            return this.encoders;
        }

        @FluentSetter
        public Builder children(Object ... values) {
            CollectionUtils.addAll(this.children, values);
            return this;
        }

        @FluentSetter
        public Builder child(String path, Object child) {
            this.children.add(new RestChild(path, child));
            return this;
        }

        @FluentSetter
        public Builder parserListener(Class<? extends ParserListener> value) {
            if (ClassUtils.isNotVoid(value)) {
                this.parsers.forEach(x -> x.listener(value));
            }
            return this;
        }

        @FluentSetter
        public Builder path(String value) {
            if (!StringUtils.isEmpty(value = StringUtils.trimLeadingSlashes(value))) {
                this.path = value;
            }
            return this;
        }

        @FluentSetter
        public Builder restChildrenClass(Class<? extends RestChildren> value) {
            this.childrenClass = value;
            return this;
        }

        @FluentSetter
        public Builder restOpContextClass(Class<? extends RestOpContext> value) {
            this.opContextClass = value;
            return this;
        }

        @FluentSetter
        public Builder restOperationsClass(Class<? extends RestOperations> value) {
            this.operationsClass = value;
            return this;
        }

        @FluentSetter
        public Builder serializerListener(Class<? extends SerializerListener> value) {
            if (ClassUtils.isNotVoid(value)) {
                this.serializers.forEach(x -> x.listener(value));
            }
            return this;
        }

        @FluentSetter
        public Builder produces(MediaType ... values) {
            this.produces = CollectionUtils.addAll(this.produces, values);
            return this;
        }

        public Optional<List<MediaType>> produces() {
            return CollectionUtils.optional(this.produces);
        }

        @FluentSetter
        public Builder consumes(MediaType ... values) {
            this.consumes = CollectionUtils.addAll(this.consumes, values);
            return this;
        }

        public Optional<List<MediaType>> consumes() {
            return CollectionUtils.optional(this.consumes);
        }

        @Override
        public Builder annotations(Annotation ... values) {
            super.annotations(values);
            return this;
        }

        @Override
        public Builder apply(AnnotationWorkList work) {
            super.apply(work);
            return this;
        }

        @Override
        public Builder applyAnnotations(Class<?> ... fromClasses) {
            super.applyAnnotations(fromClasses);
            return this;
        }

        @Override
        public Builder applyAnnotations(Method ... fromMethods) {
            super.applyAnnotations(fromMethods);
            return this;
        }

        @Override
        public Builder cache(Cache<HashKey, ? extends Context> value) {
            super.cache(value);
            return this;
        }

        @Override
        public Builder debug() {
            super.debug();
            return this;
        }

        @Override
        public Builder debug(boolean value) {
            super.debug(value);
            return this;
        }

        @Override
        public Builder impl(Context value) {
            super.impl(value);
            return this;
        }

        @Override
        public Builder type(Class<? extends Context> value) {
            super.type(value);
            return this;
        }

        private static <T extends Annotation> MethodList getAnnotatedMethods(Supplier<?> resource, Class<T> annotation, Predicate<T> predicate) {
            LinkedHashMap x = CollectionUtils.map();
            Object r = resource.get();
            ClassInfo.ofProxy(r).forEachAllMethodParentFirst(y -> y.hasAnnotation(annotation), y -> y.forEachAnnotation(annotation, predicate, z -> x.put(y.getSignature(), y.accessible().inner())));
            MethodList x2 = MethodList.of(x.values());
            return x2;
        }

        private static boolean isRestBeanMethod(MethodInfo mi) {
            RestInject x = mi.getAnnotation(RestInject.class);
            return x != null && x.methodScope().length == 0;
        }

        private static boolean isRestBeanMethod(MethodInfo mi, String name) {
            RestInject x = mi.getAnnotation(RestInject.class);
            return x != null && x.methodScope().length == 0 && x.name().equals(name);
        }

        public String getInitParameter(String name) {
            return this.inner == null ? null : this.inner.getInitParameter(name);
        }

        public Enumeration<String> getInitParameterNames() {
            return this.inner == null ? new Vector().elements() : this.inner.getInitParameterNames();
        }

        public ServletContext getServletContext() {
            return this.inner != null ? this.inner.getServletContext() : (this.parentContext != null ? this.parentContext.getBuilder().getServletContext() : null);
        }

        public String getServletName() {
            return this.inner == null ? null : this.inner.getServletName();
        }
    }
}

