/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import java.nio.charset.Charset;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.juneau.BasicRuntimeException;
import org.apache.juneau.internal.CollectionUtils;

public class SystemEnv {
    private static final Map<Class<?>, Function<String, ?>> ENV_FUNCTIONS = new IdentityHashMap();
    private static final ConcurrentHashMap<String, String> PROPERTY_TO_ENV;

    public static <T> T env(String name, T def) {
        return (T)SystemEnv.env(name).map(x -> SystemEnv.toType(x, def)).orElse(def);
    }

    public static Optional<String> env(String name) {
        String s = System.getProperty(name);
        if (s == null) {
            s = System.getenv(SystemEnv.envName(name));
        }
        return CollectionUtils.optional(s);
    }

    private static <T> T toType(String s, T def) {
        if (s == null || def == null) {
            return null;
        }
        Class<?> c = def.getClass();
        if (c == String.class) {
            return (T)s;
        }
        if (c.isEnum()) {
            return (T)Enum.valueOf(c, s);
        }
        Function<String, ?> f = ENV_FUNCTIONS.get(c);
        if (f == null) {
            throw new BasicRuntimeException("Invalid env type: {0}", c);
        }
        return (T)f.apply(s);
    }

    private static String envName(String name) {
        String name2 = PROPERTY_TO_ENV.get(name);
        if (name2 == null) {
            name2 = name.toUpperCase().replace(".", "_");
            PROPERTY_TO_ENV.put(name, name2);
        }
        return name2;
    }

    static {
        ENV_FUNCTIONS.put(Boolean.class, x -> Boolean.valueOf(x));
        ENV_FUNCTIONS.put(Charset.class, x -> Charset.forName(x));
        PROPERTY_TO_ENV = new ConcurrentHashMap();
    }
}

