/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.juneau.BasicRuntimeException;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.common.internal.ThrowableUtils;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.ConverterUtils;
import org.apache.juneau.parser.ParseException;

public final class MapBuilder<K, V> {
    private Map<K, V> map;
    private boolean unmodifiable = false;
    private boolean sparse = false;
    private Comparator<K> comparator = null;
    private Class<K> keyType;
    private Class<V> valueType;
    private Type[] valueTypeArgs;

    public MapBuilder(Class<K> keyType, Class<V> valueType, Type ... valueTypeArgs) {
        this.keyType = keyType;
        this.valueType = valueType;
        this.valueTypeArgs = valueTypeArgs;
    }

    public MapBuilder(Map<K, V> addTo) {
        this.map = addTo;
    }

    public Map<K, V> build() {
        if (this.sparse) {
            if (this.map != null && this.map.isEmpty()) {
                this.map = null;
            }
        } else if (this.map == null) {
            this.map = new LinkedHashMap();
        }
        if (this.map != null) {
            if (this.comparator != null) {
                TreeMap<K, V> m2 = new TreeMap<K, V>(this.comparator);
                m2.putAll(this.map);
                this.map = m2;
            }
            if (this.unmodifiable) {
                this.map = Collections.unmodifiableMap(this.map);
            }
        }
        return this.map;
    }

    public MapBuilder<K, V> sparse() {
        this.sparse = true;
        return this;
    }

    public MapBuilder<K, V> unmodifiable() {
        this.unmodifiable = true;
        return this;
    }

    public MapBuilder<K, V> copy() {
        if (this.map != null) {
            this.map = new LinkedHashMap<K, V>(this.map);
        }
        return this;
    }

    public MapBuilder<K, V> sorted() {
        return this.sorted(Comparator.naturalOrder());
    }

    public MapBuilder<K, V> sorted(Comparator<K> comparator) {
        this.comparator = comparator;
        return this;
    }

    public MapBuilder<K, V> addAll(Map<K, V> value) {
        if (value != null) {
            if (this.map == null) {
                this.map = new LinkedHashMap<K, V>(value);
            } else {
                this.map.putAll(value);
            }
        }
        return this;
    }

    public MapBuilder<K, V> add(K key, V value) {
        if (this.map == null) {
            this.map = new LinkedHashMap();
        }
        this.map.put(key, value);
        return this;
    }

    public MapBuilder<K, V> addJson(String ... values) {
        return this.addAny(values);
    }

    public MapBuilder<K, V> addAny(Object ... values) {
        if (this.keyType == null || this.valueType == null) {
            throw new RuntimeException("Unknown key and value types.  Cannot use this method.");
        }
        try {
            for (Object o : values) {
                if (o == null) continue;
                if (o instanceof Map) {
                    ((Map)o).forEach((k, v) -> this.add(ConverterUtils.toType(k, this.keyType), ConverterUtils.toType(v, this.valueType, this.valueTypeArgs)));
                    continue;
                }
                if (StringUtils.isJsonObject(o, false)) {
                    JsonMap.ofJson(o.toString()).forEach((k, v) -> this.add(ConverterUtils.toType(k, this.keyType), ConverterUtils.toType(v, this.valueType, this.valueTypeArgs)));
                    continue;
                }
                throw new BasicRuntimeException("Invalid object type {0} passed to addAny()", ClassUtils.className(o));
            }
        }
        catch (ParseException e) {
            throw ThrowableUtils.asRuntimeException(e);
        }
        return this;
    }

    public MapBuilder<K, V> addPairs(Object ... pairs) {
        if (pairs.length % 2 != 0) {
            throw new RuntimeException("Odd number of parameters passed into AMap.ofPairs()");
        }
        for (int i = 0; i < pairs.length; i += 2) {
            this.add(pairs[i], pairs[i + 1]);
        }
        return this;
    }
}

