/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.juneau.common.internal.ArgUtils;
import org.apache.juneau.common.internal.StringUtils;

public final class ArrayUtils {
    public static <T> T[] append(T[] array, T ... newElements) {
        int i;
        if (array == null) {
            return newElements;
        }
        if (newElements.length == 0) {
            return array;
        }
        Object[] a = (Object[])Array.newInstance(array.getClass().getComponentType(), array.length + newElements.length);
        for (i = 0; i < array.length; ++i) {
            a[i] = array[i];
        }
        for (i = 0; i < newElements.length; ++i) {
            a[i + array.length] = newElements[i];
        }
        return a;
    }

    public static <E> E[] combine(E[] ... arrays) {
        ArgUtils.assertArgNotNull("arrays", arrays);
        int l = 0;
        E[] a1 = null;
        for (E[] a : arrays) {
            if (a1 == null && a != null) {
                a1 = a;
            }
            l += a == null ? 0 : a.length;
        }
        if (a1 == null) {
            return null;
        }
        Object[] a = (Object[])Array.newInstance(a1.getClass().getComponentType(), l);
        int i = 0;
        for (E[] aa : arrays) {
            if (aa == null) continue;
            for (E t : aa) {
                a[i++] = t;
            }
        }
        return a;
    }

    public static <T> Set<T> asSet(final T[] array) {
        ArgUtils.assertArgNotNull("array", array);
        return new AbstractSet<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    int i = 0;

                    @Override
                    public boolean hasNext() {
                        return this.i < array.length;
                    }

                    @Override
                    public T next() {
                        if (this.i >= array.length) {
                            throw new NoSuchElementException();
                        }
                        Object t = array[this.i];
                        ++this.i;
                        return t;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Not supported.");
                    }
                };
            }

            @Override
            public int size() {
                return array.length;
            }
        };
    }

    public static <E> Object toArray(Collection<?> c, Class<E> elementType) {
        Object a = Array.newInstance(elementType, c.size());
        Iterator<?> it = c.iterator();
        int i = 0;
        while (it.hasNext()) {
            Array.set(a, i++, it.next());
        }
        return a;
    }

    public static boolean isArray(Object array) {
        return array != null && array.getClass().isArray();
    }

    public static <E> List<E> toList(Object array, Class<E> elementType) {
        ArrayList<Object> l = new ArrayList<Object>(Array.getLength(array));
        for (int i = 0; i < Array.getLength(array); ++i) {
            l.add(Array.get(array, i));
        }
        return l;
    }

    public static List<Object> toObjectList(Object array) {
        ArrayList<Object> l = new ArrayList<Object>(Array.getLength(array));
        for (int i = 0; i < Array.getLength(array); ++i) {
            List<Object> o = Array.get(array, i);
            if (o != null && o.getClass().isArray()) {
                o = ArrayUtils.toObjectList(o);
            }
            l.add(o);
        }
        return l;
    }

    public static List copyToList(Object array, List list) {
        if (array != null) {
            int length = Array.getLength(array);
            for (int i = 0; i < length; ++i) {
                list.add(Array.get(array, i));
            }
        }
        return list;
    }

    public static boolean contains(String element, String[] array) {
        return ArrayUtils.indexOf(element, array) != -1;
    }

    public static int indexOf(String element, String[] array) {
        if (element == null || array == null) {
            return -1;
        }
        for (int i = 0; i < array.length; ++i) {
            if (!element.equals(array[i])) continue;
            return i;
        }
        return -1;
    }

    public static String[] toStringArray(Collection<?> c) {
        String[] r = new String[c.size()];
        int i = 0;
        for (Object o : c) {
            r[i++] = StringUtils.stringify(o);
        }
        return r;
    }

    public static boolean equals(String[] a1, String[] a2) {
        if (a1.length != a2.length) {
            return false;
        }
        for (int i = 0; i < a1.length; ++i) {
            if (StringUtils.eq(a1[i], a2[i])) continue;
            return false;
        }
        return true;
    }

    public static <T> T[] copyOf(T[] array) {
        return array == null ? null : Arrays.copyOf(array, array.length);
    }

    public static final boolean isNotEmptyArray(Object[] array) {
        return array != null && array.length > 0;
    }

    public static final boolean isEmptyArray(Object[] array) {
        return array == null || array.length == 0;
    }

    public static final boolean isEmptyArray(Object[] array1, Object[] array2) {
        return ArrayUtils.isEmptyArray(array1) && ArrayUtils.isEmptyArray(array2);
    }

    public static final <E> E[] reverse(E[] array) {
        for (int i = 0; i < array.length / 2; ++i) {
            E temp = array[i];
            array[i] = array[array.length - i - 1];
            array[array.length - i - 1] = temp;
        }
        return array;
    }
}

