/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.config.event;

import java.util.List;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.config.event.ConfigEventType;

public class ConfigEvent {
    private final ConfigEventType type;
    private final String config;
    private final String section;
    private final String key;
    private final String value;
    private final String comment;
    private final List<String> preLines;
    private final String modifiers;

    private ConfigEvent(ConfigEventType type, String config, String section, String key, String value, String modifiers, String comment, List<String> preLines) {
        this.type = type;
        this.config = config;
        this.section = section;
        this.key = key;
        this.value = value;
        this.comment = comment;
        this.preLines = preLines;
        this.modifiers = modifiers;
    }

    public static ConfigEvent setEntry(String config, String section, String key, String value, String modifiers, String comment, List<String> prelines) {
        return new ConfigEvent(ConfigEventType.SET_ENTRY, config, section, key, value, modifiers, comment, prelines);
    }

    public static ConfigEvent removeEntry(String config, String section, String key) {
        return new ConfigEvent(ConfigEventType.REMOVE_ENTRY, config, section, key, null, null, null, null);
    }

    public static ConfigEvent setSection(String config, String section, List<String> prelines) {
        return new ConfigEvent(ConfigEventType.SET_SECTION, config, section, null, null, null, null, prelines);
    }

    public static ConfigEvent removeSection(String config, String section) {
        return new ConfigEvent(ConfigEventType.REMOVE_SECTION, config, section, null, null, null, null, null);
    }

    public ConfigEventType getType() {
        return this.type;
    }

    public String getConfig() {
        return this.config;
    }

    public String getSection() {
        return this.section;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public String getComment() {
        return this.comment;
    }

    public List<String> getPreLines() {
        return this.preLines;
    }

    public String getModifiers() {
        return this.modifiers;
    }

    public String toString() {
        switch (this.type) {
            case REMOVE_SECTION: {
                return "REMOVE_SECTION(" + this.section + ")";
            }
            case REMOVE_ENTRY: {
                return "REMOVE_ENTRY(" + this.section + (this.section.isEmpty() ? "" : "/") + this.key + ")";
            }
            case SET_SECTION: {
                return "SET_SECTION(" + this.section + ", preLines=" + StringUtils.join(this.preLines, '|') + ")";
            }
            case SET_ENTRY: {
                String val;
                StringBuilder out = new StringBuilder("SET(");
                out.append(this.section + (this.section.isEmpty() ? "" : "/") + this.key);
                if (this.modifiers != null) {
                    out.append(this.modifiers);
                }
                out.append(" = ");
                String string = val = this.value == null ? "null" : this.value;
                if (val.indexOf(10) != -1) {
                    val = val.replaceAll("(\\r?\\n)", "$1\t");
                }
                if (val.indexOf(35) != -1) {
                    val = val.replaceAll("#", "\\\\#");
                }
                out.append(val);
                if (StringUtils.isNotEmpty(this.comment)) {
                    out.append(" # ").append(this.comment);
                }
                out.append(')');
                return out.toString();
            }
        }
        return null;
    }
}

