/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.common.internal;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.apache.juneau.common.internal.FileReaderBuilder;
import org.apache.juneau.common.internal.FileWriterBuilder;
import org.apache.juneau.common.internal.SystemUtils;

public final class IOUtils {
    public static final Charset UTF8 = Charset.forName("UTF-8");
    public static final InputStream EMPTY_INPUT_STREAM = new InputStream(){

        @Override
        public int read() {
            return -1;
        }
    };
    private static final int BUFF_SIZE = 1024;
    private static final ThreadLocal<byte[]> BYTE_BUFFER_CACHE = Boolean.getBoolean("juneau.disableIoBufferReuse") ? null : new ThreadLocal();
    private static final ThreadLocal<char[]> CHAR_BUFFER_CACHE = Boolean.getBoolean("juneau.disableIoBufferReuse") ? null : new ThreadLocal();
    static final AtomicInteger BYTE_BUFFER_CACHE_HITS = new AtomicInteger();
    static final AtomicInteger BYTE_BUFFER_CACHE_MISSES = new AtomicInteger();
    static final AtomicInteger CHAR_BUFFER_CACHE_HITS = new AtomicInteger();
    static final AtomicInteger CHAR_BUFFER_CACHE_MISSES = new AtomicInteger();
    public static final Reader EMPTY_READER;

    public static long pipe(Reader in, File out) throws IOException {
        if (out == null || in == null) {
            return 0L;
        }
        try (Writer w = FileWriterBuilder.create(out).buffered().build();){
            long l = IOUtils.pipe(in, w);
            return l;
        }
    }

    public static long pipe(Reader in, Writer out) throws IOException {
        if (out == null || in == null) {
            return 0L;
        }
        long total = 0L;
        try (Reader in2 = in;){
            int readLen;
            char[] buffer = IOUtils.charBuffer(-1);
            while ((readLen = in.read(buffer)) != -1) {
                out.write(buffer, 0, readLen);
                total += (long)readLen;
            }
        }
        out.flush();
        return total;
    }

    public static long pipe(Reader in, Writer out, Consumer<IOException> onException) {
        try {
            return IOUtils.pipe(in, out);
        }
        catch (IOException e) {
            onException.accept(e);
            return -1L;
        }
    }

    public static long pipeLines(Reader in, Writer out) throws IOException {
        if (in == null || out == null) {
            return 0L;
        }
        long total = 0L;
        try (Reader in2 = in;
             Scanner s = new Scanner(in2);){
            while (s.hasNextLine()) {
                String l = s.nextLine();
                if (l == null) continue;
                out.write(l);
                out.write("\n");
                out.flush();
                total += (long)(l.length() + 1);
            }
        }
        return total;
    }

    public static long pipe(InputStream in, Writer out) throws IOException {
        if (in == null || out == null) {
            return 0L;
        }
        return IOUtils.pipe((Reader)new InputStreamReader(in, UTF8), out);
    }

    public static long pipe(InputStream in, Writer out, Consumer<IOException> onException) {
        try {
            if (in == null || out == null) {
                return 0L;
            }
            return IOUtils.pipe((Reader)new InputStreamReader(in, UTF8), out);
        }
        catch (IOException e) {
            onException.accept(e);
            return -2L;
        }
    }

    public static long pipe(InputStream in, OutputStream out) throws IOException {
        try (InputStream in2 = in;){
            long l = IOUtils.pipe(in, out, -1L);
            return l;
        }
    }

    public static long pipe(InputStream in, OutputStream out, Consumer<IOException> onException) {
        long l;
        block8: {
            InputStream in2 = in;
            try {
                l = IOUtils.pipe(in, out, -1L);
                if (in2 == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in2 != null) {
                        try {
                            in2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    onException.accept(e);
                    return -1L;
                }
            }
            in2.close();
        }
        return l;
    }

    public static long pipe(InputStream in, OutputStream out, long maxBytes) throws IOException {
        if (in == null || out == null) {
            return 0L;
        }
        byte[] buffer = IOUtils.byteBuffer((int)maxBytes);
        long total = 0L;
        if (maxBytes < 0L) {
            int readLen;
            while ((readLen = in.read(buffer)) != -1) {
                out.write(buffer, 0, readLen);
                total += (long)readLen;
            }
        } else {
            int readLen;
            for (long remaining = maxBytes; remaining > 0L && (readLen = in.read(buffer, 0, IOUtils.buffSize(remaining))) != -1; remaining -= (long)readLen) {
                out.write(buffer, 0, readLen);
                total += (long)readLen;
            }
        }
        out.flush();
        return total;
    }

    public static long pipe(Reader in, OutputStream out) throws IOException {
        if (in == null || out == null) {
            return 0L;
        }
        long total = 0L;
        try (Reader in2 = in;){
            int i;
            OutputStreamWriter osw = new OutputStreamWriter(out, UTF8);
            char[] b = IOUtils.charBuffer(-1);
            while ((i = in.read(b)) > 0) {
                total += (long)i;
                osw.write(b, 0, i);
            }
            osw.flush();
        }
        return total;
    }

    public static long pipe(Reader in, OutputStream out, Consumer<IOException> onException) {
        try {
            return IOUtils.pipe(in, out);
        }
        catch (IOException e) {
            onException.accept(e);
            return -1L;
        }
    }

    public static final long pipe(byte[] in, OutputStream out, int maxBytes) throws IOException {
        if (in == null || out == null) {
            return 0L;
        }
        int length = maxBytes < 0 || maxBytes > in.length ? in.length : maxBytes;
        out.write(in, 0, length);
        return length;
    }

    public static String read(Object in) throws IOException {
        if (in == null) {
            return null;
        }
        if (in instanceof Reader) {
            return IOUtils.read((Reader)in);
        }
        if (in instanceof InputStream) {
            return IOUtils.read((InputStream)in);
        }
        if (in instanceof File) {
            return IOUtils.read((File)in);
        }
        if (in instanceof byte[]) {
            return IOUtils.read((byte[])in);
        }
        throw new RuntimeException("Invalid type passed to read:  " + in.getClass().getName());
    }

    public static String read(byte[] in) {
        return IOUtils.read(in, UTF8);
    }

    public static String read(byte[] in, Charset charset) {
        if (in == null) {
            return null;
        }
        return new String(in, charset);
    }

    public static String read(File in) throws IOException {
        if (in == null || !in.exists()) {
            return null;
        }
        try (Reader r = FileReaderBuilder.create(in).build();){
            String string = IOUtils.read(r, in.length());
            return string;
        }
    }

    public static String read(Reader in) throws IOException {
        try (Reader in2 = in;){
            String string = IOUtils.read(in, -1L);
            return string;
        }
    }

    public static String read(Reader in, Consumer<IOException> onException) {
        String string;
        block8: {
            Reader in2 = in;
            try {
                string = IOUtils.read(in, -1L);
                if (in2 == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in2 != null) {
                        try {
                            in2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    onException.accept(e);
                    return null;
                }
            }
            in2.close();
        }
        return string;
    }

    public static String read(Reader in, long expectedLength) throws IOException {
        if (in == null) {
            return null;
        }
        try (Reader in2 = in;){
            StringBuilder sb = new StringBuilder(IOUtils.buffSize(expectedLength));
            char[] buf = IOUtils.charBuffer((int)expectedLength);
            int i = 0;
            while ((i = in2.read(buf)) != -1) {
                sb.append(buf, 0, i);
            }
            String string = sb.toString();
            return string;
        }
    }

    public static String read(InputStream in) throws IOException {
        return IOUtils.read(in, UTF8);
    }

    public static String read(InputStream in, Consumer<IOException> onException) {
        return IOUtils.read(in, UTF8, onException);
    }

    public static String read(InputStream in, Charset cs) throws IOException {
        if (in == null) {
            return null;
        }
        try (InputStreamReader isr = new InputStreamReader(in, cs);){
            String string = IOUtils.read(isr);
            return string;
        }
    }

    public static String read(InputStream in, Charset cs, Consumer<IOException> onException) {
        String string;
        if (in == null) {
            return null;
        }
        InputStreamReader isr = new InputStreamReader(in, cs);
        try {
            string = IOUtils.read(isr);
        }
        catch (Throwable throwable) {
            try {
                try {
                    isr.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                onException.accept(e);
                return null;
            }
        }
        isr.close();
        return string;
    }

    public static byte[] readBytes(InputStream in) throws IOException {
        try (InputStream in2 = in;){
            byte[] byArray = IOUtils.readBytes(in2, -1);
            return byArray;
        }
    }

    public static byte[] readBytes(InputStream in, int maxBytes) throws IOException {
        int nRead;
        if (in == null) {
            return new byte[0];
        }
        ByteArrayOutputStream buff = new ByteArrayOutputStream(IOUtils.buffSize(maxBytes));
        byte[] b = IOUtils.byteBuffer(maxBytes);
        while ((nRead = in.read(b, 0, b.length)) != -1) {
            buff.write(b, 0, nRead);
        }
        buff.flush();
        return buff.toByteArray();
    }

    public static byte[] readBytes(File in) throws IOException {
        return IOUtils.readBytes(in, -1);
    }

    public static byte[] readBytes(File in, int maxBytes) throws IOException {
        if (in == null || !in.exists() || !in.canRead()) {
            return new byte[0];
        }
        try (FileInputStream is = new FileInputStream(in);){
            byte[] byArray = IOUtils.readBytes(is, maxBytes);
            return byArray;
        }
    }

    public static byte[] readBytes(Reader in) throws IOException {
        if (in == null) {
            return new byte[0];
        }
        try (Reader in2 = in;){
            byte[] byArray = IOUtils.read(in2, -1L).getBytes();
            return byArray;
        }
    }

    public static Reader toBufferedReader(Reader r) {
        if (r == null || r instanceof BufferedReader || r instanceof StringReader) {
            return r;
        }
        return new BufferedReader(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long count(InputStream is) throws IOException {
        if (is == null) {
            return 0L;
        }
        long c = 0L;
        try {
            long i;
            while ((i = is.skip(1024L)) != 0L) {
                c += i;
            }
        }
        finally {
            is.close();
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long count(Reader r) throws IOException {
        if (r == null) {
            return 0L;
        }
        long c = 0L;
        try {
            long i;
            while ((i = r.skip(1024L)) != 0L) {
                c += i;
            }
        }
        finally {
            r.close();
        }
        return c;
    }

    public static void closeQuietly(InputStream is) {
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(OutputStream os) {
        try {
            if (os != null) {
                os.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(Reader r) {
        try {
            if (r != null) {
                r.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(Writer w) {
        try {
            if (w != null) {
                w.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(Object ... o) {
        for (Object o2 : o) {
            if (o2 instanceof InputStream) {
                IOUtils.closeQuietly((InputStream)o2);
            }
            if (o2 instanceof OutputStream) {
                IOUtils.closeQuietly((OutputStream)o2);
            }
            if (o2 instanceof Reader) {
                IOUtils.closeQuietly((Reader)o2);
            }
            if (!(o2 instanceof Writer)) continue;
            IOUtils.closeQuietly((Writer)o2);
        }
    }

    public static void flush(Object ... o) throws IOException {
        IOException ex = null;
        for (Object o2 : o) {
            try {
                if (o2 instanceof OutputStream) {
                    ((OutputStream)o2).flush();
                }
                if (!(o2 instanceof Writer)) continue;
                ((Writer)o2).flush();
            }
            catch (IOException e) {
                ex = e;
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    public static void close(Object ... o) throws IOException {
        IOException ex = null;
        for (Object o2 : o) {
            try {
                if (o2 instanceof InputStream) {
                    ((InputStream)o2).close();
                }
                if (o2 instanceof OutputStream) {
                    ((OutputStream)o2).close();
                }
                if (o2 instanceof Reader) {
                    ((Reader)o2).close();
                }
                if (!(o2 instanceof Writer)) continue;
                ((Writer)o2).close();
            }
            catch (IOException e) {
                ex = e;
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    public static String loadSystemResourceAsString(String name, String ... paths) throws IOException {
        for (String path : paths) {
            File f;
            File p = new File(path);
            if (!p.exists() || !(f = new File(p, name)).exists() || !f.canRead()) continue;
            return IOUtils.read(f);
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        for (String path : paths) {
            String n = ".".equals(path) ? name : path + "/" + name;
            try (InputStream is = cl.getResourceAsStream(n);){
                if (is != null) {
                    String string = IOUtils.read(is);
                    return string;
                }
            }
            is = ClassLoader.getSystemResourceAsStream(n);
            try {
                if (is == null) continue;
                String string = IOUtils.read(is);
                return string;
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        return null;
    }

    private static final byte[] byteBuffer(int maxBytes) {
        if (BYTE_BUFFER_CACHE != null) {
            byte[] x = BYTE_BUFFER_CACHE.get();
            if (x == null) {
                x = new byte[1024];
                BYTE_BUFFER_CACHE.set(x);
                BYTE_BUFFER_CACHE_MISSES.incrementAndGet();
            } else {
                BYTE_BUFFER_CACHE_HITS.incrementAndGet();
            }
            return x;
        }
        return new byte[IOUtils.buffSize(maxBytes)];
    }

    private static final char[] charBuffer(int maxChars) {
        if (CHAR_BUFFER_CACHE != null) {
            char[] x = CHAR_BUFFER_CACHE.get();
            if (x == null) {
                x = new char[1024];
                CHAR_BUFFER_CACHE.set(x);
                CHAR_BUFFER_CACHE_MISSES.incrementAndGet();
            } else {
                CHAR_BUFFER_CACHE_HITS.incrementAndGet();
            }
            return x;
        }
        return new char[IOUtils.buffSize(maxChars)];
    }

    private static final int buffSize(long max) {
        return max > 0L && max < 1024L ? (int)max : 1024;
    }

    static {
        SystemUtils.shutdownMessage(() -> "Byte buffer cache:  hits=" + BYTE_BUFFER_CACHE_HITS.get() + ", misses=" + BYTE_BUFFER_CACHE_MISSES);
        SystemUtils.shutdownMessage(() -> "Char buffer cache:  hits=" + CHAR_BUFFER_CACHE_HITS.get() + ", misses=" + CHAR_BUFFER_CACHE_MISSES);
        EMPTY_READER = new Reader(){

            @Override
            public int read() {
                return -1;
            }

            @Override
            public int read(char[] cbuf, int off, int len) throws IOException {
                return -1;
            }

            @Override
            public void close() throws IOException {
            }
        };
    }
}

