/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.common.internal;

import java.util.Arrays;

public final class AsciiSet {
    private final boolean[] store;

    public static AsciiSet create(String chars) {
        return new Builder().chars(chars).build();
    }

    public static Builder create() {
        return new Builder();
    }

    AsciiSet(boolean[] store) {
        this.store = Arrays.copyOf(store, store.length);
    }

    public Builder copy() {
        Builder b = new Builder();
        for (int i = 0; i < 128; ++i) {
            b.store[i] = this.store[i];
        }
        return b;
    }

    public boolean contains(char c) {
        if (c > '\u007f') {
            return false;
        }
        return this.store[c];
    }

    public boolean contains(int c) {
        if (c < 0 || c > 127) {
            return false;
        }
        return this.store[c];
    }

    public boolean contains(CharSequence s) {
        if (s == null) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (!this.contains(s.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public boolean containsOnly(String s) {
        if (s == null) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (this.contains(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static class Builder {
        final boolean[] store = new boolean[128];

        public Builder range(char start, char end) {
            for (char c = start; c <= end; c = (char)(c + '\u0001')) {
                if (c >= '\u0080') continue;
                this.store[c] = true;
            }
            return this;
        }

        public Builder ranges(String ... s) {
            for (String ss : s) {
                if (ss.length() != 3 || ss.charAt(1) != '-') {
                    throw new RuntimeException("Value passed to ranges() must be 3 characters");
                }
                this.range(ss.charAt(0), ss.charAt(2));
            }
            return this;
        }

        public Builder chars(String chars) {
            for (int i = 0; i < chars.length(); ++i) {
                char c = chars.charAt(i);
                if (c >= '\u0080') continue;
                this.store[c] = true;
            }
            return this;
        }

        public Builder chars(char ... chars) {
            for (int i = 0; i < chars.length; ++i) {
                if (chars[i] >= '\u0080') continue;
                this.store[chars[i]] = true;
            }
            return this;
        }

        public AsciiSet build() {
            return new AsciiSet(this.store);
        }
    }
}

