/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.io.IOException;
import java.net.URI;
import org.apache.juneau.UriContext;
import org.apache.juneau.UriRelativity;
import org.apache.juneau.UriResolution;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.common.internal.ThrowableUtils;

public class UriResolver {
    private final UriResolution resolution;
    private final UriRelativity relativity;
    private final String authority;
    private final String contextRoot;
    private final String servletPath;
    private final String pathInfo;
    private final String parentPath;

    public static UriResolver of(UriResolution resolution, UriRelativity relativity, UriContext uriContext) {
        return new UriResolver(resolution, relativity, uriContext);
    }

    public UriResolver(UriResolution resolution, UriRelativity relativity, UriContext uriContext) {
        this.resolution = resolution;
        this.relativity = relativity;
        this.authority = uriContext.authority;
        this.contextRoot = uriContext.contextRoot;
        this.servletPath = uriContext.servletPath;
        this.pathInfo = uriContext.pathInfo;
        this.parentPath = uriContext.parentPath;
    }

    public String resolve(Object uri) {
        return this.resolve(uri, this.resolution);
    }

    private String resolve(Object uri, UriResolution res) {
        String s = StringUtils.stringify(uri);
        if (StringUtils.isAbsoluteUri(s)) {
            return UriResolver.hasDotSegments(s) && res != UriResolution.NONE ? UriResolver.normalize(s) : s;
        }
        if (res == UriResolution.ROOT_RELATIVE && StringUtils.startsWith(s, '/')) {
            return UriResolver.hasDotSegments(s) ? UriResolver.normalize(s) : s;
        }
        if (res == UriResolution.NONE && !UriResolver.isSpecialUri(s)) {
            return s;
        }
        return this.append(new StringBuilder(), s).toString();
    }

    public String relativize(Object relativeTo, Object uri) {
        String r = this.resolve(relativeTo, UriResolution.ABSOLUTE);
        String s = this.resolve(uri, UriResolution.ABSOLUTE);
        return URI.create(r).relativize(URI.create(s)).toString();
    }

    public Appendable append(Appendable a, Object o) {
        try {
            Appendable a2;
            boolean needsNormalize;
            String uri = StringUtils.stringify(o);
            uri = StringUtils.nullIfEmpty(uri);
            boolean bl = needsNormalize = UriResolver.hasDotSegments(uri) && this.resolution != null;
            if (StringUtils.isAbsoluteUri(uri)) {
                return a.append(needsNormalize ? UriResolver.normalize(uri) : uri);
            }
            if (this.resolution == UriResolution.NONE && !UriResolver.isSpecialUri(uri)) {
                return a.append(StringUtils.emptyIfNull(uri));
            }
            if (this.resolution == UriResolution.ROOT_RELATIVE && StringUtils.startsWith(uri, '/')) {
                return a.append(needsNormalize ? UriResolver.normalize(uri) : uri);
            }
            Appendable appendable = a2 = needsNormalize ? new StringBuilder() : a;
            if (StringUtils.startsWith(uri, '/')) {
                if (this.authority != null) {
                    a2.append(this.authority);
                }
                if (uri.length() != 1) {
                    a2.append(uri);
                } else if (this.authority == null) {
                    a2.append('/');
                }
            } else if (uri != null && uri.startsWith("context:/")) {
                if (this.resolution == UriResolution.ABSOLUTE && this.authority != null) {
                    a2.append(this.authority);
                }
                if (this.contextRoot != null) {
                    a2.append('/').append(this.contextRoot);
                }
                if (uri.length() > 9) {
                    a2.append('/').append(uri.substring(9));
                } else if (this.contextRoot == null && (this.authority == null || this.resolution != UriResolution.ABSOLUTE)) {
                    a2.append('/');
                }
            } else if (uri != null && uri.startsWith("servlet:/")) {
                if (this.resolution == UriResolution.ABSOLUTE && this.authority != null) {
                    a2.append(this.authority);
                }
                if (this.contextRoot != null) {
                    a2.append('/').append(this.contextRoot);
                }
                if (this.servletPath != null) {
                    a2.append('/').append(this.servletPath);
                }
                if (uri.length() > 9) {
                    a2.append('/').append(uri.substring(9));
                } else if (this.servletPath == null && this.contextRoot == null && (this.authority == null || this.resolution != UriResolution.ABSOLUTE)) {
                    a2.append('/');
                }
            } else if (uri != null && uri.startsWith("request:/")) {
                if (this.resolution == UriResolution.ABSOLUTE && this.authority != null) {
                    a2.append(this.authority);
                }
                if (this.contextRoot != null) {
                    a2.append('/').append(this.contextRoot);
                }
                if (this.servletPath != null) {
                    a2.append('/').append(this.servletPath);
                }
                if (this.pathInfo != null) {
                    a2.append('/').append(this.pathInfo);
                }
                if (uri.length() > 9) {
                    a2.append('/').append(uri.substring(9));
                } else if (this.servletPath == null && this.contextRoot == null && this.pathInfo == null && (this.authority == null || this.resolution != UriResolution.ABSOLUTE)) {
                    a2.append('/');
                }
            } else {
                if (this.resolution == UriResolution.ABSOLUTE && this.authority != null) {
                    a2.append(this.authority);
                }
                if (this.contextRoot != null) {
                    a2.append('/').append(this.contextRoot);
                }
                if (this.servletPath != null) {
                    a2.append('/').append(this.servletPath);
                }
                if (this.relativity == UriRelativity.RESOURCE && uri != null) {
                    a2.append('/').append(uri);
                } else if (this.relativity == UriRelativity.PATH_INFO) {
                    if (uri == null) {
                        if (this.pathInfo != null) {
                            a2.append('/').append(this.pathInfo);
                        }
                    } else {
                        if (this.parentPath != null) {
                            a2.append('/').append(this.parentPath);
                        }
                        a2.append('/').append(uri);
                    }
                } else if (uri == null && this.contextRoot == null && this.servletPath == null && (this.authority == null || this.resolution != UriResolution.ABSOLUTE)) {
                    a2.append('/');
                }
            }
            if (needsNormalize) {
                a.append(UriResolver.normalize(a2.toString()));
            }
            return a;
        }
        catch (IOException e) {
            throw ThrowableUtils.asRuntimeException(e);
        }
    }

    private static boolean isSpecialUri(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        char c = s.charAt(0);
        if (c != 's' && c != 'c' && c != 'r') {
            return false;
        }
        return s.startsWith("servlet:/") || s.startsWith("context:/") || s.startsWith("request:/");
    }

    private static String normalize(String s) {
        if ((s = URI.create(s).normalize().toString()).length() > 1 && s.charAt(s.length() - 1) == '/') {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    private static boolean hasDotSegments(String s) {
        if (s == null) {
            return false;
        }
        for (int i = 0; i < s.length() - 1; ++i) {
            char c = s.charAt(i);
            if ((i != 0 || c != '/') && (c != '/' || s.charAt(i + 1) != '.')) continue;
            return true;
        }
        return false;
    }
}

