/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.util;

import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class BoundedServletInputStream
extends ServletInputStream {
    private final InputStream is;
    private final ServletInputStream sis;
    private long remain;

    public BoundedServletInputStream(InputStream is, long max) {
        this.is = is;
        this.sis = null;
        this.remain = max;
    }

    public BoundedServletInputStream(ServletInputStream sis, long max) {
        this.sis = sis;
        this.is = sis;
        this.remain = max;
    }

    public BoundedServletInputStream(byte[] b) {
        this(new ByteArrayInputStream(b), Long.MAX_VALUE);
    }

    public final int read() throws IOException {
        this.decrement();
        return this.is.read();
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        long numBytes = Math.min((long)len, this.remain);
        int r = this.is.read(b, off, (int)numBytes);
        if (r == -1) {
            return -1;
        }
        this.decrement(numBytes);
        return r;
    }

    public long skip(long n) throws IOException {
        long toSkip = Math.min(n, this.remain);
        long r = this.is.skip(toSkip);
        this.decrement(r);
        return r;
    }

    public int available() throws IOException {
        if (this.remain <= 0L) {
            return 0;
        }
        return this.is.available();
    }

    public synchronized void reset() throws IOException {
        this.is.reset();
    }

    public synchronized void mark(int limit) {
        this.is.mark(limit);
    }

    public boolean markSupported() {
        return this.is.markSupported();
    }

    public final void close() throws IOException {
        this.is.close();
    }

    public boolean isFinished() {
        return this.sis == null ? false : this.sis.isFinished();
    }

    public boolean isReady() {
        return this.sis == null ? true : this.sis.isReady();
    }

    public void setReadListener(ReadListener arg0) {
        if (this.sis != null) {
            this.sis.setReadListener(arg0);
        }
    }

    private void decrement() throws IOException {
        --this.remain;
        if (this.remain < 0L) {
            throw new IOException("Input limit exceeded.  See @Rest(maxInput).");
        }
    }

    private void decrement(long count) throws IOException {
        this.remain -= count;
        if (this.remain < 0L) {
            throw new IOException("Input limit exceeded.  See @Rest(maxInput).");
        }
    }
}

