/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.arg;

import java.lang.reflect.Type;
import org.apache.juneau.AnnotationWorkList;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.http.annotation.Path;
import org.apache.juneau.http.annotation.PathAnnotation;
import org.apache.juneau.httppart.HttpPartParser;
import org.apache.juneau.httppart.HttpPartParserSession;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.reflect.MethodInfo;
import org.apache.juneau.reflect.ParamInfo;
import org.apache.juneau.rest.RestOpSession;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.arg.ArgException;
import org.apache.juneau.rest.arg.RestOpArg;
import org.apache.juneau.rest.util.UrlPathMatcher;

public class PathArg
implements RestOpArg {
    private final HttpPartParser partParser;
    private final HttpPartSchema schema;
    private final String name;
    private final String def;
    private final Type type;

    public static PathArg create(ParamInfo paramInfo, AnnotationWorkList annotations, UrlPathMatcher pathMatcher) {
        if (paramInfo.hasAnnotation(Path.class) || paramInfo.getParameterType().hasAnnotation(Path.class)) {
            return new PathArg(paramInfo, annotations, pathMatcher);
        }
        return null;
    }

    protected PathArg(ParamInfo paramInfo, AnnotationWorkList annotations, UrlPathMatcher pathMatcher) {
        this.name = this.getName(paramInfo, pathMatcher);
        this.def = (String)PathAnnotation.findDef((ParamInfo)paramInfo).orElse(null);
        this.type = paramInfo.getParameterType().innerType();
        this.schema = HttpPartSchema.create(Path.class, (ParamInfo)paramInfo);
        Class pp = this.schema.getParser();
        this.partParser = pp != null ? (HttpPartParser)HttpPartParser.creator().type(pp).apply(annotations).create() : null;
    }

    private String getName(ParamInfo pi, UrlPathMatcher pathMatcher) {
        String p = (String)PathAnnotation.findName((ParamInfo)pi).orElse(null);
        if (p != null) {
            return p;
        }
        if (pathMatcher != null) {
            int idx = 0;
            int i = pi.getIndex();
            MethodInfo mi = pi.getMethod();
            for (int j = 0; j < i; ++j) {
                if (mi.getParam(i).getAnnotation(Path.class) == null) continue;
                ++idx;
            }
            String[] vars = pathMatcher.getVars();
            if (vars.length <= idx) {
                throw new ArgException(pi, "Number of attribute parameters exceeds the number of URL pattern variables", new Object[0]);
            }
            String idxs = String.valueOf(idx);
            for (int j = 0; j < vars.length; ++j) {
                if (!StringUtils.isNumeric((String)vars[j]) || !vars[j].equals(idxs)) continue;
                return vars[j];
            }
            return pathMatcher.getVars()[idx];
        }
        throw new ArgException(pi, "@Path used without name or value", new Object[0]);
    }

    @Override
    public Object resolve(RestOpSession opSession) throws Exception {
        RestRequest req = opSession.getRequest();
        if (this.name.equals("*")) {
            JsonMap m = new JsonMap();
            req.getPathParams().stream().forEach(x -> m.put(x.getName(), (Object)x.getValue()));
            return req.getBeanSession().convertToType((Object)m, this.type, new Type[0]);
        }
        HttpPartParserSession ps = this.partParser == null ? req.getPartParserSession() : this.partParser.getPartSession();
        return req.getPathParams().get(this.name).parser(ps).schema(this.schema).def(this.def).as(this.type, new Type[0]).orElse(null);
    }
}

