/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.client;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthSchemeProvider;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.BackoffManager;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ConnectionBackoffStrategy;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.UserTokenHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.InputStreamFactory;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Lookup;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.util.PublicSuffixMatcher;
import org.apache.http.cookie.CookieSpecProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.juneau.AnnotationWorkList;
import org.apache.juneau.BasicRuntimeException;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanContextable;
import org.apache.juneau.ConfigException;
import org.apache.juneau.Context;
import org.apache.juneau.DetailLevel;
import org.apache.juneau.ExecutableException;
import org.apache.juneau.MediaType;
import org.apache.juneau.PropertyNamer;
import org.apache.juneau.UriContext;
import org.apache.juneau.UriRelativity;
import org.apache.juneau.UriResolution;
import org.apache.juneau.Visibility;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.common.internal.ArgUtils;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.common.internal.ThrowableUtils;
import org.apache.juneau.cp.BeanCreator;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.html.HtmlDocSerializer;
import org.apache.juneau.html.HtmlParser;
import org.apache.juneau.html.HtmlSerializer;
import org.apache.juneau.html.HtmlStrippedDocSerializer;
import org.apache.juneau.http.HttpEntities;
import org.apache.juneau.http.HttpHeaders;
import org.apache.juneau.http.HttpMethod;
import org.apache.juneau.http.HttpParts;
import org.apache.juneau.http.header.Accept;
import org.apache.juneau.http.header.AcceptCharset;
import org.apache.juneau.http.header.ClientVersion;
import org.apache.juneau.http.header.ContentType;
import org.apache.juneau.http.header.Debug;
import org.apache.juneau.http.header.HeaderList;
import org.apache.juneau.http.header.NoTrace;
import org.apache.juneau.http.part.PartList;
import org.apache.juneau.http.remote.RemoteReturn;
import org.apache.juneau.http.remote.RrpcInterfaceMeta;
import org.apache.juneau.http.remote.RrpcInterfaceMethodMeta;
import org.apache.juneau.http.resource.HttpResource;
import org.apache.juneau.httppart.HttpPartCollectionFormat;
import org.apache.juneau.httppart.HttpPartFormat;
import org.apache.juneau.httppart.HttpPartParser;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.httppart.bean.RequestBeanMeta;
import org.apache.juneau.httppart.bean.RequestBeanPropertyMeta;
import org.apache.juneau.internal.Cache;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.FluentSetter;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.StateMachineState;
import org.apache.juneau.json.Json5Parser;
import org.apache.juneau.json.Json5Serializer;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.marshaller.Marshaller;
import org.apache.juneau.msgpack.MsgPackParser;
import org.apache.juneau.msgpack.MsgPackSerializer;
import org.apache.juneau.oapi.OpenApiParser;
import org.apache.juneau.oapi.OpenApiSerializer;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.parser.ParserSet;
import org.apache.juneau.plaintext.PlainTextParser;
import org.apache.juneau.plaintext.PlainTextSerializer;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.rest.client.BasicRestCallHandler;
import org.apache.juneau.rest.client.RestCallException;
import org.apache.juneau.rest.client.RestCallHandler;
import org.apache.juneau.rest.client.RestCallInterceptor;
import org.apache.juneau.rest.client.RestOperation;
import org.apache.juneau.rest.client.RestRequest;
import org.apache.juneau.rest.client.RestResponse;
import org.apache.juneau.rest.client.remote.RemoteMeta;
import org.apache.juneau.rest.client.remote.RemoteMetadataException;
import org.apache.juneau.rest.client.remote.RemoteOperationArg;
import org.apache.juneau.rest.client.remote.RemoteOperationMeta;
import org.apache.juneau.rest.client.remote.RemoteOperationReturn;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.serializer.SerializerSet;
import org.apache.juneau.swap.BeanInterceptor;
import org.apache.juneau.uon.ParamFormat;
import org.apache.juneau.uon.UonParser;
import org.apache.juneau.uon.UonSerializer;
import org.apache.juneau.urlencoding.UrlEncodingParser;
import org.apache.juneau.urlencoding.UrlEncodingSerializer;
import org.apache.juneau.utils.HashKey;
import org.apache.juneau.utils.ThrowingFunction;
import org.apache.juneau.xml.XmlParser;
import org.apache.juneau.xml.XmlSerializer;

public class RestClient
extends BeanContextable
implements HttpClient,
Closeable {
    private static final RestCallInterceptor[] EMPTY_REST_CALL_INTERCEPTORS = new RestCallInterceptor[0];
    final HeaderList headerData;
    final PartList queryData;
    final PartList formData;
    final PartList pathData;
    final CloseableHttpClient httpClient;
    private final HttpClientConnectionManager connectionManager;
    private final boolean keepHttpClientOpen;
    private final boolean detectLeaks;
    private final boolean skipEmptyHeaderData;
    private final boolean skipEmptyQueryData;
    private final boolean skipEmptyFormData;
    private final BeanStore beanStore;
    private final UrlEncodingSerializer urlEncodingSerializer;
    final HttpPartSerializer partSerializer;
    final HttpPartParser partParser;
    private final RestCallHandler callHandler;
    private final String rootUrl;
    private volatile boolean isClosed = false;
    private final StackTraceElement[] creationStack;
    private final Logger logger;
    final DetailLevel logRequests;
    final BiPredicate<RestRequest, RestResponse> logRequestsPredicate;
    final Level logRequestsLevel;
    final boolean ignoreErrors;
    private final boolean logToConsole;
    private final PrintStream console;
    private StackTraceElement[] closedStack;
    private static final ConcurrentHashMap<Class<?>, Context> requestContexts = new ConcurrentHashMap();
    final SerializerSet serializers;
    final ParserSet parsers;
    Predicate<Integer> errorCodes;
    final RestCallInterceptor[] interceptors;
    private final Map<Class<?>, HttpPartParser> partParsers = new ConcurrentHashMap();
    private final Map<Class<?>, HttpPartSerializer> partSerializers = new ConcurrentHashMap();
    private volatile ExecutorService executorService;
    private final boolean executorServiceShutdownOnClose;
    private static final BiPredicate<RestRequest, RestResponse> LOG_REQUESTS_PREDICATE_DEFAULT = (req, res) -> true;
    private Pattern absUrlPattern = Pattern.compile("^\\w+\\:\\/\\/.*");

    public static Builder create() {
        return new Builder();
    }

    public RestClient(Builder builder) {
        super((BeanContextable.Builder)builder);
        this.beanStore = builder.beanStore.addBean(RestClient.class, (Object)this);
        this.httpClient = builder.getHttpClient();
        this.headerData = builder.headers().copy();
        this.queryData = builder.queryData().copy();
        this.formData = builder.formData().copy();
        this.pathData = builder.pathData().copy();
        this.callHandler = (RestCallHandler)builder.callHandler().run();
        this.skipEmptyHeaderData = builder.skipEmptyHeaderData;
        this.skipEmptyQueryData = builder.skipEmptyQueryData;
        this.skipEmptyFormData = builder.skipEmptyFormData;
        this.rootUrl = builder.rootUrl;
        this.errorCodes = builder.errorCodes;
        this.connectionManager = builder.connectionManager;
        this.console = builder.console != null ? builder.console : System.err;
        this.executorService = builder.executorService;
        this.executorServiceShutdownOnClose = builder.executorServiceShutdownOnClose;
        this.ignoreErrors = builder.ignoreErrors;
        this.keepHttpClientOpen = builder.keepHttpClientOpen;
        this.detectLeaks = builder.detectLeaks;
        this.logger = builder.logger != null ? builder.logger : Logger.getLogger(RestClient.class.getName());
        boolean bl = this.logToConsole = builder.logToConsole || this.isDebug();
        DetailLevel detailLevel = builder.logRequests != null ? builder.logRequests : (this.logRequests = this.isDebug() ? DetailLevel.FULL : DetailLevel.NONE);
        this.logRequestsLevel = builder.logRequestsLevel != null ? builder.logRequestsLevel : (this.isDebug() ? Level.WARNING : Level.OFF);
        this.logRequestsPredicate = builder.logRequestsPredicate != null ? builder.logRequestsPredicate : LOG_REQUESTS_PREDICATE_DEFAULT;
        this.interceptors = builder.interceptors != null ? builder.interceptors.toArray(EMPTY_REST_CALL_INTERCEPTORS) : EMPTY_REST_CALL_INTERCEPTORS;
        this.serializers = (SerializerSet)builder.serializers().build();
        this.parsers = (ParserSet)builder.parsers().build();
        this.partSerializer = (HttpPartSerializer)builder.partSerializer().create();
        this.partParser = (HttpPartParser)builder.partParser().create();
        this.urlEncodingSerializer = builder.urlEncodingSerializer().build();
        this.creationStack = this.isDebug() ? Thread.currentThread().getStackTrace() : null;
        this.init();
    }

    public Builder copy() {
        throw new NoSuchMethodError("Not implemented.");
    }

    protected void init(Builder builder) {
    }

    protected void init() {
    }

    @Override
    public void close() throws IOException {
        this.isClosed = true;
        if (!this.keepHttpClientOpen) {
            this.httpClient.close();
        }
        if (this.executorService != null && this.executorServiceShutdownOnClose) {
            this.executorService.shutdown();
        }
        if (this.creationStack != null) {
            this.closedStack = Thread.currentThread().getStackTrace();
        }
    }

    public void closeQuietly() {
        this.isClosed = true;
        try {
            if (!this.keepHttpClientOpen) {
                this.httpClient.close();
            }
            if (this.executorService != null && this.executorServiceShutdownOnClose) {
                this.executorService.shutdown();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.creationStack != null) {
            this.closedStack = Thread.currentThread().getStackTrace();
        }
    }

    protected HttpResponse run(HttpHost target, HttpRequest request, HttpContext context) throws ClientProtocolException, IOException {
        return this.callHandler.run(target, request, context);
    }

    public RestRequest get(Object uri) throws RestCallException {
        return this.request(this.op("GET", uri, RestOperation.NO_BODY));
    }

    public RestRequest get() throws RestCallException {
        return this.request(this.op("GET", null, RestOperation.NO_BODY));
    }

    public RestRequest put(Object uri, Object body) throws RestCallException {
        return this.request(this.op("PUT", uri, body));
    }

    public RestRequest put(Object uri, String body, ContentType contentType) throws RestCallException {
        return this.request(this.op("PUT", uri, this.stringBody(body))).header((Header)contentType);
    }

    public RestRequest put(Object uri) throws RestCallException {
        return this.request(this.op("PUT", uri, RestOperation.NO_BODY));
    }

    public RestRequest post(Object uri, Object body) throws RestCallException {
        return this.request(this.op("POST", uri, body));
    }

    public RestRequest post(Object uri, String body, ContentType contentType) throws RestCallException {
        return this.request(this.op("POST", uri, this.stringBody(body))).header((Header)contentType);
    }

    public RestRequest post(Object uri) throws RestCallException {
        return this.request(this.op("POST", uri, RestOperation.NO_BODY));
    }

    public RestRequest delete(Object uri) throws RestCallException {
        return this.request(this.op("DELETE", uri, RestOperation.NO_BODY));
    }

    public RestRequest options(Object uri) throws RestCallException {
        return this.request(this.op("OPTIONS", uri, RestOperation.NO_BODY));
    }

    public RestRequest head(Object uri) throws RestCallException {
        return this.request(this.op("HEAD", uri, RestOperation.NO_BODY));
    }

    public RestRequest formPost(Object uri, Object body) throws RestCallException {
        RestRequest req = this.request(this.op("POST", uri, RestOperation.NO_BODY));
        try {
            if (body instanceof Supplier) {
                body = ((Supplier)body).get();
            }
            if (body instanceof NameValuePair) {
                return req.content(new UrlEncodedFormEntity(CollectionUtils.alist((Object[])new NameValuePair[]{(NameValuePair)body})));
            }
            if (body instanceof NameValuePair[]) {
                return req.content(new UrlEncodedFormEntity(CollectionUtils.alist((Object[])((NameValuePair[])body))));
            }
            if (body instanceof PartList) {
                return req.content(new UrlEncodedFormEntity((List)((PartList)body)));
            }
            if (body instanceof HttpResource) {
                ((HttpResource)body).getHeaders().forEach(x -> req.header((Header)x));
            }
            if (body instanceof HttpEntity) {
                HttpEntity e = (HttpEntity)body;
                if (e.getContentType() == null) {
                    req.header((Header)ContentType.APPLICATION_FORM_URLENCODED);
                }
                return req.content(e);
            }
            if (body instanceof Reader || body instanceof InputStream) {
                return req.header((Header)ContentType.APPLICATION_FORM_URLENCODED).content(body);
            }
            return req.content(HttpEntities.serializedEntity((Object)body, (Serializer)this.urlEncodingSerializer, null));
        }
        catch (IOException e) {
            throw new RestCallException(null, e, "Could not read form post body.", new Object[0]);
        }
    }

    public RestRequest formPost(Object uri) throws RestCallException {
        return this.request(this.op("POST", uri, RestOperation.NO_BODY));
    }

    public RestRequest formPostPairs(Object uri, String ... parameters) throws RestCallException {
        return this.formPost(uri, HttpParts.partList((String[])parameters));
    }

    public RestRequest patch(Object uri, Object body) throws RestCallException {
        return this.request(this.op("PATCH", uri, body));
    }

    public RestRequest patch(Object uri, String body, ContentType contentType) throws RestCallException {
        return this.request(this.op("PATCH", uri, this.stringBody(body))).header((Header)contentType);
    }

    public RestRequest patch(Object uri) throws RestCallException {
        return this.request(this.op("PATCH", uri, RestOperation.NO_BODY));
    }

    public RestRequest callback(String callString) throws RestCallException {
        callString = StringUtils.emptyIfNull((String)callString);
        StateMachineState state = StateMachineState.S01;
        int mark = 0;
        String method = null;
        String headers = null;
        String uri = null;
        String content = null;
        for (int i = 0; i < callString.length(); ++i) {
            char c = callString.charAt(i);
            if (state == StateMachineState.S01) {
                if (!Character.isWhitespace(c)) continue;
                method = callString.substring(mark, i);
                state = StateMachineState.S02;
                continue;
            }
            if (state == StateMachineState.S02) {
                if (Character.isWhitespace(c)) continue;
                mark = i;
                if (c == '{') {
                    state = StateMachineState.S03;
                    continue;
                }
                state = StateMachineState.S05;
                continue;
            }
            if (state == StateMachineState.S03) {
                if (c != '}') continue;
                headers = callString.substring(mark, i + 1);
                state = StateMachineState.S04;
                continue;
            }
            if (state == StateMachineState.S04) {
                if (Character.isWhitespace(c)) continue;
                mark = i;
                state = StateMachineState.S05;
                continue;
            }
            if (!Character.isWhitespace(c)) continue;
            uri = callString.substring(mark, i);
            content = callString.substring(i).trim();
            break;
        }
        if (state != StateMachineState.S05) {
            throw new RestCallException(null, null, "Invalid format for call string.  State={0}", state);
        }
        try {
            RestRequest req = this.request(method, (Object)uri, StringUtils.isNotEmpty(content));
            if (headers != null) {
                JsonMap.ofJson(headers).forEach((k, v) -> req.header((Header)HttpHeaders.stringHeader((String)k, (String)StringUtils.stringify((Object)v))));
            }
            if (StringUtils.isNotEmpty(content)) {
                req.contentString(content);
            }
            return req;
        }
        catch (ParseException e) {
            throw new RestCallException(null, e, "Invalid format for call string.", new Object[0]);
        }
    }

    public RestRequest request(String method, Object uri, Object body) throws RestCallException {
        return this.request(this.op(method, uri, body));
    }

    public RestRequest request(String method, Object uri) throws RestCallException {
        return this.request(this.op(method, uri, RestOperation.NO_BODY));
    }

    public RestRequest request(String method, Object uri, boolean hasBody) throws RestCallException {
        return this.request(this.op(method, uri, RestOperation.NO_BODY).hasContent(hasBody));
    }

    protected RestRequest request(RestOperation op) throws RestCallException {
        if (this.isClosed) {
            Exception e2 = null;
            if (this.closedStack != null) {
                e2 = new Exception("Creation stack:");
                e2.setStackTrace(this.closedStack);
                throw new RestCallException(null, e2, "RestClient.close() has already been called.  This client cannot be reused.", new Object[0]);
            }
            throw new RestCallException(null, null, "RestClient.close() has already been called.  This client cannot be reused.  Closed location stack trace can be displayed by setting the system property 'org.apache.juneau.rest.client2.RestClient.trackCreation' to true.", new Object[0]);
        }
        RestRequest req = this.createRequest(this.toURI(op.getUri(), this.rootUrl), op.getMethod(), op.hasContent());
        this.onCallInit(req);
        req.content(op.getContent());
        return req;
    }

    protected RestRequest createRequest(URI uri, String method, boolean hasBody) throws RestCallException {
        return new RestRequest(this, uri, method, hasBody);
    }

    protected RestResponse createResponse(RestRequest request, HttpResponse httpResponse, Parser parser) throws RestCallException {
        return new RestResponse(this, request, httpResponse, parser);
    }

    public <T> T getRemote(Class<T> interfaceClass) {
        return this.getRemote(interfaceClass, null);
    }

    public <T> T getRemote(Class<T> interfaceClass, Object rootUrl) {
        return this.getRemote(interfaceClass, rootUrl, null, null);
    }

    public <T> T getRemote(final Class<T> interfaceClass, Object rootUrl, final Serializer serializer, final Parser parser) {
        if (rootUrl == null) {
            rootUrl = this.rootUrl;
        }
        final String restUrl2 = StringUtils.trimSlashes((String)StringUtils.emptyIfNull((Object)rootUrl));
        return (T)Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, new InvocationHandler(){
            final RemoteMeta rm;
            {
                this.rm = new RemoteMeta(interfaceClass);
            }

            @Override
            public Object invoke(Object proxy, final Method method, Object[] args) throws Throwable {
                final RemoteOperationMeta rom = this.rm.getOperationMeta(method);
                Object uri = rom.getFullPath();
                if (((String)uri).indexOf("://") == -1) {
                    uri = restUrl2 + "/" + (String)uri;
                }
                if (((String)uri).indexOf("://") == -1) {
                    throw new RemoteMetadataException(interfaceClass, "Root URI has not been specified.  Cannot construct absolute path to remote resource.", new Object[0]);
                }
                String httpMethod = rom.getHttpMethod();
                final RestRequest rc = RestClient.this.request(httpMethod, uri, HttpMethod.hasContent((String)httpMethod));
                rc.serializer(serializer);
                rc.parser(parser);
                this.rm.getHeaders().forEach(x -> rc.header((Header)x));
                rom.forEachPathArg(a -> rc.pathArg(a.getName(), args[a.getIndex()], a.getSchema(), a.getSerializer().orElse(RestClient.this.partSerializer)));
                rom.forEachQueryArg(a -> rc.queryArg(a.getName(), args[a.getIndex()], a.getSchema(), a.getSerializer().orElse(RestClient.this.partSerializer), a.isSkipIfEmpty()));
                rom.forEachFormDataArg(a -> rc.formDataArg(a.getName(), args[a.getIndex()], a.getSchema(), a.getSerializer().orElse(RestClient.this.partSerializer), a.isSkipIfEmpty()));
                rom.forEachHeaderArg(a -> rc.headerArg(a.getName(), args[a.getIndex()], a.getSchema(), a.getSerializer().orElse(RestClient.this.partSerializer), a.isSkipIfEmpty()));
                RemoteOperationArg ba = rom.getContentArg();
                if (ba != null) {
                    rc.content(args[ba.getIndex()], ba.getSchema());
                }
                rom.forEachRequestArg(rmba -> {
                    RequestBeanMeta rbm = rmba.getMeta();
                    Object bean = args[rmba.getIndex()];
                    if (bean != null) {
                        for (RequestBeanPropertyMeta p : rbm.getProperties()) {
                            Object val = ThrowableUtils.safeSupplier(() -> p.getGetter().invoke(bean, new Object[0]));
                            HttpPartType pt = p.getPartType();
                            String pn = p.getPartName();
                            HttpPartSchema schema = p.getSchema();
                            if (pt == HttpPartType.PATH) {
                                rc.pathArg(pn, val, schema, p.getSerializer().orElse(RestClient.this.partSerializer));
                                continue;
                            }
                            if (val == null) continue;
                            if (pt == HttpPartType.QUERY) {
                                rc.queryArg(pn, val, schema, p.getSerializer().orElse(RestClient.this.partSerializer), schema.isSkipIfEmpty());
                                continue;
                            }
                            if (pt == HttpPartType.FORMDATA) {
                                rc.formDataArg(pn, val, schema, p.getSerializer().orElse(RestClient.this.partSerializer), schema.isSkipIfEmpty());
                                continue;
                            }
                            if (pt == HttpPartType.HEADER) {
                                rc.headerArg(pn, val, schema, p.getSerializer().orElse(RestClient.this.partSerializer), schema.isSkipIfEmpty());
                                continue;
                            }
                            rc.content(val, schema);
                        }
                    }
                });
                RemoteOperationReturn ror = rom.getReturns();
                if (ror.isFuture()) {
                    return RestClient.this.getExecutorService().submit(new Callable<Object>(){

                        @Override
                        public Object call() throws Exception {
                            try {
                                return RestClient.this.executeRemote(interfaceClass, rc, method, rom);
                            }
                            catch (Exception e) {
                                throw e;
                            }
                            catch (Throwable e) {
                                throw ThrowableUtils.asRuntimeException((Throwable)e);
                            }
                        }
                    });
                }
                if (ror.isCompletableFuture()) {
                    final CompletableFuture cf = new CompletableFuture();
                    RestClient.this.getExecutorService().submit(new Callable<Object>(){

                        @Override
                        public Object call() throws Exception {
                            try {
                                cf.complete(RestClient.this.executeRemote(interfaceClass, rc, method, rom));
                            }
                            catch (Throwable e) {
                                cf.completeExceptionally(e);
                            }
                            return null;
                        }
                    });
                    return cf;
                }
                return RestClient.this.executeRemote(interfaceClass, rc, method, rom);
            }
        });
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Object executeRemote(Class<?> interfaceClass, RestRequest rc, Method method, RemoteOperationMeta rom) throws Throwable {
        RemoteOperationReturn ror = rom.getReturns();
        try {
            void var6_12;
            Object var6_6 = null;
            RestResponse res = null;
            rc.rethrow(RuntimeException.class);
            rom.forEachException(x -> rc.rethrow((Class<?>)x));
            if (ror.getReturnValue() == RemoteReturn.NONE) {
                res = rc.complete();
                return var6_12;
            } else if (ror.getReturnValue() == RemoteReturn.STATUS) {
                res = rc.complete();
                int returnCode = res.getStatusCode();
                Class<?> clazz = method.getReturnType();
                if (clazz == Integer.class || clazz == Integer.TYPE) {
                    Integer n = returnCode;
                    return var6_12;
                } else {
                    if (clazz != Boolean.class && clazz != Boolean.TYPE) throw new RestCallException(res, null, "Invalid return type on method annotated with @RemoteOp(returns=RemoteReturn.STATUS).  Only integer and booleans types are valid.", new Object[0]);
                    Boolean bl = returnCode < 400;
                }
                return var6_12;
            } else if (ror.getReturnValue() == RemoteReturn.BEAN) {
                rc.ignoreErrors();
                res = rc.run();
                Object t = res.as(ror.getResponseBeanMeta());
                return var6_12;
            } else {
                void var9_22;
                Object t;
                Class<?> rt = method.getReturnType();
                if (Throwable.class.isAssignableFrom(rt)) {
                    rc.ignoreErrors();
                }
                if ((t = (res = rc.run()).getContent().as(ror.getReturnType(), new Type[0])) == null && rt.isPrimitive()) {
                    Object object = ClassInfo.of(rt).getPrimitiveDefault();
                }
                void var6_11 = var9_22;
            }
            return var6_12;
        }
        catch (RestCallException restCallException) {
            Throwable t = restCallException.getCause();
            if (t instanceof RuntimeException) {
                throw t;
            }
            for (Class<?> t2 : method.getExceptionTypes()) {
                if (!t2.isInstance(t)) continue;
                throw t;
            }
            throw ThrowableUtils.asRuntimeException((Throwable)((Object)restCallException));
        }
    }

    public <T> T getRrpcInterface(Class<T> interfaceClass) {
        return this.getRrpcInterface(interfaceClass, null);
    }

    public <T> T getRrpcInterface(Class<T> interfaceClass, Object uri) {
        return this.getRrpcInterface(interfaceClass, uri, null, null);
    }

    public <T> T getRrpcInterface(final Class<T> interfaceClass, Object uri, final Serializer serializer, Parser parser) {
        if (uri == null) {
            RrpcInterfaceMeta rm = new RrpcInterfaceMeta(interfaceClass, "");
            Object path = rm.getPath();
            if (((String)path).indexOf("://") == -1) {
                if (StringUtils.isEmpty((String)this.rootUrl)) {
                    throw new RemoteMetadataException(interfaceClass, "Root URI has not been specified.  Cannot construct absolute path to remote interface.", new Object[0]);
                }
                path = StringUtils.trimSlashes((String)this.rootUrl) + "/" + (String)path;
            }
            uri = path;
        }
        final String restUrl2 = StringUtils.stringify((Object)uri);
        return (T)Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, new InvocationHandler(){
            final RrpcInterfaceMeta rm;
            {
                this.rm = new RrpcInterfaceMeta(interfaceClass, restUrl2);
            }

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                RrpcInterfaceMethodMeta rim = this.rm.getMethodMeta(method);
                String uri = rim.getUri();
                RestResponse res = null;
                try {
                    RestRequest rc = RestClient.this.request("POST", (Object)uri, true).serializer(serializer).content(args).rethrow(RuntimeException.class).rethrow(method.getExceptionTypes());
                    res = rc.run();
                    Object v = res.getContent().as(method.getGenericReturnType(), new Type[0]);
                    if (v == null && method.getReturnType().isPrimitive()) {
                        v = ClassInfo.of(method.getReturnType()).getPrimitiveDefault();
                    }
                    return v;
                }
                catch (Throwable e) {
                    Throwable t;
                    if (e instanceof RestCallException && (t = e.getCause()) != null) {
                        e = t;
                    }
                    if (e instanceof RuntimeException) {
                        throw e;
                    }
                    for (Class<?> t2 : method.getExceptionTypes()) {
                        if (!t2.isInstance(e)) continue;
                        throw e;
                    }
                    throw ThrowableUtils.asRuntimeException((Throwable)e);
                }
            }
        });
    }

    protected void finalize() throws Throwable {
        if (this.detectLeaks && !this.isClosed && !this.keepHttpClientOpen) {
            StringBuilder sb = new StringBuilder("WARNING:  RestClient garbage collected before it was finalized.");
            if (this.creationStack != null) {
                sb.append("\nCreation Stack:");
                for (StackTraceElement e : this.creationStack) {
                    sb.append("\n\t" + e);
                }
            }
            this.log(Level.WARNING, sb.toString(), new Object[0]);
        }
    }

    protected void log(Level level, Throwable t, String msg, Object ... args) {
        this.logger.log(level, t, this.msg(msg, args));
        if (this.logToConsole) {
            this.console.println(this.msg(msg, args).get());
            if (t != null) {
                t.printStackTrace(this.console);
            }
        }
    }

    protected void log(Level level, String msg, Object ... args) {
        this.logger.log(level, this.msg(msg, args));
        if (this.logToConsole) {
            this.console.println(this.msg(msg, args).get());
        }
    }

    private Supplier<String> msg(String msg, Object ... args) {
        return () -> args.length == 0 ? msg : MessageFormat.format(msg, args);
    }

    protected HttpPartSerializer getPartSerializer() {
        return this.partSerializer;
    }

    protected HttpPartParser getPartParser() {
        return this.partParser;
    }

    protected HttpPartSerializer getPartSerializer(Class<? extends HttpPartSerializer> c) {
        HttpPartSerializer x = this.partSerializers.get(c);
        if (x == null) {
            try {
                x = (HttpPartSerializer)this.beanStore.createBean(c).run();
            }
            catch (ExecutableException e) {
                throw ThrowableUtils.asRuntimeException((Throwable)e);
            }
            this.partSerializers.put(c, x);
        }
        return x;
    }

    protected HttpPartParser getPartParser(Class<? extends HttpPartParser> c) {
        HttpPartParser x = this.partParsers.get(c);
        if (x == null) {
            try {
                x = (HttpPartParser)this.beanStore.createBean(c).run();
            }
            catch (ExecutableException e) {
                throw ThrowableUtils.asRuntimeException((Throwable)e);
            }
            this.partParsers.put(c, x);
        }
        return x;
    }

    protected boolean isSkipEmptyHeaderData() {
        return this.skipEmptyHeaderData;
    }

    protected boolean isSkipEmptyQueryData() {
        return this.skipEmptyQueryData;
    }

    protected boolean isSkipEmptyFormData() {
        return this.skipEmptyFormData;
    }

    public HeaderList createHeaderData() {
        return this.headerData.copy();
    }

    public PartList createQueryData() {
        return this.queryData.copy();
    }

    public PartList createFormData() {
        return this.formData.copy();
    }

    public PartList createPathData() {
        return this.pathData.copy();
    }

    protected void onCallInit(RestRequest req) throws RestCallException {
        try {
            for (RestCallInterceptor rci : this.interceptors) {
                rci.onInit(req);
            }
        }
        catch (RuntimeException | RestCallException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RestCallException(null, e, "Interceptor threw an exception on init.", new Object[0]);
        }
    }

    protected void onCallConnect(RestRequest req, RestResponse res) throws RestCallException {
        try {
            for (RestCallInterceptor rci : this.interceptors) {
                rci.onConnect(req, res);
            }
        }
        catch (RuntimeException | RestCallException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RestCallException(res, e, "Interceptor threw an exception on connect.", new Object[0]);
        }
    }

    protected void onCallClose(RestRequest req, RestResponse res) throws RestCallException {
        try {
            for (RestCallInterceptor rci : this.interceptors) {
                rci.onClose(req, res);
            }
        }
        catch (RuntimeException | RestCallException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RestCallException(res, e, "Interceptor threw an exception on close.", new Object[0]);
        }
    }

    @Deprecated
    public HttpParams getParams() {
        return this.httpClient.getParams();
    }

    @Deprecated
    public ClientConnectionManager getConnectionManager() {
        return this.httpClient.getConnectionManager();
    }

    public HttpClientConnectionManager getHttpClientConnectionManager() {
        return this.connectionManager;
    }

    public HttpResponse execute(HttpUriRequest request) throws IOException, ClientProtocolException {
        return this.httpClient.execute(request);
    }

    public HttpResponse execute(HttpUriRequest request, HttpContext context) throws IOException, ClientProtocolException {
        return this.httpClient.execute(request, context);
    }

    public HttpResponse execute(HttpHost target, HttpRequest request) throws IOException, ClientProtocolException {
        return this.httpClient.execute(target, request);
    }

    public HttpResponse execute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
        return this.httpClient.execute(target, request, context);
    }

    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        return (T)this.httpClient.execute(request, responseHandler);
    }

    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
        return (T)this.httpClient.execute(request, responseHandler, context);
    }

    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        return (T)this.httpClient.execute(target, request, responseHandler);
    }

    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
        return (T)this.httpClient.execute(target, request, responseHandler, context);
    }

    URI toURI(Object x, String rootUrl) throws RestCallException {
        try {
            String s;
            if (x instanceof URI) {
                return (URI)x;
            }
            if (x instanceof URL) {
                ((URL)x).toURI();
            }
            if (x instanceof URIBuilder) {
                return ((URIBuilder)x).build();
            }
            String string = s = x == null ? "" : x.toString();
            if (rootUrl != null && !this.absUrlPattern.matcher(s).matches()) {
                if (s.isEmpty()) {
                    s = rootUrl;
                } else {
                    StringBuilder sb = new StringBuilder(rootUrl);
                    if (!s.startsWith("/")) {
                        sb.append('/');
                    }
                    sb.append(s);
                    s = sb.toString();
                }
            }
            s = StringUtils.fixUrl((String)s);
            return new URI(s);
        }
        catch (URISyntaxException e) {
            throw new RestCallException(null, e, "Invalid URI encountered:  {0}", x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ExecutorService getExecutorService() {
        if (this.executorService != null) {
            return this.executorService;
        }
        RestClient restClient = this;
        synchronized (restClient) {
            this.executorService = new ThreadPoolExecutor(1, 1, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(10));
            return this.executorService;
        }
    }

    Serializer getMatchingSerializer(String mediaType) {
        Serializer s;
        if (this.serializers.isEmpty()) {
            return null;
        }
        if (mediaType != null && (s = this.serializers.getSerializer(mediaType)) != null) {
            return s;
        }
        List l = this.serializers.getSerializers();
        return l.size() == 1 ? (Serializer)l.get(0) : null;
    }

    boolean hasSerializers() {
        return !this.serializers.getSerializers().isEmpty();
    }

    Parser getMatchingParser(String mediaType) {
        Parser p;
        if (this.parsers.isEmpty()) {
            return null;
        }
        if (mediaType != null && (p = this.parsers.getParser(mediaType)) != null) {
            return p;
        }
        List l = this.parsers.getParsers();
        return l.size() == 1 ? (Parser)l.get(0) : null;
    }

    boolean hasParsers() {
        return !this.parsers.getParsers().isEmpty();
    }

    <T extends Context> T getInstance(Class<T> c) {
        Context o = requestContexts.get(c);
        if (o == null) {
            if (Serializer.class.isAssignableFrom(c)) {
                o = Serializer.createSerializerBuilder(c).beanContext(this.getBeanContext()).build();
            } else if (Parser.class.isAssignableFrom(c)) {
                o = Parser.createParserBuilder(c).beanContext(this.getBeanContext()).build();
            }
            requestContexts.put(c, o);
        }
        return (T)o;
    }

    private RestOperation op(String method, Object url, Object body) {
        return RestOperation.of(method, url, body);
    }

    private Reader stringBody(String body) {
        return body == null ? null : new StringReader(StringUtils.stringify((Object)body));
    }

    protected JsonMap properties() {
        return JsonMap.filteredMap().append("errorCodes", this.errorCodes).append("executorService", (Object)this.executorService).append("executorServiceShutdownOnClose", (Object)this.executorServiceShutdownOnClose).append("headerData", (Object)this.headerData).append("interceptors", (Object)this.interceptors).append("keepHttpClientOpen", (Object)this.keepHttpClientOpen).append("partParser", (Object)this.partParser).append("partSerializer", (Object)this.partSerializer).append("queryData", (Object)this.queryData).append("rootUrl", (Object)this.rootUrl);
    }

    @FluentSetters(ignore={"beanMapPutReturnsOldValue", "example", "exampleJson", "debug", "mediaType"})
    public static class Builder
    extends BeanContextable.Builder {
        BeanStore beanStore = BeanStore.create().build();
        private HttpClientBuilder httpClientBuilder;
        private CloseableHttpClient httpClient;
        private HeaderList headerData;
        private PartList queryData;
        private PartList formData;
        private PartList pathData;
        private BeanCreator<RestCallHandler> callHandler;
        private SerializerSet.Builder serializers;
        private ParserSet.Builder parsers;
        private HttpPartSerializer.Creator partSerializer;
        private HttpPartParser.Creator partParser;
        private UrlEncodingSerializer.Builder urlEncodingSerializer;
        private boolean pooled;
        String rootUrl;
        boolean skipEmptyHeaderData;
        boolean skipEmptyFormData;
        boolean skipEmptyQueryData;
        boolean executorServiceShutdownOnClose;
        boolean ignoreErrors;
        boolean keepHttpClientOpen;
        boolean detectLeaks;
        boolean logToConsole;
        Logger logger;
        DetailLevel logRequests;
        Level logRequestsLevel;
        BiPredicate<RestRequest, RestResponse> logRequestsPredicate;
        Predicate<Integer> errorCodes = x -> x <= 0 || x >= 400;
        HttpClientConnectionManager connectionManager;
        PrintStream console;
        ExecutorService executorService;
        List<RestCallInterceptor> interceptors;

        protected Builder() {
        }

        public Builder copy() {
            throw new NoSuchMethodError("Not implemented.");
        }

        public RestClient build() {
            return (RestClient)this.build(RestClient.class);
        }

        @FluentSetter
        public Builder json() {
            return this.serializer(JsonSerializer.class).parser(JsonParser.class);
        }

        @FluentSetter
        public Builder json5() {
            return this.serializer(Json5Serializer.class).parser(Json5Parser.class);
        }

        @FluentSetter
        public Builder xml() {
            return this.serializer(XmlSerializer.class).parser(XmlParser.class);
        }

        @FluentSetter
        public Builder html() {
            return this.serializer(HtmlSerializer.class).parser(HtmlParser.class);
        }

        @FluentSetter
        public Builder htmlDoc() {
            return this.serializer(HtmlDocSerializer.class).parser(HtmlParser.class);
        }

        @FluentSetter
        public Builder htmlStrippedDoc() {
            return this.serializer(HtmlStrippedDocSerializer.class).parser(HtmlParser.class);
        }

        @FluentSetter
        public Builder plainText() {
            return this.serializer(PlainTextSerializer.class).parser(PlainTextParser.class);
        }

        @FluentSetter
        public Builder msgPack() {
            return this.serializer(MsgPackSerializer.class).parser(MsgPackParser.class);
        }

        @FluentSetter
        public Builder uon() {
            return this.serializer(UonSerializer.class).parser(UonParser.class);
        }

        @FluentSetter
        public Builder urlEnc() {
            return this.serializer(UrlEncodingSerializer.class).parser(UrlEncodingParser.class);
        }

        @FluentSetter
        public Builder openApi() {
            return this.serializer(OpenApiSerializer.class).parser(OpenApiParser.class);
        }

        public Builder universal() {
            return this.serializers(JsonSerializer.class, Json5Serializer.class, HtmlSerializer.class, XmlSerializer.class, UonSerializer.class, UrlEncodingSerializer.class, OpenApiSerializer.class, MsgPackSerializer.class, PlainTextSerializer.class).parsers(JsonParser.class, Json5Parser.class, XmlParser.class, HtmlParser.class, UonParser.class, UrlEncodingParser.class, OpenApiParser.class, MsgPackParser.class, PlainTextParser.class);
        }

        public final HttpClientBuilder httpClientBuilder() {
            if (this.httpClientBuilder == null) {
                this.httpClientBuilder = this.createHttpClientBuilder();
            }
            return this.httpClientBuilder;
        }

        protected HttpClientBuilder createHttpClientBuilder() {
            return HttpClientBuilder.create();
        }

        @FluentSetter
        public Builder httpClientBuilder(HttpClientBuilder value) {
            this.httpClientBuilder = value;
            return this;
        }

        protected CloseableHttpClient createHttpClient() {
            if (this.connectionManager == null) {
                this.connectionManager = this.createConnectionManager();
            }
            this.httpClientBuilder().setConnectionManager(this.connectionManager);
            return this.httpClientBuilder().build();
        }

        @FluentSetter
        public Builder httpClient(CloseableHttpClient value) {
            this.httpClient = value;
            return this;
        }

        final CloseableHttpClient getHttpClient() {
            return this.httpClient != null ? this.httpClient : this.createHttpClient();
        }

        public final SerializerSet.Builder serializers() {
            if (this.serializers == null) {
                this.serializers = this.createSerializers();
            }
            return this.serializers;
        }

        protected SerializerSet.Builder createSerializers() {
            return SerializerSet.create().beanContext(this.beanContext());
        }

        @FluentSetter
        public Builder serializer(Class<? extends Serializer> value) {
            return this.serializers(value);
        }

        @FluentSetter
        public Builder serializer(Serializer value) {
            return this.serializers(value);
        }

        @FluentSetter
        public Builder serializers(Class<? extends Serializer> ... value) {
            this.serializers().add((Class[])value);
            return this;
        }

        @FluentSetter
        public Builder serializers(Serializer ... value) {
            this.serializers().add(value);
            return this;
        }

        public final ParserSet.Builder parsers() {
            if (this.parsers == null) {
                this.parsers = this.createParsers();
            }
            return this.parsers;
        }

        protected ParserSet.Builder createParsers() {
            return ParserSet.create().beanContext(this.beanContext());
        }

        @FluentSetter
        public Builder parser(Class<? extends Parser> value) {
            return this.parsers(value);
        }

        @FluentSetter
        public Builder parser(Parser value) {
            return this.parsers(value);
        }

        @FluentSetter
        public Builder parsers(Class<? extends Parser> ... value) {
            this.parsers().add((Class[])value);
            return this;
        }

        @FluentSetter
        public Builder parsers(Parser ... value) {
            this.parsers().add(value);
            return this;
        }

        public final HttpPartSerializer.Creator partSerializer() {
            if (this.partSerializer == null) {
                this.partSerializer = this.createPartSerializer();
            }
            return this.partSerializer;
        }

        protected HttpPartSerializer.Creator createPartSerializer() {
            return HttpPartSerializer.creator().type(OpenApiSerializer.class).beanContext(this.beanContext());
        }

        @FluentSetter
        public Builder partSerializer(Class<? extends HttpPartSerializer> value) {
            this.partSerializer().type(value);
            return this;
        }

        @FluentSetter
        public Builder partSerializer(HttpPartSerializer value) {
            this.partSerializer().impl((Object)value);
            return this;
        }

        public final HttpPartParser.Creator partParser() {
            if (this.partParser == null) {
                this.partParser = this.createPartParser();
            }
            return this.partParser;
        }

        protected HttpPartParser.Creator createPartParser() {
            return HttpPartParser.creator().type(OpenApiParser.class).beanContext(this.beanContext());
        }

        @FluentSetter
        public Builder partParser(Class<? extends HttpPartParser> value) {
            this.partParser().type(value);
            return this;
        }

        @FluentSetter
        public Builder partParser(HttpPartParser value) {
            this.partParser().impl((Object)value);
            return this;
        }

        public final UrlEncodingSerializer.Builder urlEncodingSerializer() {
            if (this.urlEncodingSerializer == null) {
                this.urlEncodingSerializer = this.createUrlEncodingSerializer();
            }
            return this.urlEncodingSerializer;
        }

        protected UrlEncodingSerializer.Builder createUrlEncodingSerializer() {
            return UrlEncodingSerializer.create().beanContext(this.beanContext());
        }

        public final HeaderList headers() {
            if (this.headerData == null) {
                this.headerData = this.createHeaderData();
            }
            return this.headerData;
        }

        protected HeaderList createHeaderData() {
            return HeaderList.create();
        }

        @FluentSetter
        public Builder headers(Header ... parts) {
            this.headers().append(parts);
            return this;
        }

        public Builder headersDefault(Header ... parts) {
            this.headers().setDefault(parts);
            return this;
        }

        @FluentSetter
        public Builder header(String name, String value) {
            this.headers().append(name, (Object)value);
            return this;
        }

        @FluentSetter
        public Builder header(String name, Supplier<String> value) {
            this.headers().append(name, value);
            return this;
        }

        @FluentSetter
        public Builder mediaType(String value) {
            super.mediaType(MediaType.of((String)value));
            return this.headers(new Header[]{Accept.of((String)value), ContentType.of((String)value)});
        }

        @FluentSetter
        public Builder mediaType(MediaType value) {
            super.mediaType(value);
            return this.headers(new Header[]{Accept.of((MediaType)value), ContentType.of((MediaType)value)});
        }

        @FluentSetter
        public Builder accept(String value) {
            return this.headers(new Header[]{Accept.of((String)value)});
        }

        @FluentSetter
        public Builder acceptCharset(String value) {
            return this.headers(new Header[]{AcceptCharset.of((String)value)});
        }

        @FluentSetter
        public Builder clientVersion(String value) {
            return this.headers(new Header[]{ClientVersion.of((String)value)});
        }

        @FluentSetter
        public Builder contentType(String value) {
            return this.headers(new Header[]{ContentType.of((String)value)});
        }

        @FluentSetter
        public Builder debug() {
            super.debug();
            this.serializers().forEach(x -> x.debug());
            return this.headers(new Header[]{Debug.TRUE});
        }

        @FluentSetter
        public Builder noTrace() {
            return this.headers(new Header[]{NoTrace.of((Boolean)true)});
        }

        public final PartList queryData() {
            if (this.queryData == null) {
                this.queryData = this.createQueryData();
            }
            return this.queryData;
        }

        protected PartList createQueryData() {
            return PartList.create();
        }

        @FluentSetter
        public Builder queryData(NameValuePair ... parts) {
            this.queryData().append(parts);
            return this;
        }

        public Builder queryDataDefault(NameValuePair ... parts) {
            this.queryData().setDefault(parts);
            return this;
        }

        @FluentSetter
        public Builder queryData(String name, String value) {
            this.queryData().append(name, (Object)value);
            return this;
        }

        @FluentSetter
        public Builder queryData(String name, Supplier<String> value) {
            this.queryData().append(name, value);
            return this;
        }

        public final PartList formData() {
            if (this.formData == null) {
                this.formData = this.createFormData();
            }
            return this.formData;
        }

        protected PartList createFormData() {
            return PartList.create();
        }

        @FluentSetter
        public Builder formData(NameValuePair ... parts) {
            this.formData().append(parts);
            return this;
        }

        public Builder formDataDefault(NameValuePair ... parts) {
            this.formData().setDefault(parts);
            return this;
        }

        @FluentSetter
        public Builder formData(String name, String value) {
            this.formData().append(name, (Object)value);
            return this;
        }

        @FluentSetter
        public Builder formData(String name, Supplier<String> value) {
            this.formData().append(name, value);
            return this;
        }

        public final PartList pathData() {
            if (this.pathData == null) {
                this.pathData = this.createPathData();
            }
            return this.pathData;
        }

        protected PartList createPathData() {
            return PartList.create();
        }

        @FluentSetter
        public Builder pathData(NameValuePair ... parts) {
            this.pathData().append(parts);
            return this;
        }

        public Builder pathDataDefault(NameValuePair ... parts) {
            this.pathData().setDefault(parts);
            return this;
        }

        @FluentSetter
        public Builder pathData(String name, String value) {
            this.pathData().append(name, (Object)value);
            return this;
        }

        @FluentSetter
        public Builder pathData(String name, Supplier<String> value) {
            this.pathData().set(name, value);
            return this;
        }

        public final BeanCreator<RestCallHandler> callHandler() {
            if (this.callHandler == null) {
                this.callHandler = this.createCallHandler();
            }
            return this.callHandler;
        }

        protected BeanCreator<RestCallHandler> createCallHandler() {
            return this.beanStore.createBean(RestCallHandler.class).type(BasicRestCallHandler.class);
        }

        @FluentSetter
        public Builder callHandler(Class<? extends RestCallHandler> value) {
            this.callHandler().type(value);
            return this;
        }

        @FluentSetter
        public Builder errorCodes(Predicate<Integer> value) {
            this.errorCodes = (Predicate)ArgUtils.assertArgNotNull((String)"value", value);
            return this;
        }

        @FluentSetter
        public Builder logger(Logger value) {
            this.logger = value;
            return this;
        }

        @FluentSetter
        public Builder logToConsole() {
            this.logToConsole = true;
            return this;
        }

        @FluentSetter
        public Builder logRequests(DetailLevel detail, Level level, BiPredicate<RestRequest, RestResponse> test) {
            this.logRequests = detail;
            this.logRequestsLevel = level;
            this.logRequestsPredicate = test;
            return this;
        }

        protected HttpClientConnectionManager createConnectionManager() {
            return this.pooled ? new PoolingHttpClientConnectionManager() : new BasicHttpClientConnectionManager();
        }

        @FluentSetter
        public Builder pooled() {
            this.pooled = true;
            return this;
        }

        @FluentSetter
        public Builder connectionManager(HttpClientConnectionManager value) {
            this.connectionManager = value;
            this.httpClientBuilder().setConnectionManager(value);
            return this;
        }

        @FluentSetter
        public Builder connectionManagerShared(boolean shared) {
            this.httpClientBuilder().setConnectionManagerShared(shared);
            return this;
        }

        @FluentSetter
        public Builder basicAuth(String host, int port, String user, String pw) {
            AuthScope scope = new AuthScope(host, port);
            UsernamePasswordCredentials up = new UsernamePasswordCredentials(user, pw);
            BasicCredentialsProvider p = new BasicCredentialsProvider();
            p.setCredentials(scope, (Credentials)up);
            this.defaultCredentialsProvider((CredentialsProvider)p);
            return this;
        }

        @FluentSetter
        public Builder console(PrintStream value) {
            this.console = value;
            return this;
        }

        @FluentSetter
        public Builder executorService(ExecutorService executorService, boolean shutdownOnClose) {
            this.executorService = executorService;
            this.executorServiceShutdownOnClose = shutdownOnClose;
            return this;
        }

        @FluentSetter
        public Builder keepHttpClientOpen() {
            this.keepHttpClientOpen = true;
            return this;
        }

        @FluentSetter
        public Builder ignoreErrors() {
            this.ignoreErrors = true;
            return this;
        }

        @FluentSetter
        public Builder interceptors(Class<?> ... values) throws Exception {
            for (Class<?> c : values) {
                ClassInfo ci = ClassInfo.of(c);
                if (ci == null) continue;
                if (ci.isChildOfAny(new Class[]{RestCallInterceptor.class, HttpRequestInterceptor.class, HttpResponseInterceptor.class})) {
                    this.interceptors(ci.newInstance());
                    continue;
                }
                throw new ConfigException("Invalid class of type ''{0}'' passed to interceptors().", new Object[]{ci.getName()});
            }
            return this;
        }

        @FluentSetter
        public Builder interceptors(Object ... value) {
            ArrayList l = CollectionUtils.list((Object[])new RestCallInterceptor[0]);
            for (Object o : value) {
                ClassInfo ci = ClassInfo.of((Object)o);
                if (ci == null) continue;
                if (!ci.isChildOfAny(new Class[]{HttpRequestInterceptor.class, HttpResponseInterceptor.class, RestCallInterceptor.class})) {
                    throw new ConfigException("Invalid object of type ''{0}'' passed to interceptors().", new Object[]{ci.getName()});
                }
                if (o instanceof HttpRequestInterceptor) {
                    this.addInterceptorLast((HttpRequestInterceptor)o);
                }
                if (o instanceof HttpResponseInterceptor) {
                    this.addInterceptorLast((HttpResponseInterceptor)o);
                }
                if (!(o instanceof RestCallInterceptor)) continue;
                l.add((RestCallInterceptor)o);
            }
            if (this.interceptors == null) {
                this.interceptors = l;
            } else {
                this.interceptors.addAll(0, l);
            }
            return this;
        }

        @FluentSetter
        public Builder detectLeaks() {
            this.detectLeaks = true;
            return this;
        }

        @FluentSetter
        public Builder marshaller(Marshaller value) {
            if (value != null) {
                this.serializer(value.getSerializer()).parser(value.getParser());
            }
            return this;
        }

        @FluentSetter
        public Builder marshallers(Marshaller ... value) {
            for (Marshaller m : value) {
                if (m == null) continue;
                this.serializer(m.getSerializer()).parser(m.getParser());
            }
            return this;
        }

        @FluentSetter
        public Builder rootUrl(Object value) {
            String s = StringUtils.stringify((Object)value);
            if (!StringUtils.isEmpty((String)s)) {
                s = s.replaceAll("\\/$", "");
            }
            if (StringUtils.isEmpty((String)s)) {
                this.rootUrl = null;
            } else {
                if (s.indexOf("://") == -1) {
                    throw new BasicRuntimeException("Invalid rootUrl value: ''{0}''.  Must be a valid absolute URL.", new Object[]{value});
                }
                this.rootUrl = s;
            }
            return this;
        }

        public String getRootUri() {
            return this.rootUrl;
        }

        @FluentSetter
        public Builder skipEmptyFormData(boolean value) {
            this.skipEmptyFormData = true;
            return this;
        }

        @FluentSetter
        public Builder skipEmptyFormData() {
            return this.skipEmptyFormData(true);
        }

        @FluentSetter
        public Builder skipEmptyHeaderData(boolean value) {
            this.skipEmptyHeaderData = true;
            return this;
        }

        @FluentSetter
        public Builder skipEmptyHeaderData() {
            return this.skipEmptyHeaderData(true);
        }

        @FluentSetter
        public Builder skipEmptyQueryData(boolean value) {
            this.skipEmptyQueryData = true;
            return this;
        }

        @FluentSetter
        public Builder skipEmptyQueryData() {
            return this.skipEmptyQueryData(true);
        }

        @FluentSetter
        public Builder detectRecursions() {
            this.serializers().forEach(x -> x.detectRecursions());
            return this;
        }

        @FluentSetter
        public Builder ignoreRecursions() {
            this.serializers().forEach(x -> x.ignoreRecursions());
            return this;
        }

        @FluentSetter
        public Builder initialDepth(int value) {
            this.serializers().forEach(x -> x.initialDepth(value));
            return this;
        }

        @FluentSetter
        public Builder maxDepth(int value) {
            this.serializers().forEach(x -> x.maxDepth(value));
            return this;
        }

        @FluentSetter
        public Builder addBeanTypes() {
            this.serializers().forEach(x -> x.addBeanTypes());
            return this;
        }

        @FluentSetter
        public Builder addRootType() {
            this.serializers().forEach(x -> x.addRootType());
            return this;
        }

        @FluentSetter
        public Builder keepNullProperties() {
            this.serializers().forEach(x -> x.keepNullProperties());
            return this;
        }

        @FluentSetter
        public Builder sortCollections() {
            this.serializers().forEach(x -> x.sortCollections());
            return this;
        }

        @FluentSetter
        public Builder sortMaps() {
            this.serializers().forEach(x -> x.sortMaps());
            return this;
        }

        @FluentSetter
        public Builder trimEmptyCollections() {
            this.serializers().forEach(x -> x.trimEmptyCollections());
            return this;
        }

        @FluentSetter
        public Builder trimEmptyMaps() {
            this.serializers().forEach(x -> x.trimEmptyMaps());
            return this;
        }

        @FluentSetter
        public Builder trimStringsOnWrite() {
            this.serializers().forEach(x -> x.trimStrings());
            return this;
        }

        @FluentSetter
        public Builder uriContext(UriContext value) {
            this.serializers().forEach(x -> x.uriContext(value));
            return this;
        }

        @FluentSetter
        public Builder uriRelativity(UriRelativity value) {
            this.serializers().forEach(x -> x.uriRelativity(value));
            return this;
        }

        @FluentSetter
        public Builder uriResolution(UriResolution value) {
            this.serializers().forEach(x -> x.uriResolution(value));
            return this;
        }

        @FluentSetter
        public Builder maxIndent(int value) {
            this.serializers().forEachWS(x -> x.maxIndent(value));
            return this;
        }

        @FluentSetter
        public Builder quoteChar(char value) {
            this.serializers().forEachWS(x -> x.quoteChar(value));
            return this;
        }

        @FluentSetter
        public Builder sq() {
            this.serializers().forEachWS(x -> x.sq());
            return this;
        }

        @FluentSetter
        public Builder useWhitespace() {
            this.serializers().forEachWS(x -> x.useWhitespace());
            return this;
        }

        @FluentSetter
        public Builder ws() {
            this.serializers().forEachWS(x -> x.ws());
            return this;
        }

        @FluentSetter
        public Builder debugOutputLines(int value) {
            this.parsers().forEach(x -> x.debugOutputLines(value));
            return this;
        }

        @FluentSetter
        public Builder strict() {
            this.parsers().forEach(x -> x.strict());
            return this;
        }

        @FluentSetter
        public Builder trimStringsOnRead() {
            this.parsers().forEach(x -> x.trimStrings());
            return this;
        }

        @FluentSetter
        public Builder oapiFormat(HttpPartFormat value) {
            this.serializers().forEach(OpenApiSerializer.Builder.class, x -> x.format(value));
            this.parsers().forEach(OpenApiParser.Builder.class, x -> x.format(value));
            this.partSerializer().builder(OpenApiSerializer.Builder.class).ifPresent(x -> x.format(value));
            this.partParser().builder(OpenApiParser.Builder.class).ifPresent(x -> x.format(value));
            return this;
        }

        @FluentSetter
        public Builder oapiCollectionFormat(HttpPartCollectionFormat value) {
            this.serializers().forEach(OpenApiSerializer.Builder.class, x -> x.collectionFormat(value));
            this.parsers().forEach(OpenApiParser.Builder.class, x -> x.collectionFormat(value));
            this.partSerializer().builder(OpenApiSerializer.Builder.class, x -> x.collectionFormat(value));
            this.partParser().builder(OpenApiParser.Builder.class, x -> x.collectionFormat(value));
            return this;
        }

        @FluentSetter
        public Builder paramFormat(ParamFormat value) {
            this.serializers().forEach(UonSerializer.Builder.class, x -> x.paramFormat(value));
            return this;
        }

        @FluentSetter
        public Builder paramFormatPlain() {
            this.serializers().forEach(UonSerializer.Builder.class, x -> x.paramFormatPlain());
            return this;
        }

        public Builder annotations(Annotation ... values) {
            super.annotations(values);
            return this;
        }

        public Builder apply(AnnotationWorkList work) {
            super.apply(work);
            return this;
        }

        public Builder applyAnnotations(Class<?> ... fromClasses) {
            super.applyAnnotations((Class[])fromClasses);
            return this;
        }

        public Builder applyAnnotations(Method ... fromMethods) {
            super.applyAnnotations(fromMethods);
            return this;
        }

        public Builder cache(Cache<HashKey, ? extends Context> value) {
            super.cache(value);
            return this;
        }

        public Builder impl(Context value) {
            super.impl(value);
            return this;
        }

        public Builder type(Class<? extends Context> value) {
            super.type(value);
            return this;
        }

        public Builder beanClassVisibility(Visibility value) {
            super.beanClassVisibility(value);
            return this;
        }

        public Builder beanConstructorVisibility(Visibility value) {
            super.beanConstructorVisibility(value);
            return this;
        }

        public Builder beanContext(BeanContext value) {
            super.beanContext(value);
            return this;
        }

        public Builder beanContext(BeanContext.Builder value) {
            super.beanContext(value);
            return this;
        }

        public Builder beanDictionary(Class<?> ... values) {
            super.beanDictionary((Class[])values);
            return this;
        }

        public Builder beanFieldVisibility(Visibility value) {
            super.beanFieldVisibility(value);
            return this;
        }

        public Builder beanInterceptor(Class<?> on, Class<? extends BeanInterceptor<?>> value) {
            super.beanInterceptor(on, value);
            return this;
        }

        public Builder beanMethodVisibility(Visibility value) {
            super.beanMethodVisibility(value);
            return this;
        }

        public Builder beanProperties(Map<String, Object> values) {
            super.beanProperties(values);
            return this;
        }

        public Builder beanProperties(Class<?> beanClass, String properties) {
            super.beanProperties(beanClass, properties);
            return this;
        }

        public Builder beanProperties(String beanClassName, String properties) {
            super.beanProperties(beanClassName, properties);
            return this;
        }

        public Builder beanPropertiesExcludes(Map<String, Object> values) {
            super.beanPropertiesExcludes(values);
            return this;
        }

        public Builder beanPropertiesExcludes(Class<?> beanClass, String properties) {
            super.beanPropertiesExcludes(beanClass, properties);
            return this;
        }

        public Builder beanPropertiesExcludes(String beanClassName, String properties) {
            super.beanPropertiesExcludes(beanClassName, properties);
            return this;
        }

        public Builder beanPropertiesReadOnly(Map<String, Object> values) {
            super.beanPropertiesReadOnly(values);
            return this;
        }

        public Builder beanPropertiesReadOnly(Class<?> beanClass, String properties) {
            super.beanPropertiesReadOnly(beanClass, properties);
            return this;
        }

        public Builder beanPropertiesReadOnly(String beanClassName, String properties) {
            super.beanPropertiesReadOnly(beanClassName, properties);
            return this;
        }

        public Builder beanPropertiesWriteOnly(Map<String, Object> values) {
            super.beanPropertiesWriteOnly(values);
            return this;
        }

        public Builder beanPropertiesWriteOnly(Class<?> beanClass, String properties) {
            super.beanPropertiesWriteOnly(beanClass, properties);
            return this;
        }

        public Builder beanPropertiesWriteOnly(String beanClassName, String properties) {
            super.beanPropertiesWriteOnly(beanClassName, properties);
            return this;
        }

        public Builder beansRequireDefaultConstructor() {
            super.beansRequireDefaultConstructor();
            return this;
        }

        public Builder beansRequireSerializable() {
            super.beansRequireSerializable();
            return this;
        }

        public Builder beansRequireSettersForGetters() {
            super.beansRequireSettersForGetters();
            return this;
        }

        public Builder dictionaryOn(Class<?> on, Class<?> ... values) {
            super.dictionaryOn(on, (Class[])values);
            return this;
        }

        public Builder disableBeansRequireSomeProperties() {
            super.disableBeansRequireSomeProperties();
            return this;
        }

        public Builder disableIgnoreMissingSetters() {
            super.disableIgnoreMissingSetters();
            return this;
        }

        public Builder disableIgnoreTransientFields() {
            super.disableIgnoreTransientFields();
            return this;
        }

        public Builder disableIgnoreUnknownNullBeanProperties() {
            super.disableIgnoreUnknownNullBeanProperties();
            return this;
        }

        public Builder disableInterfaceProxies() {
            super.disableInterfaceProxies();
            return this;
        }

        public Builder findFluentSetters() {
            super.findFluentSetters();
            return this;
        }

        public Builder findFluentSetters(Class<?> on) {
            super.findFluentSetters(on);
            return this;
        }

        public Builder ignoreInvocationExceptionsOnGetters() {
            super.ignoreInvocationExceptionsOnGetters();
            return this;
        }

        public Builder ignoreInvocationExceptionsOnSetters() {
            super.ignoreInvocationExceptionsOnSetters();
            return this;
        }

        public Builder ignoreUnknownBeanProperties() {
            super.ignoreUnknownBeanProperties();
            return this;
        }

        public Builder ignoreUnknownEnumValues() {
            super.ignoreUnknownEnumValues();
            return this;
        }

        public Builder implClass(Class<?> interfaceClass, Class<?> implClass) {
            super.implClass(interfaceClass, implClass);
            return this;
        }

        public Builder implClasses(Map<Class<?>, Class<?>> values) {
            super.implClasses(values);
            return this;
        }

        public Builder interfaceClass(Class<?> on, Class<?> value) {
            super.interfaceClass(on, value);
            return this;
        }

        public Builder interfaces(Class<?> ... value) {
            super.interfaces((Class[])value);
            return this;
        }

        public Builder locale(Locale value) {
            super.locale(value);
            return this;
        }

        public Builder notBeanClasses(Class<?> ... values) {
            super.notBeanClasses((Class[])values);
            return this;
        }

        public Builder notBeanPackages(String ... values) {
            super.notBeanPackages(values);
            return this;
        }

        public Builder propertyNamer(Class<? extends PropertyNamer> value) {
            super.propertyNamer(value);
            return this;
        }

        public Builder propertyNamer(Class<?> on, Class<? extends PropertyNamer> value) {
            super.propertyNamer(on, value);
            return this;
        }

        public Builder sortProperties() {
            super.sortProperties();
            return this;
        }

        public Builder sortProperties(Class<?> ... on) {
            super.sortProperties((Class[])on);
            return this;
        }

        public Builder stopClass(Class<?> on, Class<?> value) {
            super.stopClass(on, value);
            return this;
        }

        public <T, S> Builder swap(Class<T> normalClass, Class<S> swappedClass, ThrowingFunction<T, S> swapFunction) {
            super.swap(normalClass, swappedClass, swapFunction);
            return this;
        }

        public <T, S> Builder swap(Class<T> normalClass, Class<S> swappedClass, ThrowingFunction<T, S> swapFunction, ThrowingFunction<S, T> unswapFunction) {
            super.swap(normalClass, swappedClass, swapFunction, unswapFunction);
            return this;
        }

        public Builder swaps(Class<?> ... values) {
            super.swaps((Class[])values);
            return this;
        }

        public Builder timeZone(TimeZone value) {
            super.timeZone(value);
            return this;
        }

        public Builder typeName(Class<?> on, String value) {
            super.typeName(on, value);
            return this;
        }

        public Builder typePropertyName(String value) {
            super.typePropertyName(value);
            return this;
        }

        public Builder typePropertyName(Class<?> on, String value) {
            super.typePropertyName(on, value);
            return this;
        }

        public Builder useEnumNames() {
            super.useEnumNames();
            return this;
        }

        public Builder useJavaBeanIntrospector() {
            super.useJavaBeanIntrospector();
            return this;
        }

        @FluentSetter
        public Builder disableRedirectHandling() {
            this.httpClientBuilder().disableRedirectHandling();
            return this;
        }

        @FluentSetter
        public Builder redirectStrategy(RedirectStrategy redirectStrategy) {
            this.httpClientBuilder().setRedirectStrategy(redirectStrategy);
            return this;
        }

        @FluentSetter
        public Builder defaultCookieSpecRegistry(Lookup<CookieSpecProvider> cookieSpecRegistry) {
            this.httpClientBuilder().setDefaultCookieSpecRegistry(cookieSpecRegistry);
            return this;
        }

        @FluentSetter
        public Builder requestExecutor(HttpRequestExecutor requestExec) {
            this.httpClientBuilder().setRequestExecutor(requestExec);
            return this;
        }

        @FluentSetter
        public Builder sslHostnameVerifier(HostnameVerifier hostnameVerifier) {
            this.httpClientBuilder().setSSLHostnameVerifier(hostnameVerifier);
            return this;
        }

        @FluentSetter
        public Builder publicSuffixMatcher(PublicSuffixMatcher publicSuffixMatcher) {
            this.httpClientBuilder().setPublicSuffixMatcher(publicSuffixMatcher);
            return this;
        }

        @FluentSetter
        public Builder sslContext(SSLContext sslContext) {
            this.httpClientBuilder().setSSLContext(sslContext);
            return this;
        }

        @FluentSetter
        public Builder sslSocketFactory(LayeredConnectionSocketFactory sslSocketFactory) {
            this.httpClientBuilder().setSSLSocketFactory(sslSocketFactory);
            return this;
        }

        @FluentSetter
        public Builder maxConnTotal(int maxConnTotal) {
            this.httpClientBuilder().setMaxConnTotal(maxConnTotal);
            return this;
        }

        @FluentSetter
        public Builder maxConnPerRoute(int maxConnPerRoute) {
            this.httpClientBuilder().setMaxConnPerRoute(maxConnPerRoute);
            return this;
        }

        @FluentSetter
        public Builder defaultSocketConfig(SocketConfig config) {
            this.httpClientBuilder().setDefaultSocketConfig(config);
            return this;
        }

        @FluentSetter
        public Builder defaultConnectionConfig(ConnectionConfig config) {
            this.httpClientBuilder().setDefaultConnectionConfig(config);
            return this;
        }

        @FluentSetter
        public Builder connectionTimeToLive(long connTimeToLive, TimeUnit connTimeToLiveTimeUnit) {
            this.httpClientBuilder().setConnectionTimeToLive(connTimeToLive, connTimeToLiveTimeUnit);
            return this;
        }

        @FluentSetter
        public Builder connectionReuseStrategy(ConnectionReuseStrategy reuseStrategy) {
            this.httpClientBuilder().setConnectionReuseStrategy(reuseStrategy);
            return this;
        }

        @FluentSetter
        public Builder keepAliveStrategy(ConnectionKeepAliveStrategy keepAliveStrategy) {
            this.httpClientBuilder().setKeepAliveStrategy(keepAliveStrategy);
            return this;
        }

        @FluentSetter
        public Builder targetAuthenticationStrategy(AuthenticationStrategy targetAuthStrategy) {
            this.httpClientBuilder().setTargetAuthenticationStrategy(targetAuthStrategy);
            return this;
        }

        @FluentSetter
        public Builder proxyAuthenticationStrategy(AuthenticationStrategy proxyAuthStrategy) {
            this.httpClientBuilder().setProxyAuthenticationStrategy(proxyAuthStrategy);
            return this;
        }

        @FluentSetter
        public Builder userTokenHandler(UserTokenHandler userTokenHandler) {
            this.httpClientBuilder().setUserTokenHandler(userTokenHandler);
            return this;
        }

        @FluentSetter
        public Builder disableConnectionState() {
            this.httpClientBuilder().disableConnectionState();
            return this;
        }

        @FluentSetter
        public Builder schemePortResolver(SchemePortResolver schemePortResolver) {
            this.httpClientBuilder().setSchemePortResolver(schemePortResolver);
            return this;
        }

        @FluentSetter
        public Builder addInterceptorFirst(HttpResponseInterceptor itcp) {
            this.httpClientBuilder().addInterceptorFirst(itcp);
            return this;
        }

        @FluentSetter
        public Builder addInterceptorLast(HttpResponseInterceptor itcp) {
            this.httpClientBuilder().addInterceptorLast(itcp);
            return this;
        }

        @FluentSetter
        public Builder addInterceptorFirst(HttpRequestInterceptor itcp) {
            this.httpClientBuilder().addInterceptorFirst(itcp);
            return this;
        }

        @FluentSetter
        public Builder addInterceptorLast(HttpRequestInterceptor itcp) {
            this.httpClientBuilder().addInterceptorLast(itcp);
            return this;
        }

        @FluentSetter
        public Builder disableCookieManagement() {
            this.httpClientBuilder().disableCookieManagement();
            return this;
        }

        @FluentSetter
        public Builder disableContentCompression() {
            this.httpClientBuilder().disableContentCompression();
            return this;
        }

        @FluentSetter
        public Builder disableAuthCaching() {
            this.httpClientBuilder().disableAuthCaching();
            return this;
        }

        @FluentSetter
        public Builder httpProcessor(HttpProcessor httpprocessor) {
            this.httpClientBuilder().setHttpProcessor(httpprocessor);
            return this;
        }

        @FluentSetter
        public Builder retryHandler(HttpRequestRetryHandler retryHandler) {
            this.httpClientBuilder().setRetryHandler(retryHandler);
            return this;
        }

        @FluentSetter
        public Builder disableAutomaticRetries() {
            this.httpClientBuilder().disableAutomaticRetries();
            return this;
        }

        @FluentSetter
        public Builder proxy(HttpHost proxy) {
            this.httpClientBuilder().setProxy(proxy);
            return this;
        }

        @FluentSetter
        public Builder routePlanner(HttpRoutePlanner routePlanner) {
            this.httpClientBuilder().setRoutePlanner(routePlanner);
            return this;
        }

        @FluentSetter
        public Builder connectionBackoffStrategy(ConnectionBackoffStrategy connectionBackoffStrategy) {
            this.httpClientBuilder().setConnectionBackoffStrategy(connectionBackoffStrategy);
            return this;
        }

        @FluentSetter
        public Builder backoffManager(BackoffManager backoffManager) {
            this.httpClientBuilder().setBackoffManager(backoffManager);
            return this;
        }

        @FluentSetter
        public Builder serviceUnavailableRetryStrategy(ServiceUnavailableRetryStrategy serviceUnavailStrategy) {
            this.httpClientBuilder().setServiceUnavailableRetryStrategy(serviceUnavailStrategy);
            return this;
        }

        @FluentSetter
        public Builder defaultCookieStore(CookieStore cookieStore) {
            this.httpClientBuilder().setDefaultCookieStore(cookieStore);
            return this;
        }

        @FluentSetter
        public Builder defaultCredentialsProvider(CredentialsProvider credentialsProvider) {
            this.httpClientBuilder().setDefaultCredentialsProvider(credentialsProvider);
            return this;
        }

        @FluentSetter
        public Builder defaultAuthSchemeRegistry(Lookup<AuthSchemeProvider> authSchemeRegistry) {
            this.httpClientBuilder().setDefaultAuthSchemeRegistry(authSchemeRegistry);
            return this;
        }

        @FluentSetter
        public Builder contentDecoderRegistry(Map<String, InputStreamFactory> contentDecoderMap) {
            this.httpClientBuilder().setContentDecoderRegistry(contentDecoderMap);
            return this;
        }

        @FluentSetter
        public Builder defaultRequestConfig(RequestConfig config) {
            this.httpClientBuilder().setDefaultRequestConfig(config);
            return this;
        }

        @FluentSetter
        public Builder useSystemProperties() {
            this.httpClientBuilder().useSystemProperties();
            return this;
        }

        @FluentSetter
        public Builder evictExpiredConnections() {
            this.httpClientBuilder().evictExpiredConnections();
            return this;
        }

        @FluentSetter
        public Builder evictIdleConnections(long maxIdleTime, TimeUnit maxIdleTimeUnit) {
            this.httpClientBuilder().evictIdleConnections(maxIdleTime, maxIdleTimeUnit);
            return this;
        }
    }
}

