/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.serializer;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.juneau.AnnotationWorkList;
import org.apache.juneau.BasicRuntimeException;
import org.apache.juneau.BeanBuilder;
import org.apache.juneau.BeanContext;
import org.apache.juneau.MediaRange;
import org.apache.juneau.MediaRanges;
import org.apache.juneau.MediaType;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.ConstructorInfo;
import org.apache.juneau.serializer.OutputStreamSerializer;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.serializer.SerializerMatch;
import org.apache.juneau.serializer.WriterSerializer;

public final class SerializerSet {
    private final ConcurrentHashMap<String, SerializerMatch> cache = new ConcurrentHashMap();
    private final MediaRange[] mediaRanges;
    private final List<MediaRange> mediaRangesList;
    private final Serializer[] mediaTypeRangeSerializers;
    private final MediaType[] mediaTypes;
    private final List<MediaType> mediaTypesList;
    final Serializer[] entries;
    private final List<Serializer> entriesList;

    public static Builder create(BeanStore beanStore) {
        return new Builder(beanStore);
    }

    public static Builder create() {
        return new Builder(BeanStore.INSTANCE);
    }

    protected SerializerSet(Builder builder) {
        this.entries = (Serializer[])builder.entries.stream().map(x -> this.build(x)).toArray(Serializer[]::new);
        this.entriesList = CollectionUtils.ulist(this.entries);
        ArrayList<MediaRange> lmtr = CollectionUtils.list(new MediaRange[0]);
        LinkedHashSet<MediaType> lmt = CollectionUtils.set(new MediaType[0]);
        ArrayList<Serializer> l = CollectionUtils.list(new Serializer[0]);
        for (Serializer e : this.entries) {
            e.getMediaTypeRanges().forEachRange(x -> {
                lmtr.add((MediaRange)x);
                l.add(e);
            });
            e.forEachAcceptMediaType(x -> lmt.add((MediaType)x));
        }
        this.mediaRanges = lmtr.toArray(new MediaRange[lmtr.size()]);
        this.mediaRangesList = CollectionUtils.ulist(this.mediaRanges);
        this.mediaTypes = lmt.toArray(new MediaType[lmt.size()]);
        this.mediaTypesList = CollectionUtils.ulist(this.mediaTypes);
        this.mediaTypeRangeSerializers = l.toArray(new Serializer[l.size()]);
    }

    private Serializer build(Object o) {
        if (o instanceof Serializer) {
            return (Serializer)o;
        }
        return ((Serializer.Builder)o).build();
    }

    public Builder copy() {
        return new Builder(this);
    }

    public SerializerMatch getSerializerMatch(String acceptHeader) {
        if (acceptHeader == null) {
            return null;
        }
        SerializerMatch sm = this.cache.get(acceptHeader);
        if (sm != null) {
            return sm;
        }
        MediaRanges a = MediaRanges.of(acceptHeader);
        int match = a.match(this.mediaRangesList);
        if (match >= 0) {
            sm = new SerializerMatch(this.mediaRanges[match], this.mediaTypeRangeSerializers[match]);
            this.cache.putIfAbsent(acceptHeader, sm);
        }
        return this.cache.get(acceptHeader);
    }

    public SerializerMatch getSerializerMatch(MediaType mediaType) {
        return this.getSerializerMatch(mediaType.toString());
    }

    public Serializer getSerializer(String acceptHeader) {
        SerializerMatch sm = this.getSerializerMatch(acceptHeader);
        return sm == null ? null : sm.getSerializer();
    }

    public Serializer getSerializer(MediaType mediaType) {
        if (mediaType == null) {
            return null;
        }
        return this.getSerializer(mediaType.toString());
    }

    public WriterSerializer getWriterSerializer(String acceptHeader) {
        return (WriterSerializer)this.getSerializer(acceptHeader);
    }

    public WriterSerializer getWriterSerializer(MediaType mediaType) {
        return (WriterSerializer)this.getSerializer(mediaType);
    }

    public OutputStreamSerializer getStreamSerializer(String acceptHeader) {
        return (OutputStreamSerializer)this.getSerializer(acceptHeader);
    }

    public OutputStreamSerializer getStreamSerializer(MediaType mediaType) {
        return (OutputStreamSerializer)this.getSerializer(mediaType);
    }

    public List<MediaType> getSupportedMediaTypes() {
        return this.mediaTypesList;
    }

    public List<Serializer> getSerializers() {
        return this.entriesList;
    }

    public boolean isEmpty() {
        return this.entries.length == 0;
    }

    @FluentSetters
    public static class Builder
    extends BeanBuilder<SerializerSet> {
        List<Object> entries;
        private BeanContext.Builder bcBuilder;

        protected Builder(BeanStore beanStore) {
            super(SerializerSet.class, beanStore);
            this.entries = CollectionUtils.list(new Object[0]);
        }

        protected Builder(SerializerSet copyFrom) {
            super(copyFrom.getClass());
            this.entries = CollectionUtils.list((Object[])copyFrom.entries);
        }

        protected Builder(Builder copyFrom) {
            super(copyFrom);
            this.bcBuilder = copyFrom.bcBuilder == null ? null : copyFrom.bcBuilder.copy();
            this.entries = CollectionUtils.list(new Object[0]);
            copyFrom.entries.stream().map(x -> this.copyBuilder(x)).forEach((? super T x) -> this.entries.add(x));
        }

        private Object copyBuilder(Object o) {
            if (o instanceof Serializer.Builder) {
                Serializer.Builder x = (Serializer.Builder)o;
                Serializer.Builder x2 = x.copy();
                if (ObjectUtils.ne(x.getClass(), x2.getClass())) {
                    throw new BasicRuntimeException("Copy method not implemented on class {0}", x.getClass().getName());
                }
                x = x2;
                if (this.bcBuilder != null) {
                    x.beanContext(this.bcBuilder);
                }
                return x;
            }
            return o;
        }

        @Override
        protected SerializerSet buildDefault() {
            return new SerializerSet(this);
        }

        public Builder copy() {
            return new Builder(this);
        }

        public Builder beanContext(BeanContext.Builder value) {
            this.bcBuilder = value;
            this.forEach(x -> x.beanContext(value));
            return this;
        }

        public final Builder beanContext(Consumer<BeanContext.Builder> operation) {
            if (this.bcBuilder != null) {
                operation.accept(this.bcBuilder);
            }
            return this;
        }

        public Builder add(Class<?> ... values) {
            ArrayList<Object> l = CollectionUtils.list(new Object[0]);
            for (Class<?> e : values) {
                if (!Serializer.class.isAssignableFrom(e)) {
                    throw new BasicRuntimeException("Invalid type passed to SerializeGroup.Builder.add(): {0}", e.getName());
                }
                l.add(this.createBuilder(e));
            }
            this.entries.addAll(0, l);
            return this;
        }

        public Builder set(Class<?> ... values) {
            ArrayList<Object> l = CollectionUtils.list(new Object[0]);
            for (Class<?> e : values) {
                if (e.getSimpleName().equals("Inherit")) {
                    l.addAll(this.entries);
                    continue;
                }
                if (Serializer.class.isAssignableFrom(e)) {
                    l.add(this.createBuilder(e));
                    continue;
                }
                throw new BasicRuntimeException("Invalid type passed to SerializeGroup.Builder.set(): {0}", e.getName());
            }
            this.entries = l;
            return this;
        }

        private Object createBuilder(Object o) {
            if (o instanceof Class) {
                ConstructorInfo ci = ClassInfo.of((Class)o).getPublicConstructor(x -> x.hasNoParams());
                if (ci != null) {
                    return ci.invoke(new Object[0]);
                }
                Serializer.Builder b = Serializer.createSerializerBuilder((Class)o);
                if (this.bcBuilder != null) {
                    b.beanContext(this.bcBuilder);
                }
                o = b;
            }
            return o;
        }

        public Builder add(Serializer ... s) {
            CollectionUtils.prependAll(this.entries, (Object[])s);
            return this;
        }

        public Builder clear() {
            this.entries.clear();
            return this;
        }

        public boolean canApply(AnnotationWorkList work) {
            for (Object o : this.entries) {
                if (!(o instanceof Serializer.Builder) || !((Serializer.Builder)o).canApply(work)) continue;
                return true;
            }
            return false;
        }

        public Builder apply(AnnotationWorkList work) {
            return this.forEach(x -> x.apply(work));
        }

        public Builder forEach(Consumer<Serializer.Builder> action) {
            this.builders(Serializer.Builder.class).forEach(action);
            return this;
        }

        public Builder forEachWS(Consumer<WriterSerializer.Builder> action) {
            return this.forEach(WriterSerializer.Builder.class, action);
        }

        public Builder forEachOSS(Consumer<OutputStreamSerializer.Builder> action) {
            return this.forEach(OutputStreamSerializer.Builder.class, action);
        }

        public <T extends Serializer.Builder> Builder forEach(Class<T> type, Consumer<T> action) {
            this.builders(type).forEach(action);
            return this;
        }

        public List<Object> inner() {
            return this.entries;
        }

        private <T extends Serializer.Builder> Stream<T> builders(Class<T> type) {
            return this.entries.stream().filter(x -> type.isInstance(x)).map(x -> (Serializer.Builder)type.cast(x));
        }

        public Builder impl(Object value) {
            super.impl(value);
            return this;
        }

        public Builder type(Class<?> value) {
            super.type(value);
            return this;
        }

        public String toString() {
            return this.entries.stream().map(x -> this.toString(x)).collect(Collectors.joining(",", "[", "]"));
        }

        private String toString(Object o) {
            if (o == null) {
                return "null";
            }
            if (o instanceof Serializer.Builder) {
                return "builder:" + o.getClass().getName();
            }
            return "serializer:" + o.getClass().getName();
        }
    }

    public static abstract class NoInherit
    extends Serializer {
        public NoInherit(Serializer.Builder builder) {
            super(builder);
        }
    }

    public static abstract class Inherit
    extends Serializer {
        public Inherit(Serializer.Builder builder) {
            super(builder);
        }
    }
}

