/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.function.Predicate;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.reflect.ClassInfo;

public final class ClassUtils {
    public static final Predicate<Class<?>> NOT_VOID = x -> ClassUtils.isNotVoid(x);

    public static Class<?>[] getClasses(Object ... args) {
        Class[] pt = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            pt[i] = args[i] == null ? null : args[i].getClass();
        }
        return pt;
    }

    public static Object[] getMatchingArgs(Class<?>[] paramTypes, Object ... args) {
        boolean needsShuffle;
        boolean bl = needsShuffle = paramTypes.length != args.length;
        if (!needsShuffle) {
            for (int i = 0; i < paramTypes.length; ++i) {
                if (paramTypes[i].isInstance(args[i])) continue;
                needsShuffle = true;
            }
        }
        if (!needsShuffle) {
            return args;
        }
        Object[] params = new Object[paramTypes.length];
        block1: for (int i = 0; i < paramTypes.length; ++i) {
            ClassInfo pt = ClassInfo.of(paramTypes[i]).getWrapperInfoIfPrimitive();
            for (int j = 0; j < args.length; ++j) {
                if (args[j] == null || !pt.isParentOf(args[j].getClass())) continue;
                params[i] = args[j];
                continue block1;
            }
        }
        return params;
    }

    public static boolean setAccessible(Constructor<?> x) {
        try {
            if (x != null) {
                x.setAccessible(true);
            }
            return true;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static boolean setAccessible(Method x) {
        try {
            if (x != null) {
                x.setAccessible(true);
            }
            return true;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static boolean setAccessible(Field x) {
        try {
            if (x != null) {
                x.setAccessible(true);
            }
            return true;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static Class<?> toClass(Type t) {
        if (t instanceof Class) {
            return (Class)t;
        }
        if (t instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)t;
            return (Class)pt.getRawType();
        }
        return null;
    }

    public static String className(Object value) {
        return value == null ? null : (value instanceof Class ? ((Class)value).getName() : value.getClass().getName());
    }

    public static String simpleClassName(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof ClassInfo) {
            return ((ClassInfo)value).getSimpleName();
        }
        if (value instanceof ClassMeta) {
            return ((ClassMeta)value).getSimpleName();
        }
        if (value instanceof Class) {
            return ((Class)value).getSimpleName();
        }
        return value.getClass().getSimpleName();
    }

    public static boolean isVoid(Class c) {
        return c == null || c == Void.TYPE || c == Void.class || c.getSimpleName().equalsIgnoreCase("void");
    }

    public static boolean isNotVoid(Class c) {
        return !ClassUtils.isVoid(c);
    }
}

