/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.cp;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.common.internal.IOUtils;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.cp.FileFinder;
import org.apache.juneau.cp.LocalDir;
import org.apache.juneau.cp.LocalFile;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.FileUtils;
import org.apache.juneau.internal.HashCode;
import org.apache.juneau.internal.ObjectUtils;

public class BasicFileFinder
implements FileFinder {
    private static final ResourceBundle.Control RB_CONTROL = ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_DEFAULT);
    private final Map<String, LocalFile> files = new ConcurrentHashMap<String, LocalFile>();
    private final Map<Locale, Map<String, LocalFile>> localizedFiles = new ConcurrentHashMap<Locale, Map<String, LocalFile>>();
    private final LocalDir[] roots;
    private final long cachingLimit;
    private final Pattern[] include;
    private final Pattern[] exclude;
    private final String[] includePatterns;
    private final String[] excludePatterns;
    private final int hashCode;

    public BasicFileFinder(FileFinder.Builder builder) {
        this.roots = builder.roots.toArray(new LocalDir[builder.roots.size()]);
        this.cachingLimit = builder.cachingLimit;
        this.include = builder.include;
        this.exclude = builder.exclude;
        this.includePatterns = (String[])CollectionUtils.alist(this.include).stream().map(x -> x.pattern()).toArray(String[]::new);
        this.excludePatterns = (String[])CollectionUtils.alist(this.exclude).stream().map(x -> x.pattern()).toArray(String[]::new);
        this.hashCode = HashCode.of(this.getClass(), this.roots, this.cachingLimit, this.includePatterns, this.excludePatterns);
    }

    protected BasicFileFinder() {
        this.roots = new LocalDir[0];
        this.cachingLimit = -1L;
        this.include = new Pattern[0];
        this.exclude = new Pattern[0];
        this.includePatterns = new String[0];
        this.excludePatterns = new String[0];
        this.hashCode = HashCode.of(this.getClass(), this.roots, this.cachingLimit, this.includePatterns, this.excludePatterns);
    }

    @Override
    public final Optional<InputStream> getStream(String name, Locale locale) throws IOException {
        return this.find(name, locale);
    }

    @Override
    public Optional<String> getString(String name, Locale locale) throws IOException {
        return CollectionUtils.optional(IOUtils.read((InputStream)this.find(name, locale).orElse(null)));
    }

    protected Optional<InputStream> find(String name, Locale locale) throws IOException {
        Map<String, LocalFile> fileCache;
        LocalFile lf;
        if (this.isInvalidPath(name = StringUtils.trimSlashesAndSpaces((String)name))) {
            return CollectionUtils.empty();
        }
        if (locale != null) {
            this.localizedFiles.putIfAbsent(locale, new ConcurrentHashMap());
        }
        if ((lf = (fileCache = locale == null ? this.files : this.localizedFiles.get(locale)).get(name)) == null) {
            List<String> candidateFileNames = this.getCandidateFileNames(name, locale);
            block0: for (LocalDir root : this.roots) {
                for (String cfn : candidateFileNames) {
                    lf = root.resolve(cfn);
                    if (lf == null) continue;
                    break block0;
                }
            }
            if (lf != null && this.isIgnoredFile(lf.getName())) {
                lf = null;
            }
            if (lf != null) {
                long size;
                fileCache.put(name, lf);
                if (this.cachingLimit >= 0L && (size = lf.size()) > 0L && size <= this.cachingLimit) {
                    lf.cache();
                }
            }
        }
        return CollectionUtils.optional(lf == null ? null : lf.read());
    }

    protected List<String> getCandidateFileNames(String fileName, Locale locale) {
        if (locale == null) {
            return Collections.singletonList(fileName);
        }
        ArrayList<String> list = new ArrayList<String>();
        String baseName = FileUtils.getBaseName(fileName);
        String ext = FileUtils.getExtension(fileName);
        this.getCandidateLocales(locale).forEach(x -> {
            String ls = x.toString();
            if (ls.isEmpty()) {
                list.add(fileName);
            } else {
                list.add(baseName + "_" + ls + (String)(ext.isEmpty() ? "" : "." + ext));
                list.add(ls.replace('_', '/') + "/" + fileName);
            }
        });
        return list;
    }

    protected List<Locale> getCandidateLocales(Locale locale) {
        return RB_CONTROL.getCandidateLocales("", locale);
    }

    protected boolean isInvalidPath(String path) {
        return StringUtils.isEmpty((String)path) || path.contains("..") || path.contains("%");
    }

    protected boolean isIgnoredFile(String name) {
        for (Pattern p : this.exclude) {
            if (!p.matcher(name).matches()) continue;
            return true;
        }
        for (Pattern p : this.include) {
            if (!p.matcher(name).matches()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        return o instanceof BasicFileFinder && ObjectUtils.eq(this, (BasicFileFinder)o, (x, y) -> ObjectUtils.eq(x.hashCode, y.hashCode) && ObjectUtils.eq(x.getClass(), y.getClass()) && ObjectUtils.eq(x.roots, y.roots) && ObjectUtils.eq(x.cachingLimit, y.cachingLimit) && ObjectUtils.eq(x.includePatterns, y.includePatterns) && ObjectUtils.eq(x.excludePatterns, y.excludePatterns));
    }

    public String toString() {
        return JsonMap.filteredMap().append("class", this.getClass().getSimpleName()).append("roots", this.roots).append("cachingLimit", this.cachingLimit).append("include", this.includePatterns).append("exclude", this.excludePatterns).append("hashCode", this.hashCode).asReadableString();
    }
}

