/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.juneau.annotation.AnnotationBuilder;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.common.internal.ThrowableUtils;
import org.apache.juneau.internal.AnnotationUtils;

public class AnnotationImpl
implements Annotation {
    private final Class<? extends Annotation> annotationType;
    private int hashCode = -1;

    public AnnotationImpl(AnnotationBuilder b) {
        this.annotationType = b.annotationType;
    }

    protected void postConstruct() {
        this.hashCode = AnnotationUtils.hashCode(this);
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return this.annotationType;
    }

    @Override
    public int hashCode() {
        if (this.hashCode == -1) {
            throw new RuntimeException("Programming error.  postConstruct() was never called on annotation.");
        }
        return this.hashCode;
    }

    @Override
    public boolean equals(Object o) {
        if (!this.annotationType.isInstance(o)) {
            return false;
        }
        return AnnotationUtils.equals(this, (Annotation)o);
    }

    public JsonMap toMap() {
        JsonMap m = JsonMap.create();
        Arrays.stream(this.annotationType().getDeclaredMethods()).filter(x -> x.getParameterCount() == 0 && x.getDeclaringClass().isAnnotation()).sorted(Comparator.comparing(Method::getName)).forEach(x -> m.append(x.getName(), ThrowableUtils.safeSupplier(() -> x.invoke((Object)this, new Object[0]))));
        return m;
    }

    @Override
    public String toString() {
        return this.toMap().asString();
    }
}

