/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import org.apache.http.HeaderElement;
import org.apache.http.message.BasicHeaderValueParser;
import org.apache.juneau.StringRange;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.Cache;
import org.apache.juneau.internal.CollectionUtils;

@BeanIgnore
public class StringRanges {
    public static final StringRanges EMPTY = new StringRanges("");
    private static final Cache<String, StringRanges> CACHE = Cache.of(String.class, StringRanges.class).build();
    private final StringRange[] value;
    private final String string;
    private static final Comparator<StringRange> RANGE_COMPARATOR = new Comparator<StringRange>(){

        @Override
        public int compare(StringRange o1, StringRange o2) {
            int qCompare = Float.compare(o2.getQValue().floatValue(), o1.getQValue().floatValue());
            if (qCompare != 0) {
                return qCompare;
            }
            int i = o2.toString().compareTo(o1.toString());
            return i;
        }
    };

    public static StringRanges of(String value) {
        return StringUtils.isEmpty((String)value) ? EMPTY : CACHE.get(value, () -> new StringRanges(value));
    }

    public static StringRanges of(StringRange ... value) {
        return value == null ? null : new StringRanges(value);
    }

    public StringRanges(String value) {
        this(StringRanges.parse(value));
    }

    public StringRanges(StringRange ... value) {
        this.string = StringUtils.join((Object[])value, (String)", ");
        this.value = ArrayUtils.copyOf(value);
    }

    public StringRanges(HeaderElement ... e) {
        this.value = new StringRange[e.length];
        for (int i = 0; i < e.length; ++i) {
            this.value[i] = new StringRange(e[i]);
        }
        Arrays.sort(this.value, RANGE_COMPARATOR);
        this.string = this.value.length == 1 ? this.value[0].toString() : StringUtils.join((Object[])this.value, (String)", ");
    }

    public int match(List<String> names) {
        StringRange mr;
        float q2;
        if (this.string.isEmpty()) {
            return -1;
        }
        int matchQuant = 0;
        int matchIndex = -1;
        float q = 0.0f;
        StringRange[] stringRangeArray = this.value;
        int n = stringRangeArray.length;
        for (int i = 0; i < n && !((q2 = (mr = stringRangeArray[i]).getQValue().floatValue()) < q) && q2 != 0.0f; ++i) {
            for (int i2 = 0; i2 < names.size(); ++i2) {
                String mt = names.get(i2);
                int matchQuant2 = mr.match(mt);
                if (matchQuant2 <= matchQuant) continue;
                matchIndex = i2;
                matchQuant = matchQuant2;
                q = q2;
            }
        }
        return matchIndex;
    }

    public StringRange getRange(int index) {
        if (index < 0 || index >= this.value.length) {
            return null;
        }
        return this.value[index];
    }

    public List<StringRange> toList() {
        return CollectionUtils.ulist(this.value);
    }

    public StringRanges forEachRange(Consumer<StringRange> action) {
        for (StringRange r : this.value) {
            action.accept(r);
        }
        return this;
    }

    private static HeaderElement[] parse(String value) {
        return value == null ? null : BasicHeaderValueParser.parseElements((String)StringUtils.emptyIfNull((String)StringUtils.trim((String)value)), null);
    }

    public String toString() {
        return this.string;
    }
}

