/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.lang.annotation.Annotation;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.juneau.ConfigException;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.reflect.AnnotationInfo;
import org.apache.juneau.svl.VarResolver;
import org.apache.juneau.svl.VarResolverSession;

public abstract class AnnotationApplier<A extends Annotation, B> {
    private final VarResolverSession vr;
    private final Class<A> ca;
    private final Class<B> cb;

    protected AnnotationApplier(Class<A> annotationClass, Class<B> builderClass, VarResolverSession vr) {
        this.vr = vr == null ? VarResolver.DEFAULT.createSession() : vr;
        this.ca = annotationClass;
        this.cb = builderClass;
    }

    public abstract void apply(AnnotationInfo<A> var1, B var2);

    public boolean canApply(Object builder) {
        return this.cb.isInstance(builder);
    }

    public Class<?> getBuilderClass() {
        return this.cb;
    }

    protected VarResolverSession vr() {
        return this.vr;
    }

    protected Optional<String> string(String in) {
        return CollectionUtils.optional(StringUtils.isEmpty((String)(in = this.vr.resolve(in))) ? null : in);
    }

    protected <T> Optional<Class<T>> type(Class<T> in) {
        return CollectionUtils.optional(in).filter(ClassUtils.NOT_VOID);
    }

    protected Optional<String[]> strings(String[] in) {
        return CollectionUtils.optional(in.length == 0 ? null : (String[])Arrays.stream(in).map(x -> this.vr.resolve((String)x)).filter(x -> StringUtils.isNotEmpty((String)x)).toArray(String[]::new));
    }

    protected Stream<String> stream(String[] in) {
        return Arrays.stream(in).map(x -> this.vr.resolve((String)x)).filter(x -> StringUtils.isNotEmpty((String)x));
    }

    protected Stream<String> cdl(String in) {
        return Arrays.stream(StringUtils.split((String)this.vr.resolve(in))).filter(x -> StringUtils.isNotEmpty((String)x));
    }

    public Optional<Boolean> bool(String in) {
        return this.string(in).map(Boolean::parseBoolean);
    }

    protected Optional<Integer> integer(String in, String loc) {
        try {
            return this.string(in).map(Integer::parseInt);
        }
        catch (NumberFormatException e) {
            throw new ConfigException("Invalid syntax for integer on annotation @{0}({1}): {2}", this.ca.getSimpleName(), loc, in);
        }
    }

    protected Optional<Charset> charset(String in) {
        return this.string(in).map(x -> "default".equalsIgnoreCase((String)x) ? Charset.defaultCharset() : Charset.forName(x));
    }

    protected Optional<Character> character(String in, String loc) {
        return this.string(in).map(x -> this.toCharacter((String)x, loc));
    }

    private Character toCharacter(String in, String loc) {
        if (in.length() != 1) {
            throw new ConfigException("Invalid syntax for character on annotation @{0}({1}): {2}", this.ca.getSimpleName(), loc, in);
        }
        return Character.valueOf(in.charAt(0));
    }

    protected Optional<Class<?>[]> classes(Class<?>[] in) {
        return CollectionUtils.optional(in.length == 0 ? null : in);
    }

    public static class NoOp
    extends AnnotationApplier<Annotation, Object> {
        public NoOp(VarResolverSession r) {
            super(Annotation.class, Object.class, r);
        }

        @Override
        public void apply(AnnotationInfo<Annotation> ai, Object b) {
        }
    }
}

