/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.microservice.resources;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.annotation.Schema;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.config.Config;
import org.apache.juneau.dto.LinkString;
import org.apache.juneau.html.annotation.Html;
import org.apache.juneau.html.annotation.HtmlConfig;
import org.apache.juneau.html.annotation.HtmlDocConfig;
import org.apache.juneau.html.annotation.HtmlFormat;
import org.apache.juneau.http.annotation.Path;
import org.apache.juneau.http.annotation.Query;
import org.apache.juneau.http.annotation.Response;
import org.apache.juneau.http.response.Forbidden;
import org.apache.juneau.http.response.MethodNotAllowed;
import org.apache.juneau.http.response.NotFound;
import org.apache.juneau.microservice.resources.LogEntryFormatter;
import org.apache.juneau.microservice.resources.LogParser;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.annotation.OpSwagger;
import org.apache.juneau.rest.annotation.Rest;
import org.apache.juneau.rest.annotation.RestDelete;
import org.apache.juneau.rest.annotation.RestGet;
import org.apache.juneau.rest.annotation.RestInit;
import org.apache.juneau.rest.annotation.RestOp;
import org.apache.juneau.rest.beans.SeeOtherRoot;
import org.apache.juneau.rest.converter.Queryable;
import org.apache.juneau.rest.servlet.BasicRestServlet;
import org.apache.juneau.rest.util.FinishablePrintWriter;

@Rest(path="/logs", title={"Log files"}, description={"Log files from this service"}, allowedMethodParams="*")
@HtmlConfig(uriAnchorText="PROPERTY_NAME")
public class LogsResource
extends BasicRestServlet {
    private static final long serialVersionUID = 1L;
    private File logDir;
    private LogEntryFormatter leFormatter;
    boolean allowDeletes;

    @RestInit
    public void init(Config config) throws Exception {
        this.logDir = new File(config.get("Logging/logDir").asString().orElse("logs"));
        this.allowDeletes = config.get("Logging/allowDeletes").asBoolean().orElse(true);
        this.leFormatter = new LogEntryFormatter(config.get("Logging/format").asString().orElse("[{date} {level}] {msg}%n"), config.get("Logging/dateFormat").asString().orElse("yyyy.MM.dd hh:mm:ss"), config.get("Logging/useStackTraceHashes").asBoolean().orElse(true));
    }

    @RestGet(path={"/*"}, summary="View information on file or directory", description={"Returns information about the specified file or directory."})
    @HtmlDocConfig(nav={"<h5>Folder:  $RA{fullPath}</h5>"})
    public FileResource getFile(RestRequest req, @Path(value="/*") String path) throws NotFound, Exception {
        File dir = this.getFile(path);
        req.setAttribute("fullPath", (Object)dir.getAbsolutePath());
        return new FileResource(dir, path, this.allowDeletes, true);
    }

    @RestOp(method="VIEW", path={"/*"}, summary="View contents of log file", description={"View the contents of a log file."})
    public void viewFile(RestResponse res, @Path(value="/*") String path, @Query(name="highlight", schema=@Schema(d={"Add severity color highlighting."})) boolean highlight, @Query(name="start", schema=@Schema(d={"Start timestamp (ISO8601, full or partial).\nDon't print lines logged before the specified timestamp.\nUse any of the following formats: yyyy, yyyy-MM, yyyy-MM-dd, yyyy-MM-ddThh, yyyy-MM-ddThh:mm, yyyy-MM-ddThh:mm:ss, yyyy-MM-ddThh:mm:ss.SSS"})) String start, @Query(name="end", schema=@Schema(d={"End timestamp (ISO8601, full or partial).\nDon't print lines logged after the specified timestamp.\nUse any of the following formats: yyyy, yyyy-MM, yyyy-MM-dd, yyyy-MM-ddThh, yyyy-MM-ddThh:mm, yyyy-MM-ddThh:mm:ss, yyyy-MM-ddThh:mm:ss.SSS"})) String end, @Query(name="thread", schema=@Schema(d={"Thread name filter.\nOnly show log entries with the specified thread name."})) String thread, @Query(name="loggers", schema=@Schema(d={"Logger filter (simple class name).\nOnly show log entries if they were produced by one of the specified loggers."})) String[] loggers, @Query(name="severity", schema=@Schema(d={"Severity filter.\nOnly show log entries with the specified severity."})) String[] severity) throws NotFound, MethodNotAllowed, IOException {
        File f = this.getFile(path);
        Date startDate = StringUtils.parseIsoDate((String)start);
        Date endDate = StringUtils.parseIsoDate((String)end);
        if (!highlight) {
            Object o = this.getReader(f, startDate, endDate, thread, loggers, severity);
            res.setContentType("text/plain");
            if (o instanceof Reader) {
                res.setContent(o);
            } else {
                try (LogParser p = (LogParser)o;
                     FinishablePrintWriter w = res.getNegotiatedWriter();){
                    p.writeTo((Writer)w);
                }
            }
            return;
        }
        res.setContentType("text/html");
        try (FinishablePrintWriter w = res.getNegotiatedWriter();){
            w.println("<html><body style='font-family:monospace;font-size:8pt;white-space:pre;'>");
            try (LogParser lp = this.getLogParser(f, startDate, endDate, thread, loggers, severity);){
                if (!lp.hasNext()) {
                    w.append("<span style='color:gray'>[EMPTY]</span>");
                } else {
                    for (LogParser.Entry le : lp) {
                        char s = le.severity.charAt(0);
                        String color = "black";
                        if (s == 'I') {
                            color = "#006400";
                        } else if (s == 'W') {
                            color = "#CC8400";
                        } else if (s == 'E' || s == 'S') {
                            color = "#DD0000";
                        } else if (s == 'D' || s == 'F' || s == 'T') {
                            color = "#000064";
                        }
                        w.append("<span style='color:").append(color).append("'>");
                        le.appendHtml((Writer)w).append("</span>");
                    }
                }
                w.append("</body></html>");
            }
        }
    }

    @RestOp(method="PARSE", path={"/*"}, converters={Queryable.class}, summary="View parsed contents of file", description={"View the parsed contents of a file."}, swagger=@OpSwagger(parameters={"{in:'query',name:'s',description:'Search.\nKey/value pairs representing column names and search tokens.\n\\'*\\' and \\'?\\' can be used as meta-characters in string fields.\n\\'>\\', \\'>=\\', \\'<\\', and \\'<=\\' can be used as limits on numeric and date fields.\nDate fields can be matched with partial dates (e.g. \\'2018\\' to match any date in the year 2018).',type:'array',collectionFormat:'csv',examples:{example:'?s=Bill*,birthDate>2000'}},{in:'query',name:'v',description:'View.\nColumn names to display.',type:'array',collectionFormat:'csv',examples:{example:'?v=name,birthDate'}},{in:'query',name:'o',description:'Order by.\nColumns to sort by.\nColumn names can be suffixed with \\'+\\' or \\'-\\' to indicate ascending or descending order.\nThe default is ascending order.',type:'array',collectionFormat:'csv',examples:{example:'?o=name,birthDate-'}},{in:'query',name:'p',description:'Position.\nOnly return rows starting at the specified index position (zero-indexed).\nDefault is 0',type:'integer',examples:{example:'?p=100'}},{in:'query',name:'l',description:'Limit.\nOnly return the specified number of rows.\nDefault is 0 (meaning return all rows).',type:'integer',examples:{example:'?l=100'}}"}))
    @HtmlDocConfig(nav={"<h5>Folder:  $RA{fullPath}</h5>"})
    public LogParser viewParsedEntries(RestRequest req, @Path(value="/*") String path, @Query(name="start", schema=@Schema(d={"Start timestamp (ISO8601, full or partial).\nDon't print lines logged before the specified timestamp.\nUse any of the following formats: yyyy, yyyy-MM, yyyy-MM-dd, yyyy-MM-ddThh, yyyy-MM-ddThh:mm, yyyy-MM-ddThh:mm:ss, yyyy-MM-ddThh:mm:ss.SSS"})) String start, @Query(name="end", schema=@Schema(d={"End timestamp (ISO8601, full or partial).\nDon't print lines logged after the specified timestamp.\nUse any of the following formats: yyyy, yyyy-MM, yyyy-MM-dd, yyyy-MM-ddThh, yyyy-MM-ddThh:mm, yyyy-MM-ddThh:mm:ss, yyyy-MM-ddThh:mm:ss.SSS"})) String end, @Query(name="thread", schema=@Schema(d={"Thread name filter.\nOnly show log entries with the specified thread name."})) String thread, @Query(name="loggers", schema=@Schema(d={"Logger filter (simple class name).\nOnly show log entries if they were produced by one of the specified loggers."})) String[] loggers, @Query(name="severity", schema=@Schema(d={"Severity filter.\nOnly show log entries with the specified severity."})) String[] severity) throws NotFound, IOException {
        File f = this.getFile(path);
        req.setAttribute("fullPath", (Object)f.getAbsolutePath());
        Date startDate = StringUtils.parseIsoDate((String)start);
        Date endDate = StringUtils.parseIsoDate((String)end);
        return this.getLogParser(f, startDate, endDate, thread, loggers, severity);
    }

    @RestOp(method="DOWNLOAD", path={"/*"}, summary="Download file", description={"Download the contents of a file.\nContent-Type is set to 'application/octet-stream'."})
    public FileContents downloadFile(RestResponse res, @Path(value="/*") String path) throws NotFound, MethodNotAllowed {
        res.setContentType("application/octet-stream");
        try {
            return new FileContents(this.getFile(path));
        }
        catch (FileNotFoundException e) {
            throw new NotFound("File not found", new Object[0]);
        }
    }

    @RestDelete(path={"/*"}, summary="Delete log file", description={"Delete a log file on the file system."})
    public RedirectToRoot deleteFile(@Path(value="/*") String path) throws MethodNotAllowed {
        this.deleteFile(this.getFile(path));
        return new RedirectToRoot();
    }

    private File getFile(String path) throws NotFound {
        if (path == null) {
            return this.logDir;
        }
        File f = new File(this.logDir.getAbsolutePath() + "/" + path);
        if (f.exists()) {
            return f;
        }
        throw new NotFound("File not found.", new Object[0]);
    }

    private void deleteFile(File f) {
        File[] files;
        if (!this.allowDeletes) {
            throw new MethodNotAllowed("DELETE not enabled", new Object[0]);
        }
        if (f.isDirectory() && (files = f.listFiles()) != null) {
            for (File fc : files) {
                this.deleteFile(fc);
            }
        }
        if (!f.delete()) {
            throw new Forbidden("Could not delete file {0}", new Object[]{f.getAbsolutePath()});
        }
    }

    private static BufferedReader getReader(File f) throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), Charset.defaultCharset()));
    }

    private Object getReader(File f, Date start, Date end, String thread, String[] loggers, String[] severity) throws IOException {
        if (start == null && end == null && thread == null && loggers == null) {
            return LogsResource.getReader(f);
        }
        return this.getLogParser(f, start, end, thread, loggers, severity);
    }

    private LogParser getLogParser(File f, Date start, Date end, String thread, String[] loggers, String[] severity) throws IOException {
        return new LogParser(this.leFormatter, f, start, end, thread, loggers, severity);
    }

    @Response(schema=@Schema(description={"File or directory details"}))
    @Bean(properties="type,name,size,lastModified,actions,files")
    public static class FileResource {
        private final File f;
        private final String path;
        private final String uri;
        private final boolean includeChildren;
        private final boolean allowDeletes;
        static final FileFilter FILE_FILTER = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith(".log");
            }
        };
        static final Comparator<FileResource> FILE_COMPARATOR = new Comparator<FileResource>(){

            @Override
            public int compare(FileResource o1, FileResource o2) {
                int c = o1.getType().compareTo(o2.getType());
                return c != 0 ? c : o1.getName().compareTo(o2.getName());
            }
        };

        public FileResource(File f, String path, boolean allowDeletes, boolean includeChildren) {
            this.f = f;
            this.path = path;
            this.uri = "servlet:/" + (path == null ? "" : path);
            this.includeChildren = includeChildren;
            this.allowDeletes = allowDeletes;
        }

        public String getType() {
            return this.f.isDirectory() ? "dir" : "file";
        }

        public LinkString getName() {
            return new LinkString(this.f.getName(), this.uri, new Object[0]);
        }

        public long getSize() {
            return this.f.isDirectory() ? (long)this.f.listFiles().length : this.f.length();
        }

        public Date getLastModified() {
            return new Date(this.f.lastModified());
        }

        @Html(format=HtmlFormat.HTML_CDC)
        public List<Action> getActions() throws Exception {
            ArrayList<Action> l = new ArrayList<Action>();
            if (this.f.canRead() && !this.f.isDirectory()) {
                l.add(new Action("view", this.uri + "?method=VIEW", new Object[0]));
                l.add(new Action("highlighted", this.uri + "?method=VIEW&highlight=true", new Object[0]));
                l.add(new Action("parsed", this.uri + "?method=PARSE", new Object[0]));
                l.add(new Action("download", this.uri + "?method=DOWNLOAD", new Object[0]));
                if (this.allowDeletes) {
                    l.add(new Action("delete", this.uri + "?method=DELETE", new Object[0]));
                }
            }
            return l;
        }

        public Set<FileResource> getFiles() {
            if (this.f.isFile() || !this.includeChildren) {
                return null;
            }
            TreeSet<FileResource> s = new TreeSet<FileResource>(FILE_COMPARATOR);
            for (File fc : this.f.listFiles(FILE_FILTER)) {
                s.add(new FileResource(fc, (String)(this.path != null ? this.path + "/" : "") + StringUtils.urlEncode((String)fc.getName()), this.allowDeletes, false));
            }
            return s;
        }
    }

    @Response(schema=@Schema(type="string", format="binary", description={"Contents of file"}))
    static class FileContents
    extends FileInputStream {
        public FileContents(File file) throws FileNotFoundException {
            super(file);
        }
    }

    @Response(schema=@Schema(description={"Redirect to root page on success"}))
    static class RedirectToRoot
    extends SeeOtherRoot {
        RedirectToRoot() {
        }
    }

    @Response(schema=@Schema(description={"File action"}))
    public static class Action
    extends LinkString {
        public Action(String name, String uri, Object ... uriArgs) {
            super(name, uri, uriArgs);
        }
    }
}

