/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.client;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.IdentityHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.DetailLevel;
import org.apache.juneau.Value;
import org.apache.juneau.assertions.FluentIntegerAssertion;
import org.apache.juneau.assertions.FluentStringAssertion;
import org.apache.juneau.http.header.ContentType;
import org.apache.juneau.http.header.HeaderList;
import org.apache.juneau.httppart.HttpPartParser;
import org.apache.juneau.httppart.HttpPartParserSession;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.httppart.bean.ResponseBeanMeta;
import org.apache.juneau.httppart.bean.ResponseBeanPropertyMeta;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.rest.client.ResponseContent;
import org.apache.juneau.rest.client.ResponseHeader;
import org.apache.juneau.rest.client.ResponseStatusLine;
import org.apache.juneau.rest.client.RestCallException;
import org.apache.juneau.rest.client.RestCallInterceptor;
import org.apache.juneau.rest.client.RestClient;
import org.apache.juneau.rest.client.RestRequest;
import org.apache.juneau.rest.client.assertion.FluentResponseBodyAssertion;
import org.apache.juneau.rest.client.assertion.FluentResponseHeaderAssertion;
import org.apache.juneau.rest.client.assertion.FluentResponseStatusLineAssertion;

public class RestResponse
implements HttpResponse {
    private final RestClient client;
    private final RestRequest request;
    private final HttpResponse response;
    private final Parser parser;
    private ResponseContent responseContent;
    private boolean isClosed;
    private HeaderList headers;
    private Map<HttpPartParser, HttpPartParserSession> partParserSessions = new IdentityHashMap<HttpPartParser, HttpPartParserSession>();
    private HttpPartParserSession partParserSession;

    protected RestResponse(RestClient client, RestRequest request, HttpResponse response, Parser parser) {
        this.client = client;
        this.request = request;
        this.parser = parser;
        this.response = response == null ? new BasicHttpResponse(null, 0, null) : response;
        this.responseContent = new ResponseContent(client, request, this, parser);
        this.headers = HeaderList.of((Header[])this.response.getAllHeaders());
    }

    public RestRequest getRequest() {
        return this.request;
    }

    public RestResponse consume() throws RestCallException {
        this.close();
        return this;
    }

    public RestResponse getStatusLine(Value<StatusLine> value) {
        value.set((Object)this.getStatusLine());
        return this;
    }

    public int getStatusCode() {
        return this.getStatusLine().getStatusCode();
    }

    public RestResponse getStatusCode(Value<Integer> value) {
        value.set((Object)this.getStatusCode());
        return this;
    }

    public String getReasonPhrase() {
        return this.getStatusLine().getReasonPhrase();
    }

    public RestResponse getReasonPhrase(Value<String> value) {
        value.set((Object)this.getReasonPhrase());
        return this;
    }

    public FluentResponseStatusLineAssertion<RestResponse> assertStatus() {
        return new FluentResponseStatusLineAssertion<RestResponse>(this.getStatusLine(), this);
    }

    public FluentIntegerAssertion<RestResponse> assertCode() {
        return this.assertStatus().asCode();
    }

    public Optional<String> getStringHeader(String name) {
        return this.getHeader(name).asString();
    }

    public String getCharacterEncoding() throws RestCallException {
        Optional<ContentType> ct = this.getContentType();
        String s = null;
        if (ct.isPresent()) {
            s = this.getContentType().get().getParameter("charset");
        }
        return StringUtils.isEmpty(s) ? "utf-8" : s;
    }

    public Optional<ContentType> getContentType() throws RestCallException {
        return this.getHeader("Content-Type").as(ContentType.class);
    }

    public FluentStringAssertion<RestResponse> assertCharset() throws RestCallException {
        return new FluentStringAssertion(this.getCharacterEncoding(), (Object)this);
    }

    public FluentResponseHeaderAssertion<RestResponse> assertHeader(String name) {
        return new FluentResponseHeaderAssertion<RestResponse>(this.getHeader(name), this);
    }

    public ResponseContent getContent() {
        return this.responseContent;
    }

    public FluentResponseBodyAssertion<RestResponse> assertContent() {
        return new FluentResponseBodyAssertion<RestResponse>(this.responseContent, this);
    }

    public RestResponse cacheContent() {
        this.responseContent.cache();
        return this;
    }

    <T> T as(final ResponseBeanMeta rbm) {
        Class c = rbm.getClassMeta().getInnerClass();
        final RestClient rc = this.client;
        return (T)Proxy.newProxyInstance(c.getClassLoader(), new Class[]{c}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                ResponseBeanPropertyMeta pm = rbm.getProperty(method.getName());
                HttpPartParserSession pp = RestResponse.this.getPartParserSession(pm.getParser().orElse(rc.getPartParser()));
                HttpPartSchema schema = pm.getSchema();
                HttpPartType pt = pm.getPartType();
                String name = pm.getPartName().orElse(null);
                ClassMeta type = rc.getBeanContext().getClassMeta(method.getGenericReturnType(), new Type[0]);
                if (pt == HttpPartType.RESPONSE_HEADER) {
                    return RestResponse.this.getHeader(name).parser(pp).schema(schema).as(type).orElse(null);
                }
                if (pt == HttpPartType.RESPONSE_STATUS) {
                    return RestResponse.this.getStatusCode();
                }
                return RestResponse.this.getContent().schema(schema).as(type);
            }
        });
    }

    public RestResponse log(Level level, Throwable t, String msg, Object ... args) {
        this.client.log(level, t, msg, args);
        return this;
    }

    public RestResponse log(Level level, String msg, Object ... args) {
        this.client.log(level, msg, args);
        return this;
    }

    public ResponseStatusLine getStatusLine() {
        return new ResponseStatusLine(this, this.response.getStatusLine());
    }

    public void setStatusLine(StatusLine statusline) {
        this.response.setStatusLine(statusline);
    }

    public void setStatusLine(ProtocolVersion ver, int code) {
        this.response.setStatusLine(ver, code);
    }

    public void setStatusLine(ProtocolVersion ver, int code, String reason) {
        this.response.setStatusLine(ver, code, reason);
    }

    public void setStatusCode(int code) {
        this.response.setStatusCode(code);
    }

    public void setReasonPhrase(String reason) {
        this.response.setReasonPhrase(reason);
    }

    public ResponseContent getEntity() {
        return this.responseContent;
    }

    public void setEntity(HttpEntity entity) {
        this.response.setEntity(entity);
        this.responseContent = new ResponseContent(this.client, this.request, this, this.parser);
    }

    public Locale getLocale() {
        return this.response.getLocale();
    }

    public void setLocale(Locale loc) {
        this.response.setLocale(loc);
    }

    public ProtocolVersion getProtocolVersion() {
        return this.response.getProtocolVersion();
    }

    public boolean containsHeader(String name) {
        return this.response.containsHeader(name);
    }

    public ResponseHeader[] getHeaders(String name) {
        return (ResponseHeader[])this.headers.stream(name).map(x -> new ResponseHeader(name, this.request, this, (Header)x).parser(this.getPartParserSession())).toArray(ResponseHeader[]::new);
    }

    public ResponseHeader getFirstHeader(String name) {
        return new ResponseHeader(name, this.request, this, this.headers.getFirst(name).orElse(null)).parser(this.getPartParserSession());
    }

    public ResponseHeader getLastHeader(String name) {
        return new ResponseHeader(name, this.request, this, this.headers.getLast(name).orElse(null)).parser(this.getPartParserSession());
    }

    public ResponseHeader getHeader(String name) {
        return new ResponseHeader(name, this.request, this, this.headers.get(name).orElse(null)).parser(this.getPartParserSession());
    }

    public ResponseHeader[] getAllHeaders() {
        return (ResponseHeader[])this.headers.stream().map(x -> new ResponseHeader(x.getName(), this.request, this, (Header)x).parser(this.getPartParserSession())).toArray(ResponseHeader[]::new);
    }

    public void addHeader(Header header) {
        this.headers = (HeaderList)this.headers.copy().append(header).build();
    }

    public void addHeader(String name, String value) {
        this.headers = (HeaderList)this.headers.copy().append(name, (Object)value).build();
    }

    public void setHeader(Header header) {
        this.headers = (HeaderList)this.headers.copy().set(header).build();
    }

    public void setHeader(String name, String value) {
        this.headers = (HeaderList)this.headers.copy().set(name, (Object)value).build();
    }

    public void setHeaders(Header[] headers) {
        this.headers = HeaderList.of((Header[])headers);
    }

    public void removeHeader(Header header) {
        this.headers = (HeaderList)this.headers.copy().remove(header).build();
    }

    public void removeHeaders(String name) {
        this.headers = (HeaderList)this.headers.copy().remove(name).build();
    }

    public HeaderIterator headerIterator() {
        return this.headers.iterator();
    }

    public HeaderIterator headerIterator(String name) {
        return this.headers.iterator(name);
    }

    @Deprecated
    public HttpParams getParams() {
        return this.response.getParams();
    }

    @Deprecated
    public void setParams(HttpParams params) {
        this.response.setParams(params);
    }

    void close() throws RestCallException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        EntityUtils.consumeQuietly((HttpEntity)this.response.getEntity());
        if (!this.request.isLoggingSuppressed() && (this.request.isDebug() || this.client.logRequestsPredicate.test(this.request, this))) {
            if (this.client.logRequests == DetailLevel.SIMPLE) {
                this.client.log(this.client.logRequestsLevel, "HTTP {0} {1}, {2}", this.request.getMethod(), this.request.getURI(), this.getStatusLine());
            } else if (this.request.isDebug() || this.client.logRequests == DetailLevel.FULL) {
                String output = this.getContent().asString();
                StringBuilder sb = new StringBuilder();
                sb.append("\n=== HTTP Call (outgoing) ======================================================");
                sb.append("\n=== REQUEST ===\n");
                sb.append(this.request.getMethod()).append(" ").append(this.request.getURI());
                sb.append("\n---request headers---");
                this.request.getHeaderList().forEach(x -> sb.append("\n\t").append(x));
                if (this.request.hasHttpEntity()) {
                    sb.append("\n---request entity---");
                    ResponseHeader[] e = this.request.getHttpEntity();
                    if (e.getContentType() != null) {
                        sb.append("\n\t").append(e.getContentType());
                    }
                    if (e.isRepeatable()) {
                        try {
                            sb.append("\n---request content---\n").append(EntityUtils.toString((HttpEntity)e));
                        }
                        catch (Exception ex) {
                            sb.append("\n---request content exception---\n").append(ex.getMessage());
                        }
                    }
                }
                sb.append("\n=== RESPONSE ===\n").append(this.getStatusLine());
                sb.append("\n---response headers---");
                for (ResponseHeader h : this.getAllHeaders()) {
                    sb.append("\n\t").append((Object)h);
                }
                sb.append("\n---response content---\n").append(output);
                sb.append("\n=== END =======================================================================");
                this.client.log(this.client.logRequestsLevel, sb.toString(), new Object[0]);
            }
        }
        for (RestCallInterceptor r : this.request.interceptors) {
            try {
                r.onClose(this.request, this);
            }
            catch (RuntimeException | RestCallException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RestCallException(this, e, "Interceptor throw exception on close", new Object[0]);
            }
        }
        this.client.onClose(this.request, this);
    }

    protected HttpPartParserSession getPartParserSession(HttpPartParser parser) {
        HttpPartParserSession s = this.partParserSessions.get(parser);
        if (s == null) {
            s = parser.getPartSession();
            this.partParserSessions.put(parser, s);
        }
        return s;
    }

    protected HttpPartParserSession getPartParserSession() {
        if (this.partParserSession == null) {
            this.partParserSession = this.client.getPartParser().getPartSession();
        }
        return this.partParserSession;
    }

    HttpResponse asHttpResponse() {
        return this.response;
    }
}

