/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.servlet;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.juneau.http.response.InternalServerError;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.annotation.HookEvent;
import org.apache.juneau.rest.annotation.RestHook;

public abstract class RestObject {
    private AtomicReference<RestContext> context = new AtomicReference();

    protected void setContext(RestContext context) throws ServletException {
        this.context.set(context);
    }

    protected RestContext getContext() {
        if (this.context.get() == null) {
            throw new InternalServerError("RestContext object not set on resource.", new Object[0]);
        }
        return this.context.get();
    }

    public void log(String msg) {
        this.doLog(Level.INFO, null, () -> msg);
    }

    public void log(String msg, Throwable cause) {
        this.doLog(Level.INFO, null, () -> msg);
    }

    public void log(Level level, String msg, Object ... args) {
        this.doLog(level, null, () -> StringUtils.format(msg, args));
    }

    public void log(Level level, Throwable cause, String msg, Object ... args) {
        this.doLog(level, cause, () -> StringUtils.format(msg, args));
    }

    protected void doLog(Level level, Throwable cause, Supplier<String> msg) {
        Logger logger;
        RestContext c = this.context.get();
        Logger logger2 = logger = c == null ? null : c.getLogger();
        if (logger == null) {
            logger = Logger.getLogger(ClassUtils.className(this));
        }
        logger.log(level, cause, msg);
    }

    @RestHook(value=HookEvent.INIT)
    public void onInit(RestContext.Builder builder) throws Exception {
    }

    @RestHook(value=HookEvent.POST_INIT)
    public void onPostInit(RestContext context) throws Exception {
    }

    @RestHook(value=HookEvent.POST_INIT_CHILD_FIRST)
    public void onPostInitChildFirst(RestContext context) throws Exception {
    }

    @RestHook(value=HookEvent.DESTROY)
    public void onDestroy(RestContext context) throws Exception {
    }

    @RestHook(value=HookEvent.START_CALL)
    public void onStartCall(HttpServletRequest req, HttpServletResponse res) throws Exception {
    }

    @RestHook(value=HookEvent.PRE_CALL)
    public void onPreCall(RestRequest req, RestResponse res) throws Exception {
    }

    @RestHook(value=HookEvent.POST_CALL)
    public void onPostCall(RestRequest req, RestResponse res) throws Exception {
    }

    @RestHook(value=HookEvent.END_CALL)
    public void onEndCall(HttpServletRequest req, HttpServletResponse res) throws Exception {
    }

    public synchronized RestRequest getRequest() {
        return this.getContext().getLocalSession().getOpSession().getRequest();
    }

    public synchronized RestResponse getResponse() {
        return this.getContext().getLocalSession().getOpSession().getResponse();
    }
}

