/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.arg;

import java.io.InputStream;
import java.io.Reader;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TimeZone;
import javax.servlet.ServletInputStream;
import org.apache.juneau.UriContext;
import org.apache.juneau.UriResolver;
import org.apache.juneau.cp.Messages;
import org.apache.juneau.dto.swagger.Swagger;
import org.apache.juneau.httppart.HttpPartParserSession;
import org.apache.juneau.httppart.HttpPartSerializerSession;
import org.apache.juneau.reflect.ParamInfo;
import org.apache.juneau.rest.RestOpSession;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.arg.SimpleRestOperationArg;
import org.apache.juneau.rest.httppart.RequestAttributes;
import org.apache.juneau.rest.httppart.RequestContent;
import org.apache.juneau.rest.httppart.RequestFormParams;
import org.apache.juneau.rest.httppart.RequestHeaders;
import org.apache.juneau.rest.httppart.RequestPathParams;
import org.apache.juneau.rest.httppart.RequestQueryParams;
import org.apache.juneau.svl.VarResolverSession;
import org.apache.juneau.utils.ThrowingFunction;

public class RestRequestArgs
extends SimpleRestOperationArg {
    public static RestRequestArgs create(ParamInfo paramInfo) {
        if (paramInfo.isType(HttpPartParserSession.class)) {
            return new RestRequestArgs(x -> x.getPartParserSession());
        }
        if (paramInfo.isType(HttpPartSerializerSession.class)) {
            return new RestRequestArgs(x -> x.getPartSerializerSession());
        }
        if (paramInfo.isType(InputStream.class)) {
            return new RestRequestArgs(x -> x.getInputStream());
        }
        if (paramInfo.isType(Locale.class)) {
            return new RestRequestArgs(x -> x.getLocale());
        }
        if (paramInfo.isType(Messages.class)) {
            return new RestRequestArgs(x -> x.getMessages());
        }
        if (paramInfo.isType(Reader.class)) {
            return new RestRequestArgs(x -> x.getReader());
        }
        if (paramInfo.isType(RequestAttributes.class)) {
            return new RestRequestArgs(x -> x.getAttributes());
        }
        if (paramInfo.isType(RequestContent.class)) {
            return new RestRequestArgs(x -> x.getContent());
        }
        if (paramInfo.isType(RequestFormParams.class)) {
            return new RestRequestArgs(x -> x.getFormParams());
        }
        if (paramInfo.isType(RequestHeaders.class)) {
            return new RestRequestArgs(x -> x.getHeaders());
        }
        if (paramInfo.isType(RequestPathParams.class)) {
            return new RestRequestArgs(x -> x.getPathParams());
        }
        if (paramInfo.isType(RequestQueryParams.class)) {
            return new RestRequestArgs(x -> x.getQueryParams());
        }
        if (paramInfo.isType(ResourceBundle.class)) {
            return new RestRequestArgs(x -> x.getMessages());
        }
        if (paramInfo.isType(RestRequest.class)) {
            return new RestRequestArgs(x -> x);
        }
        if (paramInfo.isType(ServletInputStream.class)) {
            return new RestRequestArgs(x -> x.getInputStream());
        }
        if (paramInfo.isType(Swagger.class)) {
            return new RestRequestArgs(x -> x.getSwagger().orElse(null));
        }
        if (paramInfo.isType(TimeZone.class)) {
            return new RestRequestArgs(x -> x.getTimeZone().orElse(null));
        }
        if (paramInfo.isType(UriContext.class)) {
            return new RestRequestArgs(x -> x.getUriContext());
        }
        if (paramInfo.isType(UriResolver.class)) {
            return new RestRequestArgs(x -> x.getUriResolver());
        }
        if (paramInfo.isType(VarResolverSession.class)) {
            return new RestRequestArgs(x -> x.getVarResolverSession());
        }
        return null;
    }

    protected <T> RestRequestArgs(ThrowingFunction<RestRequest, T> function) {
        super((RestOpSession session) -> function.apply(session.getRequest()));
    }
}

