/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.httppart;

import java.time.ZonedDateTime;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.juneau.assertions.FluentIntegerAssertion;
import org.apache.juneau.assertions.FluentListAssertion;
import org.apache.juneau.assertions.FluentLongAssertion;
import org.apache.juneau.assertions.FluentStringAssertion;
import org.apache.juneau.assertions.FluentZonedDateTimeAssertion;
import org.apache.juneau.httppart.HttpPartParserSession;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.httppart.RequestHttpPart;

public class RequestQueryParam
extends RequestHttpPart
implements NameValuePair {
    private final String value;

    public RequestQueryParam(RestRequest request, String name, String value) {
        super(HttpPartType.QUERY, request, name);
        this.value = value;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public FluentStringAssertion<RequestQueryParam> assertString() {
        return new FluentStringAssertion(this.orElse(null), (Object)this);
    }

    public FluentIntegerAssertion<RequestQueryParam> assertInteger() {
        return new FluentIntegerAssertion((Integer)this.asIntegerPart().asInteger().orElse(null), (Object)this);
    }

    public FluentLongAssertion<RequestQueryParam> assertLong() {
        return new FluentLongAssertion((Long)this.asLongPart().asLong().orElse(null), (Object)this);
    }

    public FluentZonedDateTimeAssertion<RequestQueryParam> assertDate() {
        return new FluentZonedDateTimeAssertion((ZonedDateTime)this.asDatePart().asZonedDateTime().orElse(null), (Object)this);
    }

    public FluentListAssertion<String, RequestQueryParam> assertCsvArray() {
        return new FluentListAssertion((List)this.asCsvArrayPart().asList().orElse(null), (Object)this);
    }

    @Override
    public RequestQueryParam schema(HttpPartSchema value) {
        super.schema(value);
        return this;
    }

    @Override
    public RequestQueryParam parser(HttpPartParserSession value) {
        super.parser(value);
        return this;
    }
}

