/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.lang.reflect.Type;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.ParseException;
import org.apache.juneau.BasicAssertionError;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.httppart.HttpPartParserSession;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.httppart.SimplePartParser;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.utils.Mutable;

public class RequestHeader
implements Header {
    static final Header NULL_HEADER = new Header(){

        public String getName() {
            return null;
        }

        public String getValue() {
            return null;
        }

        public HeaderElement[] getElements() throws ParseException {
            return new HeaderElement[0];
        }
    };
    private final Header header;
    private final RestRequest request;
    private final RestResponse response;
    private HttpPartParserSession parser;
    private HttpPartSchema schema;

    public RequestHeader(RestRequest request, RestResponse response, Header header) {
        this.request = request;
        this.response = response;
        this.header = header == null ? NULL_HEADER : header;
        this.parser(null);
    }

    public RequestHeader schema(HttpPartSchema value) {
        this.schema = value;
        return this;
    }

    public RequestHeader parser(HttpPartParserSession value) {
        this.parser = value == null ? SimplePartParser.DEFAULT_SESSION : value;
        return this;
    }

    public boolean exists() {
        return this.header != NULL_HEADER;
    }

    public String asString() {
        return this.getValue();
    }

    public RestResponse asString(Mutable<String> m) {
        m.set((Object)this.asString());
        return this.response;
    }

    public Optional<String> asOptionalString() {
        return Optional.ofNullable(this.getValue());
    }

    public String asStringOrElse(String def) {
        return this.getValue() == null ? def : this.getValue();
    }

    public RestResponse asStringOrElse(Mutable<String> m, String def) {
        m.set((Object)this.asStringOrElse(def));
        return this.response;
    }

    public <T> T as(Type type, Type ... args) throws org.apache.juneau.parser.ParseException {
        return this.as(this.request.getClassMeta(type, args));
    }

    public <T> RestResponse as(Mutable<T> m, Type type, Type ... args) throws org.apache.juneau.parser.ParseException {
        m.set(this.as(type, args));
        return this.response;
    }

    public <T> T as(Class<T> type) throws org.apache.juneau.parser.ParseException {
        return this.as(this.request.getClassMeta(type));
    }

    public <T> RestResponse as(Mutable<T> m, Class<T> type) throws org.apache.juneau.parser.ParseException {
        m.set(this.as(type));
        return this.response;
    }

    public <T> T as(ClassMeta<T> type) throws org.apache.juneau.parser.ParseException {
        return (T)this.parser.parse(HttpPartType.HEADER, this.schema, this.asString(), type);
    }

    public <T> RestResponse as(Mutable<T> m, ClassMeta<T> type) throws org.apache.juneau.parser.ParseException {
        m.set(this.as(type));
        return this.response;
    }

    public <T> Optional<T> asOptional(Type type, Type ... args) throws org.apache.juneau.parser.ParseException {
        return Optional.ofNullable(this.as(type, args));
    }

    public <T> RestResponse asOptional(Mutable<Optional<T>> m, Type type, Type ... args) throws org.apache.juneau.parser.ParseException {
        m.set(this.asOptional(type, args));
        return this.response;
    }

    public <T> Optional<T> asOptional(Class<T> type) throws org.apache.juneau.parser.ParseException {
        return Optional.ofNullable(this.as(type));
    }

    public <T> RestResponse asOptional(Mutable<Optional<T>> m, Class<T> type) throws org.apache.juneau.parser.ParseException {
        m.set(this.asOptional(type));
        return this.response;
    }

    public <T> Optional<T> asOptional(ClassMeta<T> type) throws org.apache.juneau.parser.ParseException {
        return Optional.ofNullable(this.as(type));
    }

    public <T> RestResponse asOptional(Mutable<Optional<T>> m, ClassMeta<T> type) throws org.apache.juneau.parser.ParseException {
        m.set(this.asOptional(type));
        return this.response;
    }

    public Matcher asMatcher(Pattern pattern) {
        return pattern.matcher(this.asString());
    }

    public RestResponse asMatcher(Mutable<Matcher> m, Pattern pattern) {
        m.set((Object)pattern.matcher(this.asString()));
        return this.response;
    }

    public Matcher asMatcher(String regex) {
        return this.asMatcher(regex, 0);
    }

    public RestResponse asMatcher(Mutable<Matcher> m, String regex) {
        this.asMatcher(regex, 0);
        return this.response;
    }

    public Matcher asMatcher(String regex, int flags) {
        return this.asMatcher(Pattern.compile(regex, flags));
    }

    public RestResponse asMatcher(Mutable<Matcher> m, String regex, int flags) {
        this.asMatcher(Pattern.compile(regex, flags));
        return this.response;
    }

    public RestResponse toResponse() {
        return this.response;
    }

    public RestResponse assertExists() throws AssertionError {
        if (!this.exists()) {
            throw new BasicAssertionError("Response did not have the expected header {0}.", new Object[]{this.getName()});
        }
        return this.response;
    }

    public RestResponse assertValue(String value) throws AssertionError {
        if (!StringUtils.isEquals((String)value, (String)this.asString())) {
            throw new BasicAssertionError("Response did not have the expected value for header {0}.\n\tExpected=[{1}]\n\tActual=[{2}]", new Object[]{this.getName(), value, this.asString()});
        }
        return this.response;
    }

    public RestResponse assertValue(Predicate<String> test) throws AssertionError {
        String text = this.asString();
        if (!test.test(text)) {
            throw new BasicAssertionError("Response did not have the expected value for header {0}.\n\tActual=[{1}]", new Object[]{this.getName(), text});
        }
        return this.response;
    }

    public RestResponse assertContains(String ... values) throws AssertionError {
        String text = this.asString();
        for (String substring : values) {
            if (StringUtils.contains((String)text, (CharSequence)substring)) continue;
            throw new BasicAssertionError("Response did not have the expected substring in header {0}.\n\tExpected=[{1}]\n\tHeader=[{2}]", new Object[]{this.getName(), substring, text});
        }
        return this.response;
    }

    public RestResponse assertMatches(String regex) throws AssertionError {
        return this.assertMatches(regex, 0);
    }

    public RestResponse assertMatches(String regex, int flags) throws AssertionError {
        String text = this.asString();
        if (!Pattern.compile(regex, flags).matcher(text).matches()) {
            throw new BasicAssertionError("Response did not match expected pattern in header {0}.\n\tpattern=[{1}]\n\tHeader=[{2}]", new Object[]{this.getName(), regex, text});
        }
        return this.response;
    }

    public RestResponse assertMatches(Pattern pattern) throws AssertionError {
        String text = this.asString();
        if (!pattern.matcher(text).matches()) {
            throw new BasicAssertionError("Response did not match expected pattern in header {0}.\n\tpattern=[{1}]\n\tHeader=[{2}]", new Object[]{this.getName(), pattern.pattern(), text});
        }
        return this.response;
    }

    public String getName() {
        return this.header.getName();
    }

    public String getValue() {
        return this.header.getValue();
    }

    public HeaderElement[] getElements() throws ParseException {
        return this.header.getElements();
    }

    public String toString() {
        return this.getName() + ": " + this.getValue();
    }
}

