/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.httppart;

import org.apache.http.NameValuePair;
import org.apache.juneau.httppart.HttpPartParserSession;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartSerializerSession;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.httppart.SchemaValidationException;
import org.apache.juneau.parser.ParseException;

public class HttpPart
implements NameValuePair {
    private final String name;
    private final Object opart;
    private final String spart;
    private final HttpPartType partType;
    private final HttpPartSchema schema;
    private final HttpPartSerializerSession serializer;
    private final HttpPartParserSession parser;

    public HttpPart(String name, HttpPartType partType, HttpPartSchema schema, HttpPartSerializerSession serializer, Object part) {
        this.name = name;
        this.partType = partType;
        this.schema = schema;
        this.serializer = serializer;
        this.opart = part;
        this.spart = null;
        this.parser = null;
    }

    public HttpPart(String name, HttpPartType partType, HttpPartSchema schema, HttpPartParserSession parser, String part) {
        this.name = name;
        this.partType = partType;
        this.schema = schema;
        this.parser = parser;
        this.spart = part;
        this.serializer = null;
        this.opart = null;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        if (this.spart != null) {
            return this.spart;
        }
        try {
            return this.serializer.serialize(this.partType, this.schema, this.opart);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T asType(Class<T> c) throws SchemaValidationException, ParseException {
        return this.parser.parse(this.partType, this.schema, this.spart, c);
    }
}

