/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.json.SimpleJsonSerializer;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.WriterSerializer;
import org.apache.juneau.utils.PojoRest;

public class ObjectList
extends LinkedList<Object> {
    private static final long serialVersionUID = 1L;
    transient BeanSession session = null;
    private transient PojoRest pojoRest;
    public static final ObjectList EMPTY_LIST = new ObjectList(){
        private static final long serialVersionUID = 1L;

        @Override
        public void add(int location, Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ListIterator<Object> listIterator(int location) {
            return Collections.emptyList().listIterator(location);
        }

        @Override
        public Object remove(int location) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object set(int location, Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Object> subList(int start, int end) {
            return Collections.emptyList().subList(start, end);
        }
    };

    public static ObjectList parse(CharSequence s) throws ParseException {
        return s == null ? null : new ObjectList(s);
    }

    public ObjectList(CharSequence s, Parser p) throws ParseException {
        this(p == null ? null : p.createBeanSession());
        if (p == null) {
            p = JsonParser.DEFAULT;
        }
        if (s != null) {
            p.parseIntoCollection(s, this, this.bs2().object());
        }
    }

    public ObjectList(CharSequence s) throws ParseException {
        this(s, null);
    }

    public ObjectList(Reader r, Parser p) throws ParseException, IOException {
        this(p == null ? null : p.createBeanSession());
        this.parseReader(r, p);
    }

    public ObjectList(Reader r) throws ParseException, IOException {
        this.parseReader(r, JsonParser.DEFAULT);
    }

    private void parseReader(Reader r, Parser p) throws ParseException {
        if (p == null) {
            p = JsonParser.DEFAULT;
        }
        p.parseIntoCollection(r, this, this.bs2().object());
    }

    public ObjectList() {
    }

    public ObjectList(BeanSession session) {
        this.session = session;
    }

    public ObjectList(Object ... o) {
        Collections.addAll(this, o);
    }

    public ObjectList(Collection<?> c) {
        super(c);
    }

    public ObjectList setBeanSession(BeanSession session) {
        this.session = session;
        return this;
    }

    public BeanSession getBeanSession() {
        return this.session;
    }

    public ObjectList append(Object ... o) {
        for (Object o2 : o) {
            this.add(o2);
        }
        return this;
    }

    public ObjectList appendAll(ObjectList l) {
        if (l != null) {
            this.addAll(l);
        }
        return this;
    }

    public ObjectList appendIfNotEmpty(String ... o) {
        for (String s : o) {
            if (!StringUtils.isNotEmpty(s)) continue;
            this.add(s);
        }
        return this;
    }

    public ObjectList appendIfNotNull(Object ... o) {
        for (Object o2 : o) {
            if (o2 == null) continue;
            this.add(o2);
        }
        return this;
    }

    public <T> T get(int index, Class<T> type) {
        return this.bs2().convertToType(this.get(index), type);
    }

    public <T> T get(int index, Type type, Type ... args) {
        return this.bs2().convertToType(this.get(index), type, args);
    }

    public String getString(int index) {
        return this.get(index, String.class);
    }

    public Integer getInt(int index) {
        return this.get(index, Integer.class);
    }

    public Boolean getBoolean(int index) {
        return this.get(index, Boolean.class);
    }

    public Long getLong(int index) {
        return this.get(index, Long.class);
    }

    public Map<?, ?> getMap(int index) {
        return this.get(index, Map.class);
    }

    public <K, V> Map<K, V> getMap(int index, Class<K> keyType, Class<V> valType) {
        return (Map)this.bs2().convertToType(this.get(index), (Type)((Object)Map.class), keyType, valType);
    }

    public List<?> getList(int index) {
        return this.get(index, List.class);
    }

    public <E> List<E> getList(int index, Class<E> elementType) {
        return (List)this.bs2().convertToType(this.get(index), (Type)((Object)List.class), elementType);
    }

    public ObjectMap getObjectMap(int index) {
        return this.get(index, ObjectMap.class);
    }

    public ObjectList getObjectList(int index) {
        return this.get(index, ObjectList.class);
    }

    public <T> T getAt(String path, Class<T> type) {
        return this.getPojoRest().get(path, type);
    }

    public <T> T getAt(String path, Type type, Type ... args) {
        return this.getPojoRest().get(path, type, args);
    }

    public Object putAt(String path, Object o) {
        return this.getPojoRest().put(path, o);
    }

    public Object postAt(String path, Object o) {
        return this.getPojoRest().post(path, o);
    }

    public Object deleteAt(String path) {
        return this.getPojoRest().delete(path);
    }

    public <E> Iterable<E> elements(final Class<E> childType) {
        final Iterator i = this.iterator();
        return new Iterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return new Iterator<E>(){

                    @Override
                    public boolean hasNext() {
                        return i.hasNext();
                    }

                    @Override
                    public E next() {
                        return ObjectList.this.bs2().convertToType(i.next(), childType);
                    }

                    @Override
                    public void remove() {
                        i.remove();
                    }
                };
            }
        };
    }

    public ClassMeta<?> getClassMeta(int index) {
        return this.bs2().getClassMetaForObject(this.get(index));
    }

    private PojoRest getPojoRest() {
        if (this.pojoRest == null) {
            this.pojoRest = new PojoRest(this);
        }
        return this.pojoRest;
    }

    public String toString(WriterSerializer serializer) throws SerializeException {
        return serializer.serialize(this);
    }

    public boolean isUnmodifiable() {
        return false;
    }

    public ObjectList modifiable() {
        if (this.isUnmodifiable()) {
            return new ObjectList((Collection<?>)this);
        }
        return this;
    }

    public ObjectList unmodifiable() {
        if (this instanceof UnmodifiableObjectList) {
            return this;
        }
        return new UnmodifiableObjectList(this);
    }

    @Override
    public String toString() {
        try {
            return this.toString(SimpleJsonSerializer.DEFAULT);
        }
        catch (SerializeException e) {
            return e.getLocalizedMessage();
        }
    }

    public void serializeTo(Writer w) throws IOException, SerializeException {
        JsonSerializer.DEFAULT.serialize(this);
    }

    public Object cast(ClassMeta<?> cm) {
        try {
            return JsonParser.DEFAULT.parse(SimpleJsonSerializer.DEFAULT.serialize(this), cm);
        }
        catch (ParseException | SerializeException e) {
            throw new RuntimeException(e);
        }
    }

    BeanSession bs2() {
        if (this.session == null) {
            this.session = BeanContext.DEFAULT.createBeanSession();
        }
        return this.session;
    }

    private static final class UnmodifiableObjectList
    extends ObjectList {
        private static final long serialVersionUID = 1L;

        UnmodifiableObjectList(ObjectList contents) {
            if (contents != null) {
                for (Object e : this) {
                    super.add(e);
                }
            }
        }

        @Override
        public void add(int location, Object object) {
            throw new UnsupportedOperationException("ObjectList is read-only.");
        }

        @Override
        public Object remove(int location) {
            throw new UnsupportedOperationException("ObjectList is read-only.");
        }

        @Override
        public Object set(int location, Object object) {
            throw new UnsupportedOperationException("ObjectList is read-only.");
        }

        @Override
        public final boolean isUnmodifiable() {
            return true;
        }
    }
}

