/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.swagger;

import java.net.URI;
import java.util.Collection;
import java.util.Set;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.dto.swagger.SwaggerElement;
import org.apache.juneau.internal.MultiSet;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.utils.ASet;

@Bean(bpi="name,url,email,*")
public class Contact
extends SwaggerElement {
    private String name;
    private URI url;
    private String email;

    public Contact() {
    }

    public Contact(Contact copyFrom) {
        super(copyFrom);
        this.name = copyFrom.name;
        this.url = copyFrom.url;
        this.email = copyFrom.email;
    }

    public Contact copy() {
        return new Contact(this);
    }

    public String getName() {
        return this.name;
    }

    public Contact setName(String value) {
        this.name = value;
        return this;
    }

    public Contact name(Object value) {
        return this.setName(StringUtils.stringify((Object)value));
    }

    public URI getUrl() {
        return this.url;
    }

    public Contact setUrl(URI value) {
        this.url = value;
        return this;
    }

    public Contact url(Object value) {
        return this.setUrl(StringUtils.toURI((Object)value));
    }

    public String getEmail() {
        return this.email;
    }

    public Contact setEmail(String value) {
        this.email = value;
        return this;
    }

    public Contact email(Object value) {
        return this.setEmail(StringUtils.stringify((Object)value));
    }

    public boolean hasName() {
        return StringUtils.isNotEmpty((String)this.name);
    }

    public boolean hasUrl() {
        return this.url != null;
    }

    public boolean hasEmail() {
        return StringUtils.isNotEmpty((String)this.email);
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        if (property == null) {
            return null;
        }
        switch (property) {
            case "name": {
                return (T)ObjectUtils.toType((Object)this.getName(), type);
            }
            case "url": {
                return (T)ObjectUtils.toType((Object)this.getUrl(), type);
            }
            case "email": {
                return (T)ObjectUtils.toType((Object)this.getEmail(), type);
            }
        }
        return super.get(property, type);
    }

    @Override
    public Contact set(String property, Object value) {
        if (property == null) {
            return this;
        }
        switch (property) {
            case "name": {
                return this.name(value);
            }
            case "url": {
                return this.url(value);
            }
            case "email": {
                return this.email(value);
            }
        }
        super.set(property, value);
        return this;
    }

    @Override
    public Set<String> keySet() {
        ASet s = new ASet().appendIf(this.name != null, (Object)"name").appendIf(this.url != null, (Object)"url").appendIf(this.email != null, (Object)"email");
        return new MultiSet(new Collection[]{s, super.keySet()});
    }
}

