/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.utils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.juneau.utils.MethodExecStats;

public class MethodInvoker {
    private final Method m;
    private final MethodExecStats stats;

    public MethodInvoker(Method m, MethodExecStats stats) {
        this.m = m;
        this.stats = stats;
    }

    public Method inner() {
        return this.m;
    }

    public Object invoke(Object o, Object ... args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        long startTime = System.nanoTime();
        this.stats.started();
        try {
            Object object = this.m.invoke(o, args);
            return object;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            this.stats.error(e);
            throw e;
        }
        catch (InvocationTargetException e) {
            this.stats.error(e.getTargetException());
            throw e;
        }
        finally {
            this.stats.finished(System.nanoTime() - startTime);
        }
    }

    public Class<?> getDeclaringClass() {
        return this.m.getDeclaringClass();
    }

    public String getName() {
        return this.m.getName();
    }
}

