/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ObjectList;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.Value;
import org.apache.juneau.dto.swagger.Swagger;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.http.annotation.Body;
import org.apache.juneau.http.annotation.Contact;
import org.apache.juneau.http.annotation.FormData;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.annotation.License;
import org.apache.juneau.http.annotation.Path;
import org.apache.juneau.http.annotation.Query;
import org.apache.juneau.http.annotation.Response;
import org.apache.juneau.http.annotation.ResponseHeader;
import org.apache.juneau.http.annotation.Tag;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.json.SimpleJsonSerializer;
import org.apache.juneau.jsonschema.JsonSchemaGeneratorSession;
import org.apache.juneau.jsonschema.annotation.ExternalDocs;
import org.apache.juneau.jsonschema.annotation.Items;
import org.apache.juneau.jsonschema.annotation.Schema;
import org.apache.juneau.jsonschema.annotation.SubItems;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.MethodInfo;
import org.apache.juneau.reflect.ParamInfo;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.RestMethodContext;
import org.apache.juneau.rest.RestMethodParam;
import org.apache.juneau.rest.RestParamType;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestServletException;
import org.apache.juneau.rest.SwaggerException;
import org.apache.juneau.rest.annotation.MethodSwagger;
import org.apache.juneau.rest.annotation.ResourceSwagger;
import org.apache.juneau.rest.annotation.Rest;
import org.apache.juneau.rest.annotation.RestMethod;
import org.apache.juneau.rest.annotation.RestResource;
import org.apache.juneau.rest.util.AnnotationUtils;
import org.apache.juneau.rest.util.RestUtils;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.serializer.SerializerSessionArgs;
import org.apache.juneau.serializer.WriterSerializer;
import org.apache.juneau.svl.VarResolverSession;
import org.apache.juneau.utils.ASet;
import org.apache.juneau.utils.MessageBundle;

final class SwaggerGenerator {
    private final RestRequest req;
    private final VarResolverSession vr;
    private final Locale locale;
    private final RestContext context;
    private final JsonParser jp = JsonParser.create().ignoreUnknownBeanProperties().build();
    private final JsonSchemaGeneratorSession js;
    private final Class<?> c;
    private final Object resource;
    private final MessageBundle mb;

    public SwaggerGenerator(RestRequest req) {
        this.req = req;
        this.vr = req.getVarResolverSession();
        this.locale = req.getLocale();
        this.context = req.getContext();
        this.js = req.getJsonSchemaGenerator().createSession();
        this.c = this.context.getResource().getClass();
        this.resource = this.context.getResource();
        this.mb = this.context.getMessages();
    }

    public Swagger getSwagger() throws Exception {
        String s;
        Object info;
        ResourceSwagger r;
        ObjectMap sInfo;
        ClassInfo rci = ClassInfo.of(this.resource.getClass());
        rci.getSimpleName();
        ObjectMap omSwagger = this.context.getClasspathResource(ObjectMap.class, MediaType.JSON, rci.getSimpleName() + ".json", this.locale);
        if (omSwagger == null) {
            omSwagger = this.context.getClasspathResource(ObjectMap.class, MediaType.JSON, rci.getSimpleName() + ".json", this.locale);
        }
        if (omSwagger == null) {
            omSwagger = new ObjectMap();
        }
        for (RestResource rr : rci.getAnnotationsParentFirst(RestResource.class)) {
            sInfo = omSwagger.getObjectMap("info", true);
            sInfo.appendSkipEmpty("title", (Object)this.firstNonEmpty(sInfo.getString("title"), this.resolve(rr.title())));
            sInfo.appendSkipEmpty("description", (Object)this.firstNonEmpty(sInfo.getString("description"), this.resolve(rr.description())));
            r = rr.swagger();
            omSwagger.appendAll((Map)this.parseMap(r.value(), "@ResourceSwagger(value) on class {0}", this.c));
            if (!AnnotationUtils.empty((ResourceSwagger)r)) {
                info = omSwagger.getObjectMap("info", true);
                info.appendSkipEmpty("title", (Object)this.resolve(r.title()));
                info.appendSkipEmpty("description", (Object)this.resolve(r.description()));
                info.appendSkipEmpty("version", (Object)this.resolve(r.version()));
                info.appendSkipEmpty("termsOfService", (Object)this.resolve(r.termsOfService()));
                info.appendSkipEmpty("contact", (Object)this.merge(info.getObjectMap("contact"), this.toMap(r.contact(), "@ResourceSwagger(contact) on class {0}", this.c)));
                info.appendSkipEmpty("license", (Object)this.merge(info.getObjectMap("license"), this.toMap(r.license(), "@ResourceSwagger(license) on class {0}", this.c)));
            }
            omSwagger.appendSkipEmpty("externalDocs", (Object)this.merge(omSwagger.getObjectMap("externalDocs"), this.toMap(r.externalDocs(), "@ResourceSwagger(externalDocs) on class {0}", this.c)));
            omSwagger.appendSkipEmpty("tags", (Object)this.merge(omSwagger.getObjectList("tags"), this.toList(r.tags(), "@ResourceSwagger(tags) on class {0}", this.c)));
        }
        for (RestResource rr : rci.getAnnotationsParentFirst(Rest.class)) {
            sInfo = omSwagger.getObjectMap("info", true);
            sInfo.appendSkipEmpty("title", (Object)this.firstNonEmpty(sInfo.getString("title"), this.resolve(rr.title())));
            sInfo.appendSkipEmpty("description", (Object)this.firstNonEmpty(sInfo.getString("description"), this.resolve(rr.description())));
            r = rr.swagger();
            omSwagger.appendAll((Map)this.parseMap(r.value(), "@ResourceSwagger(value) on class {0}", this.c));
            if (!AnnotationUtils.empty((ResourceSwagger)r)) {
                info = omSwagger.getObjectMap("info", true);
                info.appendSkipEmpty("title", (Object)this.resolve(r.title()));
                info.appendSkipEmpty("description", (Object)this.resolve(r.description()));
                info.appendSkipEmpty("version", (Object)this.resolve(r.version()));
                info.appendSkipEmpty("termsOfService", (Object)this.resolve(r.termsOfService()));
                info.appendSkipEmpty("contact", (Object)this.merge(info.getObjectMap("contact"), this.toMap(r.contact(), "@ResourceSwagger(contact) on class {0}", this.c)));
                info.appendSkipEmpty("license", (Object)this.merge(info.getObjectMap("license"), this.toMap(r.license(), "@ResourceSwagger(license) on class {0}", this.c)));
            }
            omSwagger.appendSkipEmpty("externalDocs", (Object)this.merge(omSwagger.getObjectMap("externalDocs"), this.toMap(r.externalDocs(), "@ResourceSwagger(externalDocs) on class {0}", this.c)));
            omSwagger.appendSkipEmpty("tags", (Object)this.merge(omSwagger.getObjectList("tags"), this.toList(r.tags(), "@ResourceSwagger(tags) on class {0}", this.c)));
        }
        omSwagger.appendSkipEmpty("externalDocs", (Object)this.parseMap(this.mb.findFirstString(this.locale, new String[]{"externalDocs"}), "Messages/externalDocs on class {0}", this.c));
        ObjectMap info2 = omSwagger.getObjectMap("info", true);
        info2.appendSkipEmpty("title", (Object)this.resolve(this.mb.findFirstString(this.locale, new String[]{"title"})));
        info2.appendSkipEmpty("description", (Object)this.resolve(this.mb.findFirstString(this.locale, new String[]{"description"})));
        info2.appendSkipEmpty("version", (Object)this.resolve(this.mb.findFirstString(this.locale, new String[]{"version"})));
        info2.appendSkipEmpty("termsOfService", (Object)this.resolve(this.mb.findFirstString(this.locale, new String[]{"termsOfService"})));
        info2.appendSkipEmpty("contact", (Object)this.parseMap(this.mb.findFirstString(this.locale, new String[]{"contact"}), "Messages/contact on class {0}", this.c));
        info2.appendSkipEmpty("license", (Object)this.parseMap(this.mb.findFirstString(this.locale, new String[]{"license"}), "Messages/license on class {0}", this.c));
        if (info2.isEmpty()) {
            omSwagger.remove((Object)"info");
        }
        ObjectList produces = omSwagger.getObjectList("produces", true);
        ObjectList consumes = omSwagger.getObjectList("consumes", true);
        if (consumes.isEmpty()) {
            consumes.addAll(this.context.getConsumes());
        }
        if (produces.isEmpty()) {
            produces.addAll(this.context.getProduces());
        }
        LinkedHashMap<Object, Object> tagMap = new LinkedHashMap<Object, Object>();
        if (omSwagger.containsKey((Object)"tags")) {
            for (Object om : omSwagger.getObjectList("tags").elements(ObjectMap.class)) {
                String name = om.getString("name");
                if (name == null) {
                    throw new SwaggerException(null, "Tag definition found without name in swagger JSON.", new Object[0]);
                }
                tagMap.put(name, om);
            }
        }
        if ((s = this.mb.findFirstString(this.locale, new String[]{"tags"})) != null) {
            for (Iterator<Object> m : this.parseListOrCdl(s, "Messages/tags on class {0}", this.c).elements(ObjectMap.class)) {
                String string = m.getString("name");
                if (string == null) {
                    throw new SwaggerException(null, "Tag definition found without name in resource bundle on class {0}", this.c);
                }
                if (tagMap.containsKey(string)) {
                    ((ObjectMap)tagMap.get(string)).putAll(m);
                    continue;
                }
                tagMap.put(string, m);
            }
        }
        ObjectMap definitions = omSwagger.getObjectMap("definitions", true);
        for (String string : definitions.keySet()) {
            this.js.addBeanDef(string, definitions.getObjectMap(string));
        }
        for (RestMethodContext restMethodContext : this.context.getCallMethods().values()) {
            List<MediaType> mProduces;
            List<MediaType> mConsumes;
            Object mpi;
            if (!restMethodContext.isRequestAllowed(this.req)) continue;
            BeanSession bs = restMethodContext.createBeanSession();
            Method m = restMethodContext.method;
            MethodInfo mi = MethodInfo.of((Method)m);
            RestMethod rm = (RestMethod)mi.getAnnotation(RestMethod.class);
            String mn = m.getName();
            ObjectMap op = this.getOperation(omSwagger, restMethodContext.getPathPattern(), restMethodContext.getHttpMethod().toLowerCase());
            MethodSwagger ms = rm.swagger();
            op.appendAll((Map)this.parseMap(ms.value(), "@MethodSwagger(value) on class {0} method {1}", this.c, m));
            op.appendSkipEmpty("operationId", (Object)this.firstNonEmpty(this.resolve(ms.operationId()), op.getString("operationId"), mn));
            op.appendSkipEmpty("summary", (Object)this.firstNonEmpty(this.resolve(ms.summary()), this.resolve(this.mb.findFirstString(this.locale, new String[]{mn + ".summary"})), op.getString("summary"), this.resolve(rm.summary())));
            op.appendSkipEmpty("description", (Object)this.firstNonEmpty(this.resolve(ms.description()), this.resolve(this.mb.findFirstString(this.locale, new String[]{mn + ".description"})), op.getString("description"), this.resolve(rm.description())));
            op.appendSkipEmpty("deprecated", (Object)this.firstNonEmpty(this.resolve(ms.deprecated()), m.getAnnotation(Deprecated.class) != null || m.getDeclaringClass().getAnnotation(Deprecated.class) != null ? "true" : null));
            op.appendSkipEmpty("tags", (Object)this.merge(this.parseListOrCdl(this.mb.findFirstString(this.locale, new String[]{mn + ".tags"}), "Messages/tags on class {0} method {1}", this.c, m), this.parseListOrCdl(ms.tags(), "@MethodSwagger(tags) on class {0} method {1}", this.c, m)));
            op.appendSkipEmpty("schemes", (Object)this.merge(this.parseListOrCdl(this.mb.findFirstString(this.locale, new String[]{mn + ".schemes"}), "Messages/schemes on class {0} method {1}", this.c, m), this.parseListOrCdl(ms.schemes(), "@MethodSwagger(schemes) on class {0} method {1}", this.c, m)));
            op.appendSkipEmpty("consumes", (Object)this.firstNonEmpty(this.parseListOrCdl(this.mb.findFirstString(this.locale, new String[]{mn + ".consumes"}), "Messages/consumes on class {0} method {1}", this.c, m), this.parseListOrCdl(ms.consumes(), "@MethodSwagger(consumes) on class {0} method {1}", this.c, m)));
            op.appendSkipEmpty("produces", (Object)this.firstNonEmpty(this.parseListOrCdl(this.mb.findFirstString(this.locale, new String[]{mn + ".produces"}), "Messages/produces on class {0} method {1}", this.c, m), this.parseListOrCdl(ms.produces(), "@MethodSwagger(produces) on class {0} method {1}", this.c, m)));
            op.appendSkipEmpty("parameters", (Object)this.merge(this.parseList(this.mb.findFirstString(this.locale, new String[]{mn + ".parameters"}), "Messages/parameters on class {0} method {1}", this.c, m), this.parseList(ms.parameters(), "@MethodSwagger(parameters) on class {0} method {1}", this.c, m)));
            op.appendSkipEmpty("responses", (Object)this.merge(this.parseMap(this.mb.findFirstString(this.locale, new String[]{mn + ".responses"}), "Messages/responses on class {0} method {1}", this.c, m), this.parseMap(ms.responses(), "@MethodSwagger(responses) on class {0} method {1}", this.c, m)));
            op.appendSkipEmpty("externalDocs", (Object)this.merge(op.getObjectMap("externalDocs"), this.parseMap(this.mb.findFirstString(this.locale, new String[]{mn + ".externalDocs"}), "Messages/externalDocs on class {0} method {1}", this.c, m), this.toMap(ms.externalDocs(), "@MethodSwagger(externalDocs) on class {0} method {1}", this.c, m)));
            if (op.containsKey((Object)"tags")) {
                for (Object tag : op.getObjectList("tags").elements(String.class)) {
                    if (tagMap.containsKey(tag)) continue;
                    tagMap.put(tag, new ObjectMap().append("name", tag));
                }
            }
            ObjectMap paramMap = new ObjectMap();
            if (op.containsKey((Object)"parameters")) {
                Object tag;
                tag = op.getObjectList("parameters").elements(ObjectMap.class).iterator();
                while (tag.hasNext()) {
                    ObjectMap param = (ObjectMap)tag.next();
                    paramMap.put((Object)(param.getString("in") + '.' + ("body".equals(param.getString("in")) ? "body" : param.getString("name"))), (Object)param);
                }
            }
            for (RestMethodParam mp : this.context.getRestMethodParams(m)) {
                RestParamType in = mp.getParamType();
                mpi = mp.getMethodParamInfo();
                if (!in.isAny(RestParamType.BODY, RestParamType.QUERY, RestParamType.FORM_DATA, RestParamType.HEADER, RestParamType.PATH)) continue;
                String key = in.toString() + '.' + (in == RestParamType.BODY ? "body" : mp.getName());
                ObjectMap param = paramMap.getObjectMap(key, true);
                param.append("in", (Object)in);
                if (in != RestParamType.BODY) {
                    param.append("name", (Object)mp.name);
                }
                try {
                    if (mpi != null) {
                        if (in == RestParamType.BODY) {
                            for (Body a : mpi.getAnnotationsParentFirst(Body.class)) {
                                this.merge(param, a);
                            }
                        } else if (in == RestParamType.QUERY) {
                            for (Body a : mpi.getAnnotationsParentFirst(Query.class)) {
                                this.merge(param, (Query)a);
                            }
                        } else if (in == RestParamType.FORM_DATA) {
                            for (Body a : mpi.getAnnotationsParentFirst(FormData.class)) {
                                this.merge(param, (FormData)a);
                            }
                        } else if (in == RestParamType.HEADER) {
                            for (Body a : mpi.getAnnotationsParentFirst(Header.class)) {
                                this.merge(param, (Header)a);
                            }
                        } else if (in == RestParamType.PATH) {
                            for (Body a : mpi.getAnnotationsParentFirst(Path.class)) {
                                this.merge(param, (Path)a);
                            }
                        }
                    }
                }
                catch (ParseException e) {
                    throw new SwaggerException((Exception)((Object)e), "Malformed swagger JSON object encountered in {0} class {1} method parameter {2}", new Object[]{in, this.c, mpi});
                }
                if (!(in != RestParamType.BODY && in != RestParamType.PATH || param.containsKeyNotEmpty("required"))) {
                    param.put((Object)"required", (Object)true);
                }
                if (in == RestParamType.BODY) {
                    param.appendSkipEmpty("schema", (Object)this.getSchema(param.getObjectMap("schema"), mp.getType(), bs));
                    this.addBodyExamples(restMethodContext, param, false, mp.getType());
                    continue;
                }
                this.mergePartSchema(param, this.getSchema(param.getObjectMap("schema"), mp.getType(), bs));
                this.addParamExample(restMethodContext, param, in, mp.getType());
            }
            if (!paramMap.isEmpty()) {
                op.put((Object)"parameters", (Object)paramMap.values());
            }
            ObjectMap responses = op.getObjectMap("responses", true);
            for (ClassInfo eci : mi.getExceptionTypes()) {
                if (!eci.hasAnnotation(Response.class)) continue;
                Iterator la = eci.getAnnotationsParentFirst(Response.class);
                Set<Integer> codes = SwaggerGenerator.getCodes((List<Response>)((Object)la), 500);
                mpi = la.iterator();
                while (mpi.hasNext()) {
                    Response a = (Response)mpi.next();
                    for (Integer code : codes) {
                        ObjectMap om = responses.getObjectMap(String.valueOf(code), true);
                        this.merge(om, a);
                        if (om.containsKey((Object)"schema")) continue;
                        om.appendSkipEmpty("schema", (Object)this.getSchema(om.getObjectMap("schema"), eci.inner(), bs));
                    }
                }
                for (MethodInfo ecmi : eci.getAllMethodsParentFirst()) {
                    ResponseHeader a = (ResponseHeader)ecmi.getAnnotation(ResponseHeader.class);
                    if (a == null) {
                        a = (ResponseHeader)ecmi.getResolvedReturnType().getAnnotation(ResponseHeader.class);
                    }
                    if (a == null) continue;
                    String ha = a.name();
                    for (Integer code : codes) {
                        ObjectMap header = responses.getObjectMap(String.valueOf(code), true).getObjectMap("headers", true).getObjectMap(ha, true);
                        this.merge(header, a);
                        this.mergePartSchema(header, this.getSchema(header, ecmi.getReturnType().innerType(), bs));
                    }
                }
            }
            if (mi.hasAnnotation(Response.class) || mi.getResolvedReturnType().hasAnnotation(Response.class)) {
                List la = mi.getAnnotationsParentFirst(Response.class);
                Set<Integer> codes = SwaggerGenerator.getCodes(la, 200);
                for (Response a : la) {
                    for (Integer code : codes) {
                        ObjectMap om = responses.getObjectMap(String.valueOf(code), true);
                        this.merge(om, a);
                        if (!om.containsKey((Object)"schema")) {
                            om.appendSkipEmpty("schema", (Object)this.getSchema(om.getObjectMap("schema"), m.getGenericReturnType(), bs));
                        }
                        this.addBodyExamples(restMethodContext, om, true, m.getGenericReturnType());
                    }
                }
                if (mi.getReturnType().hasAnnotation(Response.class)) {
                    for (MethodInfo ecmi : mi.getReturnType().getAllMethodsParentFirst()) {
                        if (!ecmi.hasAnnotation(ResponseHeader.class)) continue;
                        ResponseHeader a = (ResponseHeader)ecmi.getAnnotation(ResponseHeader.class);
                        String ha = a.name();
                        for (Integer code : codes) {
                            ObjectMap header = responses.getObjectMap(String.valueOf(code), true).getObjectMap("headers", true).getObjectMap(ha, true);
                            this.merge(header, a);
                            this.mergePartSchema(header, this.getSchema(header, ecmi.getReturnType().innerType(), bs));
                        }
                    }
                }
            } else if (m.getGenericReturnType() != Void.TYPE) {
                RestMethodParam[] om = responses.getObjectMap("200", true);
                if (!om.containsKey((Object)"schema")) {
                    om.appendSkipEmpty("schema", (Object)this.getSchema(om.getObjectMap("schema"), m.getGenericReturnType(), bs));
                }
                this.addBodyExamples(restMethodContext, (ObjectMap)om, true, m.getGenericReturnType());
            }
            for (RestMethodParam mp : this.context.getRestMethodParams(m)) {
                Set<Integer> codes;
                List la;
                RestParamType in = mp.getParamType();
                ParamInfo mpi2 = mp.getMethodParamInfo();
                if (in == RestParamType.RESPONSE_HEADER) {
                    la = mpi2.getAnnotationsParentFirst(ResponseHeader.class);
                    codes = SwaggerGenerator.getCodes2(la, 200);
                    for (ResponseHeader a : la) {
                        for (Integer code : codes) {
                            ObjectMap header = responses.getObjectMap(String.valueOf(code), true).getObjectMap("headers", true).getObjectMap(mp.name, true);
                            this.merge(header, a);
                            this.mergePartSchema(header, this.getSchema(header, Value.getParameterType((Type)mp.type), bs));
                        }
                    }
                    continue;
                }
                if (in != RestParamType.RESPONSE) continue;
                la = mpi2.getAnnotationsParentFirst(Response.class);
                codes = SwaggerGenerator.getCodes(la, 200);
                for (ResponseHeader a : la) {
                    for (Integer code : codes) {
                        ObjectMap response = responses.getObjectMap(String.valueOf(code), true);
                        this.merge(response, (Response)a);
                    }
                }
                Type type = Value.getParameterType((Type)mp.type);
                if (type == null) continue;
                for (String code : responses.keySet()) {
                    ObjectMap om = responses.getObjectMap(code);
                    if (om.containsKey((Object)"schema")) continue;
                    om.appendSkipEmpty("schema", (Object)this.getSchema(om.getObjectMap("schema"), type, bs));
                }
            }
            for (Map.Entry e : responses.entrySet()) {
                String key = (String)e.getKey();
                ObjectMap val = responses.getObjectMap(key);
                if (!StringUtils.isDecimal((String)key)) continue;
                val.appendIf(false, true, true, "description", (Object)RestUtils.getHttpResponseText((int)Integer.parseInt(key)));
            }
            if (responses.isEmpty()) {
                op.remove((Object)"responses");
            } else {
                op.put((Object)"responses", new TreeMap(responses));
            }
            if (!op.containsKey((Object)"consumes") && !(mConsumes = restMethodContext.supportedContentTypes).equals(consumes)) {
                op.put((Object)"consumes", mConsumes);
            }
            if (op.containsKey((Object)"produces") || (mProduces = restMethodContext.supportedAcceptTypes).equals(produces)) continue;
            op.put((Object)"produces", mProduces);
        }
        if (this.js.getBeanDefs() != null) {
            for (Map.Entry entry : this.js.getBeanDefs().entrySet()) {
                definitions.put(entry.getKey(), (Object)this.fixSwaggerExtensions((ObjectMap)entry.getValue()));
            }
        }
        if (definitions.isEmpty()) {
            omSwagger.remove((Object)"definitions");
        }
        if (!tagMap.isEmpty()) {
            omSwagger.put((Object)"tags", tagMap.values());
        }
        if (consumes.isEmpty()) {
            omSwagger.remove((Object)"consumes");
        }
        if (produces.isEmpty()) {
            omSwagger.remove((Object)"produces");
        }
        try {
            String swaggerJson = omSwagger.toString((WriterSerializer)SimpleJsonSerializer.DEFAULT_READABLE);
            return (Swagger)this.jp.parse(swaggerJson, Swagger.class);
        }
        catch (Exception e) {
            throw new RestServletException("Error detected in swagger.", new Object[0]).initCause(e);
        }
    }

    private ObjectMap resolve(ObjectMap om) throws ParseException {
        ObjectMap om2 = null;
        if (om.containsKey((Object)"_value")) {
            om = om.modifiable();
            om2 = this.parseMap(om.remove((Object)"_value"));
        } else {
            om2 = new ObjectMap();
        }
        for (Map.Entry e : om.entrySet()) {
            Object val = e.getValue();
            if (val instanceof ObjectMap) {
                val = this.resolve((ObjectMap)val);
            } else if (val instanceof ObjectList) {
                val = this.resolve((ObjectList)val);
            } else if (val instanceof String) {
                val = this.resolve(val.toString());
            }
            om2.put(e.getKey(), val);
        }
        return om2;
    }

    private ObjectList resolve(ObjectList om) throws ParseException {
        ObjectList ol2 = new ObjectList();
        for (Object val : om) {
            if (val instanceof ObjectMap) {
                val = this.resolve((ObjectMap)val);
            } else if (val instanceof ObjectList) {
                val = this.resolve((ObjectList)val);
            } else if (val instanceof String) {
                val = this.resolve(val.toString());
            }
            ol2.add(val);
        }
        return ol2;
    }

    private String resolve(String[] ss) {
        if (ss.length == 0) {
            return null;
        }
        return this.resolve(SwaggerGenerator.joinnl(ss));
    }

    private String resolve(String s) {
        if (s == null) {
            return null;
        }
        return this.vr.resolve(s.trim());
    }

    private ObjectMap parseMap(String[] o, String location, Object ... args) throws ParseException {
        if (o.length == 0) {
            return ObjectMap.EMPTY_MAP;
        }
        try {
            return this.parseMap(o);
        }
        catch (ParseException e) {
            throw new SwaggerException((Exception)((Object)e), "Malformed swagger JSON object encountered in " + location + ".", args);
        }
    }

    private ObjectMap parseMap(String o, String location, Object ... args) throws ParseException {
        try {
            return this.parseMap(o);
        }
        catch (ParseException e) {
            throw new SwaggerException((Exception)((Object)e), "Malformed swagger JSON object encountered in " + location + ".", args);
        }
    }

    private ObjectMap parseMap(Object o) throws ParseException {
        if (o == null) {
            return null;
        }
        if (o instanceof String[]) {
            o = SwaggerGenerator.joinnl((String[])o);
        }
        if (o instanceof String) {
            String s = o.toString();
            if (s.isEmpty()) {
                return null;
            }
            if ("IGNORE".equalsIgnoreCase(s = this.resolve(s))) {
                return new ObjectMap().append("ignore", (Object)true);
            }
            if (!StringUtils.isObjectMap((Object)s, (boolean)true)) {
                s = "{" + s + "}";
            }
            return new ObjectMap((CharSequence)s);
        }
        if (o instanceof ObjectMap) {
            return (ObjectMap)o;
        }
        throw new SwaggerException(null, "Unexpected data type ''{0}''.  Expected ObjectMap or String.", o.getClass().getName());
    }

    private ObjectList parseList(Object o, String location, Object ... locationArgs) throws ParseException {
        try {
            String s;
            if (o == null) {
                return null;
            }
            String string = s = o instanceof String[] ? SwaggerGenerator.joinnl((String[])o) : o.toString();
            if (s.isEmpty()) {
                return null;
            }
            if (!StringUtils.isObjectList((Object)(s = this.resolve(s)), (boolean)true)) {
                s = "[" + s + "]";
            }
            return new ObjectList((CharSequence)s);
        }
        catch (ParseException e) {
            throw new SwaggerException((Exception)((Object)e), "Malformed swagger JSON array encountered in " + location + ".", locationArgs);
        }
    }

    private ObjectList parseListOrCdl(Object o, String location, Object ... locationArgs) throws ParseException {
        try {
            String s;
            if (o == null) {
                return null;
            }
            String string = s = o instanceof String[] ? SwaggerGenerator.joinnl((String[])o) : o.toString();
            if (s.isEmpty()) {
                return null;
            }
            s = this.resolve(s);
            return StringUtils.parseListOrCdl((String)s);
        }
        catch (ParseException e) {
            throw new SwaggerException((Exception)((Object)e), "Malformed swagger JSON array encountered in " + location + ".", locationArgs);
        }
    }

    private ObjectMap newMap(ObjectMap om, String[] value, String location, Object ... locationArgs) throws ParseException {
        if (value.length == 0) {
            return om == null ? new ObjectMap() : om;
        }
        ObjectMap om2 = this.parseMap(SwaggerGenerator.joinnl(value), location, locationArgs);
        if (om == null) {
            return om2;
        }
        return om.appendAll((Map)om2);
    }

    private ObjectMap merge(ObjectMap ... maps) {
        ObjectMap m = maps[0];
        for (int i = 1; i < maps.length; ++i) {
            if (maps[i] == null) continue;
            if (m == null) {
                m = new ObjectMap();
            }
            m.putAll((Map)maps[i]);
        }
        return m;
    }

    private ObjectList merge(ObjectList ... lists) {
        ObjectList l = lists[0];
        for (int i = 1; i < lists.length; ++i) {
            if (lists[i] == null) continue;
            if (l == null) {
                l = new ObjectList();
            }
            l.addAll((Collection)lists[i]);
        }
        return l;
    }

    @SafeVarargs
    private final <T> T firstNonEmpty(T ... t) {
        return (T)ObjectUtils.firstNonEmpty((Object[])t);
    }

    private ObjectMap toMap(ExternalDocs a, String location, Object ... locationArgs) throws ParseException {
        if (AnnotationUtils.empty((ExternalDocs)a)) {
            return null;
        }
        ObjectMap om = this.newMap(new ObjectMap(), a.value(), location, locationArgs);
        om.appendSkipEmpty("description", (Object)this.resolve(SwaggerGenerator.joinnl(a.description())));
        om.appendSkipEmpty("url", (Object)this.resolve(a.url()));
        return SwaggerGenerator.nullIfEmpty(om);
    }

    private ObjectMap toMap(Contact a, String location, Object ... locationArgs) throws ParseException {
        if (AnnotationUtils.empty((Contact)a)) {
            return null;
        }
        ObjectMap om = this.newMap(new ObjectMap(), a.value(), location, locationArgs);
        om.appendSkipEmpty("name", (Object)this.resolve(a.name()));
        om.appendSkipEmpty("url", (Object)this.resolve(a.url()));
        om.appendSkipEmpty("email", (Object)this.resolve(a.email()));
        return SwaggerGenerator.nullIfEmpty(om);
    }

    private ObjectMap toMap(License a, String location, Object ... locationArgs) throws ParseException {
        if (AnnotationUtils.empty((License)a)) {
            return null;
        }
        ObjectMap om = this.newMap(new ObjectMap(), a.value(), location, locationArgs);
        om.appendSkipEmpty("name", (Object)this.resolve(a.name()));
        om.appendSkipEmpty("url", (Object)this.resolve(a.url()));
        return SwaggerGenerator.nullIfEmpty(om);
    }

    private ObjectMap toMap(Tag a, String location, Object ... locationArgs) throws ParseException {
        ObjectMap om = this.newMap(new ObjectMap(), a.value(), location, locationArgs);
        om.appendSkipEmpty("name", (Object)this.resolve(a.name()));
        om.appendSkipEmpty("description", (Object)this.resolve(SwaggerGenerator.joinnl(a.description())));
        om.appendSkipNull("externalDocs", (Object)this.merge(om.getObjectMap("externalDocs"), this.toMap(a.externalDocs(), location, locationArgs)));
        return SwaggerGenerator.nullIfEmpty(om);
    }

    private ObjectList toList(Tag[] aa, String location, Object ... locationArgs) throws ParseException {
        if (aa.length == 0) {
            return null;
        }
        ObjectList ol = new ObjectList();
        for (Tag a : aa) {
            ol.add((Object)this.toMap(a, location, locationArgs));
        }
        return SwaggerGenerator.nullIfEmpty(ol);
    }

    private ObjectMap getSchema(ObjectMap schema, Type type, BeanSession bs) throws Exception {
        if (type == Swagger.class) {
            return null;
        }
        schema = SwaggerGenerator.newMap(schema);
        ClassMeta cm = bs.getClassMeta(type, new Type[0]);
        if (schema.getBoolean("ignore", Boolean.valueOf(false)).booleanValue()) {
            return null;
        }
        if (schema.containsKey((Object)"type") || schema.containsKey((Object)"$ref")) {
            return schema;
        }
        ObjectMap om = this.fixSwaggerExtensions(schema.appendAll((Map)this.js.getSchema(cm)));
        return SwaggerGenerator.nullIfEmpty(om);
    }

    private ObjectMap fixSwaggerExtensions(ObjectMap om) {
        om.appendSkipNull("discriminator", om.remove((Object)"x-discriminator"));
        om.appendSkipNull("readOnly", om.remove((Object)"x-readOnly"));
        om.appendSkipNull("xml", om.remove((Object)"x-xml"));
        om.appendSkipNull("externalDocs", om.remove((Object)"x-externalDocs"));
        om.appendSkipNull("example", om.remove((Object)"x-example"));
        return SwaggerGenerator.nullIfEmpty(om);
    }

    private void addBodyExamples(RestMethodContext sm, ObjectMap piri, boolean response, Type type) throws Exception {
        ObjectMap schema;
        String sex = piri.getString("x-example");
        if (sex == null && (schema = this.resolveRef(piri.getObjectMap("schema"))) != null) {
            sex = schema.getString("example", schema.getString("x-example"));
        }
        if (StringUtils.isEmpty((String)sex)) {
            return;
        }
        Object example = null;
        if (StringUtils.isJson((String)sex)) {
            example = this.jp.parse(sex, type, new Type[0]);
        } else {
            ClassMeta cm = this.js.getClassMeta(type, new Type[0]);
            if (cm.hasStringMutater()) {
                example = cm.getStringMutater().mutate((Object)sex);
            }
        }
        String examplesKey = response ? "examples" : "x-examples";
        ObjectMap examples = piri.getObjectMap(examplesKey);
        if (examples == null) {
            examples = new ObjectMap();
        }
        List mediaTypes = response ? sm.getSerializers().getSupportedMediaTypes() : sm.getParsers().getSupportedMediaTypes();
        for (MediaType mt : mediaTypes) {
            Serializer s2;
            if (mt == MediaType.HTML || (s2 = sm.getSerializers().getSerializer(mt)) == null) continue;
            SerializerSessionArgs args = SerializerSessionArgs.create().javaMethod(this.req.getJavaMethod()).locale(this.req.getLocale()).mediaType(mt).debug(this.req.isDebug() ? Boolean.valueOf(true) : null).uriContext(this.req.getUriContext()).useWhitespace(Boolean.valueOf(true)).resolver(this.req.getVarResolverSession());
            try {
                String eVal = s2.createSession(args).serializeToString(example);
                examples.put((Object)s2.getPrimaryMediaType().toString(), (Object)eVal);
            }
            catch (Exception e) {
                System.err.println("Could not serialize to media type [" + mt + "]: " + e.getLocalizedMessage());
            }
        }
        if (!examples.isEmpty()) {
            piri.put((Object)examplesKey, (Object)examples);
        }
    }

    private void addParamExample(RestMethodContext sm, ObjectMap piri, RestParamType in, Type type) throws Exception {
        String s = piri.getString("x-example");
        if (StringUtils.isEmpty((String)s)) {
            return;
        }
        ObjectMap examples = piri.getObjectMap("x-examples");
        if (examples == null) {
            examples = new ObjectMap();
        }
        String paramName = piri.getString("name");
        if (in == RestParamType.QUERY) {
            s = "?" + StringUtils.urlEncodeLax((String)paramName) + "=" + StringUtils.urlEncodeLax((String)s);
        } else if (in == RestParamType.FORM_DATA) {
            s = paramName + "=" + s;
        } else if (in == RestParamType.HEADER) {
            s = paramName + ": " + s;
        } else if (in == RestParamType.PATH) {
            s = sm.getPathPattern().replace("{" + paramName + "}", StringUtils.urlEncodeLax((String)s));
        }
        examples.put((Object)"example", (Object)s);
        if (!examples.isEmpty()) {
            piri.put((Object)"x-examples", (Object)examples);
        }
    }

    private ObjectMap resolveRef(ObjectMap m) {
        String ref;
        if (m == null) {
            return null;
        }
        if (m.containsKey((Object)"$ref") && this.js.getBeanDefs() != null && (ref = m.getString("$ref")).startsWith("#/definitions/")) {
            return (ObjectMap)this.js.getBeanDefs().get(ref.substring(14));
        }
        return m;
    }

    private ObjectMap getOperation(ObjectMap om, String path, String httpMethod) {
        if (!om.containsKey((Object)"paths")) {
            om.put((Object)"paths", (Object)new ObjectMap());
        }
        if (!(om = om.getObjectMap("paths")).containsKey((Object)path)) {
            om.put((Object)path, (Object)new ObjectMap());
        }
        if (!(om = om.getObjectMap(path)).containsKey((Object)httpMethod)) {
            om.put((Object)httpMethod, (Object)new ObjectMap());
        }
        return om.getObjectMap(httpMethod);
    }

    private static ObjectMap newMap(ObjectMap om) {
        if (om == null) {
            return new ObjectMap();
        }
        return om.modifiable();
    }

    private ObjectMap merge(ObjectMap om, Body a) throws ParseException {
        if (AnnotationUtils.empty((Body)a)) {
            return om;
        }
        om = SwaggerGenerator.newMap(om);
        if (a.value().length > 0) {
            om.putAll((Map)this.parseMap(a.value()));
        }
        if (a.api().length > 0) {
            om.putAll((Map)this.parseMap(a.api()));
        }
        return om.appendSkipEmpty("description", (Object)this.resolve(a.description())).appendSkipEmpty("x-example", (Object)this.resolve(a.example())).appendSkipEmpty("x-examples", (Object)this.parseMap(a.examples())).appendSkipFalse("required", a.required()).appendSkipEmpty("schema", (Object)this.merge(om.getObjectMap("schema"), a.schema()));
    }

    private ObjectMap merge(ObjectMap om, Query a) throws ParseException {
        if (AnnotationUtils.empty((Query)a)) {
            return om;
        }
        om = SwaggerGenerator.newMap(om);
        if (a.api().length > 0) {
            om.putAll((Map)this.parseMap(a.api()));
        }
        return om.appendSkipFalse("allowEmptyValue", a.allowEmptyValue()).appendSkipEmpty("collectionFormat", (Object)a.collectionFormat()).appendSkipEmpty("default", (Object)SwaggerGenerator.joinnl(a._default())).appendSkipEmpty("description", (Object)this.resolve(a.description())).appendSkipEmpty("enum", this.toSet(a._enum())).appendSkipEmpty("x-example", (Object)this.resolve(a.example())).appendSkipFalse("exclusiveMaximum", a.exclusiveMaximum()).appendSkipFalse("exclusiveMinimum", a.exclusiveMinimum()).appendSkipEmpty("format", (Object)a.format()).appendSkipEmpty("items", (Object)this.merge(om.getObjectMap("items"), a.items())).appendSkipEmpty("maximum", (Object)a.maximum()).appendSkipMinusOne("maxItems", (Number)a.maxItems()).appendSkipMinusOne("maxLength", (Number)a.maxLength()).appendSkipEmpty("minimum", (Object)a.minimum()).appendSkipMinusOne("minItems", (Number)a.minItems()).appendSkipMinusOne("minLength", (Number)a.minLength()).appendSkipEmpty("multipleOf", (Object)a.multipleOf()).appendSkipEmpty("pattern", (Object)a.pattern()).appendSkipFalse("required", a.required()).appendSkipEmpty("type", (Object)a.type()).appendSkipFalse("uniqueItems", a.uniqueItems());
    }

    private ObjectMap merge(ObjectMap om, FormData a) throws ParseException {
        if (AnnotationUtils.empty((FormData)a)) {
            return om;
        }
        om = SwaggerGenerator.newMap(om);
        if (a.api().length > 0) {
            om.putAll((Map)this.parseMap(a.api()));
        }
        return om.appendSkipFalse("allowEmptyValue", a.allowEmptyValue()).appendSkipEmpty("collectionFormat", (Object)a.collectionFormat()).appendSkipEmpty("default", (Object)SwaggerGenerator.joinnl(a._default())).appendSkipEmpty("description", (Object)this.resolve(a.description())).appendSkipEmpty("enum", this.toSet(a._enum())).appendSkipEmpty("x-example", (Object)this.resolve(a.example())).appendSkipFalse("exclusiveMaximum", a.exclusiveMaximum()).appendSkipFalse("exclusiveMinimum", a.exclusiveMinimum()).appendSkipEmpty("format", (Object)a.format()).appendSkipEmpty("items", (Object)this.merge(om.getObjectMap("items"), a.items())).appendSkipEmpty("maximum", (Object)a.maximum()).appendSkipMinusOne("maxItems", (Number)a.maxItems()).appendSkipMinusOne("maxLength", (Number)a.maxLength()).appendSkipEmpty("minimum", (Object)a.minimum()).appendSkipMinusOne("minItems", (Number)a.minItems()).appendSkipMinusOne("minLength", (Number)a.minLength()).appendSkipEmpty("multipleOf", (Object)a.multipleOf()).appendSkipEmpty("pattern", (Object)a.pattern()).appendSkipFalse("required", a.required()).appendSkipEmpty("type", (Object)a.type()).appendSkipFalse("uniqueItems", a.uniqueItems());
    }

    private ObjectMap merge(ObjectMap om, Header a) throws ParseException {
        if (AnnotationUtils.empty((Header)a)) {
            return om;
        }
        om = SwaggerGenerator.newMap(om);
        if (a.api().length > 0) {
            om.putAll((Map)this.parseMap(a.api()));
        }
        return om.appendSkipEmpty("collectionFormat", (Object)a.collectionFormat()).appendSkipEmpty("default", (Object)SwaggerGenerator.joinnl(a._default())).appendSkipEmpty("description", (Object)this.resolve(a.description())).appendSkipEmpty("enum", this.toSet(a._enum())).appendSkipEmpty("x-example", (Object)this.resolve(a.example())).appendSkipFalse("exclusiveMaximum", a.exclusiveMaximum()).appendSkipFalse("exclusiveMinimum", a.exclusiveMinimum()).appendSkipEmpty("format", (Object)a.format()).appendSkipEmpty("items", (Object)this.merge(om.getObjectMap("items"), a.items())).appendSkipEmpty("maximum", (Object)a.maximum()).appendSkipMinusOne("maxItems", (Number)a.maxItems()).appendSkipMinusOne("maxLength", (Number)a.maxLength()).appendSkipEmpty("minimum", (Object)a.minimum()).appendSkipMinusOne("minItems", (Number)a.minItems()).appendSkipMinusOne("minLength", (Number)a.minLength()).appendSkipEmpty("multipleOf", (Object)a.multipleOf()).appendSkipEmpty("pattern", (Object)a.pattern()).appendSkipFalse("required", a.required()).appendSkipEmpty("type", (Object)a.type()).appendSkipFalse("uniqueItems", a.uniqueItems());
    }

    private ObjectMap merge(ObjectMap om, Path a) throws ParseException {
        if (AnnotationUtils.empty((Path)a)) {
            return om;
        }
        om = SwaggerGenerator.newMap(om);
        if (a.api().length > 0) {
            om.putAll((Map)this.parseMap(a.api()));
        }
        return om.appendSkipEmpty("collectionFormat", (Object)a.collectionFormat()).appendSkipEmpty("description", (Object)this.resolve(a.description())).appendSkipEmpty("enum", this.toSet(a._enum())).appendSkipEmpty("x-example", (Object)this.resolve(a.example())).appendSkipFalse("exclusiveMaximum", a.exclusiveMaximum()).appendSkipFalse("exclusiveMinimum", a.exclusiveMinimum()).appendSkipEmpty("format", (Object)a.format()).appendSkipEmpty("items", (Object)this.merge(om.getObjectMap("items"), a.items())).appendSkipEmpty("maximum", (Object)a.maximum()).appendSkipMinusOne("maxItems", (Number)a.maxItems()).appendSkipMinusOne("maxLength", (Number)a.maxLength()).appendSkipEmpty("minimum", (Object)a.minimum()).appendSkipMinusOne("minItems", (Number)a.minItems()).appendSkipMinusOne("minLength", (Number)a.minLength()).appendSkipEmpty("multipleOf", (Object)a.multipleOf()).appendSkipEmpty("pattern", (Object)a.pattern()).appendSkipEmpty("type", (Object)a.type()).appendSkipFalse("uniqueItems", a.uniqueItems());
    }

    private ObjectMap merge(ObjectMap om, Schema a) throws ParseException {
        if (AnnotationUtils.empty((Schema)a)) {
            return om;
        }
        om = SwaggerGenerator.newMap(om);
        if (a.value().length > 0) {
            om.putAll((Map)this.parseMap(a.value()));
        }
        return om.appendSkipEmpty("additionalProperties", (Object)this.toObjectMap(a.additionalProperties())).appendSkipEmpty("allOf", (Object)SwaggerGenerator.joinnl(a.allOf())).appendSkipEmpty("collectionFormat", (Object)a.collectionFormat()).appendSkipEmpty("default", (Object)SwaggerGenerator.joinnl(a._default())).appendSkipEmpty("discriminator", (Object)a.discriminator()).appendSkipEmpty("description", (Object)this.resolve(a.description())).appendSkipEmpty("enum", this.toSet(a._enum())).appendSkipEmpty("x-example", (Object)this.resolve(a.example())).appendSkipEmpty("examples", (Object)this.parseMap(a.examples())).appendSkipFalse("exclusiveMaximum", a.exclusiveMaximum()).appendSkipFalse("exclusiveMinimum", a.exclusiveMinimum()).appendSkipEmpty("externalDocs", (Object)this.merge(om.getObjectMap("externalDocs"), a.externalDocs())).appendSkipEmpty("format", (Object)a.format()).appendSkipEmpty("ignore", (Object)(a.ignore() ? "true" : null)).appendSkipEmpty("items", (Object)this.merge(om.getObjectMap("items"), a.items())).appendSkipEmpty("maximum", (Object)a.maximum()).appendSkipMinusOne("maxItems", (Number)a.maxItems()).appendSkipMinusOne("maxLength", (Number)a.maxLength()).appendSkipMinusOne("maxProperties", (Number)a.maxProperties()).appendSkipEmpty("minimum", (Object)a.minimum()).appendSkipMinusOne("minItems", (Number)a.minItems()).appendSkipMinusOne("minLength", (Number)a.minLength()).appendSkipMinusOne("minProperties", (Number)a.minProperties()).appendSkipEmpty("multipleOf", (Object)a.multipleOf()).appendSkipEmpty("pattern", (Object)a.pattern()).appendSkipEmpty("properties", (Object)this.toObjectMap(a.properties())).appendSkipFalse("readOnly", a.readOnly()).appendSkipFalse("required", a.required()).appendSkipEmpty("title", (Object)a.title()).appendSkipEmpty("type", (Object)a.type()).appendSkipFalse("uniqueItems", a.uniqueItems()).appendSkipEmpty("xml", (Object)SwaggerGenerator.joinnl(a.xml())).appendSkipEmpty("$ref", (Object)a.$ref());
    }

    private ObjectMap merge(ObjectMap om, ExternalDocs a) throws ParseException {
        if (AnnotationUtils.empty((ExternalDocs)a)) {
            return om;
        }
        om = SwaggerGenerator.newMap(om);
        if (a.value().length > 0) {
            om.putAll((Map)this.parseMap(a.value()));
        }
        return om.appendSkipEmpty("description", (Object)this.resolve(a.description())).appendSkipEmpty("url", (Object)a.url());
    }

    private ObjectMap merge(ObjectMap om, Items a) throws ParseException {
        if (AnnotationUtils.empty((Items)a)) {
            return om;
        }
        om = SwaggerGenerator.newMap(om);
        if (a.value().length > 0) {
            om.putAll((Map)this.parseMap(a.value()));
        }
        return om.appendSkipEmpty("collectionFormat", (Object)a.collectionFormat()).appendSkipEmpty("default", (Object)SwaggerGenerator.joinnl(a._default())).appendSkipEmpty("enum", this.toSet(a._enum())).appendSkipEmpty("format", (Object)a.format()).appendSkipFalse("exclusiveMaximum", a.exclusiveMaximum()).appendSkipFalse("exclusiveMinimum", a.exclusiveMinimum()).appendSkipEmpty("items", (Object)this.merge(om.getObjectMap("items"), a.items())).appendSkipEmpty("maximum", (Object)a.maximum()).appendSkipMinusOne("maxItems", (Number)a.maxItems()).appendSkipMinusOne("maxLength", (Number)a.maxLength()).appendSkipEmpty("minimum", (Object)a.minimum()).appendSkipMinusOne("minItems", (Number)a.minItems()).appendSkipMinusOne("minLength", (Number)a.minLength()).appendSkipEmpty("multipleOf", (Object)a.multipleOf()).appendSkipEmpty("pattern", (Object)a.pattern()).appendSkipFalse("uniqueItems", a.uniqueItems()).appendSkipEmpty("type", (Object)a.type()).appendSkipEmpty("$ref", (Object)a.$ref());
    }

    private ObjectMap merge(ObjectMap om, SubItems a) throws ParseException {
        if (AnnotationUtils.empty((SubItems)a)) {
            return om;
        }
        om = SwaggerGenerator.newMap(om);
        if (a.value().length > 0) {
            om.putAll((Map)this.parseMap(a.value()));
        }
        return om.appendSkipEmpty("collectionFormat", (Object)a.collectionFormat()).appendSkipEmpty("default", (Object)SwaggerGenerator.joinnl(a._default())).appendSkipEmpty("enum", this.toSet(a._enum())).appendSkipFalse("exclusiveMaximum", a.exclusiveMaximum()).appendSkipFalse("exclusiveMinimum", a.exclusiveMinimum()).appendSkipEmpty("format", (Object)a.format()).appendSkipEmpty("items", (Object)this.toObjectMap(a.items())).appendSkipEmpty("maximum", (Object)a.maximum()).appendSkipMinusOne("maxItems", (Number)a.maxItems()).appendSkipMinusOne("maxLength", (Number)a.maxLength()).appendSkipEmpty("minimum", (Object)a.minimum()).appendSkipMinusOne("minItems", (Number)a.minItems()).appendSkipMinusOne("minLength", (Number)a.minLength()).appendSkipEmpty("multipleOf", (Object)a.multipleOf()).appendSkipEmpty("pattern", (Object)a.pattern()).appendSkipEmpty("type", (Object)a.type()).appendSkipFalse("uniqueItems", a.uniqueItems()).appendSkipEmpty("$ref", (Object)a.$ref());
    }

    private ObjectMap merge(ObjectMap om, Response a) throws ParseException {
        if (AnnotationUtils.empty((Response)a)) {
            return om;
        }
        om = SwaggerGenerator.newMap(om);
        if (a.api().length > 0) {
            om.putAll((Map)this.parseMap(a.api()));
        }
        return om.appendSkipEmpty("description", (Object)this.resolve(a.description())).appendSkipEmpty("x-example", (Object)this.resolve(a.example())).appendSkipEmpty("examples", (Object)this.parseMap(a.examples())).appendSkipEmpty("headers", (Object)this.merge(om.getObjectMap("headers"), a.headers())).appendSkipEmpty("schema", (Object)this.merge(om.getObjectMap("schema"), a.schema()));
    }

    private ObjectMap merge(ObjectMap om, ResponseHeader[] a) throws ParseException {
        if (a.length == 0) {
            return om;
        }
        om = SwaggerGenerator.newMap(om);
        for (ResponseHeader aa : a) {
            String name = StringUtils.firstNonEmpty((String[])new String[]{aa.name(), aa.value()});
            if (StringUtils.isEmpty((String)name)) {
                throw new RuntimeException("@ResponseHeader used without name or value.");
            }
            om.getObjectMap(name, true).putAll((Map)this.merge(null, aa));
        }
        return om;
    }

    private ObjectMap merge(ObjectMap om, ResponseHeader a) throws ParseException {
        if (AnnotationUtils.empty((ResponseHeader)a)) {
            return om;
        }
        om = SwaggerGenerator.newMap(om);
        if (a.api().length > 0) {
            om.putAll((Map)this.parseMap(a.api()));
        }
        return om.appendSkipEmpty("collectionFormat", (Object)a.collectionFormat()).appendSkipEmpty("default", (Object)SwaggerGenerator.joinnl(a._default())).appendSkipEmpty("description", (Object)this.resolve(a.description())).appendSkipEmpty("enum", this.toSet(a._enum())).appendSkipEmpty("x-example", (Object)this.resolve(a.example())).appendSkipFalse("exclusiveMaximum", a.exclusiveMaximum()).appendSkipFalse("exclusiveMinimum", a.exclusiveMinimum()).appendSkipEmpty("format", (Object)a.format()).appendSkipEmpty("items", (Object)this.merge(om.getObjectMap("items"), a.items())).appendSkipEmpty("maximum", (Object)a.maximum()).appendSkipMinusOne("maxItems", (Number)a.maxItems()).appendSkipMinusOne("maxLength", (Number)a.maxLength()).appendSkipMinusOne("maxItems", (Number)a.maxItems()).appendSkipEmpty("minimum", (Object)a.minimum()).appendSkipMinusOne("minItems", (Number)a.minItems()).appendSkipMinusOne("minLength", (Number)a.minLength()).appendSkipEmpty("multipleOf", (Object)a.multipleOf()).appendSkipEmpty("pattern", (Object)a.pattern()).appendSkipEmpty("type", (Object)a.type()).appendSkipFalse("uniqueItems", a.uniqueItems()).appendSkipEmpty("$ref", (Object)a.$ref());
    }

    private ObjectMap mergePartSchema(ObjectMap param, ObjectMap schema) {
        if (schema != null) {
            param.appendIf(false, true, true, "collectionFormat", schema.remove((Object)"collectionFormat")).appendIf(false, true, true, "default", schema.remove((Object)"default")).appendIf(false, true, true, "description", schema.remove((Object)"enum")).appendIf(false, true, true, "enum", schema.remove((Object)"enum")).appendIf(false, true, true, "x-example", schema.remove((Object)"x-example")).appendIf(false, true, true, "exclusiveMaximum", schema.remove((Object)"exclusiveMaximum")).appendIf(false, true, true, "exclusiveMinimum", schema.remove((Object)"exclusiveMinimum")).appendIf(false, true, true, "format", schema.remove((Object)"format")).appendIf(false, true, true, "items", schema.remove((Object)"items")).appendIf(false, true, true, "maximum", schema.remove((Object)"maximum")).appendIf(false, true, true, "maxItems", schema.remove((Object)"maxItems")).appendIf(false, true, true, "maxLength", schema.remove((Object)"maxLength")).appendIf(false, true, true, "minimum", schema.remove((Object)"minimum")).appendIf(false, true, true, "minItems", schema.remove((Object)"minItems")).appendIf(false, true, true, "minLength", schema.remove((Object)"minLength")).appendIf(false, true, true, "multipleOf", schema.remove((Object)"multipleOf")).appendIf(false, true, true, "pattern", schema.remove((Object)"pattern")).appendIf(false, true, true, "required", schema.remove((Object)"required")).appendIf(false, true, true, "type", schema.remove((Object)"type")).appendIf(false, true, true, "uniqueItems", schema.remove((Object)"uniqueItems"));
            if ("object".equals(param.getString("type")) && !schema.isEmpty()) {
                param.put((Object)"schema", (Object)schema);
            }
        }
        return param;
    }

    private ObjectMap toObjectMap(String[] ss) throws ParseException {
        if (ss.length == 0) {
            return null;
        }
        String s = SwaggerGenerator.joinnl(ss);
        if (s.isEmpty()) {
            return null;
        }
        if (!StringUtils.isObjectMap((Object)s, (boolean)true)) {
            s = "{" + s + "}";
        }
        s = this.resolve(s);
        return new ObjectMap((CharSequence)s);
    }

    private Set<String> toSet(String[] ss) throws ParseException {
        if (ss.length == 0) {
            return null;
        }
        String s = SwaggerGenerator.joinnl(ss);
        if (s.isEmpty()) {
            return null;
        }
        s = this.resolve(s);
        ASet set = new ASet();
        for (Object o : StringUtils.parseListOrCdl((String)s)) {
            set.add(o.toString());
        }
        return set;
    }

    static String joinnl(String[] ss) {
        if (ss.length == 0) {
            return "";
        }
        return StringUtils.joinnl((Object[])ss).trim();
    }

    private static Set<Integer> getCodes(List<Response> la, Integer def) {
        TreeSet<Integer> codes = new TreeSet<Integer>();
        for (Response a : la) {
            for (int i : a.value()) {
                codes.add(i);
            }
            for (int i : a.code()) {
                codes.add(i);
            }
        }
        if (codes.isEmpty() && def != null) {
            codes.add(def);
        }
        return codes;
    }

    private static Set<Integer> getCodes2(List<ResponseHeader> la, Integer def) {
        TreeSet<Integer> codes = new TreeSet<Integer>();
        for (ResponseHeader a : la) {
            for (int i : a.code()) {
                codes.add(i);
            }
        }
        if (codes.isEmpty() && def != null) {
            codes.add(def);
        }
        return codes;
    }

    private static ObjectMap nullIfEmpty(ObjectMap m) {
        return m == null || m.isEmpty() ? null : m;
    }

    private static ObjectList nullIfEmpty(ObjectList l) {
        return l == null || l.isEmpty() ? null : l;
    }
}

