/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.util.logging.Level;
import org.apache.juneau.dto.swagger.Swagger;
import org.apache.juneau.html.annotation.HtmlDocConfig;
import org.apache.juneau.http.exception.InternalServerError;
import org.apache.juneau.internal.JuneauLogger;
import org.apache.juneau.rest.BasicRestConfig;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.annotation.HookEvent;
import org.apache.juneau.rest.annotation.Rest;
import org.apache.juneau.rest.annotation.RestHook;

@Rest(allowedMethodParams="OPTIONS")
@HtmlDocConfig(navlinks={"up: request:/..", "options: servlet:/?method=OPTIONS"})
public abstract class BasicRest
implements BasicRestConfig {
    private JuneauLogger logger = JuneauLogger.getLogger(this.getClass());
    private volatile RestContext context;

    @RestHook(value=HookEvent.POST_INIT)
    public synchronized void onPostInit(RestContext context) {
        this.context = context;
    }

    @Override
    public Swagger getOptions(RestRequest req) {
        return req.getSwagger();
    }

    protected synchronized RestContext getContext() {
        if (this.context == null) {
            throw new InternalServerError("RestContext object not set on resource.");
        }
        return this.context;
    }

    public void log(String msg) {
        this.logger.info(msg);
    }

    public void log(String msg, Throwable cause) {
        this.logger.info(cause, msg, new Object[0]);
    }

    public void log(Level level, String msg, Object ... args) {
        this.logger.log(level, msg, args);
    }

    public void logObjects(Level level, String msg, Object ... args) {
        this.logger.logObjects(level, msg, args);
    }

    public void log(Level level, Throwable cause, String msg, Object ... args) {
        this.logger.log(level, cause, msg, args);
    }

    public synchronized RestRequest getRequest() {
        return this.getContext().getRequest();
    }

    public synchronized RestResponse getResponse() {
        return this.getContext().getResponse();
    }
}

