/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.jena;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.jena.rdf.model.Container;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.RDFWriter;
import org.apache.jena.rdf.model.Resource;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanMeta;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanPropertyValue;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.DefaultFilteringObjectMap;
import org.apache.juneau.Delegate;
import org.apache.juneau.FormattedRuntimeException;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.jena.RdfBeanMeta;
import org.apache.juneau.jena.RdfBeanPropertyMeta;
import org.apache.juneau.jena.RdfClassMeta;
import org.apache.juneau.jena.RdfCollectionFormat;
import org.apache.juneau.jena.RdfCommon;
import org.apache.juneau.jena.RdfSerializer;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.SerializerPipe;
import org.apache.juneau.serializer.SerializerSessionArgs;
import org.apache.juneau.serializer.WriterSerializer;
import org.apache.juneau.serializer.WriterSerializerSession;
import org.apache.juneau.transform.PojoSwap;
import org.apache.juneau.xml.Namespace;
import org.apache.juneau.xml.XmlBeanPropertyMeta;
import org.apache.juneau.xml.XmlUtils;

public final class RdfSerializerSession
extends WriterSerializerSession {
    private final RdfSerializer ctx;
    private final Property pRoot;
    private final Property pValue;
    private final Model model;
    private final RDFWriter writer;
    private final Namespace[] namespaces;

    protected RdfSerializerSession(RdfSerializer ctx, SerializerSessionArgs args) {
        super((WriterSerializer)ctx, args);
        this.ctx = ctx;
        this.namespaces = (Namespace[])this.getInstanceArrayProperty("RdfSerializer.namespaces.ls", Namespace.class, ctx.namespaces);
        this.model = ModelFactory.createDefaultModel();
        this.addModelPrefix(ctx.getJuneauNs());
        this.addModelPrefix(ctx.getJuneauBpNs());
        for (Namespace ns : this.namespaces) {
            this.addModelPrefix(ns);
        }
        this.pRoot = this.model.createProperty(ctx.getJuneauNs().getUri(), "root");
        this.pValue = this.model.createProperty(ctx.getJuneauNs().getUri(), "value");
        this.writer = this.model.getWriter(ctx.getLanguage());
        String propPrefix = RdfCommon.LANG_PROP_MAP.get(ctx.getLanguage());
        if (propPrefix == null) {
            throw new FormattedRuntimeException("Unknown RDF language encountered: ''{0}''", new Object[]{ctx.getLanguage()});
        }
        if (propPrefix.equals("rdfXml.")) {
            this.writer.setProperty("tab", (Object)(this.isUseWhitespace() ? 2 : 0));
            this.writer.setProperty("attributeQuoteChar", (Object)Character.toString(this.getQuoteChar()));
        }
        for (Map.Entry<String, Object> e : ctx.jenaProperties.entrySet()) {
            if (!e.getKey().startsWith(propPrefix, 5)) continue;
            this.writer.setProperty(e.getKey().substring(5 + propPrefix.length()), e.getValue());
        }
        for (String k : this.getPropertyKeys()) {
            if (!k.startsWith("RdfCommon.jena.") || !k.startsWith(propPrefix, 15)) continue;
            this.writer.setProperty(k.substring(15 + propPrefix.length()), this.getProperty(k));
        }
    }

    private void addModelPrefix(Namespace ns) {
        this.model.setNsPrefix(ns.getName(), ns.getUri());
    }

    private String encodeTextInvalidChars(Object o) {
        if (o == null) {
            return null;
        }
        String s = this.toString(o);
        return XmlUtils.escapeText((Object)s);
    }

    private String encodeElementName(Object o) {
        return XmlUtils.encodeElementName((Object)this.toString(o));
    }

    protected void doSerialize(SerializerPipe out, Object o) throws IOException, SerializeException {
        Resource r = null;
        ClassMeta cm = this.getClassMetaForObject(o);
        if (this.isLooseCollections() && cm != null && cm.isCollectionOrArray()) {
            Collection c = this.sort(cm.isCollection() ? (Collection)o : RdfSerializerSession.toList((Class)cm.getInnerClass(), (Object)o));
            for (Object o2 : c) {
                this.serializeAnything(o2, false, this.object(), "root", null, null);
            }
        } else {
            RDFNode n = this.serializeAnything(o, false, this.getExpectedRootType(o), "root", null, null);
            if (n.isLiteral()) {
                r = this.model.createResource();
                r.addProperty(this.pValue, n);
            } else {
                r = n.asResource();
            }
            if (this.isAddRootProp()) {
                r.addProperty(this.pRoot, "true");
            }
        }
        this.writer.write(this.model, out.getWriter(), "http://unknown/");
    }

    private RDFNode serializeAnything(Object o, boolean isURI, ClassMeta<?> eType, String attrName, BeanPropertyMeta bpm, Resource parentResource) throws IOException, SerializeException {
        Model m = this.model;
        ClassMeta aType = null;
        ClassMeta wType = null;
        ClassMeta sType = this.object();
        aType = this.push2(attrName, o, eType);
        if (eType == null) {
            eType = this.object();
        }
        if (aType == null) {
            o = null;
            aType = this.object();
        }
        if (this.isOptional(aType)) {
            o = this.getOptionalValue(o);
            eType = this.getOptionalType(eType);
            aType = this.getClassMetaForObject(o, this.object());
        }
        if (o != null) {
            if (aType.isDelegate()) {
                wType = aType;
                aType = ((Delegate)o).getClassMeta();
            }
            sType = aType;
            PojoSwap swap = aType.getPojoSwap((BeanSession)this);
            if (swap != null) {
                o = this.swap(swap, o);
                sType = swap.getSwapClassMeta((BeanSession)this);
                if (sType.isObject()) {
                    sType = this.getClassMetaForObject(o);
                }
            }
        } else {
            sType = eType.getSerializedClassMeta((BeanSession)this);
        }
        String typeName = this.getBeanTypeName(eType, aType, bpm);
        Object n = null;
        if (o == null || sType.isChar() && ((Character)o).charValue() == '\u0000') {
            if (bpm != null) {
                if (!this.isTrimNullProperties()) {
                    n = m.createResource("http://www.w3.org/1999/02/22-rdf-syntax-ns#nil");
                }
            } else {
                n = m.createResource("http://www.w3.org/1999/02/22-rdf-syntax-ns#nil");
            }
        } else if (sType.isUri() || isURI) {
            String uri = this.getUri(o, null);
            n = StringUtils.isAbsoluteUri((String)uri) ? m.createResource(uri) : m.createLiteral(this.encodeTextInvalidChars(uri));
        } else if (sType.isCharSequence() || sType.isChar()) {
            n = m.createLiteral(this.encodeTextInvalidChars(o));
        } else if (sType.isNumber() || sType.isBoolean()) {
            n = !this.isAddLiteralTypes() ? m.createLiteral(o.toString()) : m.createTypedLiteral(o);
        } else if (sType.isMap() || wType != null && wType.isMap()) {
            if (o instanceof BeanMap) {
                BeanMap bm = (BeanMap)o;
                Object uri = null;
                RdfBeanMeta rbm = RdfSerializerSession.bRdf(bm.getMeta());
                if (rbm.hasBeanUri()) {
                    uri = rbm.getBeanUriProperty().get(bm, null);
                }
                String uri2 = this.getUri(uri, null);
                n = m.createResource(uri2);
                this.serializeBeanMap((BeanMap<?>)bm, (Resource)n, typeName);
            } else {
                Map m2 = (Map)o;
                n = m.createResource();
                this.serializeMap(m2, (Resource)n, (ClassMeta<?>)sType);
            }
        } else if (sType.isBean()) {
            BeanMap bm = this.toBeanMap(o);
            Object uri = null;
            RdfBeanMeta rbm = RdfSerializerSession.bRdf(bm.getMeta());
            if (rbm.hasBeanUri()) {
                uri = rbm.getBeanUriProperty().get(bm, null);
            }
            String uri2 = this.getUri(uri, null);
            n = m.createResource(uri2);
            this.serializeBeanMap((BeanMap<?>)bm, (Resource)n, typeName);
        } else if (sType.isCollectionOrArray() || wType != null && wType.isCollection()) {
            Collection c = this.sort(sType.isCollection() ? (Collection)o : RdfSerializerSession.toList((Class)sType.getInnerClass(), (Object)o));
            RdfCollectionFormat f = this.getCollectionFormat();
            RdfClassMeta cRdf = RdfSerializerSession.cRdf(sType);
            RdfBeanPropertyMeta bpRdf = RdfSerializerSession.bpRdf(bpm);
            if (cRdf.getCollectionFormat() != RdfCollectionFormat.DEFAULT) {
                f = cRdf.getCollectionFormat();
            }
            if (bpRdf.getCollectionFormat() != RdfCollectionFormat.DEFAULT) {
                f = bpRdf.getCollectionFormat();
            }
            switch (f) {
                case BAG: {
                    n = this.serializeToContainer(c, eType, (Container)m.createBag());
                    break;
                }
                case LIST: {
                    n = this.serializeToList(c, eType);
                    break;
                }
                case MULTI_VALUED: {
                    this.serializeToMultiProperties(c, eType, bpm, attrName, parentResource);
                    break;
                }
                default: {
                    n = this.serializeToContainer(c, eType, (Container)m.createSeq());
                    break;
                }
            }
        } else {
            n = sType.isReader() || sType.isInputStream() ? m.createLiteral(this.encodeTextInvalidChars(IOUtils.read((Object)o))) : m.createLiteral(this.encodeTextInvalidChars(this.toString(o)));
        }
        this.pop();
        return n;
    }

    private String getUri(Object uri, Object uri2) {
        String s = null;
        if (uri != null) {
            s = uri.toString();
        }
        if ((s == null || s.isEmpty()) && uri2 != null) {
            s = uri2.toString();
        }
        if (s == null) {
            return null;
        }
        return this.getUriResolver().resolve((Object)s);
    }

    private void serializeMap(Map m, Resource r, ClassMeta<?> type) throws IOException, SerializeException {
        m = this.sort(m);
        ClassMeta keyType = type.getKeyType();
        ClassMeta valueType = type.getValueType();
        ArrayList l = new ArrayList(m.entrySet());
        Collections.reverse(l);
        for (Map.Entry me : l) {
            Object value = me.getValue();
            Object key = this.generalize(me.getKey(), keyType);
            Namespace ns = this.getJuneauBpNs();
            Property p = this.model.createProperty(ns.getUri(), this.encodeElementName(this.toString(key)));
            RDFNode n = this.serializeAnything(value, false, valueType, this.toString(key), null, r);
            if (n == null) continue;
            r.addProperty(p, n);
        }
    }

    private void serializeBeanMap(BeanMap<?> m, Resource r, String typeName) throws IOException, SerializeException {
        List l = m.getValues(this.isTrimNullProperties(), new BeanPropertyValue[]{typeName != null ? RdfSerializerSession.createBeanTypeNameProperty(m, (String)typeName) : null});
        Collections.reverse(l);
        for (BeanPropertyValue bpv : l) {
            BeanPropertyMeta bpMeta = bpv.getMeta();
            ClassMeta cMeta = bpMeta.getClassMeta();
            RdfBeanPropertyMeta bpRdf = RdfSerializerSession.bpRdf(bpMeta);
            XmlBeanPropertyMeta bpXml = RdfSerializerSession.bpXml(bpMeta);
            if (bpRdf.isBeanUri()) continue;
            String key = bpv.getName();
            Object value = bpv.getValue();
            Throwable t = bpv.getThrown();
            if (t != null) {
                this.onBeanGetterException(bpMeta, t);
            }
            if (this.canIgnoreValue(cMeta, key, value)) continue;
            Namespace ns = bpRdf.getNamespace();
            if (ns == null && this.isUseXmlNamespaces()) {
                ns = bpXml.getNamespace();
            }
            if (ns == null) {
                ns = this.getJuneauBpNs();
            } else if (this.isAutoDetectNamespaces()) {
                this.addModelPrefix(ns);
            }
            Property p = this.model.createProperty(ns.getUri(), this.encodeElementName(key));
            RDFNode n = this.serializeAnything(value, bpMeta.isUri(), cMeta, key, bpMeta, r);
            if (n == null) continue;
            r.addProperty(p, n);
        }
    }

    private Container serializeToContainer(Collection c, ClassMeta<?> type, Container list) throws IOException, SerializeException {
        ClassMeta elementType = type.getElementType();
        for (Object e : c) {
            RDFNode n = this.serializeAnything(e, false, elementType, null, null, null);
            list = list.add(n);
        }
        return list;
    }

    private RDFList serializeToList(Collection c, ClassMeta<?> type) throws IOException, SerializeException {
        ClassMeta elementType = type.getElementType();
        ArrayList<RDFNode> l = new ArrayList<RDFNode>(c.size());
        for (Object e : c) {
            l.add(this.serializeAnything(e, false, elementType, null, null, null));
        }
        return this.model.createList(l.iterator());
    }

    private void serializeToMultiProperties(Collection c, ClassMeta<?> sType, BeanPropertyMeta bpm, String attrName, Resource parentResource) throws IOException, SerializeException {
        ClassMeta elementType = sType.getElementType();
        RdfBeanPropertyMeta bpRdf = RdfSerializerSession.bpRdf(bpm);
        XmlBeanPropertyMeta bpXml = RdfSerializerSession.bpXml(bpm);
        for (Object e : c) {
            Namespace ns = bpRdf.getNamespace();
            if (ns == null && this.isUseXmlNamespaces()) {
                ns = bpXml.getNamespace();
            }
            if (ns == null) {
                ns = this.getJuneauBpNs();
            } else if (this.isAutoDetectNamespaces()) {
                this.addModelPrefix(ns);
            }
            RDFNode n2 = this.serializeAnything(e, false, elementType, null, null, null);
            Property p = this.model.createProperty(ns.getUri(), this.encodeElementName(attrName));
            parentResource.addProperty(p, n2);
        }
    }

    private static RdfClassMeta cRdf(ClassMeta<?> cm) {
        return (RdfClassMeta)cm.getExtendedMeta(RdfClassMeta.class);
    }

    private static XmlBeanPropertyMeta bpXml(BeanPropertyMeta pMeta) {
        return pMeta == null ? XmlBeanPropertyMeta.DEFAULT : (XmlBeanPropertyMeta)pMeta.getExtendedMeta(XmlBeanPropertyMeta.class);
    }

    private static RdfBeanPropertyMeta bpRdf(BeanPropertyMeta pMeta) {
        return pMeta == null ? RdfBeanPropertyMeta.DEFAULT : (RdfBeanPropertyMeta)pMeta.getExtendedMeta(RdfBeanPropertyMeta.class);
    }

    private static RdfBeanMeta bRdf(BeanMeta bm) {
        return (RdfBeanMeta)bm.getExtendedMeta(RdfBeanMeta.class);
    }

    protected final RdfCollectionFormat getCollectionFormat() {
        return this.ctx.getCollectionFormat();
    }

    protected final Namespace getJuneauBpNs() {
        return this.ctx.getJuneauBpNs();
    }

    protected final Namespace getJuneauNs() {
        return this.ctx.getJuneauNs();
    }

    protected final String getLanguage() {
        return this.ctx.getLanguage();
    }

    protected final boolean isLooseCollections() {
        return this.ctx.isLooseCollections();
    }

    protected final Map<String, Object> getJenaProperties() {
        return this.ctx.getJenaProperties();
    }

    protected final boolean isAddBeanTypes() {
        return this.ctx.isAddBeanTypes();
    }

    protected final boolean isAddLiteralTypes() {
        return this.ctx.isAddLiteralTypes();
    }

    protected final boolean isAddRootProp() {
        return this.ctx.isAddRootProp();
    }

    protected final boolean isAutoDetectNamespaces() {
        return this.ctx.isAutoDetectNamespaces();
    }

    protected final Namespace[] getNamespaces() {
        return this.ctx.getNamespaces();
    }

    protected final boolean isUseXmlNamespaces() {
        return this.ctx.isUseXmlNamespaces();
    }

    public ObjectMap toMap() {
        return super.toMap().append("RdfSerializerSession", (Object)new DefaultFilteringObjectMap());
    }
}

