/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.juneau.BeanRuntimeException;
import org.apache.juneau.reflect.ClassInfo;

public class MetadataMap {
    private Class<?>[] classes = new Class[0];
    private Object[] metadata = new Object[0];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T get(Class<T> c, Object constructorArg) {
        for (int i = 0; i < this.classes.length; ++i) {
            if (this.classes[i] != c) continue;
            return (T)this.metadata[i];
        }
        MetadataMap metadataMap = this;
        synchronized (metadataMap) {
            for (int i = 0; i < this.classes.length; ++i) {
                if (this.classes[i] != c) continue;
                return (T)this.metadata[i];
            }
            Class[] classes2 = new Class[this.classes.length + 1];
            Object[] metadata2 = new Object[this.classes.length + 1];
            for (int i = 0; i < this.classes.length; ++i) {
                classes2[i] = this.classes[i];
                metadata2[i] = this.metadata[i];
            }
            T o = null;
            try {
                for (Constructor<?> con : c.getConstructors()) {
                    Class<?>[] pt = con.getParameterTypes();
                    if (pt.length != 1 || !ClassInfo.of(pt[0]).isParentOf(constructorArg.getClass())) continue;
                    o = (T)con.newInstance(constructorArg);
                    break;
                }
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new RuntimeException(t);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (o == null) {
                throw new BeanRuntimeException(c, "Could not find a constructor on class with a parameter to handle type {0}", constructorArg.getClass());
            }
            classes2[this.classes.length] = c;
            metadata2[this.classes.length] = o;
            this.classes = classes2;
            this.metadata = metadata2;
            return o;
        }
    }
}

