/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.transform;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.ConstructorInfo;
import org.apache.juneau.reflect.MethodInfo;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.transform.PojoSwap;

public class AutoListSwap<T>
extends PojoSwap<T, List<?>> {
    private static final Set<String> SWAP_METHOD_NAMES = CollectionUtils.newUnmodifiableHashSet("toList", "toObjectList");
    private static final Set<String> UNSWAP_METHOD_NAMES = CollectionUtils.newUnmodifiableHashSet("fromList", "fromObjectList", "create", "valueOf");
    private final Method swapMethod;
    private final Method unswapMethod;
    private final Constructor<?> unswapConstructor;

    public static PojoSwap<?, ?> find(ClassInfo ci) {
        if (AutoListSwap.shouldIgnore(ci)) {
            return null;
        }
        for (MethodInfo m : ci.getPublicMethods()) {
            if (!AutoListSwap.isSwapMethod(m)) continue;
            ClassInfo rt = m.getReturnType();
            for (MethodInfo m2 : ci.getPublicMethods()) {
                if (!AutoListSwap.isUnswapMethod(m2, ci, rt)) continue;
                return new AutoListSwap(ci, m, m2, null);
            }
            for (ConstructorInfo cs : ci.getPublicConstructors()) {
                if (!AutoListSwap.isUnswapConstructor(cs, rt)) continue;
                return new AutoListSwap(ci, m, null, cs);
            }
            return new AutoListSwap(ci, m, null, null);
        }
        return null;
    }

    private static boolean shouldIgnore(ClassInfo ci) {
        return ci.hasAnnotation(BeanIgnore.class) || ci.isNonStaticMemberClass();
    }

    private static boolean isSwapMethod(MethodInfo mi) {
        return mi.isNotDeprecated() && mi.isNotStatic() && mi.hasName(SWAP_METHOD_NAMES) && mi.hasReturnTypeParent(List.class) && mi.hasFuzzyParamTypes(BeanSession.class) && !mi.hasAnnotation(BeanIgnore.class);
    }

    private static boolean isUnswapMethod(MethodInfo mi, ClassInfo ci, ClassInfo rt) {
        return mi.isNotDeprecated() && mi.isStatic() && mi.hasName(UNSWAP_METHOD_NAMES) && mi.hasFuzzyParamTypes(BeanSession.class, rt.inner()) && mi.hasReturnTypeParent(ci) && !mi.hasAnnotation(BeanIgnore.class);
    }

    private static boolean isUnswapConstructor(ConstructorInfo cs, ClassInfo rt) {
        return cs.isNotDeprecated() && cs.hasParamTypeParents(rt) && !cs.hasAnnotation(BeanIgnore.class);
    }

    private AutoListSwap(ClassInfo ci, MethodInfo swapMethod, MethodInfo unswapMethod, ConstructorInfo unswapConstructor) {
        super(ci.inner(), swapMethod.getReturnType().inner());
        this.swapMethod = swapMethod.inner();
        this.unswapMethod = unswapMethod == null ? null : unswapMethod.inner();
        this.unswapConstructor = unswapConstructor == null ? null : unswapConstructor.inner();
    }

    @Override
    public List<?> swap(BeanSession session, Object o) throws SerializeException {
        try {
            return (List)this.swapMethod.invoke(o, ClassUtils.getMatchingArgs(this.swapMethod.getParameterTypes(), session));
        }
        catch (Exception e) {
            throw SerializeException.create(e);
        }
    }

    @Override
    public T unswap(BeanSession session, List<?> o, ClassMeta<?> hint) throws ParseException {
        try {
            if (this.unswapMethod != null) {
                return (T)this.unswapMethod.invoke(null, ClassUtils.getMatchingArgs(this.unswapMethod.getParameterTypes(), session, o));
            }
            if (this.unswapConstructor != null) {
                return (T)this.unswapConstructor.newInstance(o);
            }
            return super.unswap(session, o, hint);
        }
        catch (Exception e) {
            throw ParseException.create(e);
        }
    }
}

