/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.msgpack;

import org.apache.juneau.BinaryFormat;
import org.apache.juneau.DefaultFilteringObjectMap;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.ConfigurableContext;
import org.apache.juneau.msgpack.MsgPackSerializerBuilder;
import org.apache.juneau.msgpack.MsgPackSerializerSession;
import org.apache.juneau.serializer.OutputStreamSerializer;
import org.apache.juneau.serializer.SerializerSessionArgs;

@ConfigurableContext
public class MsgPackSerializer
extends OutputStreamSerializer {
    static final String PREFIX = "MsgPackSerializer";
    public static final String MSGPACK_addBeanTypes = "MsgPackSerializer.addBeanTypes.b";
    public static final MsgPackSerializer DEFAULT = new MsgPackSerializer(PropertyStore.DEFAULT);
    public static final MsgPackSerializer DEFAULT_SPACED_HEX = new SpacedHex(PropertyStore.DEFAULT);
    public static final MsgPackSerializer DEFAULT_BASE64 = new Base64(PropertyStore.DEFAULT);
    private final boolean addBeanTypes = this.getBooleanProperty("MsgPackSerializer.addBeanTypes.b", this.getBooleanProperty("Serializer.addBeanTypes.b", false));

    public MsgPackSerializer(PropertyStore ps) {
        super(ps, "octal/msgpack", null);
    }

    @Override
    public MsgPackSerializerBuilder builder() {
        return new MsgPackSerializerBuilder(this.getPropertyStore());
    }

    public static MsgPackSerializerBuilder create() {
        return new MsgPackSerializerBuilder();
    }

    @Override
    public MsgPackSerializerSession createSession() {
        return this.createSession(this.createDefaultSessionArgs());
    }

    @Override
    public MsgPackSerializerSession createSession(SerializerSessionArgs args) {
        return new MsgPackSerializerSession(this, args);
    }

    @Override
    protected final boolean isAddBeanTypes() {
        return this.addBeanTypes;
    }

    @Override
    public ObjectMap toMap() {
        return super.toMap().append(PREFIX, new DefaultFilteringObjectMap().append("addBeanTypes", this.addBeanTypes));
    }

    public static class Base64
    extends MsgPackSerializer {
        public Base64(PropertyStore ps) {
            super(ps.builder().set("OutputStreamSerializer.binaryFormat.s", (Object)BinaryFormat.BASE64).build());
        }
    }

    public static class SpacedHex
    extends MsgPackSerializer {
        public SpacedHex(PropertyStore ps) {
            super(ps.builder().set("OutputStreamSerializer.binaryFormat.s", (Object)BinaryFormat.SPACED_HEX).build());
        }
    }
}

