/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.msgpack;

import org.apache.juneau.BinaryFormat;
import org.apache.juneau.DefaultFilteringObjectMap;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.ConfigurableContext;
import org.apache.juneau.msgpack.MsgPackParserBuilder;
import org.apache.juneau.msgpack.MsgPackParserSession;
import org.apache.juneau.parser.InputStreamParser;
import org.apache.juneau.parser.ParserSessionArgs;

@ConfigurableContext
public class MsgPackParser
extends InputStreamParser {
    static final String PREFIX = "MsgPackParser";
    public static final MsgPackParser DEFAULT = new MsgPackParser(PropertyStore.DEFAULT);
    public static final MsgPackParser DEFAULT_SPACED_HEX = new SpacedHex(PropertyStore.DEFAULT);
    public static final MsgPackParser DEFAULT_BASE64 = new Base64(PropertyStore.DEFAULT);

    public MsgPackParser(PropertyStore ps) {
        super(ps, "octal/msgpack");
    }

    @Override
    public MsgPackParserBuilder builder() {
        return new MsgPackParserBuilder(this.getPropertyStore());
    }

    public static MsgPackParserBuilder create() {
        return new MsgPackParserBuilder();
    }

    @Override
    public MsgPackParserSession createSession() {
        return this.createSession(this.createDefaultSessionArgs());
    }

    @Override
    public MsgPackParserSession createSession(ParserSessionArgs args) {
        return new MsgPackParserSession(this, args);
    }

    @Override
    public ObjectMap toMap() {
        return super.toMap().append(PREFIX, new DefaultFilteringObjectMap());
    }

    public static class Base64
    extends MsgPackParser {
        public Base64(PropertyStore ps) {
            super(ps.builder().set("InputStreamParser.binaryFormat.s", (Object)BinaryFormat.BASE64).build());
        }
    }

    public static class SpacedHex
    extends MsgPackParser {
        public SpacedHex(PropertyStore ps) {
            super(ps.builder().set("InputStreamParser.binaryFormat.s", (Object)BinaryFormat.SPACED_HEX).build());
        }
    }
}

