/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.annotation;

import java.lang.annotation.Annotation;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.juneau.ConfigApply;
import org.apache.juneau.ConfigException;
import org.apache.juneau.PropertyNamer;
import org.apache.juneau.PropertyStoreBuilder;
import org.apache.juneau.annotation.BeanConfig;
import org.apache.juneau.annotation.CS;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.marshall.SimpleJson;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.reflect.AnnotationInfo;
import org.apache.juneau.svl.VarResolverSession;

public class BeanConfigApply
extends ConfigApply<BeanConfig> {
    public BeanConfigApply(Class<BeanConfig> c, VarResolverSession r) {
        super(c, r);
    }

    @Override
    public void apply(AnnotationInfo<BeanConfig> ai, PropertyStoreBuilder psb) {
        BeanConfig a = ai.getAnnotation();
        for (CS cS : a.excludeProperties()) {
            psb.addTo("BeanContext.bpx.sms", cS.k().getName(), this.string(cS.v()));
        }
        for (CS cS : a.includeProperties()) {
            psb.addTo("BeanContext.bpi.sms", cS.k().getName(), this.string(cS.v()));
        }
        if (a.beanDictionary().length != 0) {
            psb.addTo("BeanContext.beanDictionary.lc", a.beanDictionary());
        }
        if (a.beanDictionary_replace().length != 0) {
            psb.set("BeanContext.beanDictionary.lc", a.beanDictionary_replace());
        }
        if (a.beanDictionary_remove().length != 0) {
            psb.removeFrom("BeanContext.beanDictionary.lc", a.beanDictionary_remove());
        }
        if (!a.beanClassVisibility().isEmpty()) {
            psb.set("BeanContext.beanClassVisibility.s", (Object)this.visibility(a.beanClassVisibility(), "beanClassVisibility"));
        }
        if (!a.beanConstructorVisibility().isEmpty()) {
            psb.set("BeanContext.beanConstructorVisibility.s", (Object)this.visibility(a.beanConstructorVisibility(), "beanConstructorVisibility"));
        }
        if (a.dictionary().length != 0) {
            psb.addTo("BeanContext.beanDictionary.lc", a.dictionary());
        }
        if (a.dictionary_replace().length != 0) {
            psb.set("BeanContext.beanDictionary.lc", a.dictionary_replace());
        }
        if (a.dictionary_remove().length != 0) {
            psb.removeFrom("BeanContext.beanDictionary.lc", a.dictionary_remove());
        }
        if (!a.beanFieldVisibility().isEmpty()) {
            psb.set("BeanContext.beanFieldVisibility.s", (Object)this.visibility(a.beanFieldVisibility(), "beanFieldVisibility"));
        }
        if (a.beanFilters().length != 0) {
            psb.addTo("BeanContext.beanFilters.lc", a.beanFilters());
        }
        if (a.beanFilters_replace().length != 0) {
            psb.set("BeanContext.beanFilters.lc", a.beanFilters_replace());
        }
        if (a.beanFilters_remove().length != 0) {
            psb.removeFrom("BeanContext.beanFilters.lc", a.beanFilters_remove());
        }
        if (!a.beanMapPutReturnsOldValue().isEmpty()) {
            psb.set("BeanContext.beanMapPutReturnsOldValue.b", this.bool(a.beanMapPutReturnsOldValue()));
        }
        if (!a.beanMethodVisibility().isEmpty()) {
            psb.set("BeanContext.beanMethodVisibility.s", (Object)this.visibility(a.beanMethodVisibility(), "beanMethodVisibility"));
        }
        if (!a.beansRequireDefaultConstructor().isEmpty()) {
            psb.set("BeanContext.beansRequireDefaultConstructor.b", this.bool(a.beansRequireDefaultConstructor()));
        }
        if (!a.beansRequireSerializable().isEmpty()) {
            psb.set("BeanContext.beansRequireSerializable.b", this.bool(a.beansRequireSerializable()));
        }
        if (!a.beansRequireSettersForGetters().isEmpty()) {
            psb.set("BeanContext.beansRequireSettersForGetters.b", this.bool(a.beansRequireSettersForGetters()));
        }
        if (!a.beansRequireSomeProperties().isEmpty()) {
            psb.set("BeanContext.beansRequireSomeProperties.b", this.bool(a.beansRequireSomeProperties()));
        }
        if (!a.beanTypePropertyName().isEmpty()) {
            psb.set("BeanContext.beanTypePropertyName.s", this.string(a.beanTypePropertyName()));
        }
        if (a.bpi().length > 0) {
            psb.addTo("BeanContext.bpi.sms", this.stringsMap(a.bpi(), "bpi"));
        }
        for (CS cS : a.bpiMap()) {
            psb.addTo("BeanContext.bpi.sms", cS.k().getName(), this.string(cS.v()));
        }
        if (a.bpx().length > 0) {
            psb.addTo("BeanContext.bpx.sms", this.stringsMap(a.bpi(), "bpx"));
        }
        for (CS cS : a.bpxMap()) {
            psb.addTo("BeanContext.bpx.sms", cS.k().getName(), this.string(cS.v()));
        }
        if (a.bpro().length > 0) {
            psb.addTo("BeanContext.bpro.sms", this.stringsMap(a.bpro(), "bpro"));
        }
        for (CS cS : a.bproMap()) {
            psb.addTo("BeanContext.bpro.sms", cS.k().getName(), this.string(cS.v()));
        }
        if (a.bpwo().length > 0) {
            psb.addTo("BeanContext.bpwo.sms", this.stringsMap(a.bpi(), "bpwo"));
        }
        for (CS cS : a.bpwoMap()) {
            psb.addTo("BeanContext.bpwo.sms", cS.k().getName(), this.string(cS.v()));
        }
        if (!a.debug().isEmpty()) {
            psb.set("BeanContext.debug.b", this.bool(a.debug()));
        }
        for (CS cS : a.example()) {
            psb.addTo("BeanContext.examples.smo", cS.k().getName(), this.parse(cS.k(), cS.v(), "example"));
        }
        if (a.examples().length > 0) {
            psb.addTo("BeanContext.examples.smo", this.objectMap(a.examples(), "examples"));
        }
        if (!a.fluentSetters().isEmpty()) {
            psb.set("BeanContext.fluentSetters.b", this.bool(a.fluentSetters()));
        }
        if (!a.ignoreInvocationExceptionsOnGetters().isEmpty()) {
            psb.set("BeanContext.ignoreInvocationExceptionsOnGetters.b", this.bool(a.ignoreInvocationExceptionsOnGetters()));
        }
        if (!a.ignoreInvocationExceptionsOnSetters().isEmpty()) {
            psb.set("BeanContext.ignoreInvocationExceptionsOnSetters.b", this.bool(a.ignoreInvocationExceptionsOnSetters()));
        }
        if (!a.ignorePropertiesWithoutSetters().isEmpty()) {
            psb.set("BeanContext.ignorePropertiesWithoutSetters.b", this.bool(a.ignorePropertiesWithoutSetters()));
        }
        if (!a.ignoreUnknownBeanProperties().isEmpty()) {
            psb.set("BeanContext.ignoreUnknownBeanProperties.b", this.bool(a.ignoreUnknownBeanProperties()));
        }
        if (!a.ignoreUnknownNullBeanProperties().isEmpty()) {
            psb.set("BeanContext.ignoreUnknownNullBeanProperties.b", this.bool(a.ignoreUnknownNullBeanProperties()));
        }
        for (Annotation annotation : a.implClasses()) {
            psb.addTo("BeanContext.implClasses.smc", annotation.k().getName(), annotation.v());
        }
        if (!a.locale().isEmpty()) {
            psb.set("BeanContext.locale.s", this.locale(a.locale()));
        }
        if (!a.mediaType().isEmpty()) {
            psb.set("BeanContext.mediaType.s", this.mediaType(a.mediaType()));
        }
        if (a.notBeanClasses().length != 0) {
            psb.addTo("BeanContext.notBeanClasses.sc", a.notBeanClasses());
        }
        if (a.notBeanClasses_replace().length != 0) {
            psb.set("BeanContext.notBeanClasses.sc", a.notBeanClasses_replace());
        }
        if (a.notBeanClasses_remove().length != 0) {
            psb.removeFrom("BeanContext.notBeanClasses.sc", a.notBeanClasses_remove());
        }
        if (a.notBeanPackages().length != 0) {
            psb.addTo("BeanContext.notBeanPackages.ss", this.strings(a.notBeanPackages()));
        }
        if (a.notBeanPackages_replace().length != 0) {
            psb.set("BeanContext.notBeanPackages.ss", this.strings(a.notBeanPackages_replace()));
        }
        if (a.notBeanPackages_remove().length != 0) {
            psb.removeFrom("BeanContext.notBeanPackages.ss", this.strings(a.notBeanPackages_remove()));
        }
        if (a.pojoSwaps().length != 0) {
            psb.addTo("BeanContext.pojoSwaps.lo", a.pojoSwaps());
        }
        if (a.pojoSwaps_replace().length != 0) {
            psb.set("BeanContext.pojoSwaps.lo", a.pojoSwaps_replace());
        }
        if (a.pojoSwaps_remove().length != 0) {
            psb.removeFrom("BeanContext.pojoSwaps.lo", a.pojoSwaps_remove());
        }
        if (a.propertyNamer() != PropertyNamer.Null.class) {
            psb.set("BeanContext.propertyNamer.c", a.propertyNamer());
        }
        if (!a.sortProperties().isEmpty()) {
            psb.set("BeanContext.sortProperties.b", this.bool(a.sortProperties()));
        }
        if (!a.timeZone().isEmpty()) {
            psb.set("BeanContext.timeZone.s", this.timeZone(a.timeZone()));
        }
        if (!a.useEnumNames().isEmpty()) {
            psb.set("BeanContext.useEnumNames.b", this.bool(a.useEnumNames()));
        }
        if (!a.useInterfaceProxies().isEmpty()) {
            psb.set("BeanContext.useInterfaceProxies.b", this.bool(a.useInterfaceProxies()));
        }
        if (!a.useJavaBeanIntrospector().isEmpty()) {
            psb.set("BeanContext.useJavaBeanIntrospector.b", this.bool(a.useJavaBeanIntrospector()));
        }
        if (!a.detectRecursions().isEmpty()) {
            psb.set("BeanTraverseContext.detectRecursions.b", this.bool(a.detectRecursions()));
        }
        if (!a.ignoreRecursions().isEmpty()) {
            psb.set("BeanTraverseContext.ignoreRecursions.b", this.bool(a.ignoreRecursions()));
        }
        if (!a.initialDepth().isEmpty()) {
            psb.set("BeanTraverseContext.initialDepth.i", this.integer(a.initialDepth(), "initialDepth"));
        }
        if (!a.maxDepth().isEmpty()) {
            psb.set("BeanTraverseContext.maxDepth.i", this.integer(a.maxDepth(), "maxDepth"));
        }
    }

    private Locale locale(String in) {
        return Locale.forLanguageTag(this.string(in));
    }

    private MediaType mediaType(String in) {
        return MediaType.forString(this.string(in));
    }

    private TimeZone timeZone(String in) {
        return TimeZone.getTimeZone(this.string(in));
    }

    private <T> T parse(Class<T> c, String in, String loc) {
        try {
            return SimpleJson.DEFAULT.read(this.string(in), c);
        }
        catch (ParseException e) {
            throw new ConfigException("Invalid syntax for visibility on annotation @BeanConfig({0}): {1}", loc, in);
        }
    }
}

