/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanRecursionException;
import org.apache.juneau.BeanSession;
import org.apache.juneau.BeanSessionArgs;
import org.apache.juneau.BeanTraverseContext;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.DefaultFilteringObjectMap;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.internal.StringUtils;

public class BeanTraverseSession
extends BeanSession {
    private final BeanTraverseContext ctx;
    private final Map<Object, Object> set;
    private final LinkedList<StackElement> stack = new LinkedList();
    private boolean isBottom;
    private BeanPropertyMeta currentProperty;
    private ClassMeta<?> currentClass;
    public int indent;

    protected BeanTraverseSession(BeanTraverseContext ctx, BeanSessionArgs args) {
        super(ctx, args == null ? BeanSessionArgs.DEFAULT : args);
        args = args == null ? BeanSessionArgs.DEFAULT : args;
        this.ctx = ctx;
        this.indent = this.getInitialDepth();
        this.set = this.isDetectRecursions() || this.isDebug() ? new IdentityHashMap<Object, Object>() : Collections.emptyMap();
    }

    protected final void setCurrentProperty(BeanPropertyMeta currentProperty) {
        this.currentProperty = currentProperty;
    }

    protected final void setCurrentClass(ClassMeta<?> currentClass) {
        this.currentClass = currentClass;
    }

    protected final ClassMeta<?> push(String attrName, Object o, ClassMeta<?> eType) throws BeanRecursionException {
        ClassMeta<?> cm;
        ++this.indent;
        this.isBottom = true;
        if (o == null) {
            return null;
        }
        Class<?> c = o.getClass();
        ClassMeta<?> classMeta = eType != null && c == eType.getInnerClass() ? eType : (cm = o instanceof ClassMeta ? (ClassMeta<?>)o : this.getClassMeta(c));
        if (cm.isCharSequence() || cm.isNumber() || cm.isBoolean()) {
            return cm;
        }
        if (this.isDetectRecursions() || this.isDebug()) {
            if (this.stack.size() > this.getMaxDepth()) {
                return null;
            }
            if (this.willRecurse(attrName, o, cm)) {
                return null;
            }
            this.isBottom = false;
            this.stack.add(new StackElement(this.stack.size(), attrName, o, cm));
            if (this.isDebug()) {
                this.getLogger().info(this.getStack(false));
            }
            this.set.put(o, o);
        }
        return cm;
    }

    protected final boolean willRecurse(String attrName, Object o, ClassMeta<?> cm) throws BeanRecursionException {
        if (!this.isDetectRecursions() && !this.isDebug()) {
            return false;
        }
        if (!this.set.containsKey(o)) {
            return false;
        }
        if (this.isIgnoreRecursions() && !this.isDebug()) {
            return true;
        }
        this.stack.add(new StackElement(this.stack.size(), attrName, o, cm));
        throw new BeanRecursionException("Recursion occurred, stack={0}", this.getStack(true));
    }

    protected final void pop() {
        Object o;
        Object o2;
        --this.indent;
        if ((this.isDetectRecursions() || this.isDebug()) && !this.isBottom && (o2 = this.set.remove(o = this.stack.removeLast().o)) == null) {
            this.onError(null, "Couldn't remove object of type ''{0}'' on attribute ''{1}'' from object stack.", o.getClass().getName(), this.stack);
        }
        this.isBottom = false;
    }

    protected final boolean isOptional(ClassMeta<?> cm) {
        return cm != null && cm.isOptional();
    }

    protected final ClassMeta<?> getOptionalType(ClassMeta<?> cm) {
        if (cm.isOptional()) {
            return this.getOptionalType(cm.getElementType());
        }
        return cm;
    }

    protected final Object getOptionalValue(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Optional) {
            return this.getOptionalValue(((Optional)o).orElse(null));
        }
        return o;
    }

    protected void onError(Throwable t, String msg, Object ... args) {
        super.addWarning(msg, args);
    }

    protected String getStack(boolean full) {
        StringBuilder sb = new StringBuilder();
        for (StackElement e : this.stack) {
            if (full) {
                sb.append("\n\t");
                for (int i = 1; i < e.depth; ++i) {
                    sb.append("  ");
                }
                if (e.depth > 0) {
                    sb.append("->");
                }
                sb.append(e.toString(false));
                continue;
            }
            sb.append(" > ").append(e.toString(true));
        }
        return sb.toString();
    }

    public final ObjectMap getLastLocation() {
        ObjectMap m = new ObjectMap();
        if (this.currentClass != null) {
            m.put("currentClass", this.currentClass);
        }
        if (this.currentProperty != null) {
            m.put("currentProperty", this.currentProperty);
        }
        if (this.stack != null && !this.stack.isEmpty()) {
            m.put("stack", this.stack);
        }
        return m;
    }

    protected final boolean isDetectRecursions() {
        return this.ctx.isDetectRecursions();
    }

    protected final boolean isIgnoreRecursions() {
        return this.ctx.isIgnoreRecursions();
    }

    protected final int getInitialDepth() {
        return this.ctx.getInitialDepth();
    }

    protected final int getMaxDepth() {
        return this.ctx.getMaxDepth();
    }

    @Override
    public ObjectMap toMap() {
        return super.toMap().append("BeanTraverseSession", new DefaultFilteringObjectMap());
    }

    private final class StackElement {
        final int depth;
        final String name;
        final Object o;
        final ClassMeta<?> aType;

        StackElement(int depth, String name, Object o, ClassMeta<?> aType) {
            this.depth = depth;
            this.name = name;
            this.o = o;
            this.aType = aType;
        }

        String toString(boolean simple) {
            StringBuilder sb = new StringBuilder().append('[').append(this.depth).append(']').append(' ');
            sb.append(StringUtils.isEmpty(this.name) ? "<noname>" : this.name).append(':');
            sb.append(this.aType.toString(simple));
            if (this.aType != this.aType.getSerializedClassMeta(BeanTraverseSession.this)) {
                sb.append('/').append(this.aType.getSerializedClassMeta(BeanTraverseSession.this).toString(simple));
            }
            return sb.toString();
        }
    }
}

