/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.juneau.BeanContext;
import org.apache.juneau.ContextBuilder;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyNamer;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.Visibility;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.marshall.SimpleJson;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.reflect.AnnotationList;
import org.apache.juneau.svl.VarResolverSession;

public class BeanContextBuilder
extends ContextBuilder {
    public BeanContextBuilder() {
    }

    public BeanContextBuilder(PropertyStore ps) {
        super(ps);
    }

    @Override
    public BeanContext build() {
        return this.build(BeanContext.class);
    }

    public BeanContextBuilder beanClassVisibility(Visibility value) {
        return this.set("BeanContext.beanClassVisibility.s", (Object)value);
    }

    public BeanContextBuilder beanConstructorVisibility(Visibility value) {
        return this.set("BeanContext.beanConstructorVisibility.s", (Object)value);
    }

    @Deprecated
    public BeanContextBuilder beanDictionary(Object ... values) {
        return this.addTo("BeanContext.beanDictionary.lc", values);
    }

    @Deprecated
    public BeanContextBuilder beanDictionary(Class<?> ... values) {
        return this.addTo("BeanContext.beanDictionary.lc", values);
    }

    @Deprecated
    public BeanContextBuilder beanDictionaryReplace(Class<?> ... values) {
        return this.set("BeanContext.beanDictionary.lc", values);
    }

    @Deprecated
    public BeanContextBuilder beanDictionaryReplace(Object ... values) {
        return this.set("BeanContext.beanDictionary.lc", values);
    }

    @Deprecated
    public BeanContextBuilder beanDictionaryRemove(Class<?> ... values) {
        return this.removeFrom("BeanContext.beanDictionary.lc", values);
    }

    @Deprecated
    public BeanContextBuilder beanDictionaryRemove(Object ... values) {
        return this.removeFrom("BeanContext.beanDictionary.lc", values);
    }

    public BeanContextBuilder beanFieldVisibility(Visibility value) {
        return this.set("BeanContext.beanFieldVisibility.s", (Object)value);
    }

    public BeanContextBuilder beanFilters(Object ... values) {
        return this.addTo("BeanContext.beanFilters.lc", values);
    }

    public BeanContextBuilder beanFilters(Class<?> ... values) {
        return this.addTo("BeanContext.beanFilters.lc", values);
    }

    public BeanContextBuilder beanFiltersReplace(Class<?> ... values) {
        return this.set("BeanContext.beanFilters.lc", values);
    }

    public BeanContextBuilder beanFiltersReplace(Object ... values) {
        return this.set("BeanContext.beanFilters.lc", values);
    }

    public BeanContextBuilder beanFiltersRemove(Class<?> ... values) {
        return this.removeFrom("BeanContext.beanFilters.lc", values);
    }

    public BeanContextBuilder beanFiltersRemove(Object ... values) {
        return this.removeFrom("BeanContext.beanFilters.lc", values);
    }

    public BeanContextBuilder beanMapPutReturnsOldValue(boolean value) {
        return this.set("BeanContext.beanMapPutReturnsOldValue.b", value);
    }

    public BeanContextBuilder beanMapPutReturnsOldValue() {
        return this.set("BeanContext.beanMapPutReturnsOldValue.b", true);
    }

    public BeanContextBuilder beanMethodVisibility(Visibility value) {
        return this.set("BeanContext.beanMethodVisibility.s", (Object)value);
    }

    public BeanContextBuilder beansRequireDefaultConstructor(boolean value) {
        return this.set("BeanContext.beansRequireDefaultConstructor.b", value);
    }

    public BeanContextBuilder beansRequireDefaultConstructor() {
        return this.set("BeanContext.beansRequireDefaultConstructor.b", true);
    }

    public BeanContextBuilder beansRequireSerializable(boolean value) {
        return this.set("BeanContext.beansRequireSerializable.b", value);
    }

    public BeanContextBuilder beansRequireSerializable() {
        return this.set("BeanContext.beansRequireSerializable.b", true);
    }

    public BeanContextBuilder beansRequireSettersForGetters(boolean value) {
        return this.set("BeanContext.beansRequireSettersForGetters.b", value);
    }

    public BeanContextBuilder beansRequireSettersForGetters() {
        return this.set("BeanContext.beansRequireSettersForGetters.b", true);
    }

    public BeanContextBuilder beansRequireSomeProperties(boolean value) {
        return this.set("BeanContext.beansRequireSomeProperties.b", value);
    }

    public BeanContextBuilder beanTypePropertyName(String value) {
        return this.set("BeanContext.beanTypePropertyName.s", value);
    }

    public BeanContextBuilder bpi(Class<?> beanClass, String value) {
        return this.addTo("BeanContext.bpi.sms", beanClass.getName(), value);
    }

    public BeanContextBuilder bpi(Map<String, String> values) {
        return this.set("BeanContext.bpi.sms", values);
    }

    public BeanContextBuilder bpi(String beanClassName, String value) {
        return this.addTo("BeanContext.bpi.sms", beanClassName, value);
    }

    public BeanContextBuilder bpx(Class<?> beanClass, String properties) {
        return this.addTo("BeanContext.bpx.sms", beanClass.getName(), properties);
    }

    public BeanContextBuilder bpx(Map<String, String> values) {
        return this.set("BeanContext.bpx.sms", values);
    }

    public BeanContextBuilder bpx(String beanClassName, String value) {
        return this.addTo("BeanContext.bpx.sms", beanClassName, value);
    }

    public BeanContextBuilder bpro(Class<?> beanClass, String properties) {
        return this.addTo("BeanContext.bpro.sms", beanClass.getName(), properties);
    }

    public BeanContextBuilder bpro(Map<String, String> values) {
        return this.set("BeanContext.bpro.sms", values);
    }

    public BeanContextBuilder bpro(String beanClassName, String value) {
        return this.addTo("BeanContext.bpro.sms", beanClassName, value);
    }

    public BeanContextBuilder bpwo(Class<?> beanClass, String properties) {
        return this.addTo("BeanContext.bpwo.sms", beanClass.getName(), properties);
    }

    public BeanContextBuilder bpwo(Map<String, String> values) {
        return this.set("BeanContext.bpwo.sms", values);
    }

    public BeanContextBuilder bpwo(String beanClassName, String value) {
        return this.addTo("BeanContext.bpwo.sms", beanClassName, value);
    }

    public BeanContextBuilder debug(boolean value) {
        return this.set("BeanContext.debug.b", value);
    }

    public BeanContextBuilder dictionary(Object ... values) {
        return this.addTo("BeanContext.beanDictionary.lc", values);
    }

    public BeanContextBuilder dictionary(Class<?> ... values) {
        return this.addTo("BeanContext.beanDictionary.lc", values);
    }

    public BeanContextBuilder dictionaryReplace(Class<?> ... values) {
        return this.set("BeanContext.beanDictionary.lc", values);
    }

    public BeanContextBuilder dictionaryReplace(Object ... values) {
        return this.set("BeanContext.beanDictionary.lc", values);
    }

    public BeanContextBuilder dictionaryRemove(Class<?> ... values) {
        return this.removeFrom("BeanContext.beanDictionary.lc", values);
    }

    public BeanContextBuilder dictionaryRemove(Object ... values) {
        return this.removeFrom("BeanContext.beanDictionary.lc", values);
    }

    public BeanContextBuilder debug() {
        return this.set("BeanContext.debug.b", true);
    }

    public <T> BeanContextBuilder example(Class<T> pojoClass, T o) {
        return this.addTo("BeanContext.examples.smo", pojoClass.getName(), o);
    }

    public <T> BeanContextBuilder exampleJson(Class<T> pojoClass, String json) {
        try {
            return this.addTo("BeanContext.examples.smo", pojoClass.getName(), SimpleJson.DEFAULT.read(json, pojoClass));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public BeanContextBuilder examples(String json) throws ParseException {
        if (!StringUtils.isObjectMap(json, true)) {
            json = "{" + json + "}";
        }
        ObjectMap m = new ObjectMap(json);
        for (Map.Entry<String, Object> e : m.entrySet()) {
            this.addTo("BeanContext.examples.smo", e.getKey(), e.getValue());
        }
        return this;
    }

    @Deprecated
    public BeanContextBuilder excludeProperties(Class<?> beanClass, String properties) {
        return this.addTo("BeanContext.bpx.sms", beanClass.getName(), properties);
    }

    @Deprecated
    public BeanContextBuilder excludeProperties(Map<String, String> values) {
        return this.set("BeanContext.bpx.sms", values);
    }

    @Deprecated
    public BeanContextBuilder excludeProperties(String beanClassName, String value) {
        return this.addTo("BeanContext.bpx.sms", beanClassName, value);
    }

    public BeanContextBuilder fluentSetters(boolean value) {
        return this.set("BeanContext.fluentSetters.b", value);
    }

    public BeanContextBuilder fluentSetters() {
        return this.set("BeanContext.fluentSetters.b", true);
    }

    public BeanContextBuilder ignoreInvocationExceptionsOnGetters(boolean value) {
        return this.set("BeanContext.ignoreInvocationExceptionsOnGetters.b", value);
    }

    public BeanContextBuilder ignoreInvocationExceptionsOnGetters() {
        return this.set("BeanContext.ignoreInvocationExceptionsOnGetters.b", true);
    }

    public BeanContextBuilder ignoreInvocationExceptionsOnSetters(boolean value) {
        return this.set("BeanContext.ignoreInvocationExceptionsOnSetters.b", value);
    }

    public BeanContextBuilder ignoreInvocationExceptionsOnSetters() {
        return this.set("BeanContext.ignoreInvocationExceptionsOnSetters.b", true);
    }

    public BeanContextBuilder ignorePropertiesWithoutSetters(boolean value) {
        return this.set("BeanContext.ignorePropertiesWithoutSetters.b", value);
    }

    public BeanContextBuilder ignoreUnknownBeanProperties(boolean value) {
        return this.set("BeanContext.ignoreUnknownBeanProperties.b", value);
    }

    public BeanContextBuilder ignoreUnknownBeanProperties() {
        return this.set("BeanContext.ignoreUnknownBeanProperties.b", true);
    }

    public BeanContextBuilder ignoreUnknownNullBeanProperties(boolean value) {
        return this.set("BeanContext.ignoreUnknownNullBeanProperties.b", value);
    }

    public BeanContextBuilder implClass(Class<?> interfaceClass, Class<?> implClass) {
        return this.addTo("BeanContext.implClasses.smc", interfaceClass.getName(), implClass);
    }

    public BeanContextBuilder implClasses(Map<String, Class<?>> values) {
        return this.set("BeanContext.implClasses.smc", values);
    }

    @Deprecated
    public BeanContextBuilder includeProperties(Class<?> beanClass, String value) {
        return this.addTo("BeanContext.bpi.sms", beanClass.getName(), value);
    }

    @Deprecated
    public BeanContextBuilder includeProperties(Map<String, String> values) {
        return this.set("BeanContext.bpi.sms", values);
    }

    @Deprecated
    public BeanContextBuilder includeProperties(String beanClassName, String value) {
        return this.addTo("BeanContext.bpi.sms", beanClassName, value);
    }

    public BeanContextBuilder locale(Locale value) {
        return this.set("BeanContext.locale.s", value);
    }

    public BeanContextBuilder mediaType(MediaType value) {
        return this.set("BeanContext.mediaType.s", value);
    }

    public BeanContextBuilder notBeanClasses(Class<?> ... values) {
        return this.addTo("BeanContext.notBeanClasses.sc", values);
    }

    public BeanContextBuilder notBeanClasses(Object ... values) {
        return this.addTo("BeanContext.notBeanClasses.sc", values);
    }

    public BeanContextBuilder notBeanClassesReplace(Class<?> ... values) {
        return this.set("BeanContext.notBeanClasses.sc", values);
    }

    public BeanContextBuilder notBeanClassesReplace(Object ... values) {
        return this.set("BeanContext.notBeanClasses.sc", values);
    }

    public BeanContextBuilder notBeanClassesRemove(Class<?> ... values) {
        return this.removeFrom("BeanContext.notBeanClasses.sc", values);
    }

    public BeanContextBuilder notBeanClassesRemove(Object ... values) {
        return this.removeFrom("BeanContext.notBeanClasses.sc", values);
    }

    public BeanContextBuilder notBeanPackages(String ... values) {
        return this.addTo("BeanContext.notBeanPackages.ss", values);
    }

    public BeanContextBuilder notBeanPackages(Object ... values) {
        return this.addTo("BeanContext.notBeanPackages.ss", values);
    }

    public BeanContextBuilder notBeanPackagesReplace(String ... values) {
        return this.set("BeanContext.notBeanPackages.ss", values);
    }

    public BeanContextBuilder notBeanPackagesReplace(Object ... values) {
        return this.set("BeanContext.notBeanPackages.ss", values);
    }

    public BeanContextBuilder notBeanPackagesRemove(String ... values) {
        return this.removeFrom("BeanContext.notBeanPackages.ss", values);
    }

    public BeanContextBuilder notBeanPackagesRemove(Object ... values) {
        return this.removeFrom("BeanContext.notBeanPackages.ss", values);
    }

    public BeanContextBuilder pojoSwaps(Class<?> ... values) {
        return this.addTo("BeanContext.pojoSwaps.lo", values);
    }

    public BeanContextBuilder pojoSwaps(Object ... values) {
        return this.addTo("BeanContext.pojoSwaps.lo", values);
    }

    public BeanContextBuilder pojoSwapsReplace(Class<?> ... values) {
        return this.set("BeanContext.pojoSwaps.lo", values);
    }

    public BeanContextBuilder pojoSwapsReplace(Object ... values) {
        return this.set("BeanContext.pojoSwaps.lo", values);
    }

    public BeanContextBuilder pojoSwapsRemove(Class<?> ... values) {
        return this.removeFrom("BeanContext.pojoSwaps.lo", values);
    }

    public BeanContextBuilder pojoSwapsRemove(Object ... values) {
        return this.removeFrom("BeanContext.pojoSwaps.lo", values);
    }

    public BeanContextBuilder propertyNamer(Class<? extends PropertyNamer> value) {
        return this.set("BeanContext.propertyNamer.c", value);
    }

    public BeanContextBuilder sortProperties(boolean value) {
        return this.set("BeanContext.sortProperties.b", value);
    }

    public BeanContextBuilder sortProperties() {
        return this.set("BeanContext.sortProperties.b", true);
    }

    public BeanContextBuilder timeZone(TimeZone value) {
        return this.set("BeanContext.timeZone.s", value);
    }

    public BeanContextBuilder useEnumNames(boolean value) {
        return this.set("BeanContext.useEnumNames.b", value);
    }

    public BeanContextBuilder useEnumNames() {
        return this.set("BeanContext.useEnumNames.b", true);
    }

    public BeanContextBuilder useInterfaceProxies(boolean value) {
        return this.set("BeanContext.useInterfaceProxies.b", value);
    }

    public BeanContextBuilder useJavaBeanIntrospector(boolean value) {
        return this.set("BeanContext.useJavaBeanIntrospector.b", value);
    }

    public BeanContextBuilder useJavaBeanIntrospector() {
        return this.set("BeanContext.useJavaBeanIntrospector.b", true);
    }

    @Override
    public BeanContextBuilder set(String name, Object value) {
        super.set(name, value);
        return this;
    }

    @Override
    public BeanContextBuilder set(Map<String, Object> properties) {
        super.set(properties);
        return this;
    }

    @Override
    public BeanContextBuilder add(Map<String, Object> properties) {
        super.add(properties);
        return this;
    }

    @Override
    public BeanContextBuilder addTo(String name, Object value) {
        super.addTo(name, value);
        return this;
    }

    @Override
    public BeanContextBuilder addTo(String name, String key, Object value) {
        super.addTo(name, key, value);
        return this;
    }

    @Override
    public BeanContextBuilder removeFrom(String name, Object value) {
        super.removeFrom(name, value);
        return this;
    }

    @Override
    public BeanContextBuilder apply(PropertyStore copyFrom) {
        super.apply(copyFrom);
        return this;
    }

    @Override
    public BeanContextBuilder applyAnnotations(AnnotationList al, VarResolverSession vrs) {
        super.applyAnnotations(al, vrs);
        return this;
    }

    @Override
    public BeanContextBuilder applyAnnotations(Class<?> fromClass) {
        super.applyAnnotations(fromClass);
        return this;
    }

    @Override
    public BeanContextBuilder applyAnnotations(Method fromMethod) {
        super.applyAnnotations(fromMethod);
        return this;
    }
}

