/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.encoders.Encoder;
import org.apache.juneau.encoders.EncoderGroup;
import org.apache.juneau.encoders.EncoderMatch;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.http.MediaTypeRange;
import org.apache.juneau.http.exception.BadRequest;
import org.apache.juneau.http.exception.NotAcceptable;
import org.apache.juneau.httppart.HttpPart;
import org.apache.juneau.httppart.HttpPartParser;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.httppart.SchemaValidationException;
import org.apache.juneau.httppart.bean.ResponseBeanMeta;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.rest.HtmlDocBuilder;
import org.apache.juneau.rest.RequestAttributes;
import org.apache.juneau.rest.RequestProperties;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.RestMethodContext;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.util.CachingHttpServletResponse;
import org.apache.juneau.rest.util.FinishablePrintWriter;
import org.apache.juneau.rest.util.FinishableServletOutputStream;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.SerializerGroup;

public final class RestResponse
extends HttpServletResponseWrapper {
    private HttpServletResponse inner;
    private final RestRequest request;
    private RestMethodContext restJavaMethod;
    private Object output;
    private boolean isNullOutput;
    private RequestProperties properties;
    private ServletOutputStream sos;
    private FinishableServletOutputStream os;
    private FinishablePrintWriter w;
    private HtmlDocBuilder htmlDocBuilder;
    private ResponseBeanMeta responseMeta;

    RestResponse(RestContext context, RestRequest req, HttpServletResponse res) throws BadRequest {
        super(res);
        this.inner = res;
        this.request = req;
        for (Map.Entry<String, Object> e : context.getDefaultResponseHeaders().entrySet()) {
            this.setHeaderSafe(e.getKey(), StringUtils.stringify((Object)e.getValue()));
        }
        try {
            String passThroughHeaders = req.getHeader("x-response-headers");
            if (passThroughHeaders != null) {
                HttpPartParser p = context.getPartParser();
                ObjectMap m = (ObjectMap)p.createPartSession(req.getParserSessionArgs()).parse(HttpPartType.HEADER, null, passThroughHeaders, context.getClassMeta(ObjectMap.class));
                for (Map.Entry e : m.entrySet()) {
                    this.setHeaderSafe((String)e.getKey(), e.getValue().toString());
                }
            }
        }
        catch (Exception e1) {
            throw new BadRequest((Throwable)e1, "Invalid format for header 'x-response-headers'.  Must be in URL-encoded format.", new Object[0]);
        }
    }

    final void init(RestMethodContext rjm, RequestProperties properties) throws NotAcceptable, IOException {
        this.restJavaMethod = rjm;
        this.properties = properties;
        if (this.request.isDebug()) {
            this.setDebug();
        }
        String h = this.request.getHeader("accept-charset");
        String charset = null;
        if (h == null) {
            charset = rjm.defaultCharset;
        } else {
            for (MediaTypeRange r : MediaTypeRange.parse((String)h)) {
                if (!(r.getQValue().floatValue() > 0.0f)) continue;
                MediaType mt = r.getMediaType();
                if (mt.getType().equals("*")) {
                    charset = rjm.defaultCharset;
                } else if (Charset.isSupported(mt.getType())) {
                    charset = mt.getType();
                }
                if (charset != null) break;
            }
        }
        if (charset == null) {
            throw new NotAcceptable("No supported charsets in header ''Accept-Charset'': ''{0}''", new Object[]{this.request.getHeader("Accept-Charset")});
        }
        super.setCharacterEncoding(charset);
        this.responseMeta = rjm.responseMeta;
    }

    public SerializerGroup getSerializers() {
        return this.restJavaMethod == null ? SerializerGroup.EMPTY : this.restJavaMethod.serializers;
    }

    public List<MediaType> getSupportedMediaTypes() {
        return this.restJavaMethod == null ? Collections.emptyList() : this.restJavaMethod.supportedAcceptTypes;
    }

    public List<String> getSupportedEncodings() {
        return this.restJavaMethod == null ? Collections.emptyList() : this.restJavaMethod.encoders.getSupportedEncodings();
    }

    public RestResponse setOutput(Object output) {
        this.output = output;
        this.isNullOutput = output == null;
        return this;
    }

    @Deprecated
    public HtmlDocBuilder getHtmlDocBuilder() {
        if (this.htmlDocBuilder == null) {
            this.htmlDocBuilder = new HtmlDocBuilder(PropertyStore.create());
        }
        return this.htmlDocBuilder;
    }

    @Deprecated
    public RequestProperties getProperties() {
        return this.properties;
    }

    @Deprecated
    public RestResponse prop(String name, Object value) {
        this.properties.append(name, value);
        return this;
    }

    public RequestAttributes getAttributes() {
        return this.request.getAttributes();
    }

    public RestResponse attr(String name, Object value) {
        this.request.setAttribute(name, value);
        return this;
    }

    public RestResponse setOutputs(Object ... output) {
        this.output = output;
        return this;
    }

    public Object getOutput() {
        return this.output;
    }

    public boolean hasOutput() {
        return this.output != null || this.isNullOutput;
    }

    public RestResponse sendPlainText(String text) throws IOException {
        this.setContentType("text/plain");
        this.getNegotiatedWriter().write(text);
        return this;
    }

    public FinishableServletOutputStream getNegotiatedOutputStream() throws NotAcceptable, IOException {
        if (this.os == null) {
            Encoder encoder = null;
            EncoderGroup encoders = this.restJavaMethod == null ? EncoderGroup.DEFAULT : this.restJavaMethod.encoders;
            String ae = this.request.getHeader("Accept-Encoding");
            if (ae != null && !ae.isEmpty()) {
                EncoderMatch match = encoders.getEncoderMatch(ae);
                if (match == null) {
                    if (ae.matches(".*(identity|\\*)\\s*;\\s*q\\s*=\\s*(0(?!\\.)|0\\.0).*")) {
                        throw new NotAcceptable("Unsupported encoding in request header ''Accept-Encoding'': ''{0}''\n\tSupported codings: {1}", new Object[]{ae, encoders.getSupportedEncodings()});
                    }
                } else {
                    encoder = match.getEncoder();
                    String encoding = match.getEncoding().toString();
                    if (!encoding.equals("identity")) {
                        this.setHeader("content-encoding", encoding);
                    }
                }
            }
            ServletOutputStream sos = this.getOutputStream();
            this.os = new FinishableServletOutputStream((OutputStream)(encoder == null ? sos : encoder.getOutputStream((OutputStream)sos)));
        }
        return this.os;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.sos == null) {
            this.sos = this.inner.getOutputStream();
        }
        return this.sos;
    }

    public boolean getOutputStreamCalled() {
        return this.sos != null;
    }

    public PrintWriter getWriter() throws IOException {
        return this.getWriter(true, false);
    }

    public PrintWriter getDirectWriter(String contentType) throws IOException {
        this.setContentType(contentType);
        this.setHeader("X-Content-Type-Options", "nosniff");
        this.setHeader("Content-Encoding", "identity");
        return this.getWriter(true, true);
    }

    public FinishablePrintWriter getNegotiatedWriter() throws NotAcceptable, IOException {
        return this.getWriter(false, false);
    }

    private FinishablePrintWriter getWriter(boolean raw, boolean autoflush) throws NotAcceptable, IOException {
        if (this.w != null) {
            return this.w;
        }
        if (this.request.isPlainText()) {
            this.setHeader("Content-Type", "text/plain");
        }
        try {
            ServletOutputStream out = raw ? this.getOutputStream() : this.getNegotiatedOutputStream();
            this.w = new FinishablePrintWriter((OutputStream)out, this.getCharacterEncoding(), autoflush);
            return this.w;
        }
        catch (UnsupportedEncodingException e) {
            String ce = this.getCharacterEncoding();
            this.setCharacterEncoding("UTF-8");
            throw new NotAcceptable("Unsupported charset in request header ''Accept-Charset'': ''{0}''", new Object[]{ce});
        }
    }

    public MediaType getMediaType() {
        return MediaType.forString((String)this.getContentType());
    }

    public Charset getCharset() {
        String s = this.getCharacterEncoding();
        return s == null ? null : Charset.forName(s);
    }

    public void sendRedirect(String uri) throws IOException {
        char c;
        char c2 = c = uri.length() > 0 ? uri.charAt(0) : (char)'\u0000';
        if (c != '/' && uri.indexOf("://") == -1) {
            uri = this.request.getContextPath() + '/' + uri;
        }
        super.sendRedirect(uri);
    }

    public void setHeader(String name, String value) {
        if (name.equalsIgnoreCase("Content-Type")) {
            super.setContentType(value);
        } else {
            super.setHeader(name, value);
        }
    }

    public void setHeaderSafe(String name, String value) {
        this.setHeaderSafe(name, value, 1024);
    }

    public void setHeaderSafe(String name, String value, int maxLength) {
        if (name.equalsIgnoreCase("Content-Type")) {
            super.setContentType(value);
        } else {
            super.setHeader(name, StringUtils.abbreviate((String)StringUtils.stripInvalidHttpHeaderChars((String)value), (int)maxLength));
        }
    }

    public void setHeader(HttpPart h) throws SchemaValidationException, SerializeException {
        this.setHeaderSafe(h.getName(), h.asString());
    }

    public RestResponse setException(Throwable t) {
        this.request.setException(t);
        return this;
    }

    public RestResponse setNoTrace(Boolean b) {
        this.request.setNoTrace(b);
        return this;
    }

    public RestResponse setNoTrace() {
        return this.setNoTrace(true);
    }

    public RestResponse setDebug(Boolean b) throws IOException {
        this.request.setDebug(b);
        if (b.booleanValue()) {
            this.inner = CachingHttpServletResponse.wrap(this.inner);
        }
        return this;
    }

    public RestResponse setDebug() throws IOException {
        return this.setDebug(true);
    }

    public ResponseBeanMeta getResponseMeta() {
        return this.responseMeta;
    }

    public RestResponse setResponseMeta(ResponseBeanMeta rbm) {
        this.responseMeta = rbm;
        return this;
    }

    public boolean isOutputType(Class<?> c) {
        return c.isInstance(this.output);
    }

    public <T> T getOutput(Class<T> c) {
        return (T)this.output;
    }

    protected HttpServletResponse getInner() {
        return this.inner;
    }

    public void flushBuffer() throws IOException {
        if (this.w != null) {
            this.w.flush();
        }
        if (this.os != null) {
            this.os.flush();
        }
        super.flushBuffer();
    }
}

